/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.lang.reflect.TypeSignature;
import java.io.InvalidClassException;
import java.io.VMObjectStreamClass;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class ObjectStreamField
implements Comparable {
    private String name;
    private Class type;
    private String typename;
    private int offset;
    private boolean unshared;
    private boolean persistent;
    private boolean toset;
    private Field field;

    private /* synthetic */ void finit$() {
        this.offset = -1;
        this.persistent = false;
        this.toset = true;
    }

    ObjectStreamField(Field field) {
        this(field.getName(), field.getType());
        this.field = field;
    }

    public ObjectStreamField(String string, Class clazz) {
        this(string, clazz, false);
    }

    public ObjectStreamField(String string, Class clazz, boolean bl) {
        this.finit$();
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.type = clazz;
        this.typename = TypeSignature.getEncodingOfClass(clazz);
        this.unshared = bl;
    }

    ObjectStreamField(String string, String string2) {
        this.finit$();
        this.name = string;
        this.typename = string2;
        try {
            this.type = TypeSignature.getClassForEncoding(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    ObjectStreamField(String string, String string2, ClassLoader classLoader) {
        this.finit$();
        this.name = string;
        this.typename = string2;
        try {
            this.type = TypeSignature.getClassForEncoding(string2, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public char getTypeCode() {
        return this.typename.charAt(0);
    }

    public String getTypeString() {
        if (this.isPrimitive()) {
            return null;
        }
        return this.typename.intern();
    }

    public int getOffset() {
        return this.offset;
    }

    protected void setOffset(int n) {
        this.offset = n;
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    public boolean isPrimitive() {
        return this.typename.length() == 1;
    }

    public int compareTo(Object object) {
        ObjectStreamField objectStreamField = (ObjectStreamField)object;
        boolean bl = this.isPrimitive();
        boolean bl2 = objectStreamField.isPrimitive();
        if (bl && !bl2) {
            return -1;
        }
        if (!bl && bl2) {
            return 1;
        }
        return this.getName().compareTo(objectStreamField.getName());
    }

    void setPersistent(boolean bl) {
        this.persistent = bl;
    }

    boolean isPersistent() {
        return this.persistent;
    }

    void setToSet(boolean bl) {
        this.toset = bl;
    }

    boolean isToSet() {
        return this.toset;
    }

    void lookupField(Class clazz) throws NoSuchFieldException, SecurityException {
        Field field = clazz.getDeclaredField(this.name);
        AccessController.doPrivileged(new PrivilegedAction(this, field){
            private /* synthetic */ ObjectStreamField this$0;
            private /* synthetic */ Field val$f;
            {
                this.this$0 = objectStreamField;
                this.finit$(field);
            }

            private /* synthetic */ void finit$(Field field) {
                this.val$f = field;
            }

            public Object run() {
                this.val$f.setAccessible(true);
                return null;
            }
        });
        this.field = field;
    }

    void checkFieldType() throws InvalidClassException {
        Class clazz = this.field.getType();
        if (!clazz.isAssignableFrom(this.type)) {
            throw new InvalidClassException("invalid field type for " + this.name + " in class " + this.field.getDeclaringClass());
        }
    }

    public String toString() {
        return "ObjectStreamField< " + this.type + " " + this.name + " >";
    }

    final void setBooleanField(Object object, boolean bl) {
        VMObjectStreamClass.setBooleanNative(this.field, object, bl);
    }

    final void setByteField(Object object, byte by) {
        VMObjectStreamClass.setByteNative(this.field, object, by);
    }

    final void setCharField(Object object, char c) {
        VMObjectStreamClass.setCharNative(this.field, object, c);
    }

    final void setShortField(Object object, short s) {
        VMObjectStreamClass.setShortNative(this.field, object, s);
    }

    final void setIntField(Object object, int n) {
        VMObjectStreamClass.setIntNative(this.field, object, n);
    }

    final void setLongField(Object object, long l) {
        VMObjectStreamClass.setLongNative(this.field, object, l);
    }

    final void setFloatField(Object object, float f) {
        VMObjectStreamClass.setFloatNative(this.field, object, f);
    }

    final void setDoubleField(Object object, double d) {
        VMObjectStreamClass.setDoubleNative(this.field, object, d);
    }

    final void setObjectField(Object object, Object object2) {
        VMObjectStreamClass.setObjectNative(this.field, object, object2);
    }
}

