/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

public class ReplicateScaleFilter
extends ImageFilter {
    protected int destHeight;
    protected int destWidth;
    protected int srcHeight;
    protected int srcWidth;
    protected int[] srcrows;
    protected int[] srccols;
    protected Object outpixbuf;

    public ReplicateScaleFilter(int n, int n2) {
        this.destHeight = n2;
        this.destWidth = n;
    }

    public void setDimensions(int n, int n2) {
        this.srcWidth = n;
        this.srcHeight = n2;
        if (this.destWidth < 0 && this.destHeight < 0) {
            this.destWidth = n;
            this.destHeight = n2;
        } else if (this.destWidth < 0) {
            this.destWidth = (int)((double)n * ((double)this.destHeight / (double)this.srcHeight));
        } else if (this.destHeight < 0) {
            this.destHeight = (int)((double)n2 * ((double)this.destWidth / (double)this.srcWidth));
        }
        if (this.consumer != null) {
            this.consumer.setDimensions(this.destWidth, this.destHeight);
        }
    }

    public void setProperties(Hashtable hashtable) {
        hashtable.put("filters", "ReplicateScaleFilter");
        if (this.consumer != null) {
            this.consumer.setProperties(hashtable);
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        double d = (double)this.srcWidth / (double)this.destWidth;
        double d2 = (double)this.srcHeight / (double)this.destHeight;
        int n7 = (int)Math.round((double)n6 / d);
        byte[] byArray2 = this.replicatePixels(n, n2, n3, n4, colorModel, byArray, n5, n6, d, d2, n7);
        if (this.consumer != null) {
            this.consumer.setPixels((int)Math.floor((double)n / d), (int)Math.floor((double)n2 / d2), (int)Math.ceil((double)n3 / d), (int)Math.ceil((double)n4 / d2), colorModel, byArray2, 0, n7);
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        double d = (double)this.srcWidth / (double)this.destWidth;
        double d2 = (double)this.srcHeight / (double)this.destHeight;
        int n7 = (int)Math.round((double)n6 / d);
        int[] nArray2 = this.replicatePixels(n, n2, n3, n4, colorModel, nArray, n5, n6, d, d2, n7);
        if (this.consumer != null) {
            this.consumer.setPixels((int)Math.floor((double)n / d), (int)Math.floor((double)n2 / d2), (int)Math.ceil((double)n3 / d), (int)Math.ceil((double)n4 / d2), colorModel, nArray2, 0, n7);
        }
    }

    private byte[] replicatePixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6, double d, double d2, int n7) {
        byte[] byArray2 = new byte[(int)Math.ceil((double)n3 / d) * (int)Math.ceil((double)n4 / d2)];
        for (int i = 0; i < byArray2.length; ++i) {
            int n8 = (int)((double)((int)((double)i / (double)n7)) * d2) * n6;
            int n9 = (int)((double)(i % n7) * d);
            if (n8 + n9 + n5 >= byArray.length) continue;
            byArray2[i] = byArray[n8 + n9 + n5];
        }
        return byArray2;
    }

    private int[] replicatePixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6, double d, double d2, int n7) {
        int[] nArray2 = new int[(int)Math.ceil((double)n3 / d) * (int)Math.ceil((double)n4 / d2)];
        for (int i = 0; i < nArray2.length; ++i) {
            int n8 = (int)((double)((int)((double)i / (double)n7)) * d2) * n6;
            int n9 = (int)((double)(i % n7) * d);
            if (n8 + n9 + n5 >= nArray.length) continue;
            nArray2[i] = nArray[n8 + n9 + n5];
        }
        return nArray2;
    }
}

