/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.stream.UnicodeReader;
import gnu.xml.stream.XMLParser;
import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class NMTokensType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    NMTokensType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "NMTOKENS"), TypeLibrary.NMTOKEN);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                String string2 = stringBuffer.toString();
                if (string2.length() > 0) {
                    this.checkNmtoken(string2, i);
                }
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(c);
        }
        this.checkNmtoken(stringBuffer.toString(), n);
    }

    private void checkNmtoken(String string, int n) throws DatatypeException {
        try {
            int[] nArray = UnicodeReader.toCodePointArray(string);
            if (nArray.length == 0) {
                throw new DatatypeException("invalid NMTOKEN value");
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (XMLParser.isNameCharacter(nArray[i], false)) continue;
                throw new DatatypeException(n, "invalid NMTOKEN value");
            }
        }
        catch (IOException iOException) {
            DatatypeException datatypeException = new DatatypeException("invalid NMTOKEN value");
            datatypeException.initCause(iOException);
            throw datatypeException;
        }
    }
}

