/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.stream.UnicodeReader;
import gnu.xml.stream.XMLParser;
import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class NCNameType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    NCNameType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "NCName"), TypeLibrary.NAME);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        try {
            int[] nArray = UnicodeReader.toCodePointArray(string);
            if (nArray.length == 0) {
                throw new DatatypeException("invalid NCName value");
            }
            if (nArray[0] == 58 || !XMLParser.isNameStartCharacter(nArray[0], false)) {
                throw new DatatypeException(0, "invalid NCName value");
            }
            boolean bl = false;
            for (int i = 1; i < nArray.length; ++i) {
                if (nArray[i] == 58) {
                    if (bl || i + 1 == nArray.length) {
                        throw new DatatypeException(i, "invalid NCName value");
                    }
                    bl = true;
                    continue;
                }
                if (XMLParser.isNameCharacter(nArray[i], false)) continue;
                throw new DatatypeException(i, "invalid NCName value");
            }
        }
        catch (IOException iOException) {
            DatatypeException datatypeException = new DatatypeException("invalid NCName value");
            datatypeException.initCause(iOException);
            throw datatypeException;
        }
    }
}

