/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class HexBinaryType
extends AtomicSimpleType {
    static final String HEX = "0123456789ABCDEF";
    static final int[] CONSTRAINING_FACETS;

    HexBinaryType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "hexBinary"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (HEX.indexOf(c) != -1) continue;
            throw new DatatypeException(i, "invalid hexBinary value");
        }
    }

    static {
        HEX = HEX;
        CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};
    }
}

