/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import java.io.BufferedWriter;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.LocatorImpl;

public class XMLWriter
implements ContentHandler,
LexicalHandler,
DTDHandler,
DeclHandler {
    private static final int CTX_ENTITY = 1;
    private static final int CTX_ATTRIBUTE = 2;
    private static final int CTX_CONTENT = 3;
    private static final int CTX_UNPARSED = 4;
    private static final int CTX_NAME = 5;
    private static String sysEOL;
    private Writer out;
    private boolean inCDATA;
    private int elementNestLevel;
    private String eol;
    private short dangerMask;
    private StringBuffer stringBuf;
    private Locator locator;
    private ErrorHandler errHandler;
    private boolean expandingEntities;
    private int entityNestLevel;
    private boolean xhtml;
    private boolean startedDoctype;
    private String encoding;
    private boolean canonical;
    private boolean inDoctype;
    private boolean inEpilogue;
    private boolean prettyPrinting;
    private int column;
    private boolean noWrap;
    private Stack space;
    private static final int lineLength = 75;
    private static final String xhtmlFullDTD = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    private static final String[] HTMLlat1x;
    private static final String[] HTMLsymbolx_GR;
    private static final String[] HTMLsymbolx_gr;

    private /* synthetic */ void finit$() {
        this.eol = sysEOL;
        this.expandingEntities = false;
        this.space = new Stack();
    }

    private static boolean isLineEnd(String string) {
        return "\n".equals(string) || "\r".equals(string) || "\r\n".equals(string);
    }

    public XMLWriter() throws IOException {
        this(System.out);
    }

    public XMLWriter(OutputStream outputStream) throws IOException {
        this(new OutputStreamWriter(outputStream, "UTF8"));
    }

    public XMLWriter(Writer writer) {
        this(writer, null);
    }

    public XMLWriter(Writer writer, String string) {
        this.finit$();
        this.setWriter(writer, string);
    }

    private void setEncoding(String string) {
        if (string == null && this.out instanceof OutputStreamWriter) {
            string = ((OutputStreamWriter)this.out).getEncoding();
        }
        if (string != null) {
            if ("UTF8".equals(string = string.toUpperCase())) {
                string = "UTF-8";
            } else if ("US-ASCII".equals(string) || "ASCII".equals(string)) {
                this.dangerMask = (short)-128;
                string = "US-ASCII";
            } else if ("ISO-8859-1".equals(string) || "8859_1".equals(string) || "ISO8859_1".equals(string)) {
                this.dangerMask = (short)-256;
                string = "ISO-8859-1";
            } else if ("UNICODE".equals(string) || "UNICODE-BIG".equals(string) || "UNICODE-LITTLE".equals(string)) {
                string = "UTF-16";
            }
            if (this.dangerMask != 0) {
                this.stringBuf = new StringBuffer();
            }
        }
        this.encoding = string;
    }

    public final void setWriter(Writer writer, String string) {
        if (this.out != null) {
            throw new IllegalStateException("can't change stream in mid course");
        }
        this.out = writer;
        if (this.out != null) {
            this.setEncoding(string);
        }
        if (!(this.out instanceof BufferedWriter)) {
            this.out = new BufferedWriter(this.out);
        }
        this.space.push("default");
    }

    public final void setEOL(String string) {
        if (string == null) {
            this.eol = sysEOL;
        } else if (!XMLWriter.isLineEnd(string)) {
            this.eol = string;
        } else {
            throw new IllegalArgumentException(string);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errHandler = errorHandler;
    }

    protected void fatal(String string, Exception exception) throws SAXException {
        SAXParseException sAXParseException = this.locator == null ? new SAXParseException(string, null, null, -1, -1, exception) : new SAXParseException(string, this.locator, exception);
        if (this.errHandler != null) {
            this.errHandler.fatalError(sAXParseException);
        }
        throw sAXParseException;
    }

    public final void setXhtml(boolean bl) {
        if (this.locator != null) {
            throw new IllegalStateException("started parsing");
        }
        this.xhtml = bl;
        if (this.xhtml) {
            this.canonical = false;
        }
    }

    public final boolean isXhtml() {
        return this.xhtml;
    }

    public final void setExpandingEntities(boolean bl) {
        if (this.locator != null) {
            throw new IllegalStateException("started parsing");
        }
        this.expandingEntities = bl;
        if (!this.expandingEntities) {
            this.canonical = false;
        }
    }

    public final boolean isExpandingEntities() {
        return this.expandingEntities;
    }

    public final void setPrettyPrinting(boolean bl) {
        if (this.locator != null) {
            throw new IllegalStateException("started parsing");
        }
        this.prettyPrinting = bl;
        if (this.prettyPrinting) {
            this.canonical = false;
        }
    }

    public final boolean isPrettyPrinting() {
        return this.prettyPrinting;
    }

    public final void setCanonical(boolean bl) {
        if (bl && !"UTF-8".equals(this.encoding)) {
            throw new IllegalArgumentException("encoding != UTF-8");
        }
        this.canonical = bl;
        if (this.canonical) {
            this.xhtml = false;
            this.prettyPrinting = false;
            this.expandingEntities = true;
            this.eol = "\n";
        }
    }

    public final boolean isCanonical() {
        return this.canonical;
    }

    public final void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public final void write(String string) throws SAXException {
        char[] cArray = string.toCharArray();
        this.characters(cArray, 0, cArray.length);
    }

    public void writeElement(String string, String string2, String string3, Attributes attributes, String string4) throws SAXException {
        if (string4 == null || string4.length() == 0) {
            this.writeEmptyElement(string, string2, string3, attributes);
            return;
        }
        this.startElement(string, string2, string3, attributes);
        char[] cArray = string4.toCharArray();
        this.characters(cArray, 0, cArray.length);
        this.endElement(string, string2, string3);
    }

    public void writeElement(String string, String string2, String string3, Attributes attributes, int n) throws SAXException {
        this.writeElement(string, string2, string3, attributes, Integer.toString(n));
    }

    public final void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        try {
            if (this.out == null) {
                throw new IllegalStateException("null Writer given to XMLWriter");
            }
            if (this.locator == null) {
                this.locator = new LocatorImpl();
            }
            if (!this.canonical && this.dangerMask != -128 && this.encoding != null) {
                this.rawWrite("<?xml version='1.0'");
                this.rawWrite(" encoding='" + this.encoding + "'");
                this.rawWrite("?>");
                this.newline();
            }
            if (this.xhtml) {
                this.rawWrite("<!DOCTYPE html PUBLIC");
                this.newline();
                this.rawWrite("  '-//W3C//DTD XHTML 1.0 Transitional//EN'");
                this.newline();
                this.rawWrite("  '");
                this.rawWrite(xhtmlFullDTD);
                this.rawWrite("'>");
                this.newline();
                this.newline();
                this.startedDoctype = true;
            }
            this.entityNestLevel = 0;
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            if (!this.canonical) {
                this.newline();
                this.newline();
            }
            this.out.close();
            this.out = null;
            this.locator = null;
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    private static final boolean isEmptyElementTag(String string) {
        switch (string.charAt(0)) {
            case 'a': {
                return "area".equals(string);
            }
            case 'b': {
                return "base".equals(string) || "basefont".equals(string) || "br".equals(string);
            }
            case 'c': {
                return "col".equals(string);
            }
            case 'f': {
                return "frame".equals(string);
            }
            case 'h': {
                return "hr".equals(string);
            }
            case 'i': {
                return "img".equals(string) || "input".equals(string) || "isindex".equals(string);
            }
            case 'l': {
                return "link".equals(string);
            }
            case 'm': {
                return "meta".equals(string);
            }
            case 'p': {
                return "param".equals(string);
            }
        }
        return false;
    }

    private static boolean indentBefore(String string) {
        switch (string.charAt(0)) {
            case 'a': {
                return "applet".equals(string);
            }
            case 'b': {
                return "body".equals(string) || "blockquote".equals(string);
            }
            case 'c': {
                return "center".equals(string);
            }
            case 'f': {
                return "frame".equals(string) || "frameset".equals(string);
            }
            case 'h': {
                return "head".equals(string);
            }
            case 'm': {
                return "meta".equals(string);
            }
            case 'o': {
                return "object".equals(string);
            }
            case 'p': {
                return "param".equals(string) || "pre".equals(string);
            }
            case 's': {
                return "style".equals(string);
            }
            case 't': {
                return "title".equals(string) || "td".equals(string) || "th".equals(string);
            }
        }
        return false;
    }

    private static boolean spaceBefore(String string) {
        switch (string.charAt(0)) {
            case 'h': {
                return "h1".equals(string) || "h2".equals(string) || "h3".equals(string) || "h4".equals(string) || "h5".equals(string) || "h6".equals(string) || "hr".equals(string);
            }
            case 'l': {
                return "li".equals(string);
            }
            case 'o': {
                return "ol".equals(string);
            }
            case 'p': {
                return "p".equals(string);
            }
            case 't': {
                return "table".equals(string) || "tr".equals(string);
            }
            case 'u': {
                return "ul".equals(string);
            }
        }
        return false;
    }

    private static boolean spacePreserve(String string) {
        return "pre".equals(string) || "style".equals(string) || "script".equals(string);
    }

    public final void startPrefixMapping(String string, String string2) {
    }

    public final void endPrefixMapping(String string) {
    }

    private void writeStartTag(String string, Attributes attributes, boolean bl) throws SAXException, IOException {
        this.rawWrite('<');
        this.rawWrite(string);
        if (attributes != null && attributes.getLength() != 0) {
            int n;
            int[] nArray = new int[attributes.getLength()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = n;
            }
            if (this.canonical || this.prettyPrinting) {
                for (n = 1; n < nArray.length; ++n) {
                    int n2 = nArray[n];
                    String string2 = attributes.getQName(n2);
                    for (int i = n - 1; i >= 0 && string2.compareTo(attributes.getQName(nArray[i])) < 0; --i) {
                        nArray[i + 1] = nArray[i];
                    }
                    nArray[i + 1] = n2;
                }
            }
            for (n = 0; n < nArray.length; ++n) {
                String string3 = attributes.getQName(nArray[n]);
                if (string3 == null || "".equals(string3)) {
                    throw new IllegalArgumentException("no XML name");
                }
                this.rawWrite(" ");
                this.rawWrite(string3);
                this.rawWrite("=");
                this.writeQuotedValue(attributes.getValue(nArray[n]), 2);
            }
        }
        if (bl) {
            this.rawWrite(" /");
        }
        this.rawWrite('>');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.startedDoctype = false;
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        if (string3 == null || "".equals(string3)) {
            throw new IllegalArgumentException("no XML name");
        }
        try {
            if (this.entityNestLevel != 0) {
                return;
            }
            if (this.prettyPrinting) {
                String string4 = null;
                if (this.xhtml && XMLWriter.spacePreserve(string3)) {
                    string4 = "preserve";
                } else if (attributes != null) {
                    string4 = attributes.getValue("xml:space");
                }
                if (string4 == null) {
                    string4 = (String)this.space.peek();
                }
                this.space.push(string4);
                if ("default".equals(string4)) {
                    if (this.xhtml) {
                        if (XMLWriter.spaceBefore(string3)) {
                            this.newline();
                            this.doIndent();
                        } else if (XMLWriter.indentBefore(string3)) {
                            this.doIndent();
                        }
                    } else {
                        this.doIndent();
                    }
                }
            }
            ++this.elementNestLevel;
            this.writeStartTag(string3, attributes, this.xhtml && XMLWriter.isEmptyElementTag(string3));
            if (!this.xhtml) return;
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public void writeEmptyElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.canonical) {
            this.startElement(string, string2, string3, attributes);
            this.endElement(string, string2, string3);
        } else {
            try {
                this.writeStartTag(string3, attributes, true);
            }
            catch (IOException iOException) {
                this.fatal("can't write", iOException);
            }
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        if (string3 == null || "".equals(string3)) {
            throw new IllegalArgumentException("no XML name");
        }
        try {
            --this.elementNestLevel;
            if (this.entityNestLevel != 0) {
                return;
            }
            if (this.xhtml && XMLWriter.isEmptyElementTag(string3)) {
                return;
            }
            this.rawWrite("</");
            this.rawWrite(string3);
            this.rawWrite('>');
            if (this.prettyPrinting) {
                if (!this.space.empty()) {
                    this.space.pop();
                } else {
                    this.fatal("stack discipline", null);
                }
            }
            if (this.elementNestLevel == 0) {
                this.inEpilogue = true;
            }
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        try {
            if (this.entityNestLevel != 0) {
                return;
            }
            if (this.inCDATA) {
                this.escapeChars(cArray, n, n2, 4);
            } else {
                this.escapeChars(cArray, n, n2, 3);
            }
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        try {
            if (this.entityNestLevel != 0) {
                return;
            }
            this.escapeChars(cArray, n, n2, 3);
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void processingInstruction(String string, String string2) throws SAXException {
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        if (this.xhtml && this.startedDoctype) {
            return;
        }
        try {
            if (this.entityNestLevel != 0) {
                return;
            }
            if (this.canonical && this.inEpilogue) {
                this.newline();
            }
            this.rawWrite("<?");
            this.rawWrite(string);
            this.rawWrite(' ');
            this.escapeChars(string2.toCharArray(), -1, -1, 4);
            this.rawWrite("?>");
            if (!(this.elementNestLevel != 0 || this.canonical && this.inEpilogue)) {
                this.newline();
            }
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public void skippedEntity(String string) throws SAXException {
        try {
            this.rawWrite("&");
            this.rawWrite(string);
            this.rawWrite(";");
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void startCDATA() throws SAXException {
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        if (this.canonical) {
            return;
        }
        try {
            this.inCDATA = true;
            if (this.entityNestLevel == 0) {
                this.rawWrite("<![CDATA[");
            }
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void endCDATA() throws SAXException {
        if (this.canonical) {
            return;
        }
        try {
            this.inCDATA = false;
            if (this.entityNestLevel == 0) {
                this.rawWrite("]]>");
            }
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        if (this.xhtml) {
            return;
        }
        try {
            this.startedDoctype = true;
            this.inDoctype = true;
            if (this.canonical) {
                return;
            }
            this.rawWrite("<!DOCTYPE ");
            this.rawWrite(string);
            this.rawWrite(' ');
            if (!this.expandingEntities) {
                if (string2 != null) {
                    this.rawWrite("PUBLIC '" + string2 + "' '" + string3 + "' ");
                } else if (string3 != null) {
                    this.rawWrite("SYSTEM '" + string3 + "' ");
                }
            }
            this.rawWrite('[');
            this.newline();
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void endDTD() throws SAXException {
        this.inDoctype = false;
        if (this.canonical || this.xhtml) {
            return;
        }
        try {
            this.rawWrite("]>");
            this.newline();
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void startEntity(String string) throws SAXException {
        try {
            boolean bl = true;
            if (this.xhtml || this.expandingEntities) {
                return;
            }
            ++this.entityNestLevel;
            if (string.equals("[dtd]")) {
                return;
            }
            if (this.entityNestLevel != 1) {
                return;
            }
            if (!string.startsWith("%")) {
                bl = false;
                this.rawWrite('&');
            }
            this.rawWrite(string);
            this.rawWrite(';');
            if (bl) {
                this.newline();
            }
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void endEntity(String string) throws SAXException {
        if (this.xhtml || this.expandingEntities) {
            return;
        }
        --this.entityNestLevel;
    }

    public final void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        if (this.xhtml && this.startedDoctype) {
            return;
        }
        if (this.canonical && this.inDoctype) {
            return;
        }
        try {
            boolean bl;
            if (this.prettyPrinting && this.space.empty()) {
                this.fatal("stack discipline", null);
            }
            boolean bl2 = bl = this.prettyPrinting && "default".equals(this.space.peek());
            if (this.entityNestLevel != 0) {
                return;
            }
            if (bl) {
                this.doIndent();
            }
            if (this.canonical && this.inEpilogue) {
                this.newline();
            }
            this.rawWrite("<!--");
            this.escapeChars(cArray, n, n2, 4);
            this.rawWrite("-->");
            if (bl) {
                this.doIndent();
            }
            if (!(this.elementNestLevel != 0 || this.canonical && this.inEpilogue)) {
                this.newline();
            }
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void notationDecl(String string, String string2, String string3) throws SAXException {
        if (this.xhtml) {
            return;
        }
        try {
            if (!this.startedDoctype) {
                return;
            }
            if (this.entityNestLevel != 0) {
                return;
            }
            this.rawWrite("<!NOTATION " + string + " ");
            if (string2 != null) {
                this.rawWrite("PUBLIC \"" + string2 + '\"');
            } else {
                this.rawWrite("SYSTEM ");
            }
            if (string3 != null) {
                this.rawWrite('\"' + string3 + '\"');
            }
            this.rawWrite(">");
            this.newline();
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (this.xhtml) {
            return;
        }
        try {
            if (!this.startedDoctype) {
                return;
            }
            if (this.entityNestLevel != 0) {
                return;
            }
            this.rawWrite("<!ENTITY " + string + " ");
            if (string2 != null) {
                this.rawWrite("PUBLIC \"" + string2 + '\"');
            } else {
                this.rawWrite("SYSTEM ");
            }
            this.rawWrite('\"' + string3 + '\"');
            this.rawWrite(" NDATA " + string4 + ">");
            this.newline();
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.xhtml) {
            return;
        }
        try {
            if (!this.startedDoctype) {
                return;
            }
            if (this.entityNestLevel != 0) {
                return;
            }
            this.rawWrite("<!ATTLIST " + string + ' ' + string2 + ' ');
            this.rawWrite(string3);
            this.rawWrite(' ');
            if (string4 != null) {
                this.rawWrite(string4 + ' ');
            }
            if (string5 != null) {
                this.writeQuotedValue(string5, 2);
            }
            this.rawWrite('>');
            this.newline();
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void elementDecl(String string, String string2) throws SAXException {
        if (this.xhtml) {
            return;
        }
        try {
            if (!this.startedDoctype) {
                return;
            }
            if (this.entityNestLevel != 0) {
                return;
            }
            this.rawWrite("<!ELEMENT " + string + ' ' + string2 + '>');
            this.newline();
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (this.xhtml) {
            return;
        }
        try {
            if (!this.startedDoctype) {
                return;
            }
            if (this.entityNestLevel != 0) {
                return;
            }
            this.rawWrite("<!ENTITY ");
            if (string.startsWith("%")) {
                this.rawWrite("% ");
                this.rawWrite(string.substring(1));
            } else {
                this.rawWrite(string);
            }
            if (string2 != null) {
                this.rawWrite(" PUBLIC \"" + string2 + '\"');
            } else {
                this.rawWrite(" SYSTEM ");
            }
            this.rawWrite('\"' + string3 + "\">");
            this.newline();
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    public final void internalEntityDecl(String string, String string2) throws SAXException {
        if (this.xhtml) {
            return;
        }
        try {
            if (!this.startedDoctype) {
                return;
            }
            if (this.entityNestLevel != 0) {
                return;
            }
            this.rawWrite("<!ENTITY ");
            if (string.startsWith("%")) {
                this.rawWrite("% ");
                this.rawWrite(string.substring(1));
            } else {
                this.rawWrite(string);
            }
            this.rawWrite(' ');
            this.writeQuotedValue(string2, 1);
            this.rawWrite('>');
            this.newline();
        }
        catch (IOException iOException) {
            this.fatal("can't write", iOException);
        }
    }

    private void writeQuotedValue(String string, int n) throws SAXException, IOException {
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = cArray.length;
        this.noWrap = true;
        this.rawWrite('\"');
        this.escapeChars(cArray, n2, n3, n);
        this.rawWrite('\"');
        this.noWrap = false;
    }

    private void escapeChars(char[] cArray, int n, int n2, int n3) throws SAXException, IOException {
        int n4 = 0;
        if (n < 0) {
            n = 0;
            n2 = cArray.length;
        }
        block113: for (int i = 0; i < n2; ++i) {
            String string;
            char c = cArray[n + i];
            switch (c) {
                case '&': {
                    if (n3 == 1 || n3 == 4) continue block113;
                    string = "amp";
                    break;
                }
                case '<': {
                    if (n3 == 1 || n3 == 4) continue block113;
                    string = "lt";
                    break;
                }
                case '>': {
                    if (n3 == 1 || n3 == 4) continue block113;
                    string = "gt";
                    break;
                }
                case '\'': {
                    if (n3 == 3 || n3 == 4 || this.canonical) continue block113;
                    string = "apos";
                    break;
                }
                case '\"': {
                    if (n3 == 3 || n3 == 4) continue block113;
                    string = "quot";
                    break;
                }
                case '\n': {
                    string = this.eol;
                    break;
                }
                default: {
                    if (c > '\ufffd' || c < ' ' && c != '\t' && c != '\n' && c != '\r' || (c & this.dangerMask) != 0 && n3 == 4) {
                        throw new CharConversionException("Illegal or non-writable character: U+" + Integer.toHexString(c));
                    }
                    if ((c & this.dangerMask) == 0) continue block113;
                    string = null;
                    if (this.xhtml) {
                        if (c >= '\u00a0' && c <= '\u00ff') {
                            string = HTMLlat1x[c - 160];
                        } else if (c >= '\u0391' && c <= '\u03a9') {
                            string = HTMLsymbolx_GR[c - 913];
                        } else if (c >= '\u03b1' && c <= '\u03c9') {
                            string = HTMLsymbolx_gr[c - 945];
                        } else {
                            switch (c) {
                                case '\u0152': {
                                    string = "OElig";
                                    break;
                                }
                                case '\u0153': {
                                    string = "oelig";
                                    break;
                                }
                                case '\u0160': {
                                    string = "Scaron";
                                    break;
                                }
                                case '\u0161': {
                                    string = "scaron";
                                    break;
                                }
                                case '\u0178': {
                                    string = "Yuml";
                                    break;
                                }
                                case '\u02c6': {
                                    string = "circ";
                                    break;
                                }
                                case '\u02dc': {
                                    string = "tilde";
                                    break;
                                }
                                case '\u2002': {
                                    string = "ensp";
                                    break;
                                }
                                case '\u2003': {
                                    string = "emsp";
                                    break;
                                }
                                case '\u2009': {
                                    string = "thinsp";
                                    break;
                                }
                                case '\u200c': {
                                    string = "zwnj";
                                    break;
                                }
                                case '\u200d': {
                                    string = "zwj";
                                    break;
                                }
                                case '\u200e': {
                                    string = "lrm";
                                    break;
                                }
                                case '\u200f': {
                                    string = "rlm";
                                    break;
                                }
                                case '\u2013': {
                                    string = "ndash";
                                    break;
                                }
                                case '\u2014': {
                                    string = "mdash";
                                    break;
                                }
                                case '\u2018': {
                                    string = "lsquo";
                                    break;
                                }
                                case '\u2019': {
                                    string = "rsquo";
                                    break;
                                }
                                case '\u201a': {
                                    string = "sbquo";
                                    break;
                                }
                                case '\u201c': {
                                    string = "ldquo";
                                    break;
                                }
                                case '\u201d': {
                                    string = "rdquo";
                                    break;
                                }
                                case '\u201e': {
                                    string = "bdquo";
                                    break;
                                }
                                case '\u2020': {
                                    string = "dagger";
                                    break;
                                }
                                case '\u2021': {
                                    string = "Dagger";
                                    break;
                                }
                                case '\u2030': {
                                    string = "permil";
                                    break;
                                }
                                case '\u2039': {
                                    string = "lsaquo";
                                    break;
                                }
                                case '\u203a': {
                                    string = "rsaquo";
                                    break;
                                }
                                case '\u20ac': {
                                    string = "euro";
                                    break;
                                }
                                case '\u0192': {
                                    string = "fnof";
                                    break;
                                }
                                case '\u03d1': {
                                    string = "thetasym";
                                    break;
                                }
                                case '\u03d2': {
                                    string = "upsih";
                                    break;
                                }
                                case '\u03d6': {
                                    string = "piv";
                                    break;
                                }
                                case '\u2022': {
                                    string = "bull";
                                    break;
                                }
                                case '\u2026': {
                                    string = "hellip";
                                    break;
                                }
                                case '\u2032': {
                                    string = "prime";
                                    break;
                                }
                                case '\u2033': {
                                    string = "Prime";
                                    break;
                                }
                                case '\u203e': {
                                    string = "oline";
                                    break;
                                }
                                case '\u2044': {
                                    string = "frasl";
                                    break;
                                }
                                case '\u2118': {
                                    string = "weierp";
                                    break;
                                }
                                case '\u2111': {
                                    string = "image";
                                    break;
                                }
                                case '\u211c': {
                                    string = "real";
                                    break;
                                }
                                case '\u2122': {
                                    string = "trade";
                                    break;
                                }
                                case '\u2135': {
                                    string = "alefsym";
                                    break;
                                }
                                case '\u2190': {
                                    string = "larr";
                                    break;
                                }
                                case '\u2191': {
                                    string = "uarr";
                                    break;
                                }
                                case '\u2192': {
                                    string = "rarr";
                                    break;
                                }
                                case '\u2193': {
                                    string = "darr";
                                    break;
                                }
                                case '\u2194': {
                                    string = "harr";
                                    break;
                                }
                                case '\u21b5': {
                                    string = "crarr";
                                    break;
                                }
                                case '\u21d0': {
                                    string = "lArr";
                                    break;
                                }
                                case '\u21d1': {
                                    string = "uArr";
                                    break;
                                }
                                case '\u21d2': {
                                    string = "rArr";
                                    break;
                                }
                                case '\u21d3': {
                                    string = "dArr";
                                    break;
                                }
                                case '\u21d4': {
                                    string = "hArr";
                                    break;
                                }
                                case '\u2200': {
                                    string = "forall";
                                    break;
                                }
                                case '\u2202': {
                                    string = "part";
                                    break;
                                }
                                case '\u2203': {
                                    string = "exist";
                                    break;
                                }
                                case '\u2205': {
                                    string = "empty";
                                    break;
                                }
                                case '\u2207': {
                                    string = "nabla";
                                    break;
                                }
                                case '\u2208': {
                                    string = "isin";
                                    break;
                                }
                                case '\u2209': {
                                    string = "notin";
                                    break;
                                }
                                case '\u220b': {
                                    string = "ni";
                                    break;
                                }
                                case '\u220f': {
                                    string = "prod";
                                    break;
                                }
                                case '\u2211': {
                                    string = "sum";
                                    break;
                                }
                                case '\u2212': {
                                    string = "minus";
                                    break;
                                }
                                case '\u2217': {
                                    string = "lowast";
                                    break;
                                }
                                case '\u221a': {
                                    string = "radic";
                                    break;
                                }
                                case '\u221d': {
                                    string = "prop";
                                    break;
                                }
                                case '\u221e': {
                                    string = "infin";
                                    break;
                                }
                                case '\u2220': {
                                    string = "ang";
                                    break;
                                }
                                case '\u2227': {
                                    string = "and";
                                    break;
                                }
                                case '\u2228': {
                                    string = "or";
                                    break;
                                }
                                case '\u2229': {
                                    string = "cap";
                                    break;
                                }
                                case '\u222a': {
                                    string = "cup";
                                    break;
                                }
                                case '\u222b': {
                                    string = "int";
                                    break;
                                }
                                case '\u2234': {
                                    string = "there4";
                                    break;
                                }
                                case '\u223c': {
                                    string = "sim";
                                    break;
                                }
                                case '\u2245': {
                                    string = "cong";
                                    break;
                                }
                                case '\u2248': {
                                    string = "asymp";
                                    break;
                                }
                                case '\u2260': {
                                    string = "ne";
                                    break;
                                }
                                case '\u2261': {
                                    string = "equiv";
                                    break;
                                }
                                case '\u2264': {
                                    string = "le";
                                    break;
                                }
                                case '\u2265': {
                                    string = "ge";
                                    break;
                                }
                                case '\u2282': {
                                    string = "sub";
                                    break;
                                }
                                case '\u2283': {
                                    string = "sup";
                                    break;
                                }
                                case '\u2284': {
                                    string = "nsub";
                                    break;
                                }
                                case '\u2286': {
                                    string = "sube";
                                    break;
                                }
                                case '\u2287': {
                                    string = "supe";
                                    break;
                                }
                                case '\u2295': {
                                    string = "oplus";
                                    break;
                                }
                                case '\u2297': {
                                    string = "otimes";
                                    break;
                                }
                                case '\u22a5': {
                                    string = "perp";
                                    break;
                                }
                                case '\u22c5': {
                                    string = "sdot";
                                    break;
                                }
                                case '\u2308': {
                                    string = "lceil";
                                    break;
                                }
                                case '\u2309': {
                                    string = "rceil";
                                    break;
                                }
                                case '\u230a': {
                                    string = "lfloor";
                                    break;
                                }
                                case '\u230b': {
                                    string = "rfloor";
                                    break;
                                }
                                case '\u2329': {
                                    string = "lang";
                                    break;
                                }
                                case '\u232a': {
                                    string = "rang";
                                    break;
                                }
                                case '\u25ca': {
                                    string = "loz";
                                    break;
                                }
                                case '\u2660': {
                                    string = "spades";
                                    break;
                                }
                                case '\u2663': {
                                    string = "clubs";
                                    break;
                                }
                                case '\u2665': {
                                    string = "hearts";
                                    break;
                                }
                                case '\u2666': {
                                    string = "diams";
                                }
                            }
                        }
                    }
                    if (string != null) break;
                    this.stringBuf.setLength(0);
                    this.stringBuf.append("#x");
                    this.stringBuf.append(Integer.toHexString(c).toUpperCase());
                    string = this.stringBuf.toString();
                }
            }
            if (i != n4) {
                this.rawWrite(cArray, n + n4, i - n4);
            }
            n4 = i + 1;
            if (string == this.eol) {
                this.newline();
                continue;
            }
            this.rawWrite('&');
            this.rawWrite(string);
            this.rawWrite(';');
        }
        if (n4 < n2) {
            this.rawWrite(cArray, n + n4, n2 - n4);
        }
    }

    private void newline() throws SAXException, IOException {
        this.out.write(this.eol);
        this.column = 0;
    }

    private void doIndent() throws SAXException, IOException {
        int n;
        this.newline();
        this.column = n;
        for (n = this.elementNestLevel * 2; n > 8; n -= 8) {
            this.out.write("\t");
        }
        while (n > 0) {
            this.out.write("  ");
            n -= 2;
        }
    }

    private void rawWrite(char c) throws IOException {
        this.out.write(c);
        ++this.column;
    }

    private void rawWrite(String string) throws SAXException, IOException {
        if (this.prettyPrinting && "default".equals(this.space.peek())) {
            char[] cArray = string.toCharArray();
            this.rawWrite(cArray, 0, cArray.length);
        } else {
            this.out.write(string);
            this.column += string.length();
        }
    }

    private void rawWrite(char[] cArray, int n, int n2) throws SAXException, IOException {
        boolean bl;
        if (this.prettyPrinting && this.space.empty()) {
            this.fatal("stack discipline", null);
        }
        boolean bl2 = bl = this.prettyPrinting && "default".equals(this.space.peek());
        if (!bl) {
            this.out.write(cArray, n, n2);
            this.column += n2;
            return;
        }
        while (n2 > 0) {
            char c;
            int n3;
            int n4 = 75 - this.column;
            boolean bl3 = false;
            if (n4 > n2 || this.noWrap) {
                this.out.write(cArray, n, n2);
                this.column += n2;
                return;
            }
            for (n3 = n4 - 1; n3 >= 0; --n3) {
                c = cArray[n + n3];
                if (c != ' ' && c != '\t') continue;
                this.out.write(cArray, n, ++n3);
                this.doIndent();
                n += n3;
                n2 -= n3;
                bl3 = true;
                break;
            }
            if (bl3) continue;
            if (n4 < 0) {
                n4 = 0;
            }
            for (n3 = n4; n3 < n2; ++n3) {
                c = cArray[n + n3];
                if (c != ' ' && c != '\t') continue;
                this.out.write(cArray, n, ++n3);
                this.doIndent();
                n += n3;
                n2 -= n3;
                bl3 = true;
                break;
            }
            if (bl3) continue;
            this.out.write(cArray, n, n2);
            this.column += n2;
            break;
        }
    }

    static {
        try {
            sysEOL = System.getProperty("line.separator", "\n");
            if (!XMLWriter.isLineEnd(sysEOL)) {
                sysEOL = "\n";
            }
        }
        catch (SecurityException securityException) {
            sysEOL = "\n";
        }
        xhtmlFullDTD = xhtmlFullDTD;
        HTMLlat1x = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
        HTMLsymbolx_GR = new String[]{"Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omicron", "Pi", "Rho", null, "Sigma", "Tau", "Upsilon", "Phi", "Chi", "Psi", "Omega"};
        HTMLsymbolx_gr = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigmaf", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega"};
    }
}

