/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.helpers.XMLReaderFactory;

public class XCat
implements EntityResolver2 {
    private Catalog[] catalogs;
    private boolean usingPublic;
    private boolean loadingPermitted;
    private boolean unified;
    private String parserClass;
    private ErrorHandler errorHandler;
    private static final String catalogNamespace = "urn:oasis:names:tc:entity:xmlns:xml:catalog";

    private /* synthetic */ void finit$() {
        this.usingPublic = true;
        this.loadingPermitted = true;
        this.unified = true;
    }

    public XCat() {
        this.finit$();
    }

    public XCat(String string) throws SAXException, IOException {
        this.finit$();
        this.loadCatalog(string);
    }

    public synchronized void loadCatalog(String string) throws SAXException, IOException {
        int n = -1;
        if (!this.loadingPermitted) {
            throw new IllegalStateException();
        }
        string = XCat.normalizeURI(string);
        if (this.catalogs != null) {
            for (n = 0; n < this.catalogs.length && !string.equals(this.catalogs[n].catalogURI); ++n) {
            }
        }
        Catalog catalog = XCat.loadCatalog(this.parserClass, this.errorHandler, string, this.unified);
        if (this.catalogs == null) {
            n = 0;
            this.catalogs = new Catalog[1];
        } else if (n == this.catalogs.length) {
            Catalog[] catalogArray = new Catalog[n + 1];
            System.arraycopy(this.catalogs, 0, catalogArray, 0, n);
            this.catalogs = catalogArray;
        }
        this.catalogs[n] = catalog;
    }

    public InputSource resolveEntity(String string, String string2, String string3, String string4) throws SAXException, IOException {
        if (this.loadingPermitted) {
            this.disableLoading();
        }
        try {
            for (int i = 0; i < this.catalogs.length; ++i) {
                InputSource inputSource = this.catalogs[i].resolve(this.usingPublic, string2, string4);
                if (inputSource == null) continue;
                return inputSource;
            }
        }
        catch (DoneDelegation doneDelegation) {
            // empty catch block
        }
        return null;
    }

    public InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
        if (this.loadingPermitted) {
            this.disableLoading();
        }
        try {
            for (int i = 0; i < this.catalogs.length; ++i) {
                InputSource inputSource = this.catalogs[i].getExternalSubset(string);
                if (inputSource == null) continue;
                return inputSource;
            }
        }
        catch (DoneDelegation doneDelegation) {
            // empty catch block
        }
        return null;
    }

    public final InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        return this.resolveEntity(null, string, null, string2);
    }

    public InputSource resolveURI(String string, String string2) throws SAXException, IOException {
        if (this.loadingPermitted) {
            this.disableLoading();
        }
        try {
            for (int i = 0; i < this.catalogs.length; ++i) {
                InputSource inputSource = this.catalogs[i].resolveURI(string2);
                if (inputSource == null) continue;
                return inputSource;
            }
        }
        catch (DoneDelegation doneDelegation) {
            // empty catch block
        }
        return null;
    }

    public synchronized void disableLoading() {
        this.loadingPermitted = false;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public String getParserClass() {
        return this.parserClass;
    }

    public void setParserClass(String string) {
        this.parserClass = string;
    }

    public boolean isUnified() {
        return this.unified;
    }

    public void setUnified(boolean bl) {
        this.unified = bl;
    }

    public boolean isUsingPublic() {
        return this.usingPublic;
    }

    public void setUsingPublic(boolean bl) {
        this.usingPublic = bl;
    }

    private static Catalog loadCatalog(String string, ErrorHandler errorHandler, String string2, boolean bl) throws SAXException, IOException {
        boolean bl2 = false;
        XMLReader xMLReader = string == null ? XMLReaderFactory.createXMLReader() : XMLReaderFactory.createXMLReader(string);
        if (errorHandler != null) {
            xMLReader.setErrorHandler(errorHandler);
        }
        try {
            bl2 = xMLReader.getFeature("http://xml.org/sax/features/string-interning");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            // empty catch block
        }
        Loader loader = new Loader(bl2, errorHandler, bl);
        loader.cat.parserClass = string;
        loader.cat.catalogURI = string2;
        xMLReader.setContentHandler(loader);
        xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", loader);
        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", loader);
        xMLReader.parse(string2);
        return loader.cat;
    }

    private static String normalizePublicId(boolean bl, String string) {
        Object object;
        if (string.startsWith("urn:publicid:")) {
            StringBuffer stringBuffer = new StringBuffer();
            object = string.toCharArray();
            boolean bl2 = false;
            block6: for (int i = 13; i < ((Object)object).length; ++i) {
                switch (object[i]) {
                    case 43: {
                        stringBuffer.append(' ');
                        continue block6;
                    }
                    case 58: {
                        stringBuffer.append("//");
                        continue block6;
                    }
                    case 59: {
                        stringBuffer.append("::");
                        continue block6;
                    }
                    case 37: {
                        bl2 = true;
                    }
                    default: {
                        stringBuffer.append((char)object[i]);
                    }
                }
            }
            string = stringBuffer.toString();
            if (bl2) {
                System.err.println("nyet unhexing public id: " + string);
            }
            bl = true;
        }
        if (bl) {
            object = new StringTokenizer(string, " \r\n");
            string = null;
            while (((StringTokenizer)object).hasMoreTokens()) {
                if (string == null) {
                    string = ((StringTokenizer)object).nextToken();
                    continue;
                }
                string = string + new StringBuffer(" ").append(((StringTokenizer)object).nextToken());
            }
        }
        return string;
    }

    private static boolean isUriExcluded(int n) {
        return n <= 32 || n >= 127 || "\"<>^`{|}".indexOf(n) != -1;
    }

    private static int hexNibble(int n) {
        if (n < 10) {
            return n + 48;
        }
        return 87 + n;
    }

    private static String normalizeURI(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!XCat.isUriExcluded(c)) continue;
            try {
                byte[] byArray = string.getBytes("UTF8");
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length + 10);
                for (i = 0; i < byArray.length; ++i) {
                    int n2 = byArray[i] & 0xFF;
                    if (XCat.isUriExcluded(n2)) {
                        byteArrayOutputStream.write(37);
                        byteArrayOutputStream.write(XCat.hexNibble(n2 >> 4));
                        byteArrayOutputStream.write(XCat.hexNibble(n2 & 0xF));
                        continue;
                    }
                    byteArrayOutputStream.write(n2);
                }
                return byteArrayOutputStream.toString("8859_1");
            }
            catch (IOException iOException) {
                throw new RuntimeException("can't normalize URI: " + iOException.getMessage());
            }
        }
        return string;
    }

    private static class Loader
    extends DefaultHandler2 {
        private boolean preInterned;
        private ErrorHandler handler;
        private boolean unified;
        private int ignoreDepth;
        private Locator locator;
        private boolean started;
        private Hashtable externals;
        private Stack bases;
        Catalog cat;

        private /* synthetic */ void finit$() {
            this.cat = new Catalog();
        }

        Loader(boolean bl, ErrorHandler errorHandler, boolean bl2) {
            this.finit$();
            this.preInterned = bl;
            this.handler = errorHandler;
            this.unified = bl2;
            this.cat.unified = bl2;
            this.cat.eh = errorHandler;
        }

        private String nofrag(String string) throws SAXException {
            if (string.indexOf(35) != -1) {
                this.warn("URI with fragment: " + string);
                string = string.substring(0, string.indexOf(35));
            }
            return string;
        }

        private String absolutize(String string) throws SAXException {
            if (string.startsWith("file:/") || string.startsWith("http:/") || string.startsWith("https:/") || string.startsWith("ftp:/") || string.startsWith("urn:")) {
                return string;
            }
            try {
                URL uRL = (URL)this.bases.peek();
                return new URL(uRL, string).toString();
            }
            catch (Exception exception) {
                this.fatal("can't absolutize URI: " + string);
                return null;
            }
        }

        private void error(String string) throws SAXException {
            if (this.handler == null) {
                return;
            }
            this.handler.error(new SAXParseException(string, this.locator));
        }

        private void fatal(String string) throws SAXException {
            SAXParseException sAXParseException = new SAXParseException(string, this.locator);
            if (this.handler != null) {
                this.handler.fatalError(sAXParseException);
            }
            throw sAXParseException;
        }

        private void warn(String string) throws SAXException {
            if (this.handler == null) {
                return;
            }
            this.handler.warning(new SAXParseException(string, this.locator));
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startDocument() throws SAXException {
            if (this.locator == null) {
                this.error("no locator!");
            }
            this.bases = new Stack();
            String string = this.locator.getSystemId();
            try {
                this.bases.push(new URL(string));
            }
            catch (IOException iOException) {
                this.fatal("bad document base URI: " + string);
            }
        }

        public void endDocument() throws SAXException {
            block2: {
                try {
                    if (this.started) break block2;
                    this.error("not a catalog!");
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    this.locator = null;
                    this.handler = null;
                    this.externals = null;
                    this.bases = null;
                    throw throwable;
                }
            }
            Object var1_1 = null;
            this.locator = null;
            this.handler = null;
            this.externals = null;
            this.bases = null;
        }

        public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
            if (this.externals == null) {
                this.externals = new Hashtable();
            }
            if (this.externals.get(string) == null) {
                this.externals.put(string, string2);
            }
        }

        public void startEntity(String string) throws SAXException {
            if (this.externals == null) {
                return;
            }
            String string2 = (String)this.externals.get(string);
            if (string2 != null) {
                try {
                    this.bases.push(new URL(string2));
                }
                catch (IOException iOException) {
                    this.fatal("entity '" + string + "', bad URI: " + string2);
                }
            }
        }

        public void endEntity(String string) {
            if (this.externals == null) {
                return;
            }
            String string2 = (String)this.externals.get(string);
            if (string2 != null) {
                this.bases.pop();
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            String string5;
            String string6;
            Object object;
            String string7;
            if (this.ignoreDepth != 0 || !catalogNamespace.equals(string)) {
                ++this.ignoreDepth;
                return;
            }
            if (!this.preInterned) {
                string2 = string2.intern();
            }
            if (!this.started) {
                this.started = true;
                if ("catalog" != string2) {
                    this.fatal("root element not 'catalog': " + string2);
                }
            }
            if ((string7 = attributes.getValue("xml:base")) != null) {
                object = (URL)this.bases.peek();
                try {
                    object = new URL((URL)object, string7);
                }
                catch (IOException iOException) {
                    this.fatal("can't resolve xml:base attribute: " + string7);
                }
                this.bases.push(object);
            } else {
                this.bases.push(this.bases.peek());
            }
            object = attributes.getValue("catalog");
            if (object != null) {
                object = XCat.normalizeURI(this.absolutize((String)object));
            }
            if ((string6 = attributes.getValue("rewritePrefix")) != null) {
                string6 = XCat.normalizeURI(this.absolutize(string6));
            }
            if ((string5 = attributes.getValue("systemIdStartString")) != null && (string5 = XCat.normalizeURI(string5)).startsWith("urn:publicid:")) {
                this.error("systemIdStartString is really a publicId!!");
                return;
            }
            String string8 = attributes.getValue("uri");
            if (string8 != null) {
                string8 = XCat.normalizeURI(this.absolutize(string8));
            }
            if ((string4 = attributes.getValue("uriStartString")) != null && (string4 = XCat.normalizeURI(string4)).startsWith("urn:publicid:")) {
                this.error("uriStartString is really a publicId!!");
                return;
            }
            if ("catalog" == string2 || "group" == string2) {
                String string9 = attributes.getValue("prefer");
                if (string9 != null && !"public".equals(string9) && !"system".equals(string9)) {
                    this.error("in <" + string2 + " ... prefer='...'>, " + "assuming 'public'");
                    string9 = "public";
                }
                if (string9 != null) {
                    if ("catalog" == string2) {
                        this.cat.hasPreference = true;
                        this.cat.usingPublic = "public".equals(string9);
                    } else if (!this.cat.hasPreference || this.cat.usingPublic != "public".equals(string9)) {
                        this.fatal("<group prefer=...> case not handled");
                    }
                } else if ("group" == string2 && this.cat.hasPreference) {
                    this.fatal("<group prefer=...> case not handled");
                }
            } else if ("public" == string2) {
                String string10 = attributes.getValue("publicId");
                String string11 = null;
                if (string10 == null || string8 == null) {
                    this.error("expecting <public publicId=... uri=.../>");
                    return;
                }
                string10 = XCat.normalizePublicId(true, string10);
                string8 = this.nofrag(string8);
                if (this.cat.publicIds == null) {
                    this.cat.publicIds = new Hashtable();
                } else {
                    string11 = (String)this.cat.publicIds.get(string10);
                }
                if (string11 != null) {
                    if (!string11.equals(string8)) {
                        this.warn("ignoring <public...> entry for " + string10);
                    }
                } else {
                    this.cat.publicIds.put(string10, string8);
                }
            } else if ("delegatePublic" == string2) {
                Object object2 = null;
                String string12 = attributes.getValue("publicIdStartString");
                if (string12 == null || object == null) {
                    this.error("expecting <delegatePublic publicIdStartString=... catalog=.../>");
                    return;
                }
                string12 = XCat.normalizePublicId(true, string12);
                if (this.cat.publicDelegations == null) {
                    this.cat.publicDelegations = new Hashtable();
                } else {
                    object2 = this.cat.publicDelegations.get(string12);
                }
                if (object2 != null) {
                    if (!object2.equals(object)) {
                        this.warn("ignoring <delegatePublic...> entry for " + string4);
                    }
                } else {
                    this.cat.publicDelegations.put(string12, object);
                }
            } else if ("system" == string2) {
                String string13 = attributes.getValue("systemId");
                String string14 = null;
                if (string13 == null || string8 == null) {
                    this.error("expecting <system systemId=... uri=.../>");
                    return;
                }
                string13 = XCat.normalizeURI(string13);
                string8 = this.nofrag(string8);
                if (string13.startsWith("urn:publicid:")) {
                    this.error("systemId is really a publicId!!");
                    return;
                }
                if (this.cat.systemIds == null) {
                    this.cat.systemIds = new Hashtable();
                    if (this.unified) {
                        this.cat.uris = this.cat.systemIds;
                    }
                } else {
                    string14 = (String)this.cat.systemIds.get(string13);
                }
                if (string14 != null) {
                    if (!string14.equals(string8)) {
                        this.warn("ignoring <system...> entry for " + string13);
                    }
                } else {
                    this.cat.systemIds.put(string13, string8);
                }
            } else if ("rewriteSystem" == string2) {
                String string15 = null;
                if (string5 == null || string6 == null || string5.length() == 0 || string6.length() == 0) {
                    this.error("expecting <rewriteSystem systemIdStartString=... rewritePrefix=.../>");
                    return;
                }
                if (this.cat.systemRewrites == null) {
                    this.cat.systemRewrites = new Hashtable();
                    if (this.unified) {
                        this.cat.uriRewrites = this.cat.systemRewrites;
                    }
                } else {
                    string15 = (String)this.cat.systemRewrites.get(string5);
                }
                if (string15 != null) {
                    if (!string15.equals(string6)) {
                        this.warn("ignoring <rewriteSystem...> entry for " + string5);
                    }
                } else {
                    this.cat.systemRewrites.put(string5, string6);
                }
            } else if ("delegateSystem" == string2) {
                Object object3 = null;
                if (string5 == null || object == null) {
                    this.error("expecting <delegateSystem systemIdStartString=... catalog=.../>");
                    return;
                }
                if (this.cat.systemDelegations == null) {
                    this.cat.systemDelegations = new Hashtable();
                    if (this.unified) {
                        this.cat.uriDelegations = this.cat.systemDelegations;
                    }
                } else {
                    object3 = this.cat.systemDelegations.get(string5);
                }
                if (object3 != null) {
                    if (!object3.equals(object)) {
                        this.warn("ignoring <delegateSystem...> entry for " + string4);
                    }
                } else {
                    this.cat.systemDelegations.put(string5, object);
                }
            } else if ("uri" == string2) {
                String string16 = attributes.getValue("name");
                String string17 = null;
                if (string16 == null || string8 == null) {
                    this.error("expecting <uri name=... uri=.../>");
                    return;
                }
                if (string16.startsWith("urn:publicid:")) {
                    this.error("name is really a publicId!!");
                    return;
                }
                string16 = XCat.normalizeURI(string16);
                if (this.cat.uris == null) {
                    this.cat.uris = new Hashtable();
                    if (this.unified) {
                        this.cat.systemIds = this.cat.uris;
                    }
                } else {
                    string17 = (String)this.cat.uris.get(string16);
                }
                if (string17 != null) {
                    if (!string17.equals(string8)) {
                        this.warn("ignoring <uri...> entry for " + string16);
                    }
                } else {
                    this.cat.uris.put(string16, string8);
                }
            } else if ("rewriteURI" == string2) {
                String string18 = null;
                if (string4 == null || string6 == null || string4.length() == 0 || string6.length() == 0) {
                    this.error("expecting <rewriteURI uriStartString=... rewritePrefix=.../>");
                    return;
                }
                if (this.cat.uriRewrites == null) {
                    this.cat.uriRewrites = new Hashtable();
                    if (this.unified) {
                        this.cat.systemRewrites = this.cat.uriRewrites;
                    }
                } else {
                    string18 = (String)this.cat.uriRewrites.get(string4);
                }
                if (string18 != null) {
                    if (!string18.equals(string6)) {
                        this.warn("ignoring <rewriteURI...> entry for " + string4);
                    }
                } else {
                    this.cat.uriRewrites.put(string4, string6);
                }
            } else if ("delegateURI" == string2) {
                Object object4 = null;
                if (string4 == null || object == null) {
                    this.error("expecting <delegateURI uriStartString=... catalog=.../>");
                    return;
                }
                if (this.cat.uriDelegations == null) {
                    this.cat.uriDelegations = new Hashtable();
                    if (this.unified) {
                        this.cat.systemDelegations = this.cat.uriDelegations;
                    }
                } else {
                    object4 = this.cat.uriDelegations.get(string4);
                }
                if (object4 != null) {
                    if (!object4.equals(object)) {
                        this.warn("ignoring <delegateURI...> entry for " + string4);
                    }
                } else {
                    this.cat.uriDelegations.put(string4, object);
                }
            } else if ("nextCatalog" == string2) {
                if (object == null) {
                    this.error("expecting <nextCatalog catalog=.../>");
                    return;
                }
                if (this.cat.next == null) {
                    this.cat.next = new Vector();
                }
                this.cat.next.addElement(object);
            } else if ("doctype" == string2) {
                String string19 = attributes.getValue("name");
                String string20 = null;
                if (string19 == null || string8 == null) {
                    this.error("expecting <doctype name=... uri=.../>");
                    return;
                }
                string19 = XCat.normalizeURI(string19);
                if (this.cat.doctypes == null) {
                    this.cat.doctypes = new Hashtable();
                } else {
                    string20 = (String)this.cat.doctypes.get(string19);
                }
                if (string20 != null) {
                    if (!string20.equals(string8)) {
                        this.warn("ignoring <doctype...> entry for " + string4);
                    }
                } else {
                    this.cat.doctypes.put(string19, string8);
                }
            } else {
                this.warn("ignoring unknown catalog element: " + string2);
                ++this.ignoreDepth;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.ignoreDepth != 0) {
                --this.ignoreDepth;
            } else {
                this.bases.pop();
            }
        }
    }

    private static class Catalog {
        String catalogURI;
        ErrorHandler eh;
        boolean unified;
        String parserClass;
        boolean hasPreference;
        boolean usingPublic;
        Hashtable publicIds;
        Hashtable publicDelegations;
        Hashtable systemIds;
        Hashtable systemRewrites;
        Hashtable systemDelegations;
        Hashtable uris;
        Hashtable uriRewrites;
        Hashtable uriDelegations;
        Hashtable doctypes;
        Vector next;

        Catalog() {
        }

        private InputSource locatePublicId(String string) throws SAXException, IOException {
            String string2;
            if (this.publicIds != null && (string2 = (String)this.publicIds.get(string)) != null) {
                return new InputSource(string2);
            }
            if (this.publicDelegations != null) {
                return this.checkDelegations(this.publicDelegations, string, string, null);
            }
            return null;
        }

        private InputSource mapURI(String string, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) throws SAXException, IOException {
            String string2;
            if (hashtable != null && (string2 = (String)hashtable.get(string)) != null) {
                return new InputSource(string2);
            }
            if (hashtable2 != null) {
                string2 = null;
                String string3 = null;
                int n = -1;
                Object object = hashtable2.keys();
                while (object.hasMoreElements()) {
                    String string4 = (String)object.nextElement();
                    int n2 = -1;
                    if (!string.startsWith(string4) || string2 != null && (n2 = string4.length()) < n) continue;
                    string2 = string4;
                    n = n2;
                    string3 = (String)hashtable2.get(string4);
                }
                if (string2 != null) {
                    object = new StringBuffer(string3);
                    ((StringBuffer)object).append(string.substring(n));
                    return new InputSource(((StringBuffer)object).toString());
                }
            }
            if (hashtable3 != null) {
                return this.checkDelegations(hashtable3, string, null, string);
            }
            return null;
        }

        public InputSource resolve(boolean bl, String string, String string2) throws SAXException, IOException {
            InputSource inputSource;
            boolean bl2 = this.hasPreference ? this.usingPublic ^ true : bl ^ true;
            if (string != null) {
                string = XCat.normalizePublicId(false, string);
            }
            if (string2 != null) {
                if (string2.startsWith("urn:publicid:")) {
                    String string3 = XCat.normalizePublicId(true, string2);
                    if (string == null) {
                        string = string3;
                        string2 = null;
                    } else if (!string.equals(string3)) {
                        string2 = null;
                    }
                } else {
                    string2 = XCat.normalizeURI(string2);
                }
            }
            if (string2 == null && string == null) {
                return null;
            }
            if (string2 != null && (inputSource = this.mapURI(string2, this.systemIds, this.systemRewrites, this.systemDelegations)) != null) {
                inputSource.setPublicId(string);
                return inputSource;
            }
            if (!(string == null || string2 != null && bl2 || (inputSource = this.locatePublicId(string)) == null)) {
                inputSource.setPublicId(string);
                return inputSource;
            }
            if (this.next != null) {
                int n = this.next.size();
                for (int i = 0; i < n; ++i) {
                    Catalog catalog = this.getNext(i);
                    inputSource = catalog.resolve(bl, string, string2);
                    if (inputSource == null) continue;
                    return inputSource;
                }
            }
            return null;
        }

        public InputSource resolveURI(String string) throws SAXException, IOException {
            if (string.startsWith("urn:publicid:")) {
                return this.resolve(true, XCat.normalizePublicId(true, string), null);
            }
            InputSource inputSource = this.mapURI(string = XCat.normalizeURI(string), this.uris, this.uriRewrites, this.uriDelegations);
            if (inputSource != null) {
                return inputSource;
            }
            if (this.next != null) {
                int n = this.next.size();
                for (int i = 0; i < n; ++i) {
                    Catalog catalog = this.getNext(i);
                    inputSource = catalog.resolveURI(string);
                    if (inputSource == null) continue;
                    return inputSource;
                }
            }
            return null;
        }

        public InputSource getExternalSubset(String string) throws SAXException, IOException {
            String string2;
            if (this.doctypes != null && (string2 = (String)this.doctypes.get(string)) != null) {
                return new InputSource(string2);
            }
            if (this.next != null) {
                int n = this.next.size();
                for (int i = 0; i < n; ++i) {
                    InputSource inputSource;
                    Catalog catalog = this.getNext(i);
                    if (catalog == null || (inputSource = catalog.getExternalSubset(string)) == null) continue;
                    return inputSource;
                }
            }
            return null;
        }

        private synchronized Catalog getNext(int n) throws SAXException, IOException {
            if (this.next == null || n < 0 || n >= this.next.size()) {
                return null;
            }
            Object object = this.next.elementAt(n);
            if (object instanceof Catalog) {
                return (Catalog)object;
            }
            Catalog catalog = null;
            try {
                catalog = XCat.loadCatalog(this.parserClass, this.eh, (String)object, this.unified);
                this.next.setElementAt(catalog, n);
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return catalog;
        }

        private InputSource checkDelegations(Hashtable hashtable, String string, String string2, String string3) throws SAXException, IOException {
            Object object;
            Object object2;
            Vector vector = null;
            int n = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                int n2;
                object2 = (String)enumeration.nextElement();
                if (!string.startsWith((String)object2)) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                for (n2 = 0; n2 < n; ++n2) {
                    object = (String)vector.elementAt(n2);
                    if (((String)object2).length() <= ((String)object).length()) continue;
                    vector.insertElementAt(object2, n2);
                    break;
                }
                if (n2 == n) {
                    vector.addElement(object2);
                }
                ++n;
            }
            if (vector == null) {
                return null;
            }
            for (int i = 0; i < n; ++i) {
                InputSource inputSource;
                Object object3;
                object2 = null;
                object = hashtable;
                synchronized (object) {
                    try {
                        object3 = vector.elementAt(i);
                        Object object4 = hashtable.get(object3);
                        if (object4 instanceof Catalog) {
                            object2 = (Catalog)object4;
                        } else {
                            try {
                                object2 = XCat.loadCatalog(this.parserClass, this.eh, (String)object4, this.unified);
                                hashtable.put(object3, object2);
                            }
                            catch (SAXException sAXException) {
                            }
                            catch (IOException iOException) {
                            }
                        }
                        object3 = null;
                    }
                    catch (Throwable throwable) {
                        object3 = null;
                        throw throwable;
                    }
                }
                if (object2 == null || (inputSource = ((Catalog)object2).resolve(true, string2, string3)) == null) continue;
                object3 = inputSource;
                return object3;
            }
            throw new DoneDelegation();
        }
    }

    private static class DoneDelegation
    extends SAXException {
        DoneDelegation() {
        }
    }
}

