/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;

public class XMLEventReaderImpl
implements XMLEventReader {
    protected final XMLStreamReader reader;
    protected final XMLEventAllocator allocator;
    protected final String systemId;
    protected XMLEvent peekEvent;

    protected XMLEventReaderImpl(XMLStreamReader xMLStreamReader, XMLEventAllocator xMLEventAllocator, String string) {
        this.reader = xMLStreamReader;
        this.allocator = xMLEventAllocator;
        this.systemId = string;
    }

    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent xMLEvent = this.peek();
        this.peekEvent = null;
        return xMLEvent;
    }

    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException xMLStreamException) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.initCause(xMLStreamException);
            throw runtimeException;
        }
    }

    public boolean hasNext() {
        if (this.peekEvent != null) {
            return true;
        }
        try {
            return this.reader.hasNext();
        }
        catch (XMLStreamException xMLStreamException) {
            return false;
        }
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this.peekEvent != null) {
            return this.peekEvent;
        }
        if (!this.reader.hasNext()) {
            return null;
        }
        this.reader.next();
        this.peekEvent = this.allocator.allocate(this.reader);
        return this.peekEvent;
    }

    public String getElementText() throws XMLStreamException {
        return this.reader.getElementText();
    }

    public XMLEvent nextTag() throws XMLStreamException {
        if (this.peekEvent != null) {
            int n = this.peekEvent.getEventType();
            if (n == 1 || n == 2) {
                return this.peekEvent;
            }
            this.peekEvent = null;
        }
        this.reader.nextTag();
        return this.allocator.allocate(this.reader);
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return this.reader.getProperty(string);
    }

    public void close() throws XMLStreamException {
        this.reader.close();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

