/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.MutationEvent;

public abstract class DomCharacterData
extends DomNode
implements CharacterData {
    static final NodeList CHILD_NODES = new EmptyNodeList();
    private String text;

    DomCharacterData(short s, DomDocument domDocument, String string) {
        super(s, domDocument);
        this.text = string == null ? "" : string;
    }

    DomCharacterData(short s, DomDocument domDocument, char[] cArray, int n, int n2) {
        super(s, domDocument);
        this.text = cArray == null ? "" : new String(cArray, n, n2);
    }

    public void appendData(String string) {
        if (this.isReadonly()) {
            throw new DomDOMException(7);
        }
        String string2 = this.text + string;
        this.mutating(string2);
        this.text = string2;
    }

    public void deleteData(int n, int n2) {
        if (this.isReadonly()) {
            throw new DomDOMException(7);
        }
        char[] cArray = this.text.toCharArray();
        if (n < 0 || n2 < 0 || n > cArray.length) {
            throw new DomDOMException(1);
        }
        if (n + n2 > cArray.length) {
            n2 = cArray.length - n;
        }
        if (n2 == 0) {
            return;
        }
        try {
            char[] cArray2 = new char[cArray.length - n2];
            System.arraycopy(cArray, 0, cArray2, 0, n);
            System.arraycopy(cArray, n + n2, cArray2, n, cArray.length - (n + n2));
            String string = new String(cArray2);
            this.mutating(string);
            this.text = string;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DomDOMException(1);
        }
    }

    public String getNodeValue() {
        return this.text;
    }

    public final String getData() {
        return this.text;
    }

    public int getLength() {
        return this.text.length();
    }

    public void insertData(int n, String string) {
        if (this.isReadonly()) {
            throw new DomDOMException(7);
        }
        char[] cArray = this.text.toCharArray();
        char[] cArray2 = string.toCharArray();
        char[] cArray3 = new char[cArray.length + cArray2.length];
        try {
            System.arraycopy(cArray, 0, cArray3, 0, n);
            System.arraycopy(cArray2, 0, cArray3, n, cArray2.length);
            System.arraycopy(cArray, n, cArray3, n + cArray2.length, cArray.length - n);
            String string2 = new String(cArray3);
            this.mutating(string2);
            this.text = string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DomDOMException(1);
        }
    }

    public void replaceData(int n, int n2, String string) {
        if (this.readonly) {
            throw new DomDOMException(7);
        }
        char[] cArray = this.text.toCharArray();
        if (n < 0 || n2 < 0 || n > cArray.length) {
            throw new DomDOMException(1);
        }
        if (n + n2 > cArray.length) {
            n2 = cArray.length - n;
        }
        try {
            char[] cArray2 = new char[cArray.length - n2];
            System.arraycopy(cArray, 0, cArray2, 0, n);
            System.arraycopy(cArray, n + n2, cArray2, n, cArray.length - (n + n2));
            char[] cArray3 = string.toCharArray();
            char[] cArray4 = new char[cArray2.length + cArray3.length];
            System.arraycopy(cArray, 0, cArray2, 0, n);
            System.arraycopy(cArray3, 0, cArray2, n, cArray3.length);
            System.arraycopy(cArray, n, cArray2, n + cArray3.length, cArray.length - n);
            String string2 = new String(cArray2);
            this.mutating(string2);
            this.text = string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DomDOMException(1);
        }
    }

    public void setNodeValue(String string) {
        if (this.isReadonly()) {
            throw new DomDOMException(7);
        }
        if (string == null) {
            string = "";
        }
        this.mutating(string);
        this.text = string;
    }

    public final void setData(String string) {
        this.setNodeValue(string);
    }

    public String substringData(int n, int n2) {
        try {
            return this.text.substring(n, n2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            if (n >= 0 && n2 >= 0 && n < this.text.length()) {
                return this.text.substring(n);
            }
            throw new DomDOMException(1);
        }
    }

    public NodeList getChildNodes() {
        return CHILD_NODES;
    }

    public final String getBaseURI() {
        return null;
    }

    private void mutating(String string) {
        MutationEvent mutationEvent = (MutationEvent)this.createEvent("MutationEvents");
        mutationEvent.initMutationEvent("DOMCharacterDataModified", true, false, null, this.text, string, null, (short)0);
        this.dispatchEvent(mutationEvent);
    }

    static class EmptyNodeList
    implements NodeList {
        public int getLength() {
            return 0;
        }

        public Node item(int n) {
            return null;
        }

        EmptyNodeList() {
        }
    }
}

