/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print.ipp;

import gnu.classpath.SystemProperties;
import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.javax.print.ipp.DocPrintJobImpl;
import gnu.javax.print.ipp.IppException;
import gnu.javax.print.ipp.IppRequest;
import gnu.javax.print.ipp.IppResponse;
import gnu.javax.print.ipp.IppUtilities;
import gnu.javax.print.ipp.attribute.DefaultValueAttribute;
import gnu.javax.print.ipp.attribute.RequestedAttributes;
import gnu.javax.print.ipp.attribute.printer.DocumentFormat;
import gnu.javax.print.ipp.attribute.supported.CompressionSupported;
import gnu.javax.print.ipp.attribute.supported.DocumentFormatSupported;
import gnu.javax.print.ipp.attribute.supported.FinishingsSupported;
import gnu.javax.print.ipp.attribute.supported.JobSheetsSupported;
import gnu.javax.print.ipp.attribute.supported.MediaSupported;
import gnu.javax.print.ipp.attribute.supported.MultipleDocumentHandlingSupported;
import gnu.javax.print.ipp.attribute.supported.OperationsSupported;
import gnu.javax.print.ipp.attribute.supported.OrientationRequestedSupported;
import gnu.javax.print.ipp.attribute.supported.PrintQualitySupported;
import gnu.javax.print.ipp.attribute.supported.PrinterResolutionSupported;
import gnu.javax.print.ipp.attribute.supported.PrinterUriSupported;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Compression;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobHoldUntil;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.JobPrioritySupported;
import javax.print.attribute.standard.NumberUpSupported;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.event.PrintServiceAttributeListener;

public class IppPrintService
implements PrintService {
    private Map printerAttr;
    private HashSet printServiceAttributeListener;
    private transient String user;
    private transient String passwd;
    private String name;
    private List flavors;
    private PrinterURI printerUri;
    private ArrayList printerUris;
    static final Logger logger = SystemLogger.SYSTEM;
    public static final RequestingUserName REQUESTING_USER_NAME;
    public static final JobName JOB_NAME;

    public IppPrintService(URI uRI, String string, String string2) throws IppException {
        this.printerUri = new PrinterURI(uRI);
        this.user = string;
        this.passwd = string2;
        this.printServiceAttributeListener = new HashSet();
        this.printerAttr = this.getPrinterAttributes();
        this.processResponse();
    }

    private Map getPrinterAttributes() throws IppException {
        IppResponse ippResponse = null;
        try {
            IppRequest ippRequest = new IppRequest(this.printerUri.getURI(), this.user, this.passwd);
            int n = OperationsSupported.GET_PRINTER_ATTRIBUTES.getValue();
            ippRequest.setOperationID((short)n);
            ippRequest.setOperationAttributeDefaults();
            ippRequest.addOperationAttribute(this.printerUri);
            ippResponse = ippRequest.send();
        }
        catch (IOException iOException) {
            throw new IppException("IOException in IPP request/response.", iOException);
        }
        return (Map)ippResponse.getPrinterAttributes().get(0);
    }

    private Set getPrinterAttributeSet(Class clazz) {
        return (Set)this.printerAttr.get(clazz);
    }

    private Attribute getPrinterDefaultAttribute(Class clazz) {
        Set set = (Set)this.printerAttr.get(clazz);
        return ((DefaultValueAttribute)set.toArray()[0]).getAssociatedAttribute();
    }

    private void processResponse() {
        Object object;
        Object object2;
        PrinterName[] printerNameArray = (PrinterName[])this.getPrinterAttributeSet(IppPrintService.class$("javax.print.attribute.standard.PrinterName")).toArray(new PrinterName[1]);
        this.name = printerNameArray[0].getValue();
        this.flavors = new ArrayList();
        Set set = this.getPrinterAttributeSet(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.DocumentFormatSupported"));
        if (set != null) {
            object2 = set.iterator();
            while (object2.hasNext()) {
                object = ((DocumentFormatSupported)object2.next()).getValue();
                if (((String)object).equals("text/plain")) {
                    this.flavors.add(DocFlavor.CHAR_ARRAY.TEXT_PLAIN);
                    this.flavors.add(DocFlavor.READER.TEXT_PLAIN);
                    this.flavors.add(DocFlavor.STRING.TEXT_PLAIN);
                    object = (String)object + "; charset=utf-8";
                } else if (((String)object).equals("text/html")) {
                    this.flavors.add(DocFlavor.CHAR_ARRAY.TEXT_HTML);
                    this.flavors.add(DocFlavor.READER.TEXT_HTML);
                    this.flavors.add(DocFlavor.STRING.TEXT_HTML);
                    object = (String)object + "; charset=utf-8";
                }
                boolean bl = false;
                try {
                    Class[] classArray = new Class[]{IppPrintService.class$("javax.print.DocFlavor$BYTE_ARRAY"), IppPrintService.class$("javax.print.DocFlavor$INPUT_STREAM"), IppPrintService.class$("javax.print.DocFlavor$URL")};
                    for (int i = 0; i < classArray.length; ++i) {
                        Field[] fieldArray = classArray[i].getDeclaredFields();
                        for (int j = 0; j < fieldArray.length; ++j) {
                            DocFlavor docFlavor;
                            if (!fieldArray[j].getType().equals(classArray[i]) || !(docFlavor = (DocFlavor)fieldArray[j].get(null)).getMimeType().equals(object)) continue;
                            bl = this.flavors.add(docFlavor);
                        }
                    }
                    if (bl) continue;
                    this.flavors.add(new DocFlavor((String)object, "[B"));
                    this.flavors.add(new DocFlavor((String)object, "java.io.InputStream"));
                    this.flavors.add(new DocFlavor((String)object, "java.net.URL"));
                }
                catch (SecurityException securityException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        object2 = this.getPrinterAttributeSet(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.PrinterUriSupported"));
        this.printerUris = new ArrayList(object2.size());
        object = object2.iterator();
        while (object.hasNext()) {
            PrinterUriSupported printerUriSupported = (PrinterUriSupported)object.next();
            this.printerUris.add(new PrinterURI(printerUriSupported.getURI()));
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DocPrintJob createPrintJob() {
        return new DocPrintJobImpl(this, this.user, this.passwd);
    }

    public PrintServiceAttribute getAttribute(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("category may not be null");
        }
        if (!IppPrintService.class$("javax.print.attribute.PrintServiceAttribute").isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("category must be of type PrintServiceAttribute");
        }
        Set set = this.getPrinterAttributeSet(clazz);
        if (set != null && set.size() > 0) {
            return (PrintServiceAttribute)set.toArray()[0];
        }
        return null;
    }

    public PrintServiceAttributeSet getAttributes() {
        HashPrintServiceAttributeSet hashPrintServiceAttributeSet = new HashPrintServiceAttributeSet();
        Iterator iterator = this.printerAttr.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((Set)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                Attribute attribute = (Attribute)iterator2.next();
                if (!(attribute instanceof PrintServiceAttribute)) continue;
                hashPrintServiceAttributeSet.add(attribute);
            }
        }
        return AttributeSetUtilities.unmodifiableView(hashPrintServiceAttributeSet);
    }

    public Object getDefaultAttributeValue(Class clazz) {
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.Fidelity"))) {
            return Fidelity.FIDELITY_FALSE;
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.JobName"))) {
            return JOB_NAME;
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.RequestingUserName"))) {
            return REQUESTING_USER_NAME;
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.JobPriority")) && this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.JobPriorityDefault"))) {
            return this.getPrinterDefaultAttribute(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.JobPriorityDefault"));
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.JobHoldUntil")) && this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.JobHoldUntilDefault"))) {
            return this.getPrinterDefaultAttribute(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.JobHoldUntilDefault"));
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.JobSheets")) && this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.JobSheetsDefault"))) {
            return this.getPrinterDefaultAttribute(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.JobSheetsDefault"));
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.MultipleDocumentHandling")) && this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.MultipleDocumentHandlingDefault"))) {
            return this.getPrinterDefaultAttribute(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.MultipleDocumentHandlingDefault"));
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.Copies")) && this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.CopiesDefault"))) {
            return this.getPrinterDefaultAttribute(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.CopiesDefault"));
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.Finishings")) && this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.FinishingsDefault"))) {
            return this.getPrinterDefaultAttribute(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.FinishingsDefault"));
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.Sides")) && this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.SidesDefault"))) {
            return this.getPrinterDefaultAttribute(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.SidesDefault"));
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.NumberUp")) && this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.NumberUpDefault"))) {
            return this.getPrinterDefaultAttribute(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.NumberUpDefault"));
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.OrientationRequested")) && this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.OrientationRequestedDefault"))) {
            return this.getPrinterDefaultAttribute(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.OrientationRequestedDefault"));
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.Media")) && this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.MediaDefault"))) {
            return this.getPrinterDefaultAttribute(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.MediaDefault"));
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.PrinterResolution")) && this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.PrinterResolutionDefault"))) {
            return this.getPrinterDefaultAttribute(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.PrinterResolutionDefault"));
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.PrintQuality")) && this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.PrintQualityDefault"))) {
            return this.getPrinterDefaultAttribute(IppPrintService.class$("gnu.javax.print.ipp.attribute.defaults.PrintQualityDefault"));
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.Compression")) && this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.CompressionSupported"))) {
            return Compression.NONE;
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.PageRanges"))) {
            return new PageRanges(1, Integer.MAX_VALUE);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    public Class[] getSupportedAttributeCategories() {
        Set set;
        HashSet hashSet = new HashSet();
        if (this.printerAttr.containsKey(IppPrintService.class$("javax.print.attribute.standard.JobPrioritySupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.JobPriority"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.JobHoldUntilSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.JobHoldUntil"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.JobSheetsSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.JobSheets"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.MultipleDocumentHandlingSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.MultipleDocumentHandling"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("javax.print.attribute.standard.CopiesSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.Copies"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.FinishingsSupported")) && ((set = this.getPrinterAttributeSet(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.FinishingsSupported"))).size() != 1 || !set.contains(FinishingsSupported.NONE))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.Finishings"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.PageRangesSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.PageRanges"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.SidesSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.Sides"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("javax.print.attribute.standard.NumberUpSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.NumberUp"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.OrientationRequestedSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.OrientationRequested"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.MediaSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.Media"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.PrinterResolutionSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.PrinterResolution"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.PrintQualitySupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.PrintQuality"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.CompressionSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.Compression"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("javax.print.attribute.standard.JobImpressionsSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.JobImpressions"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("javax.print.attribute.standard.JobKOctetsSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.JobKOctets"));
        }
        if (this.printerAttr.containsKey(IppPrintService.class$("javax.print.attribute.standard.JobMediaSheetsSupported"))) {
            hashSet.add(IppPrintService.class$("javax.print.attribute.standard.JobMediaSheets"));
        }
        hashSet.add(IppPrintService.class$("javax.print.attribute.standard.Fidelity"));
        hashSet.add(IppPrintService.class$("javax.print.attribute.standard.JobName"));
        hashSet.add(IppPrintService.class$("javax.print.attribute.standard.RequestingUserName"));
        return (Class[])hashSet.toArray(new Class[hashSet.size()]);
    }

    public Object getSupportedAttributeValues(Class clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
        if (clazz == null) {
            throw new NullPointerException("category may not be null");
        }
        if (!IppPrintService.class$("javax.print.attribute.Attribute").isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("category must be of type Attribute");
        }
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException("flavor is not supported");
        }
        if (!this.isAttributeCategorySupported(clazz)) {
            return null;
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.Fidelity"))) {
            return new Fidelity[]{Fidelity.FIDELITY_FALSE, Fidelity.FIDELITY_TRUE};
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.JobName"))) {
            return JOB_NAME;
        }
        if (clazz.equals(IppPrintService.class$("javax.print.attribute.standard.RequestingUserName"))) {
            return REQUESTING_USER_NAME;
        }
        String string = IppUtilities.getSupportedAttrName(clazz);
        IppResponse ippResponse = null;
        try {
            short s;
            IppRequest ippRequest = new IppRequest(this.printerUri.getURI(), this.user, this.passwd);
            ippRequest.setOperationID((short)OperationsSupported.GET_PRINTER_ATTRIBUTES.getValue());
            ippRequest.setOperationAttributeDefaults();
            ippRequest.addOperationAttribute(new RequestedAttributes(string));
            ippRequest.addOperationAttribute(this.printerUri);
            if (docFlavor != null) {
                DocumentFormat documentFormat = DocumentFormat.createDocumentFormat(docFlavor);
                ippRequest.addOperationAttribute(documentFormat);
            }
            if ((s = (ippResponse = ippRequest.send()).getStatusCode()) != 0 && s != 1 && s != 2) {
                logger.log(Component.IPP, "Statuscode not OK - got:" + s);
            }
        }
        catch (IOException iOException) {
            logger.log((Level)Component.IPP, "IOException", iOException);
        }
        catch (IppException ippException) {
            logger.log((Level)Component.IPP, "IPPException", ippException);
        }
        return this.handleSupportedAttributeValuesResponse(ippResponse, clazz);
    }

    protected Object handleSupportedAttributeValuesResponse(IppResponse ippResponse, Class clazz) {
        List list2 = ippResponse.getPrinterAttributes();
        Map map = (Map)list2.get(0);
        Class clazz2 = IppUtilities.getSupportedCategory(clazz);
        Set set = (Set)map.get(clazz2);
        if (clazz2.equals(IppPrintService.class$("javax.print.attribute.standard.JobPrioritySupported"))) {
            return (JobPrioritySupported)set.toArray(new JobPrioritySupported[1])[0];
        }
        if (clazz2.equals(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.JobHoldUntilSupported"))) {
            return new JobHoldUntil(new Date());
        }
        if (clazz2.equals(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.JobSheetsSupported"))) {
            return JobSheetsSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.MultipleDocumentHandlingSupported"))) {
            return MultipleDocumentHandlingSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(IppPrintService.class$("javax.print.attribute.standard.CopiesSupported"))) {
            return (CopiesSupported)set.toArray(new CopiesSupported[1])[0];
        }
        if (clazz2.equals(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.FinishingsSupported"))) {
            return FinishingsSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.PageRangesSupported"))) {
            return new PageRanges[]{new PageRanges(1, Integer.MAX_VALUE)};
        }
        if (clazz2.equals(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.OrientationRequestedSupported"))) {
            return OrientationRequestedSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.MediaSupported"))) {
            return MediaSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.PrinterResolutionSupported"))) {
            return PrinterResolutionSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.PrintQualitySupported"))) {
            return PrintQualitySupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(IppPrintService.class$("gnu.javax.print.ipp.attribute.supported.CompressionSupported"))) {
            return CompressionSupported.getAssociatedAttributeArray(set);
        }
        if (clazz2.equals(IppPrintService.class$("javax.print.attribute.standard.NumberUpSupported"))) {
            NumberUpSupported[] numberUpSupportedArray = (NumberUpSupported[])set.toArray(new NumberUpSupported[set.size()]);
            if (set.size() == 1) {
                return numberUpSupportedArray[0];
            }
            int[][] nArray = new int[set.size()][2];
            for (int i = 0; i < set.size(); ++i) {
                int n = numberUpSupportedArray[i].getMembers()[0][0];
                nArray[i] = new int[]{n, n};
            }
            NumberUpSupported numberUpSupported = new NumberUpSupported(nArray);
            return numberUpSupported;
        }
        return null;
    }

    public DocFlavor[] getSupportedDocFlavors() {
        return (DocFlavor[])this.flavors.toArray(new DocFlavor[this.flavors.size()]);
    }

    public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
        Object object;
        if (docFlavor != null && !this.isDocFlavorSupported(docFlavor)) {
            throw new IllegalArgumentException("flavor is not supported");
        }
        IppResponse ippResponse = null;
        try {
            short s;
            object = new IppRequest(this.printerUri.getURI(), this.user, this.passwd);
            short s2 = (short)OperationsSupported.VALIDATE_JOB.getValue();
            ((IppRequest)object).setOperationID(s2);
            ((IppRequest)object).setOperationAttributeDefaults();
            ((IppRequest)object).addOperationAttribute(this.printerUri);
            ((IppRequest)object).addOperationAttribute(Fidelity.FIDELITY_TRUE);
            if (attributeSet != null && attributeSet.size() > 0) {
                ((IppRequest)object).addAndFilterJobOperationAttributes(attributeSet);
                ((IppRequest)object).addAndFilterJobTemplateAttributes(attributeSet);
            }
            if (docFlavor != null) {
                DocumentFormat documentFormat = DocumentFormat.createDocumentFormat(docFlavor);
                ((IppRequest)object).addOperationAttribute(documentFormat);
            }
            if ((s = (ippResponse = ((IppRequest)object).send()).getStatusCode()) != 0 && s != 1 && s != 2) {
                logger.log(Component.IPP, "Statuscode not OK - got:" + s);
            }
        }
        catch (IOException iOException) {
            logger.log((Level)Component.IPP, "IOException", iOException);
        }
        catch (IppException ippException) {
            logger.log((Level)Component.IPP, "IPPException", ippException);
        }
        object = ippResponse.getUnsupportedAttributes();
        if (object.size() == 0) {
            return null;
        }
        Map map = (Map)object.get(0);
        if (map.size() == 0) {
            return null;
        }
        HashAttributeSet hashAttributeSet = new HashAttributeSet();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Set set = (Set)iterator.next();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                hashAttributeSet.add((Attribute)iterator2.next());
            }
        }
        return hashAttributeSet;
    }

    public boolean isAttributeCategorySupported(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("category may not be null");
        }
        if (!IppPrintService.class$("javax.print.attribute.Attribute").isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("category must be of type Attribute");
        }
        return Arrays.asList(this.getSupportedAttributeCategories()).contains(clazz);
    }

    public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
        Object object = this.getSupportedAttributeValues(attribute.getCategory(), docFlavor, attributeSet);
        if (object == null) {
            return false;
        }
        if (object.getClass().isArray()) {
            return Arrays.asList((Object[])object).contains(attribute);
        }
        if (object.getClass().equals(attribute.getCategory())) {
            return true;
        }
        if (object.getClass().equals(IppPrintService.class$("javax.print.attribute.standard.CopiesSupported"))) {
            return ((CopiesSupported)object).contains((IntegerSyntax)((Object)attribute));
        }
        if (object.getClass().equals(IppPrintService.class$("javax.print.attribute.standard.NumberUpSupported"))) {
            return ((NumberUpSupported)object).contains((IntegerSyntax)((Object)attribute));
        }
        if (object.getClass().equals(IppPrintService.class$("javax.print.attribute.standard.JobPrioritySupported"))) {
            JobPriority jobPriority = (JobPriority)attribute;
            JobPrioritySupported jobPrioritySupported = (JobPrioritySupported)object;
            if (jobPriority.getValue() < jobPrioritySupported.getValue()) {
                return true;
            }
        }
        return false;
    }

    public boolean isDocFlavorSupported(DocFlavor docFlavor) {
        if (docFlavor == null) {
            throw new NullPointerException("DocFlavor may not be null.");
        }
        return this.flavors.contains(docFlavor);
    }

    public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        this.printServiceAttributeListener.add(printServiceAttributeListener);
    }

    public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
        this.printServiceAttributeListener.remove(printServiceAttributeListener);
    }

    public String toString() {
        return "IppPrinter: " + this.getName();
    }

    public PrinterURI getPrinterURI() {
        return this.printerUri;
    }

    static {
        JOB_NAME = new JobName("Java Printing", null);
        REQUESTING_USER_NAME = new RequestingUserName(SystemProperties.getProperty("user.name", ""), null);
    }
}

