/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.javax.crypto.mac.IMac;
import java.util.Arrays;
import java.util.Map;

class SSLHMac
implements IMac,
Cloneable {
    static final byte PAD1 = 54;
    static final byte PAD2 = 92;
    protected IMessageDigest md;
    protected byte[] key;
    protected final byte[] pad1;
    protected final byte[] pad2;

    SSLHMac(String string) {
        this.md = HashFactory.getInstance(string);
        if (string.equalsIgnoreCase("MD5")) {
            this.pad1 = new byte[48];
            this.pad2 = new byte[48];
        } else {
            this.pad1 = new byte[40];
            this.pad2 = new byte[40];
        }
        Arrays.fill(this.pad1, (byte)54);
        Arrays.fill(this.pad2, (byte)92);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    public String name() {
        return "SSLHMac-" + this.md.name();
    }

    public int macSize() {
        return this.md.hashSize();
    }

    public void init(Map map) {
        this.key = (byte[])map.get("gnu.crypto.mac.key.material");
        if (this.key == null) {
            throw new NullPointerException();
        }
        this.reset();
    }

    public void reset() {
        this.md.reset();
        this.md.update(this.key, 0, this.key.length);
        this.md.update(this.pad1, 0, this.pad1.length);
    }

    public byte[] digest() {
        byte[] byArray = this.md.digest();
        this.md.update(this.key, 0, this.key.length);
        this.md.update(this.pad2, 0, this.pad2.length);
        this.md.update(byArray, 0, byArray.length);
        byte[] byArray2 = this.md.digest();
        this.reset();
        return byArray2;
    }

    public void update(byte by) {
        this.md.update(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.md.update(byArray, n, n2);
    }

    public boolean selfTest() {
        return true;
    }
}

