/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGHeader;

public class PNGFilter {
    public static final byte FILTER_NONE = 0;
    public static final byte FILTER_SUB = 1;
    public static final byte FILTER_UP = 2;
    public static final byte FILTER_AVERAGE = 3;
    public static final byte FILTER_PAETH = 4;

    public static boolean useFilter(PNGHeader pNGHeader) {
        switch (pNGHeader.getColorType()) {
            case 3: {
                return false;
            }
            case 0: 
            case 2: {
                if (pNGHeader.bytesPerPixel() > 1) break;
                return false;
            }
        }
        return true;
    }

    public static byte chooseFilter(byte[] byArray, byte[] byArray2, int n) {
        long[] lArray = new long[5];
        int n2 = 0;
        for (int i = 0; i < 5; ++i) {
            byte[] byArray3 = PNGFilter.filterScanline((byte)i, byArray, byArray2, n);
            lArray[i] = 0L;
            for (int j = 0; j < byArray3.length; ++j) {
                int n3 = i;
                lArray[n3] = lArray[n3] + ((long)byArray3[j] & (long)255);
            }
            if (lArray[n2] <= lArray[i]) continue;
            n2 = i;
        }
        return (byte)n2;
    }

    public static byte[] filterScanline(byte by, byte[] byArray, byte[] byArray2, int n) {
        int n2 = byArray.length;
        byte[] byArray3 = new byte[n2];
        switch (by) {
            case 1: {
                int n3;
                for (n3 = 0; n3 < n; ++n3) {
                    byArray3[n3] = byArray[n3];
                }
                for (n3 = n; n3 < n2; ++n3) {
                    byArray3[n3] = byArray[n3] - byArray[n3 - n];
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    byArray3[i] = byArray[i] - byArray2[i];
                }
                break;
            }
            case 3: {
                int n4;
                for (n4 = 0; n4 < n; ++n4) {
                    byArray3[n4] = byArray[n4] - (byte)((byArray2[n4] & 0xFF) >> 1);
                }
                for (n4 = n; n4 < n2; ++n4) {
                    byArray3[n4] = byArray[n4] - (byte)((byArray[n4 - n] & 0xFF) + (byArray2[n4] & 0xFF) >> 1);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n2; ++i) {
                    int n5;
                    int n6;
                    int n7;
                    if (i >= n) {
                        n7 = byArray[i - n] & 0xFF;
                        n6 = byArray2[i - n] & 0xFF;
                    } else {
                        n6 = 0;
                        n7 = 0;
                    }
                    int n8 = byArray2[i] & 0xFF;
                    int n9 = n7 + n8 - n6;
                    int n10 = n9 > n7 ? n9 - n7 : n7 - n9;
                    int n11 = n9 > n8 ? n9 - n8 : n8 - n9;
                    int n12 = n5 = n9 > n6 ? n9 - n6 : n6 - n9;
                    int n13 = n10 <= n11 && n10 <= n5 ? n7 : (n11 <= n5 ? n8 : n6);
                    byArray3[i] = byArray[i] - (byte)n13;
                }
                break;
            }
            default: {
                return byArray;
            }
        }
        return byArray3;
    }

    public static byte[] unFilterScanline(int n, byte[] byArray, byte[] byArray2, int n2) {
        int n3 = byArray.length;
        byte[] byArray3 = new byte[n3];
        switch (n) {
            case 0: {
                System.arraycopy(byArray, 0, byArray3, 0, n3);
                break;
            }
            case 1: {
                int n4;
                for (n4 = 0; n4 < n2; ++n4) {
                    byArray3[n4] = byArray[n4];
                }
                for (n4 = n2; n4 < n3; ++n4) {
                    byArray3[n4] = byArray[n4] + byArray3[n4 - n2];
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n3; ++i) {
                    byArray3[i] = byArray[i] + byArray2[i];
                }
                break;
            }
            case 3: {
                int n5;
                for (n5 = 0; n5 < n2; ++n5) {
                    byArray3[n5] = byArray[n5] + (byte)((byArray2[n5] & 0xFF) >> 1);
                }
                for (n5 = n2; n5 < n3; ++n5) {
                    byArray3[n5] = byArray[n5] + (byte)((byArray3[n5 - n2] & 0xFF) + (byArray2[n5] & 0xFF) >> 1);
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n3; ++i) {
                    int n6;
                    int n7;
                    int n8;
                    if (i >= n2) {
                        n8 = byArray3[i - n2] & 0xFF;
                        n7 = byArray2[i - n2] & 0xFF;
                    } else {
                        n7 = 0;
                        n8 = 0;
                    }
                    int n9 = byArray2[i] & 0xFF;
                    int n10 = n8 + n9 - n7;
                    int n11 = n10 > n8 ? n10 - n8 : n8 - n10;
                    int n12 = n10 > n9 ? n10 - n9 : n9 - n10;
                    int n13 = n6 = n10 > n7 ? n10 - n7 : n7 - n10;
                    int n14 = n11 <= n12 && n11 <= n6 ? n8 : (n12 <= n6 ? n9 : n7);
                    byArray3[i] = byArray[i] + (byte)n14;
                }
                break;
            }
        }
        return byArray3;
    }
}

