/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl;

import gnu.java.security.util.Util;
import gnu.javax.crypto.sasl.SaslEncodingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class OutputBuffer {
    private ByteArrayOutputStream out = new ByteArrayOutputStream();

    public void setScalar(int n, int n2) throws IOException {
        if (n < 0 || n > 4) {
            throw new SaslEncodingException("Invalid SASL scalar octet count: " + String.valueOf(n));
        }
        byte[] byArray = new byte[n];
        int n3 = n;
        while (--n3 >= 0) {
            byArray[n3] = (byte)n2;
            n2 >>>= 8;
        }
        this.out.write(byArray);
    }

    public void setOS(byte[] byArray) throws IOException {
        int n = byArray.length;
        if (n > 255) {
            throw new SaslEncodingException("SASL octet-sequence too long");
        }
        this.out.write(n & 0xFF);
        this.out.write(byArray);
    }

    public void setEOS(byte[] byArray) throws IOException {
        int n = byArray.length;
        if (n > 65535) {
            throw new SaslEncodingException("SASL extended octet-sequence too long");
        }
        byte[] byArray2 = new byte[]{(byte)(n >>> 8), (byte)n};
        this.out.write(byArray2);
        this.out.write(byArray);
    }

    public void setMPI(BigInteger bigInteger) throws IOException {
        byte[] byArray = Util.trim(bigInteger);
        int n = byArray.length;
        if (n > 65535) {
            throw new SaslEncodingException("SASL multi-precision integer too long");
        }
        byte[] byArray2 = new byte[]{(byte)(n >>> 8), (byte)n};
        this.out.write(byArray2);
        this.out.write(byArray);
    }

    public void setText(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF8");
        int n = byArray.length;
        if (n > 65535) {
            throw new SaslEncodingException("SASL text too long");
        }
        byte[] byArray2 = new byte[]{(byte)(n >>> 8), (byte)n};
        this.out.write(byArray2);
        this.out.write(byArray);
    }

    public byte[] encode() throws SaslEncodingException {
        byte[] byArray = this.wrap();
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 4];
        byArray2[0] = (byte)(n >>> 24);
        byArray2[1] = (byte)(n >>> 16);
        byArray2[2] = (byte)(n >>> 8);
        byArray2[3] = (byte)n;
        System.arraycopy(byArray, 0, byArray2, 4, n);
        return byArray2;
    }

    public byte[] wrap() throws SaslEncodingException {
        int n = this.out.size();
        if (n > 0x7FFFFFFB || n < 0) {
            throw new SaslEncodingException("SASL buffer too long");
        }
        return this.out.toByteArray();
    }
}

