/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.java.security.Registry;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mac.BaseMac;
import gnu.javax.crypto.mac.HMacFactory;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.OMAC;
import gnu.javax.crypto.mac.TMMH16;
import gnu.javax.crypto.mac.UHash32;
import gnu.javax.crypto.mac.UMac32;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MacFactory
implements Registry {
    private static Set names;

    private MacFactory() {
    }

    public static IMac getInstance(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        if ((string = string.toLowerCase()).startsWith("hmac-")) {
            return HMacFactory.getInstance(string);
        }
        if (string.startsWith("omac-")) {
            IBlockCipher iBlockCipher = CipherFactory.getInstance(string = string.substring(Registry.OMAC_PREFIX.length()));
            if (iBlockCipher == null) {
                return null;
            }
            return new OMAC(iBlockCipher);
        }
        BaseMac baseMac = null;
        if (string.equalsIgnoreCase("uhash32")) {
            baseMac = new UHash32();
        } else if (string.equalsIgnoreCase("umac32")) {
            baseMac = new UMac32();
        } else if (string.equalsIgnoreCase("tmmh16")) {
            baseMac = new TMMH16();
        }
        if (baseMac != null && !baseMac.selfTest()) {
            throw new InternalError(baseMac.name());
        }
        return baseMac;
    }

    public static final Set getNames() {
        Set set;
        Class clazz = MacFactory.class$("gnu.javax.crypto.mac.MacFactory");
        synchronized (clazz) {
            block4: {
                try {
                    if (names != null) break block4;
                    set = new HashSet();
                    ((AbstractCollection)((Object)set)).addAll(HMacFactory.getNames());
                    ((HashSet)set).add("uhash32");
                    ((HashSet)set).add("umac32");
                    ((HashSet)set).add("tmmh16");
                    Iterator iterator = CipherFactory.getNames().iterator();
                    while (iterator.hasNext()) {
                        ((HashSet)set).add("omac-" + iterator.next());
                    }
                    names = Collections.unmodifiableSet(set);
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    throw throwable;
                }
            }
            set = null;
        }
        set = names;
        return set;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

