/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.GnuPKIExtension;
import gnu.java.security.x509.ext.Extension;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

class X509CRLEntry
extends java.security.cert.X509CRLEntry
implements GnuPKIExtension {
    private static final Logger log = Logger.getLogger(X509CRLEntry.class$("gnu.java.security.x509.X509CRLEntry").getName());
    private byte[] encoded;
    private BigInteger serialNo;
    private Date revocationDate;
    private HashMap extensions = new HashMap();

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    X509CRLEntry(int n, DERReader dERReader) throws CRLException, IOException {
        try {
            this.parse(n, dERReader);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new CRLException(exception.toString());
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof X509CRLEntry)) {
            return false;
        }
        return ((X509CRLEntry)object).getSerialNumber().equals(this.serialNo) && ((X509CRLEntry)object).getRevocationDate().equals(this.revocationDate);
    }

    public int hashCode() {
        return this.serialNo.hashCode();
    }

    public byte[] getEncoded() throws CRLException {
        return (byte[])this.encoded.clone();
    }

    public BigInteger getSerialNumber() {
        return this.serialNo;
    }

    public Date getRevocationDate() {
        return (Date)this.revocationDate.clone();
    }

    public boolean hasExtensions() {
        return this.extensions.isEmpty() ^ true;
    }

    public String toString() {
        return "X509CRLEntry serial=" + this.serialNo + " revocation date=" + this.revocationDate + " ext=" + this.extensions;
    }

    public boolean hasUnsupportedCriticalExtension() {
        Iterator iterator = this.extensions.values().iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!extension.isCritical() || extension.isSupported()) continue;
            return true;
        }
        return false;
    }

    public Set getCriticalExtensionOIDs() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.extensions.values().iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!extension.isCritical()) continue;
            hashSet.add(extension.getOid().toString());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.extensions.values().iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (extension.isCritical()) continue;
            hashSet.add(extension.getOid().toString());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public byte[] getExtensionValue(String string) {
        Extension extension = this.getExtension(new OID(string));
        if (extension != null) {
            return extension.getValue().getEncoded();
        }
        return null;
    }

    public Extension getExtension(OID oID) {
        return (Extension)this.extensions.get(oID);
    }

    public Collection getExtensions() {
        return this.extensions.values();
    }

    private void parse(int n, DERReader dERReader) throws Exception {
        DERValue dERValue = dERReader.read();
        if (!dERValue.isConstructed()) {
            throw new IOException("malformed revokedCertificate");
        }
        this.encoded = dERValue.getEncoded();
        int n2 = 0;
        DERValue dERValue2 = dERReader.read();
        this.serialNo = (BigInteger)dERValue2.getValue();
        n2 += dERValue2.getEncodedLength();
        dERValue2 = dERReader.read();
        this.revocationDate = (Date)dERValue2.getValue();
        if ((n2 += dERValue2.getEncodedLength()) < dERValue.getLength()) {
            if (n < 2) {
                throw new IOException("extra data in CRL entry");
            }
            DERValue dERValue3 = dERReader.read();
            if (!dERValue3.isConstructed()) {
                throw new IOException("malformed Extensions");
            }
            for (n2 = 0; n2 < dERValue3.getLength(); n2 += dERValue2.getEncodedLength()) {
                dERValue2 = dERReader.read();
                if (!dERValue2.isConstructed()) {
                    throw new IOException("malformed Extension");
                }
                Extension extension = new Extension(dERValue2.getEncoded());
                this.extensions.put(extension.getOid(), extension);
                dERReader.skip(dERValue2.getLength());
            }
        }
    }
}

