/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.activation;

import gnu.java.rmi.activation.ActivationSystemTransient;
import gnu.java.rmi.server.ActivatableServerRef;
import gnu.java.rmi.server.UnicastServer;
import java.lang.reflect.Constructor;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;

public class DefaultActivationGroup
extends ActivationGroup {
    private static final long serialVersionUID = 1L;
    static final Class[] cConstructorTypes = new Class[]{DefaultActivationGroup.class$("java.rmi.activation.ActivationID"), DefaultActivationGroup.class$("java.rmi.MarshalledObject")};

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DefaultActivationGroup(ActivationGroupID activationGroupID, MarshalledObject marshalledObject) throws RemoteException {
        super(activationGroupID);
    }

    public void activeObject(ActivationID activationID, Remote remote) throws ActivationException, UnknownObjectException, RemoteException {
    }

    public MarshalledObject newInstance(ActivationID activationID, ActivationDesc activationDesc) throws ActivationException, RemoteException {
        try {
            if (ActivationSystemTransient.debug) {
                System.out.println("Instantiating " + activationDesc.getClassName());
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class clazz = classLoader.loadClass(activationDesc.getClassName());
            Constructor constructor = clazz.getConstructor(cConstructorTypes);
            Remote remote = (Remote)constructor.newInstance(new Object[]{activationID, activationDesc.getData()});
            ActivatableServerRef activatableServerRef = UnicastServer.getActivatableRef(activationID);
            Remote remote2 = activatableServerRef.exportObject(remote);
            MarshalledObject marshalledObject = new MarshalledObject(remote2);
            this.activeObject(activationID, marshalledObject);
            this.activeObject(activationID, remote2);
            return marshalledObject;
        }
        catch (Exception exception) {
            ActivationException activationException = new ActivationException("Unable to activate " + activationDesc.getClassName() + " from " + activationDesc.getLocation(), exception);
            throw activationException;
        }
    }
}

