/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.net.PlainDatagramSocketImpl;
import gnu.java.nio.NIODatagramSocket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;

public final class DatagramChannelImpl
extends DatagramChannel {
    private NIODatagramSocket socket = new NIODatagramSocket(new PlainDatagramSocketImpl(), this);
    private boolean inChannelOperation;

    public final boolean isInChannelOperation() {
        return this.inChannelOperation;
    }

    public final void setInChannelOperation(boolean bl) {
        this.inChannelOperation = bl;
    }

    protected DatagramChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.configureBlocking(true);
    }

    public int getNativeFD() {
        return this.socket.getPlainDatagramSocketImpl().getNativeFD();
    }

    public DatagramSocket socket() {
        return this.socket;
    }

    protected void implCloseSelectableChannel() throws IOException {
        this.socket.close();
    }

    protected void implConfigureBlocking(boolean bl) throws IOException {
        this.socket.setSoTimeout(bl ? 0 : 50);
    }

    public DatagramChannel connect(SocketAddress socketAddress) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.socket.connect(socketAddress);
        return this;
    }

    public DatagramChannel disconnect() throws IOException {
        this.socket.disconnect();
        return this;
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        return this.send(byteBuffer, this.socket.getRemoteSocketAddress());
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        long l = 0L;
        for (int i = n; i < n + n2; ++i) {
            l += (long)this.write(byteBufferArray[i]);
        }
        return l;
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        int n = byteBuffer.remaining();
        this.receive(byteBuffer);
        return n - byteBuffer.remaining();
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (n < 0 || n > byteBufferArray.length || n2 < 0 || n2 > byteBufferArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        long l = 0L;
        for (int i = n; i < n + n2; ++i) {
            l += (long)this.read(byteBufferArray[i]);
        }
        return l;
    }

    public SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        try {
            SocketAddress socketAddress;
            int n = byteBuffer.remaining();
            DatagramPacket datagramPacket = byteBuffer.hasArray() ? new DatagramPacket(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n) : new DatagramPacket(new byte[n], n);
            boolean bl = false;
            try {
                this.begin();
                this.setInChannelOperation(true);
                this.socket.receive(datagramPacket);
                bl = true;
            }
            finally {
                socketAddress = null;
                this.end(bl);
                this.setInChannelOperation(false);
            }
            if (!byteBuffer.hasArray()) {
                byteBuffer.put(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
            } else {
                byteBuffer.position(byteBuffer.position() + datagramPacket.getLength());
            }
            socketAddress = datagramPacket.getSocketAddress();
            return socketAddress;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            SocketAddress socketAddress = null;
            return socketAddress;
        }
    }

    public int send(ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        byte[] byArray;
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (socketAddress instanceof InetSocketAddress && ((InetSocketAddress)socketAddress).isUnresolved()) {
            throw new IOException("Target address not resolved");
        }
        int n = 0;
        int n2 = byteBuffer.remaining();
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
            n = byteBuffer.arrayOffset() + byteBuffer.position();
        } else {
            byArray = new byte[n2];
            byteBuffer.get(byArray);
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, n2, socketAddress);
        boolean bl = false;
        try {
            this.begin();
            this.setInChannelOperation(true);
            this.socket.send(datagramPacket);
            bl = true;
        }
        finally {
            Object var8_8 = null;
            this.end(bl);
            this.setInChannelOperation(false);
        }
        if (byteBuffer.hasArray()) {
            byteBuffer.position(byteBuffer.position() + n2);
        }
        int n3 = n2;
        return n3;
    }
}

