/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.reflect;

import gnu.java.lang.reflect.TypeImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

final class ParameterizedTypeImpl
extends TypeImpl
implements ParameterizedType {
    private String rawTypeName;
    private ClassLoader loader;
    private Class rawType;
    private Type owner;
    private Type[] typeArgs;

    ParameterizedTypeImpl(String string, ClassLoader classLoader, Type type, Type[] typeArray) {
        this.rawTypeName = string;
        this.loader = classLoader;
        this.owner = type;
        this.typeArgs = typeArray;
    }

    Type resolve() {
        if (this.rawType == null) {
            try {
                this.rawType = Class.forName(this.rawTypeName, false, this.loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new TypeNotPresentException(this.rawTypeName, classNotFoundException);
            }
        }
        if (this.typeArgs == null) {
            if (this.owner == null) {
                return this.rawType;
            }
            this.typeArgs = new Type[0];
        }
        TypeImpl.resolve(this.typeArgs);
        this.owner = TypeImpl.resolve(this.owner);
        return this;
    }

    public Type[] getActualTypeArguments() {
        return (Type[])this.typeArgs.clone();
    }

    public Type getRawType() {
        return this.rawType;
    }

    public Type getOwnerType() {
        return this.owner;
    }

    public boolean equals(Object object) {
        if (object instanceof ParameterizedTypeImpl) {
            ParameterizedTypeImpl parameterizedTypeImpl = (ParameterizedTypeImpl)object;
            return this.rawType.equals(parameterizedTypeImpl.rawType) && (this.owner == null && parameterizedTypeImpl.owner == null || this.owner.equals(parameterizedTypeImpl.owner)) && Arrays.deepEquals(this.typeArgs, parameterizedTypeImpl.typeArgs);
        }
        return false;
    }

    public int hashCode() {
        int n = 0x58158970 ^ this.rawType.hashCode();
        if (this.owner != null) {
            n ^= Integer.reverse(this.owner.hashCode());
        }
        for (int i = 0; i < this.typeArgs.length; ++i) {
            n ^= Integer.rotateLeft(this.typeArgs[i].hashCode(), i);
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.owner != null) {
            stringBuilder.append(this.owner);
            stringBuilder.append('.');
            stringBuilder.append(this.rawType.getSimpleName());
        } else {
            stringBuilder.append(this.rawTypeName);
        }
        if (this.typeArgs.length > 0) {
            stringBuilder.append('<');
            for (int i = 0; i < this.typeArgs.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (this.typeArgs[i] instanceof Class) {
                    stringBuilder.append(((Class)this.typeArgs[i]).getName());
                    continue;
                }
                stringBuilder.append(this.typeArgs[i]);
            }
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }
}

