/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.GtkImageConsumer;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class GtkImage
extends Image {
    int width;
    int height;
    Hashtable props;
    boolean isLoaded;
    Pointer pixbuf;
    Vector observers;
    boolean errorLoading;
    ImageProducer source;
    static ColorModel nativeModel = new DirectColorModel(32, 255, 65280, 0xFF0000, -16777216);
    private static GtkImage errorImage;
    static Object pixbufLock;

    private /* synthetic */ void finit$() {
        this.width = -1;
        this.height = -1;
    }

    private native void initFromBuffer(long var1);

    native int[] getPixels();

    private native void setPixels(int[] var1);

    private native boolean loadPixbuf(String var1);

    private native boolean loadImageFromData(byte[] var1);

    private native void createPixbuf();

    private native void freePixbuf();

    private native void createScaledPixbuf(GtkImage var1, int var2);

    public GtkImage(ImageProducer imageProducer) {
        this.finit$();
        this.isLoaded = false;
        this.observers = new Vector();
        this.source = imageProducer;
        this.errorLoading = false;
        this.source.startProduction(new GtkImageConsumer(this, this.source));
    }

    public GtkImage() {
        this.finit$();
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
        this.errorLoading = false;
    }

    public GtkImage(String string) {
        this.finit$();
        File file = new File(string);
        try {
            String string2 = file.getCanonicalPath();
            Object object = pixbufLock;
            synchronized (object) {
                try {
                    if (!this.loadPixbuf(file.getCanonicalPath())) {
                        throw new IllegalArgumentException("Couldn't load image: " + string);
                    }
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }
        catch (IOException iOException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Couldn't load image: " + string);
            illegalArgumentException.initCause(iOException);
            throw illegalArgumentException;
        }
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
    }

    public GtkImage(byte[] byArray) {
        this.finit$();
        Object object = pixbufLock;
        synchronized (object) {
            try {
                if (!this.loadImageFromData(byArray)) {
                    throw new IllegalArgumentException("Couldn't load image.");
                }
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
        this.errorLoading = false;
    }

    public GtkImage(URL uRL) {
        Object object;
        Object object2;
        this.finit$();
        this.isLoaded = false;
        this.observers = new Vector();
        this.errorLoading = false;
        if (uRL == null) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(5000);
        try {
            object2 = new BufferedInputStream(uRL.openStream());
            object = new byte[5000];
            int n = 0;
            while ((n = ((FilterInputStream)object2).read((byte[])object)) != -1) {
                byteArrayOutputStream.write((byte[])object, 0, n);
            }
            ((BufferedInputStream)object2).close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Couldn't load image.");
        }
        object2 = byteArrayOutputStream.toByteArray();
        object = pixbufLock;
        synchronized (object) {
            try {
                if (!this.loadImageFromData((byte[])object2)) {
                    throw new IllegalArgumentException("Couldn't load image.");
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
        }
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
    }

    private GtkImage(GtkImage gtkImage, int n, int n2, int n3) {
        this.finit$();
        this.width = n;
        this.height = n2;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.observers = null;
        Object object = pixbufLock;
        synchronized (object) {
            try {
                this.createScaledPixbuf(gtkImage, n3);
            }
            finally {
                Object var6_6 = null;
            }
            return;
        }
    }

    GtkImage(Pointer pointer) {
        this.finit$();
        this.pixbuf = pointer;
        Object object = pixbufLock;
        synchronized (object) {
            try {
                this.createFromPixbuf();
            }
            finally {
                Object var3_3 = null;
            }
            this.isLoaded = true;
            this.observers = null;
            this.props = new Hashtable();
            return;
        }
    }

    GtkImage(int n, int n2, long l) {
        this.finit$();
        this.width = n;
        this.height = n2;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.observers = null;
        this.initFromBuffer(l);
    }

    static synchronized GtkImage getErrorImage() {
        if (errorImage == null) {
            errorImage = new GtkImage();
            GtkImage.errorImage.errorLoading = true;
        }
        return errorImage;
    }

    private native void createFromPixbuf();

    public void setImage(int n, int n2, int[] nArray, Hashtable hashtable) {
        this.width = n;
        this.height = n2;
        Hashtable hashtable2 = this.props = hashtable != null ? hashtable : new Hashtable();
        if (n <= 0 || n2 <= 0 || nArray == null) {
            this.errorLoading = true;
            return;
        }
        this.isLoaded = true;
        this.deliver();
        Object object = pixbufLock;
        synchronized (object) {
            try {
                this.createPixbuf();
                this.setPixels(nArray);
            }
            finally {
                Object var6_6 = null;
            }
            return;
        }
    }

    public synchronized int getWidth(ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return -1;
        }
        return this.width;
    }

    public synchronized int getHeight(ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return -1;
        }
        return this.height;
    }

    public synchronized Object getProperty(String string, ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return Image.UndefinedProperty;
        }
        Object object = this.props.get(string);
        if (object == null) {
            return Image.UndefinedProperty;
        }
        return object;
    }

    public ImageProducer getSource() {
        int[] nArray;
        if (!this.isLoaded) {
            return null;
        }
        Object object = pixbufLock;
        synchronized (object) {
            block5: {
                try {
                    if (!this.errorLoading) {
                        nArray = this.getPixels();
                        break block5;
                    }
                    ImageProducer imageProducer = null;
                    Object var4_5 = null;
                    return imageProducer;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    throw throwable;
                }
            }
            Object var4_6 = null;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(this.width, this.height, nativeModel, nArray, 0, this.width);
        return memoryImageSource;
    }

    public Graphics getGraphics() {
        throw new IllegalAccessError("This method only works for off-screen Images.");
    }

    public Image getScaledInstance(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Width and height of scaled bitmapmust be >= 0");
        }
        return new GtkImage(this, n, n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void flush() {
        if (!this.isLoaded || this.source == null) return;
        this.observers = new Vector();
        this.isLoaded = false;
        Object object = pixbufLock;
        synchronized (object) {
            try {
                this.freePixbuf();
            }
            finally {
                Object var2_2 = null;
            }
            this.source.startProduction(new GtkImageConsumer(this, this.source));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalize() {
        if (!this.isLoaded) return;
        Object object = pixbufLock;
        synchronized (object) {
            try {
                this.freePixbuf();
                return;
            }
            finally {
                Object var2_2 = null;
            }
        }
    }

    public int checkImage(ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            if (this.errorLoading) {
                return 64;
            }
            return 0;
        }
        return 35;
    }

    private void deliver() {
        int n = 39;
        if (this.observers != null) {
            for (int i = 0; i < this.observers.size(); ++i) {
                ((ImageObserver)this.observers.elementAt(i)).imageUpdate(this, n, 0, 0, this.width, this.height);
            }
        }
        this.observers = null;
    }

    private boolean addObserver(ImageObserver imageObserver) {
        if (!this.isLoaded) {
            if (imageObserver != null && !this.observers.contains(imageObserver)) {
                this.observers.addElement(imageObserver);
            }
            return true;
        }
        return false;
    }

    static {
        pixbufLock = new Object();
    }
}

