/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.BufferedImageGraphics;
import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.GdkScreenGraphicsDevice;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.Locale;

public class GdkGraphicsEnvironment
extends GraphicsEnvironment {
    private final int native_state;
    private GdkScreenGraphicsDevice defaultDevice;
    private GdkScreenGraphicsDevice[] devices;

    private /* synthetic */ void finit$() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
    }

    static native void initStaticState();

    public GdkGraphicsEnvironment() {
        this.finit$();
        this.nativeInitState();
    }

    native void nativeInitState();

    public GraphicsDevice[] getScreenDevices() {
        if (this.devices == null) {
            this.devices = this.nativeGetScreenDevices();
        }
        return (GraphicsDevice[])this.devices.clone();
    }

    private native GdkScreenGraphicsDevice[] nativeGetScreenDevices();

    public GraphicsDevice getDefaultScreenDevice() {
        GdkScreenGraphicsDevice gdkScreenGraphicsDevice;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        Class clazz = GdkGraphicsEnvironment.class$("gnu.java.awt.peer.gtk.GdkGraphicsEnvironment");
        synchronized (clazz) {
            block4: {
                try {
                    if (this.defaultDevice != null) break block4;
                    this.defaultDevice = this.nativeGetDefaultScreenDevice();
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            gdkScreenGraphicsDevice = null;
        }
        gdkScreenGraphicsDevice = this.defaultDevice;
        return gdkScreenGraphicsDevice;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private native GdkScreenGraphicsDevice nativeGetDefaultScreenDevice();

    public Graphics2D createGraphics(BufferedImage bufferedImage) {
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof CairoSurface) {
            return ((CairoSurface)dataBuffer).getGraphics();
        }
        return new BufferedImageGraphics(bufferedImage);
    }

    private native int nativeGetNumFontFamilies();

    private native void nativeGetFontFamilies(String[] var1);

    public Font[] getAllFonts() {
        throw new UnsupportedOperationException();
    }

    public String[] getAvailableFontFamilyNames() {
        int n = this.nativeGetNumFontFamilies();
        String[] stringArray = new String[n];
        this.nativeGetFontFamilies(stringArray);
        return stringArray;
    }

    public String[] getAvailableFontFamilyNames(Locale locale) {
        throw new UnsupportedOperationException();
    }

    native int[] getMouseCoordinates();

    static {
        System.loadLibrary("gtkpeer");
        GdkGraphicsEnvironment.initStaticState();
    }
}

