/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;

final class GlyphNamer {
    private ByteBuffer postTable;
    private ByteBuffer zapfTable;
    private IntBuffer zapfOffsets;
    private int zapfExtraInfo;
    private int postFormat;
    private String[] glyphNames;
    private CharBuffer glyphCharacterCodes;
    private static final String[] STANDARD_POSTSCRIPT_GLYPH_NAMES = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};
    private static final String AGLFN_GLYPHS = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ae\u00af\u00b0\u00b1\u00b4\u00b5\u00b6\u00b7\u00b8\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff\u0100\u0101\u0102\u0103\u0104\u0105\u0106\u0107\u0108\u0109\u010a\u010b\u010c\u010d\u010e\u010f\u0110\u0111\u0112\u0113\u0114\u0115\u0116\u0117\u0118\u0119\u011a\u011b\u011c\u011d\u011e\u011f\u0120\u0121\u0122\u0123\u0124\u0125\u0126\u0127\u0128\u0129\u012a\u012b\u012c\u012d\u012e\u012f\u0130\u0131\u0132\u0133\u0134\u0135\u0136\u0137\u0138\u0139\u013a\u013b\u013c\u013d\u013e\u013f\u0140\u0141\u0142\u0143\u0144\u0145\u0146\u0147\u0148\u0149\u014a\u014b\u014c\u014d\u014e\u014f\u0150\u0151\u0152\u0153\u0154\u0155\u0156\u0157\u0158\u0159\u015a\u015b\u015c\u015d\u015e\u015f\u0160\u0161\u0162\u0163\u0164\u0165\u0166\u0167\u0168\u0169\u016a\u016b\u016c\u016d\u016e\u016f\u0170\u0171\u0172\u0173\u0174\u0175\u0176\u0177\u0178\u0179\u017a\u017b\u017c\u017d\u017e\u017f\u0192\u01a0\u01a1\u01af\u01b0\u01e6\u01e7\u01fa\u01fb\u01fc\u01fd\u01fe\u01ff\u0218\u0219\u02bc\u02bd\u02c6\u02c7\u02d8\u02d9\u02da\u02db\u02dc\u02dd\u0300\u0301\u0303\u0309\u0323\u0384\u0385\u0386\u0387\u0388\u0389\u038a\u038c\u038e\u038f\u0390\u0391\u0392\u0393\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03aa\u03ab\u03ac\u03ad\u03ae\u03af\u03b0\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bd\u03be\u03bf\u03c0\u03c1\u03c2\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9\u03ca\u03cb\u03cc\u03cd\u03ce\u03d1\u03d2\u03d5\u03d6\u0401\u0402\u0403\u0404\u0405\u0406\u0407\u0408\u0409\u040a\u040b\u040c\u040e\u040f\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042a\u042b\u042c\u042d\u042e\u042f\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044a\u044b\u044c\u044d\u044e\u044f\u0451\u0452\u0453\u0454\u0455\u0456\u0457\u0458\u0459\u045a\u045b\u045c\u045e\u045f\u0462\u0463\u0472\u0473\u0474\u0475\u0490\u0491\u04d9\u05b0\u05b1\u05b2\u05b3\u05b4\u05b5\u05b6\u05b7\u05b8\u05b9\u05bb\u05bc\u05bd\u05be\u05bf\u05c0\u05c1\u05c2\u05c3\u05d0\u05d1\u05d2\u05d3\u05d4\u05d5\u05d6\u05d7\u05d8\u05d9\u05da\u05db\u05dc\u05dd\u05de\u05df\u05e0\u05e1\u05e2\u05e3\u05e4\u05e5\u05e6\u05e7\u05e8\u05e9\u05ea\u05f0\u05f1\u05f2\u060c\u061b\u061f\u0621\u0622\u0623\u0624\u0625\u0626\u0627\u0628\u0629\u062a\u062b\u062c\u062d\u062e\u062f\u0630\u0631\u0632\u0633\u0634\u0635\u0636\u0637\u0638\u0639\u063a\u0640\u0641\u0642\u0643\u0644\u0645\u0646\u0647\u0648\u0649\u064a\u064b\u064c\u064d\u064e\u064f\u0650\u0651\u0652\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669\u066a\u066d\u0679\u067e\u0686\u0688\u0691\u0698\u06a4\u06af\u06ba\u06d2\u06d5\u1e80\u1e81\u1e82\u1e83\u1e84\u1e85\u1ef2\u1ef3\u200c\u200d\u200e\u200f\u2012\u2013\u2014\u2015\u2017\u2018\u2019\u201a\u201b\u201c\u201d\u201e\u2020\u2021\u2022\u2024\u2025\u2026\u202c\u202d\u202e\u2030\u2032\u2033\u2039\u203a\u203c\u2044\u20a1\u20a3\u20a4\u20a7\u20aa\u20ab\u20ac\u2105\u2111\u2113\u2116\u2118\u211c\u211e\u2122\u2126\u212e\u2135\u2153\u2154\u215b\u215c\u215d\u215e\u2190\u2191\u2192\u2193\u2194\u2195\u21a8\u21b5\u21d0\u21d1\u21d2\u21d3\u21d4\u2200\u2202\u2203\u2205\u2206\u2207\u2208\u2209\u220b\u220f\u2211\u2212\u2217\u221a\u221d\u221e\u221f\u2220\u2227\u2228\u2229\u222a\u222b\u2234\u223c\u2245\u2248\u2260\u2261\u2264\u2265\u2282\u2283\u2284\u2286\u2287\u2295\u2297\u22a5\u22c5\u2302\u2310\u2320\u2321\u2329\u232a\u2500\u2502\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c\u2550\u2551\u2552\u2553\u2554\u2555\u2556\u2557\u2558\u2559\u255a\u255b\u255c\u255d\u255e\u255f\u2560\u2561\u2562\u2563\u2564\u2565\u2566\u2567\u2568\u2569\u256a\u256b\u256c\u2580\u2584\u2588\u258c\u2590\u2591\u2592\u2593\u25a0\u25a1\u25aa\u25ab\u25ac\u25b2\u25ba\u25bc\u25c4\u25ca\u25cb\u25cf\u25d8\u25d9\u25e6\u263a\u263b\u263c\u2640\u2642\u2660\u2663\u2665\u2666\u266a\u266b";
    private static final String AGLFN_NAME_OFFSET = "\u0001\u0007\u000e\u0017\")1;GQ\\ejpw~\u0084\u0089\u008d\u0091\u0097\u009c\u00a1\u00a5\u00ab\u00b1\u00b6\u00bc\u00c6\u00cb\u00d1\u00d9\u00e2\u00e5\u00e7\u00e9\u00eb\u00ed\u00ef\u00f1\u00f3\u00f5\u00f7\u00f9\u00fb\u00fd\u00ff\u0101\u0103\u0105\u0107\u0109\u010b\u010d\u010f\u0111\u0113\u0115\u0117\u0119\u0125\u012f\u013c\u0148\u0153\u0159\u015b\u015d\u015f\u0161\u0163\u0165\u0167\u0169\u016b\u016d\u016f\u0171\u0173\u0175\u0177\u0179\u017b\u017d\u017f\u0181\u0183\u0185\u0187\u0189\u018b\u018d\u0197\u019b\u01a6\u01b1\u01bc\u01c1\u01ca\u01d3\u01d7\u01e1\u01e9\u01f2\u01fc\u0208\u0216\u0221\u022c\u0233\u023a\u0244\u024a\u024d\u0257\u0266\u026e\u027b\u028a\u0295\u029d\u02ab\u02b8\u02bf\u02c6\u02d2\u02d9\u02e3\u02e9\u02ec\u02f5\u02fc\u0303\u030f\u0319\u0320\u0327\u0333\u033d\u0341\u0348\u034f\u0356\u0362\u0369\u0373\u037c\u0383\u038a\u0391\u039d\u03a7\u03ae\u03b4\u03bf\u03c6\u03cd\u03d9\u03e0\u03ea\u03f0\u03f3\u03fc\u0403\u040a\u0416\u0420\u0427\u042e\u043a\u0444\u0448\u044f\u0456\u045d\u0469\u0470\u047a\u0481\u0488\u048f\u0496\u04a2\u04ac\u04b3\u04b9\u04c3\u04cb\u04d3\u04da\u04e1\u04e9\u04f1\u04f8\u04ff\u050b\u0517\u0522\u052d\u0534\u053b\u0542\u0549\u0550\u0557\u055f\u0567\u056e\u0575\u0580\u058b\u0593\u059b\u05a2\u05a9\u05b5\u05c1\u05c8\u05cf\u05da\u05e5\u05f2\u05ff\u060b\u0617\u061c\u0621\u0628\u062f\u0637\u063f\u0646\u064d\u0655\u065d\u0668\u0671\u0674\u0677\u0683\u068f\u069c\u06a9\u06b6\u06bd\u06c4\u06d1\u06de\u06e5\u06ec\u06f1\u06f6\u06fd\u0704\u070b\u0712\u071f\u072c\u0733\u073a\u0746\u074a\u074e\u0756\u075e\u0765\u076c\u077a\u0788\u078b\u078e\u0795\u079c\u07a9\u07b6\u07bd\u07c4\u07cb\u07d2\u07de\u07ea\u07f3\u07fc\u0803\u080a\u0817\u0824\u082b\u0832\u0837\u083c\u0843\u084a\u0852\u085a\u0861\u0868\u086e\u0874\u0882\u0890\u0898\u08a0\u08ac\u08b8\u08c4\u08d0\u08da\u08e1\u08e8\u08f3\u08fe\u0905\u090c\u0912\u0919\u091f\u0925\u092b\u0931\u0938\u093f\u094a\u0955\u095d\u0965\u0971\u097d\u098a\u0997\u09a1\u09ab\u09b6\u09bc\u09c2\u09cc\u09d1\u09d8\u09de\u09eb\u09f5\u09ff\u0a09\u0a17\u0a24\u0a2a\u0a38\u0a43\u0a4d\u0a5a\u0a63\u0a6d\u0a7a\u0a87\u0a92\u0aa4\u0aaa\u0aaf\u0ab5\u0abd\u0ac2\u0ac6\u0acc\u0ad1\u0ad7\u0ade\u0ae1\u0ae4\u0ae7\u0aef\u0af2\u0af6\u0afc\u0b00\u0b08\u0b0c\u0b10\u0b14\u0b21\u0b31\u0b3c\u0b49\u0b52\u0b5c\u0b71\u0b77\u0b7c\u0b82\u0b88\u0b90\u0b95\u0b99\u0b9f\u0ba4\u0baa\u0bb1\u0bb4\u0bb7\u0bbf\u0bc2\u0bc6\u0bcd\u0bd3\u0bd7\u0bdf\u0be3\u0be7\u0beb\u0bf1\u0bfe\u0c0e\u0c1b\u0c28\u0c33\u0c3a\u0c43\u0c48\u0c4f\u0c59\u0c63\u0c6d\u0c77\u0c81\u0c8b\u0c95\u0c9f\u0ca9\u0cb3\u0cbd\u0cc7\u0cd1\u0cdb\u0ce5\u0cef\u0cf9\u0d03\u0d0d\u0d17\u0d21\u0d2b\u0d35\u0d3f\u0d49\u0d53\u0d5d\u0d67\u0d71\u0d7b\u0d85\u0d8f\u0d99\u0da3\u0dad\u0db7\u0dc1\u0dcb\u0dd5\u0ddf\u0de9\u0df3\u0dfd\u0e07\u0e11\u0e1b\u0e25\u0e2f\u0e39\u0e43\u0e4d\u0e57\u0e61\u0e6b\u0e75\u0e7f\u0e89\u0e93\u0e9d\u0ea7\u0eb1\u0ebb\u0ec5\u0ecf\u0ed9\u0ee3\u0eed\u0ef7\u0f01\u0f0b\u0f15\u0f1f\u0f29\u0f33\u0f3d\u0f47\u0f51\u0f5b\u0f65\u0f6f\u0f79\u0f83\u0f8d\u0f97\u0fa1\u0fab\u0fb5\u0fbf\u0fc9\u0fd3\u0fdd\u0fe7\u0ff1\u0ffb\u1005\u100f\u1019\u1023\u102d\u1037\u1041\u104b\u1055\u105f\u1069\u1073\u107d\u1087\u1091\u109b\u10a5\u10af\u10b9\u10c3\u10cd\u10d7\u10e1\u10eb\u10f5\u10ff\u1109\u1113\u111d\u1127\u1131\u113b\u1145\u114f\u1159\u1163\u116d\u1177\u1181\u118b\u1195\u119f\u11a9\u11b3\u11bd\u11c7\u11d1\u11db\u11e5\u11ef\u11f9\u1203\u120d\u1217\u1221\u122b\u1235\u123f\u1249\u1253\u125d\u1267\u1271\u127b\u1285\u128f\u1299\u12a3\u12ad\u12b7\u12c1\u12cb\u12d5\u12df\u12e9\u12f3\u12fd\u1307\u1311\u131b\u1325\u132f\u1339\u1343\u134d\u1357\u1361\u136b\u1375\u137f\u1389\u1393\u139d\u13a7\u13b1\u13bb\u13c5\u13cf\u13d9\u13e3\u13ed\u13f7\u1401\u140b\u1415\u141f\u1429\u1433\u143d\u1447\u1451\u145b\u1465\u146f\u1479\u1483\u148d\u1497\u14a1\u14ab\u14b5\u14bf\u14c9\u14d3\u14dd\u14e7\u14f1\u14f8\u14ff\u1506\u150d\u1517\u1521\u1528\u152f\u1539\u1541\u1549\u1551\u155c\u1563\u156a\u1574\u1582\u158c\u1597\u15a6\u15b4\u15c1\u15cf\u15dc\u15e3\u15ed\u15f4\u1603\u1612\u161b\u1625\u162f\u1639\u1645\u164c\u1653\u1661\u1670\u167a\u1683\u1691\u1697\u169c\u16a3\u16ad\u16b2\u16b7\u16c1\u16ca\u16d4\u16de\u16ea\u16f3\u1700\u170a\u1710\u171a\u1720\u1729\u1733\u173d\u174a\u1756\u1763\u176d\u1775\u1780\u178a\u1794\u179e\u17ab\u17ba\u17c7\u17d2\u17e0\u17ed\u17fa\u1804\u1810\u181c\u1825\u182b\u1834\u183c\u1847\u1850\u1858\u1862\u1868\u1875\u187d\u188a\u1893\u189e\u18a4\u18af\u18b9\u18c6\u18cc\u18d5\u18df\u18e7\u18f1\u18fd\u1906\u1912\u191c\u1929\u1936\u1945\u194f\u195c\u196b\u1976\u1985\u1993\u199b\u19a1\u19af\u19ba\u19c5\u19cf\u19da\u19e3\u19ec\u19f5\u19fe\u1a07\u1a10\u1a19\u1a22\u1a2b\u1a34\u1a3d\u1a46\u1a4f\u1a58\u1a61\u1a6a\u1a73\u1a7c\u1a85\u1a8e\u1a97\u1aa0\u1aa9\u1ab2\u1abb\u1ac4\u1acd\u1ad6\u1adf\u1ae8\u1af1\u1afa\u1b03\u1b0c\u1b15\u1b1e\u1b27\u1b30\u1b39\u1b42\u1b4a\u1b52\u1b58\u1b60\u1b68\u1b70\u1b76\u1b7e\u1b88\u1b8f\u1b96\u1b9d\u1ba8\u1bb0\u1bb8\u1bc0\u1bc8\u1bd0\u1bd7\u1bde\u1be8\u1bf2\u1bfd\u1c07\u1c14\u1c18\u1c1f\u1c24\u1c2a\u1c2f\u1c35\u1c3d\u1c49";
    private static final String AGLFN_NAMES = "/space/exclam/quotedbl/numbersign/dollar/percent/ampersand/quotesingle/parenleft/parenright/asterisk/plus/comma/hyphen/period/slash/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon/less/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash/bracketright/asciicircum/underscore/grave/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde/exclamdown/cent/sterling/currency/yen/brokenbar/section/dieresis/copyright/ordfeminine/guillemotleft/logicalnot/registered/macron/degree/plusminus/acute/mu/paragraph/periodcentered/cedilla/ordmasculine/guillemotright/onequarter/onehalf/threequarters/questiondown/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex/Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis/multiply/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute/Thorn/germandbls/agrave/aacute/acircumflex/atilde/adieresis/aring/ae/ccedilla/egrave/eacute/ecircumflex/edieresis/igrave/iacute/icircumflex/idieresis/eth/ntilde/ograve/oacute/ocircumflex/otilde/odieresis/divide/oslash/ugrave/uacute/ucircumflex/udieresis/yacute/thorn/ydieresis/Amacron/amacron/Abreve/abreve/Aogonek/aogonek/Cacute/cacute/Ccircumflex/ccircumflex/Cdotaccent/cdotaccent/Ccaron/ccaron/Dcaron/dcaron/Dcroat/dcroat/Emacron/emacron/Ebreve/ebreve/Edotaccent/edotaccent/Eogonek/eogonek/Ecaron/ecaron/Gcircumflex/gcircumflex/Gbreve/gbreve/Gdotaccent/gdotaccent/Gcommaaccent/gcommaaccent/Hcircumflex/hcircumflex/Hbar/hbar/Itilde/itilde/Imacron/imacron/Ibreve/ibreve/Iogonek/iogonek/Idotaccent/dotlessi/IJ/ij/Jcircumflex/jcircumflex/Kcommaaccent/kcommaaccent/kgreenlandic/Lacute/lacute/Lcommaaccent/lcommaaccent/Lcaron/lcaron/Ldot/ldot/Lslash/lslash/Nacute/nacute/Ncommaaccent/ncommaaccent/Ncaron/ncaron/napostrophe/Eng/eng/Omacron/omacron/Obreve/obreve/Ohungarumlaut/ohungarumlaut/OE/oe/Racute/racute/Rcommaaccent/rcommaaccent/Rcaron/rcaron/Sacute/sacute/Scircumflex/scircumflex/Scedilla/scedilla/Scaron/scaron/Tcommaaccent/tcommaaccent/Tcaron/tcaron/Tbar/tbar/Utilde/utilde/Umacron/umacron/Ubreve/ubreve/Uring/uring/Uhungarumlaut/uhungarumlaut/Uogonek/uogonek/Wcircumflex/wcircumflex/Ycircumflex/ycircumflex/Ydieresis/Zacute/zacute/Zdotaccent/zdotaccent/Zcaron/zcaron/longs/florin/Ohorn/ohorn/Uhorn/uhorn/Gcaron/gcaron/Aringacute/aringacute/AEacute/aeacute/Oslashacute/oslashacute/Scommaaccent/scommaaccent/afii57929/afii64937/circumflex/caron/breve/dotaccent/ring/ogonek/tilde/hungarumlaut/gravecomb/acutecomb/tildecomb/hookabovecomb/dotbelowcomb/tonos/dieresistonos/Alphatonos/anoteleia/Epsilontonos/Etatonos/Iotatonos/Omicrontonos/Upsilontonos/Omegatonos/iotadieresistonos/Alpha/Beta/Gamma/Epsilon/Zeta/Eta/Theta/Iota/Kappa/Lambda/Mu/Nu/Xi/Omicron/Pi/Rho/Sigma/Tau/Upsilon/Phi/Chi/Psi/Iotadieresis/Upsilondieresis/alphatonos/epsilontonos/etatonos/iotatonos/upsilondieresistonos/alpha/beta/gamma/delta/epsilon/zeta/eta/theta/iota/kappa/lambda/nu/xi/omicron/pi/rho/sigma1/sigma/tau/upsilon/phi/chi/psi/omega/iotadieresis/upsilondieresis/omicrontonos/upsilontonos/omegatonos/theta1/Upsilon1/phi1/omega1/afii10023/afii10051/afii10052/afii10053/afii10054/afii10055/afii10056/afii10057/afii10058/afii10059/afii10060/afii10061/afii10062/afii10145/afii10017/afii10018/afii10019/afii10020/afii10021/afii10022/afii10024/afii10025/afii10026/afii10027/afii10028/afii10029/afii10030/afii10031/afii10032/afii10033/afii10034/afii10035/afii10036/afii10037/afii10038/afii10039/afii10040/afii10041/afii10042/afii10043/afii10044/afii10045/afii10046/afii10047/afii10048/afii10049/afii10065/afii10066/afii10067/afii10068/afii10069/afii10070/afii10072/afii10073/afii10074/afii10075/afii10076/afii10077/afii10078/afii10079/afii10080/afii10081/afii10082/afii10083/afii10084/afii10085/afii10086/afii10087/afii10088/afii10089/afii10090/afii10091/afii10092/afii10093/afii10094/afii10095/afii10096/afii10097/afii10071/afii10099/afii10100/afii10101/afii10102/afii10103/afii10104/afii10105/afii10106/afii10107/afii10108/afii10109/afii10110/afii10193/afii10146/afii10194/afii10147/afii10195/afii10148/afii10196/afii10050/afii10098/afii10846/afii57799/afii57801/afii57800/afii57802/afii57793/afii57794/afii57795/afii57798/afii57797/afii57806/afii57796/afii57807/afii57839/afii57645/afii57841/afii57842/afii57804/afii57803/afii57658/afii57664/afii57665/afii57666/afii57667/afii57668/afii57669/afii57670/afii57671/afii57672/afii57673/afii57674/afii57675/afii57676/afii57677/afii57678/afii57679/afii57680/afii57681/afii57682/afii57683/afii57684/afii57685/afii57686/afii57687/afii57688/afii57689/afii57690/afii57716/afii57717/afii57718/afii57388/afii57403/afii57407/afii57409/afii57410/afii57411/afii57412/afii57413/afii57414/afii57415/afii57416/afii57417/afii57418/afii57419/afii57420/afii57421/afii57422/afii57423/afii57424/afii57425/afii57426/afii57427/afii57428/afii57429/afii57430/afii57431/afii57432/afii57433/afii57434/afii57440/afii57441/afii57442/afii57443/afii57444/afii57445/afii57446/afii57470/afii57448/afii57449/afii57450/afii57451/afii57452/afii57453/afii57454/afii57455/afii57456/afii57457/afii57458/afii57392/afii57393/afii57394/afii57395/afii57396/afii57397/afii57398/afii57399/afii57400/afii57401/afii57381/afii63167/afii57511/afii57506/afii57507/afii57512/afii57513/afii57508/afii57505/afii57509/afii57514/afii57519/afii57534/Wgrave/wgrave/Wacute/wacute/Wdieresis/wdieresis/Ygrave/ygrave/afii61664/afii301/afii299/afii300/figuredash/endash/emdash/afii00208/underscoredbl/quoteleft/quoteright/quotesinglbase/quotereversed/quotedblleft/quotedblright/quotedblbase/dagger/daggerdbl/bullet/onedotenleader/twodotenleader/ellipsis/afii61573/afii61574/afii61575/perthousand/minute/second/guilsinglleft/guilsinglright/exclamdbl/fraction/colonmonetary/franc/lira/peseta/afii57636/dong/Euro/afii61248/Ifraktur/afii61289/afii61352/weierstrass/Rfraktur/prescription/trademark/Omega/estimated/aleph/onethird/twothirds/oneeighth/threeeighths/fiveeighths/seveneighths/arrowleft/arrowup/arrowright/arrowdown/arrowboth/arrowupdn/arrowupdnbse/carriagereturn/arrowdblleft/arrowdblup/arrowdblright/arrowdbldown/arrowdblboth/universal/partialdiff/existential/emptyset/Delta/gradient/element/notelement/suchthat/product/summation/minus/asteriskmath/radical/proportional/infinity/orthogonal/angle/logicaland/logicalor/intersection/union/integral/therefore/similar/congruent/approxequal/notequal/equivalence/lessequal/greaterequal/propersubset/propersuperset/notsubset/reflexsubset/reflexsuperset/circleplus/circlemultiply/perpendicular/dotmath/house/revlogicalnot/integraltp/integralbt/angleleft/angleright/SF100000/SF110000/SF010000/SF030000/SF020000/SF040000/SF080000/SF090000/SF060000/SF070000/SF050000/SF430000/SF240000/SF510000/SF520000/SF390000/SF220000/SF210000/SF250000/SF500000/SF490000/SF380000/SF280000/SF270000/SF260000/SF360000/SF370000/SF420000/SF190000/SF200000/SF230000/SF470000/SF480000/SF410000/SF450000/SF460000/SF400000/SF540000/SF530000/SF440000/upblock/dnblock/block/lfblock/rtblock/ltshade/shade/dkshade/filledbox/H22073/H18543/H18551/filledrect/triagup/triagrt/triagdn/triaglf/lozenge/circle/H18533/invbullet/invcircle/openbullet/smileface/invsmileface/sun/female/male/spade/club/heart/diamond/musicalnote/musicalnotedbl/";

    private GlyphNamer(int n, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        this.postTable = byteBuffer;
        this.zapfTable = byteBuffer2;
        if (byteBuffer2 != null && byteBuffer2.getInt(0) == 65536) {
            this.readZapf(n);
            return;
        }
        this.readPost();
    }

    public static GlyphNamer forTables(int n, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return new GlyphNamer(n, byteBuffer, byteBuffer2);
    }

    String getGlyphName(int n) {
        if (this.zapfOffsets != null) {
            this.zapfTable.position(this.zapfOffsets.get(n) + 8);
            int n2 = this.zapfTable.getChar();
            char[] cArray = new char[n2];
            for (int i = 0; i < n2; ++i) {
                cArray[i] = this.zapfTable.getChar();
            }
            return GlyphNamer.getGlyphName(cArray);
        }
        if (this.glyphNames != null) {
            return this.glyphNames[n];
        }
        if (this.glyphCharacterCodes != null) {
            return "a" + this.glyphCharacterCodes.get(n);
        }
        return "g" + n;
    }

    private void readZapf(int n) {
        this.zapfExtraInfo = this.zapfTable.getInt(4);
        this.zapfTable.position(8);
        this.zapfOffsets = this.zapfTable.asIntBuffer();
        this.zapfOffsets.limit(n);
    }

    private void readPost() {
        this.postTable.position(0);
        this.postFormat = this.postTable.getInt();
        switch (this.postFormat) {
            case 65536: {
                this.glyphNames = STANDARD_POSTSCRIPT_GLYPH_NAMES;
                return;
            }
            case 131072: {
                int n;
                this.postTable.position(32);
                int n2 = this.postTable.getChar();
                this.glyphNames = new String[n2];
                byte[] byArray = new byte[255];
                char[] cArray = new char[n2];
                int n3 = 0;
                for (n = 0; n < n2; ++n) {
                    cArray[n] = this.postTable.getChar();
                    n3 = Math.max(n3, cArray[n]);
                }
                String[] stringArray = new String[Math.max(n3 - 258 + 1, 0)];
                for (n = 258; n <= n3; ++n) {
                    int n4 = this.postTable.get() & 0xFF;
                    this.postTable.get(byArray, 0, n4);
                    stringArray[n - 258] = new String(byArray, 0, n4);
                }
                for (n = 0; n < n2; ++n) {
                    char c = cArray[n];
                    this.glyphNames[n] = c < '\u0102' ? STANDARD_POSTSCRIPT_GLYPH_NAMES[c] : stringArray[c - 258];
                }
                return;
            }
            case 151552: 
            case 163840: {
                this.postTable.position(32);
                int n = this.postTable.getChar();
                this.glyphNames = new String[n];
                for (int i = 0; i < n; ++i) {
                    this.glyphNames[i] = STANDARD_POSTSCRIPT_GLYPH_NAMES[i + this.postTable.get()];
                }
                return;
            }
            case 196608: {
                return;
            }
            case 262144: {
                this.postTable.position(32);
                char c = this.postTable.getChar();
                this.glyphCharacterCodes = this.postTable.asCharBuffer();
                this.glyphCharacterCodes.limit(c);
                return;
            }
        }
    }

    private static String getAGLFNName(char c) {
        int n = 0;
        int n2 = AGLFN_GLYPHS.length() - 1;
        int n3 = n2 >> 1;
        char c2 = AGLFN_GLYPHS.charAt(n3);
        while (c2 != c) {
            if (c2 < c) {
                n = n3 + 1;
            } else {
                n2 = n3;
            }
            n3 = n + n2 >> 1;
            c2 = AGLFN_GLYPHS.charAt(n3);
            if (n < n2) continue;
        }
        if (c2 != c) {
            return null;
        }
        char c3 = AGLFN_NAME_OFFSET.charAt(n3);
        return AGLFN_NAMES.substring(c3, AGLFN_NAMES.indexOf(47, (int)c3));
    }

    private static String getGlyphName(char[] cArray) {
        char c;
        String string;
        int n;
        boolean bl = false;
        if (cArray == null || (n = cArray.length) == 0) {
            return ".notdef";
        }
        if (n == 1 && (string = GlyphNamer.getAGLFNName(c = cArray[0])) != null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n * 8);
        for (int i = 0; i < n; ++i) {
            char c2;
            if (i > 0) {
                stringBuffer.append('_');
            }
            if ((c = cArray[i]) >> 10 == 54) {
                c2 = ((c & 0x3FF) << 10 | cArray[++i] & 0x3FF) + 65536;
                stringBuffer.append('u');
                stringBuffer.append(Integer.toHexString(c2).toUpperCase());
                continue;
            }
            string = GlyphNamer.getAGLFNName(c);
            if (string != null) {
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append("uni");
            c2 = (char)((c >> 12 & 0xF) + 48);
            if (c2 > '9') {
                c2 = (char)(c2 + 7);
            }
            stringBuffer.append(c2);
            c2 = (char)((c >> 8 & 0xF) + 48);
            if (c2 > '9') {
                c2 = (char)(c2 + 7);
            }
            stringBuffer.append(c2);
            c2 = (char)((c >> 4 & 0xF) + 48);
            if (c2 > '9') {
                c2 = (char)(c2 + 7);
            }
            stringBuffer.append(c2);
            c2 = (char)((c >> 0 & 0xF) + 48);
            if (c2 > '9') {
                c2 = (char)(c2 + 7);
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    static {
        AGLFN_GLYPHS = AGLFN_GLYPHS;
        AGLFN_NAME_OFFSET = AGLFN_NAME_OFFSET;
        AGLFN_NAMES = AGLFN_NAMES;
    }
}

