/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import javax.management.MBeanNotificationInfo;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorMBean;

public class GaugeMonitor
extends Monitor
implements MonitorMBean,
GaugeMonitorMBean {
    private Number highThreshold = new Integer(0);
    private Number lowThreshold = new Integer(0);
    private boolean notifyHigh = false;
    private boolean notifyLow = false;
    private boolean differenceMode = false;
    private transient boolean highNotified = false;
    private transient boolean lowNotified = false;
    private transient boolean errorNotified = false;
    private Number lastDerivatedGauge = new Integer(0);
    private long lastDerivatedGaugeTimestamp = 0L;
    private transient Number lastValue = null;
    private transient Class type = NONE;
    private static final Class NONE = null;
    private static final Class INT = class$java$lang$Integer == null ? (class$java$lang$Integer = GaugeMonitor.class$("java.lang.Integer")) : class$java$lang$Integer;
    private static final Class LONG = class$java$lang$Long == null ? (class$java$lang$Long = GaugeMonitor.class$("java.lang.Long")) : class$java$lang$Long;
    private static final Class BYTE = class$java$lang$Byte == null ? (class$java$lang$Byte = GaugeMonitor.class$("java.lang.Byte")) : class$java$lang$Byte;
    private static final Class SHORT = class$java$lang$Short == null ? (class$java$lang$Short = GaugeMonitor.class$("java.lang.Short")) : class$java$lang$Short;
    private static final Class FLOAT = class$java$lang$Float == null ? (class$java$lang$Float = GaugeMonitor.class$("java.lang.Float")) : class$java$lang$Float;
    private static final Class DOUBLE = class$java$lang$Double == null ? (class$java$lang$Double = GaugeMonitor.class$("java.lang.Double")) : class$java$lang$Double;
    private transient boolean isLong = false;
    private static final MBeanNotificationInfo[] notificationInfos = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.gauge.high", "jmx.monitor.gauge.low"}, "javax.management.monitor.MonitorNotification", "Notifications sent by the GaugeMonitor MBean")};
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public synchronized void start() {
        this.doStart();
    }

    public synchronized void stop() {
        this.doStop();
    }

    void executeMonitor(Object attributeValue) {
        if (!(this.highThreshold != null && this.highThreshold.longValue() != 0L || this.errorNotified)) {
            this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" threshold value is null or zero"));
            this.notifyListeners("jmx.monitor.error.threshold", this.objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        if (!(this.lowThreshold != null && this.lowThreshold.longValue() != 0L || this.errorNotified)) {
            this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" threshold value is null or zero"));
            this.notifyListeners("jmx.monitor.error.threshold", this.objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        if (!(attributeValue instanceof Number) && !this.errorNotified) {
            this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" attribute is not a Number"));
            this.notifyListeners("jmx.monitor.error.threshold", this.objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        this.determineType(attributeValue);
        if (this.type == NONE && !this.errorNotified) {
            this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" attribute, threshold, offset and modules types don't match"));
            this.notifyListeners("jmx.monitor.error.threshold", this.objectName, this.attribute);
            this.errorNotified = true;
            return;
        }
        this.calculateDerivedGauge((Number)attributeValue);
        if (this.isLong) {
            if (((Number)attributeValue).longValue() >= this.highThreshold.longValue() && !this.highNotified && this.notifyHigh) {
                this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" counter over the threshold"));
                this.notifyListeners("jmx.monitor.gauge.high", this.objectName, this.attribute);
                this.highNotified = true;
                this.lowNotified = false;
            }
            if (((Number)attributeValue).longValue() <= this.lowThreshold.longValue() && !this.lowNotified && this.notifyLow) {
                this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" counter over the threshold"));
                this.notifyListeners("jmx.monitor.gauge.low", this.objectName, this.attribute);
                this.lowNotified = true;
                this.highNotified = false;
            }
        } else {
            if (((Number)attributeValue).doubleValue() >= this.highThreshold.doubleValue() && !this.highNotified && this.notifyHigh) {
                this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" counter over the threshold"));
                this.notifyListeners("jmx.monitor.gauge.high", this.objectName, this.attribute);
                this.highNotified = true;
                this.lowNotified = false;
            }
            if (((Number)attributeValue).doubleValue() <= this.lowThreshold.doubleValue() && !this.lowNotified && this.notifyLow) {
                this.getLogger().info(new StringBuffer("Monitor ").append(this).append(" counter over the threshold"));
                this.notifyListeners("jmx.monitor.gauge.low", this.objectName, this.attribute);
                this.lowNotified = true;
                this.highNotified = false;
            }
        }
    }

    void determineType(Object attributeValue) {
        Class<?> targetClass = attributeValue.getClass();
        if (this.highThreshold != null && this.lowThreshold != null) {
            if (this.highThreshold.getClass().equals(this.lowThreshold.getClass()) && this.highThreshold.getClass().equals(targetClass)) {
                boolean match = true;
                if (targetClass != INT && targetClass != LONG && targetClass != BYTE && targetClass != SHORT && targetClass != FLOAT && targetClass != DOUBLE) {
                    match = false;
                }
                if (match) {
                    this.type = targetClass;
                    this.isLong = !targetClass.equals(FLOAT) && !targetClass.equals(DOUBLE);
                }
            } else {
                this.type = NONE;
            }
        } else {
            this.type = NONE;
        }
    }

    void calculateDerivedGauge(Number attributeValue) {
        this.lastDerivatedGaugeTimestamp = System.currentTimeMillis();
        if (this.differenceMode && this.lastValue != null) {
            if (this.isLong) {
                long difference = attributeValue.longValue() - this.lastValue.longValue();
                this.lastDerivatedGauge = this.createNumber(difference);
            } else {
                double difference = attributeValue.doubleValue() - this.lastValue.doubleValue();
                this.lastDerivatedGauge = this.createNumber(difference);
            }
        }
        this.lastValue = attributeValue;
    }

    Number createNumber(long value) {
        Number result = null;
        if (this.type == INT) {
            result = new Integer((int)value);
        } else if (this.type == LONG) {
            result = new Long(value);
        } else if (this.type == SHORT) {
            result = new Short((short)value);
        } else if (this.type == BYTE) {
            result = new Byte((byte)value);
        }
        return result;
    }

    Number createNumber(double value) {
        Number result = null;
        if (this.type == FLOAT) {
            result = new Float((float)value);
        } else if (this.type == DOUBLE) {
            result = new Double(value);
        }
        return result;
    }

    public Number getDerivedGauge() {
        return this.lastDerivatedGauge;
    }

    public long getDerivedGaugeTimeStamp() {
        return this.lastDerivatedGaugeTimestamp;
    }

    public Number getHighThreshold() {
        return this.highThreshold;
    }

    public Number getLowThreshold() {
        return this.lowThreshold;
    }

    public void setThresholds(Number highValue, Number lowValue) throws IllegalArgumentException {
        if (highValue == null || lowValue == null) {
            throw new IllegalArgumentException("Threshold values cannot be null");
        }
        if (!highValue.getClass().equals(lowValue.getClass())) {
            throw new IllegalArgumentException("Threshold need to be of the same class");
        }
        if (highValue.doubleValue() < lowValue.doubleValue()) {
            throw new IllegalArgumentException("Threshold need to be of the same class");
        }
        this.highThreshold = highValue;
        this.lowThreshold = lowValue;
    }

    public boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    public void setNotifyHigh(boolean value) {
        this.notifyHigh = value;
    }

    public boolean getNotifyLow() {
        return this.notifyLow;
    }

    public void setNotifyLow(boolean value) {
        this.notifyLow = value;
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public void setDifferenceMode(boolean value) {
        this.differenceMode = value;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notificationInfos;
    }

    public String toString() {
        return "GaugeMonitor on " + super.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

