/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.buildpath.IClasspathInformationProvider;
import org.eclipse.jdt.internal.corext.buildpath.IPackageExplorerActionListener;
import org.eclipse.jdt.internal.corext.buildpath.PackageExplorerActionEvent;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ClasspathModifierAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ClasspathModifierQueries;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorer;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.NewSourceContainerWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public final class HintTextGroup
implements IClasspathInformationProvider,
IPackageExplorerActionListener {
    private static final int[] ACTION_ORDER;
    private StringDialogField fOutputLocationField;
    private Composite fTopComposite;
    private DialogPackageExplorerActionGroup fActionGroup;
    private DialogPackageExplorer fPackageExplorer;
    private IRunnableContext fRunnableContext;
    private IJavaProject fCurrJProject;
    private List fNewFolders;
    private String fOldOutputLocation;
    private HashMap fImageMap;
    private final NewSourceContainerWorkbookPage fPage;

    static {
        int[] nArray = new int[14];
        nArray[0] = 12;
        nArray[1] = 5;
        nArray[2] = 4;
        nArray[3] = 2;
        nArray[4] = 10;
        nArray[5] = 3;
        nArray[6] = 11;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[10] = 1;
        nArray[11] = 15;
        nArray[12] = 14;
        nArray[13] = 13;
        ACTION_ORDER = nArray;
    }

    public HintTextGroup(DialogPackageExplorer packageExplorer, StringDialogField outputLocationField, SelectionButtonDialogField useFolderOutputs, IRunnableContext runnableContext, NewSourceContainerWorkbookPage page) {
        this.fPackageExplorer = packageExplorer;
        this.fRunnableContext = runnableContext;
        this.fPage = page;
        this.fCurrJProject = null;
        this.fNewFolders = new ArrayList();
        this.fImageMap = new HashMap();
        this.fOutputLocationField = outputLocationField;
    }

    public Composite createControl(Composite parent) {
        this.fTopComposite = new Composite(parent, 0);
        this.fTopComposite.setFont(parent.getFont());
        GridData gridData = new GridData(1808);
        PixelConverter converter = new PixelConverter((Control)parent);
        gridData.heightHint = converter.convertHeightInCharsToPixels(12);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.fTopComposite.setLayout((Layout)gridLayout);
        this.fTopComposite.setLayoutData((Object)gridData);
        this.fTopComposite.setData(null);
        this.fTopComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Collection collection = HintTextGroup.this.fImageMap.values();
                for (Image image : collection) {
                    image.dispose();
                }
            }
        });
        return this.fTopComposite;
    }

    private Shell getShell() {
        return JavaPlugin.getActiveWorkbenchShell();
    }

    public void setJavaProject(IJavaProject jProject) {
        this.fCurrJProject = jProject;
        this.fOldOutputLocation = this.fOutputLocationField.getText();
    }

    public void setActionGroup(DialogPackageExplorerActionGroup actionGroup) {
        this.fActionGroup = actionGroup;
    }

    private FormText createFormText(Composite parent, String text) {
        FormToolkit toolkit = new FormToolkit(this.getShell().getDisplay());
        try {
            FormText formText = toolkit.createFormText(parent, true);
            formText.setFont(parent.getFont());
            try {
                formText.setText(text, true, false);
            }
            catch (IllegalArgumentException e) {
                formText.setText(e.getMessage(), false, false);
                JavaPlugin.log(e);
            }
            formText.marginHeight = 2;
            formText.marginWidth = 0;
            formText.setBackground(null);
            formText.setLayoutData((Object)new TableWrapData(256));
            FormText formText2 = formText;
            return formText2;
        }
        finally {
            toolkit.dispose();
        }
    }

    private void createLabel(Composite parent, String text, final ClasspathModifierAction action, final IRunnableContext context) {
        FormText formText = this.createFormText(parent, text);
        Image image = (Image)this.fImageMap.get(action.getId());
        if (image == null) {
            image = action.getImageDescriptor().createImage();
            this.fImageMap.put(action.getId(), image);
        }
        formText.setImage("defaultImage", image);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    HintTextGroup.this.fPage.commitDefaultOutputFolder();
                    context.run(false, false, (IRunnableWithProgress)action.getOperation());
                }
                catch (InvocationTargetException err) {
                    ExceptionHandler.handle(err, HintTextGroup.this.getShell(), Messages.format(NewWizardMessages.HintTextGroup_Exception_Title, action.getName()), err.getMessage());
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    public IStructuredSelection getSelection() {
        return this.fPackageExplorer.getSelection();
    }

    public void setSelection(List elements) {
        this.fPackageExplorer.setSelection(elements);
    }

    public IJavaProject getJavaProject() {
        return this.fCurrJProject;
    }

    public void handleResult(List resultElements, CoreException exception, int actionType) {
        if (exception != null) {
            ExceptionHandler.handle(exception, this.getShell(), Messages.format(NewWizardMessages.HintTextGroup_Exception_Title_refresh, this.fActionGroup.getAction(actionType).getName()), exception.getLocalizedMessage());
            return;
        }
        switch (actionType) {
            case 12: {
                this.handleFolderCreation(resultElements);
                break;
            }
            case 5: {
                this.handleFolderCreation(resultElements);
                break;
            }
            case 4: {
                this.defaultHandle(resultElements, false);
                break;
            }
            case 0: 
            case 13: 
            case 14: 
            case 15: {
                this.handleAddToCP(resultElements);
                break;
            }
            case 1: {
                this.handleRemoveFromBP(resultElements, false);
                break;
            }
            case 10: {
                this.defaultHandle(resultElements, true);
                break;
            }
            case 2: {
                this.defaultHandle(resultElements, false);
                break;
            }
            case 11: {
                this.defaultHandle(resultElements, false);
                break;
            }
            case 3: {
                this.defaultHandle(resultElements, true);
                break;
            }
            case 9: {
                this.defaultHandle(resultElements, false);
                break;
            }
            case 7: {
                this.handleEditOutputFolder(resultElements);
                break;
            }
            case 6: {
                this.handleResetAll();
                break;
            }
        }
    }

    private void defaultHandle(List result, boolean forceRebuild) {
        try {
            this.fPackageExplorer.setSelection(result);
            if (forceRebuild) {
                this.fActionGroup.refresh(new DialogPackageExplorerActionGroup.DialogExplorerActionContext(result, this.fCurrJProject));
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), NewWizardMessages.HintTextGroup_Exception_Title_refresh, e.getLocalizedMessage());
        }
    }

    private void handleFolderCreation(List result) {
        if (result.size() == 1) {
            this.fNewFolders.add(result.get(0));
            this.fPackageExplorer.setSelection(result);
            this.setOutputLocationFieldText(this.getOldOutputLocation());
        }
    }

    private void handleAddToCP(List result) {
        try {
            if (this.containsJavaProject(result)) {
                this.fPackageExplorer.setSelection(result);
                this.fActionGroup.refresh(new DialogPackageExplorerActionGroup.DialogExplorerActionContext(result, this.fCurrJProject));
            } else {
                this.fPackageExplorer.setSelection(result);
            }
            this.setOutputLocationFieldText(this.getOldOutputLocation());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), NewWizardMessages.HintTextGroup_Exception_Title_refresh, e.getLocalizedMessage());
        }
    }

    private void handleRemoveFromBP(List result, boolean forceRebuild) {
        this.fPackageExplorer.setSelection(result);
        try {
            if (forceRebuild || this.containsJavaProject(result)) {
                this.fActionGroup.refresh(new DialogPackageExplorerActionGroup.DialogExplorerActionContext(result, this.fCurrJProject));
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), NewWizardMessages.HintTextGroup_Exception_Title_refresh, e.getLocalizedMessage());
        }
    }

    private void handleEditOutputFolder(List result) {
        if (result.size() == 0) {
            return;
        }
        CPListElementAttribute attribute = (CPListElementAttribute)result.get(0);
        if (attribute != null) {
            IFolder folder;
            this.fPackageExplorer.setSelection(result);
            IPath path = (IPath)attribute.getValue();
            if (path != null && !(folder = this.fCurrJProject.getProject().getWorkspace().getRoot().getFolder(path)).exists()) {
                this.fNewFolders.add(folder);
            }
            this.setOutputLocationFieldText(this.getOldOutputLocation());
        }
    }

    private void handleResetAll() {
        ArrayList<IJavaProject> list = new ArrayList<IJavaProject>();
        list.add(this.fCurrJProject);
        this.setSelection(list);
    }

    private boolean containsJavaProject(List elements) {
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i) instanceof IJavaProject) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IPath getOldOutputLocation() {
        return new Path(this.fOutputLocationField.getText()).makeAbsolute();
    }

    private void setOutputLocationFieldText(IPath oldOutputLocation) {
        try {
            if (!this.fCurrJProject.getOutputLocation().equals((Object)oldOutputLocation)) {
                this.fOutputLocationField.setText(this.fCurrJProject.getOutputLocation().makeRelative().toString());
                IJavaElement element = this.fCurrJProject.findElement(this.fCurrJProject.getOutputLocation().removeFirstSegments(1));
                if (element != null) {
                    this.fNewFolders.add(element);
                }
            }
        }
        catch (JavaModelException exception) {
            ExceptionHandler.handle((CoreException)((Object)exception), this.getShell(), NewWizardMessages.HintTextGroup_Exception_Title_output, exception.getMessage());
        }
    }

    public ClasspathModifierQueries.OutputFolderQuery getOutputFolderQuery() {
        return ClasspathModifierQueries.getDefaultFolderQuery(this.getShell(), (IPath)new Path(this.fOutputLocationField.getText()));
    }

    public ClasspathModifierQueries.IInclusionExclusionQuery getInclusionExclusionQuery() {
        return ClasspathModifierQueries.getDefaultInclusionExclusionQuery(this.getShell());
    }

    public ClasspathModifierQueries.IOutputLocationQuery getOutputLocationQuery() throws JavaModelException {
        List classpathEntries = ClasspathModifier.getExistingEntries(this.fCurrJProject);
        return ClasspathModifierQueries.getDefaultOutputLocationQuery(this.getShell(), (IPath)new Path(this.fOutputLocationField.getText()), classpathEntries);
    }

    public ClasspathModifierQueries.ILinkToQuery getLinkFolderQuery() throws JavaModelException {
        return ClasspathModifierQueries.getDefaultLinkQuery(this.getShell(), this.fCurrJProject, (IPath)new Path(this.fOutputLocationField.getText()));
    }

    public ClasspathModifierQueries.ICreateFolderQuery getCreateFolderQuery() throws JavaModelException {
        return ClasspathModifierQueries.getDefaultCreateFolderQuery(this.getShell(), this.fCurrJProject);
    }

    public ClasspathModifierQueries.IRemoveLinkedFolderQuery getRemoveLinkedFolderQuery() throws JavaModelException {
        return ClasspathModifierQueries.getDefaultRemoveLinkedFolderQuery(this.getShell());
    }

    public ClasspathModifierQueries.IAddArchivesQuery getExternalArchivesQuery() throws JavaModelException {
        return ClasspathModifierQueries.getDefaultArchivesQuery(this.getShell());
    }

    public ClasspathModifierQueries.IAddLibrariesQuery getLibrariesQuery() throws JavaModelException {
        return ClasspathModifierQueries.getDefaultLibrariesQuery(this.getShell());
    }

    public void deleteCreatedResources() {
        for (Object element : this.fNewFolders) {
            try {
                IFolder folder;
                if (element instanceof IFolder) {
                    folder = (IFolder)element;
                } else if (element instanceof IJavaElement) {
                    folder = this.fCurrJProject.getProject().getWorkspace().getRoot().getFolder(((IJavaElement)element).getPath());
                } else {
                    ((IFile)element).delete(false, null);
                    continue;
                }
                folder.delete(false, null);
            }
            catch (CoreException coreException) {}
        }
        this.fOutputLocationField.setText(this.fOldOutputLocation);
        this.fNewFolders = new ArrayList();
    }

    public void handlePackageExplorerActionEvent(PackageExplorerActionEvent event) {
        Composite childComposite = (Composite)this.fTopComposite.getData();
        if (childComposite != null && childComposite.getParent() != null) {
            childComposite.getParent().dispose();
        }
        ScrolledPageContent spc = new ScrolledPageContent(this.fTopComposite, 512);
        spc.getVerticalBar().setIncrement(5);
        spc.setLayoutData(new GridData(1808));
        childComposite = spc.getBody();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.leftMargin = 0;
        tableWrapLayout.rightMargin = 0;
        childComposite.setLayout((Layout)tableWrapLayout);
        childComposite.setLayoutData((Object)new GridData(768));
        this.fTopComposite.setData((Object)childComposite);
        ClasspathModifierAction[] actions = event.getEnabledActions();
        String[] descriptionText = event.getEnabledActionsText();
        if (this.noContextHelpAvailable(actions)) {
            String noAction = this.fActionGroup.getNoActionDescription();
            this.createFormText(childComposite, Messages.format(NewWizardMessages.HintTextGroup_NoAction, noAction));
            this.fTopComposite.layout(true);
            return;
        }
        int j = 0;
        while (j < ACTION_ORDER.length) {
            int i = 0;
            while (i < actions.length) {
                int id = Integer.parseInt(actions[i].getId());
                if (id == ACTION_ORDER[j]) {
                    this.createLabel(childComposite, descriptionText[i], actions[i], this.fRunnableContext);
                    break;
                }
                ++i;
            }
            ++j;
        }
        this.fTopComposite.layout(true);
    }

    private boolean noContextHelpAvailable(ClasspathModifierAction[] actions) {
        int id;
        if (actions.length == 0) {
            return true;
        }
        if (actions.length == 1 && (id = Integer.parseInt(actions[0].getId())) == 5) {
            return true;
        }
        if (actions.length == 2) {
            int idLink = Integer.parseInt(actions[0].getId());
            int idReset = Integer.parseInt(actions[1].getId());
            if (idReset == 6 && idLink == 5) {
                return true;
            }
        }
        return false;
    }
}

