/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.IEditorInput;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyDocumentProvider;
import org.rubypeople.rdt.ui.IWorkingCopyManager;
import org.rubypeople.rdt.ui.IWorkingCopyManagerExtension;

public class WorkingCopyManager
implements IWorkingCopyManager,
IWorkingCopyManagerExtension {
    private RubyDocumentProvider fDocumentProvider;
    private Map fMap;
    private boolean fIsShuttingDown;

    public WorkingCopyManager(RubyDocumentProvider rubyDocumentProvider) {
        Assert.isNotNull((Object)((Object)rubyDocumentProvider));
        this.fDocumentProvider = rubyDocumentProvider;
    }

    public void connect(IEditorInput iEditorInput) throws CoreException {
        this.fDocumentProvider.connect(iEditorInput);
    }

    public void disconnect(IEditorInput iEditorInput) {
        this.fDocumentProvider.disconnect(iEditorInput);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        if (this.fIsShuttingDown) return;
        this.fIsShuttingDown = true;
        try {
            if (this.fMap != null) {
                this.fMap.clear();
                this.fMap = null;
            }
            this.fDocumentProvider.shutdown();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fIsShuttingDown = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fIsShuttingDown = false;
            return;
        }
    }

    public IRubyScript getWorkingCopy(IEditorInput iEditorInput) {
        IRubyScript iRubyScript = this.fMap == null ? null : (IRubyScript)this.fMap.get(iEditorInput);
        return iRubyScript != null ? iRubyScript : this.fDocumentProvider.getWorkingCopy(iEditorInput);
    }

    public void setWorkingCopy(IEditorInput iEditorInput, IRubyScript iRubyScript) {
        if (this.fDocumentProvider.getDocument(iEditorInput) != null) {
            if (this.fMap == null) {
                this.fMap = new HashMap();
            }
            this.fMap.put(iEditorInput, iRubyScript);
        }
    }

    public void removeWorkingCopy(IEditorInput iEditorInput) {
        this.fMap.remove(iEditorInput);
        if (this.fMap.isEmpty()) {
            this.fMap = null;
        }
    }
}

