/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.osgi.service.prefs.BackingStoreException;
import org.rubypeople.rdt.core.IImportContainer;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyOutlinePage;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubySourceViewer;
import org.rubypeople.rdt.internal.ui.text.ContentAssistPreference;
import org.rubypeople.rdt.internal.ui.text.PreferencesAdapter;
import org.rubypeople.rdt.internal.ui.text.RubyPairMatcher;
import org.rubypeople.rdt.ui.IWorkingCopyManager;
import org.rubypeople.rdt.ui.text.RubySourceViewerConfiguration;
import org.rubypeople.rdt.ui.text.RubyTextTools;

public abstract class RubyAbstractEditor
extends TextEditor {
    protected RubyTextTools textTools;
    private ISourceReference reference;
    protected String fOutlinerContextMenuId;
    protected AbstractTextEditor.AbstractSelectionChangedListener fOutlineSelectionChangedListener = new OutlineSelectionChangedListener();
    private RubyOutlinePage fOutlinePage;
    protected static final String MATCHING_BRACKETS = "matchingBrackets";
    protected static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']'};
    protected RubyPairMatcher fBracketMatcher = new RubyPairMatcher(BRACKETS);
    static /* synthetic */ Class class$0;

    private IPreferenceStore createCombinedPreferenceStore(IEditorInput iEditorInput) {
        ArrayList<IPreferenceStore> arrayList = new ArrayList<IPreferenceStore>(3);
        IRubyProject iRubyProject = EditorUtility.getRubyProject(iEditorInput);
        if (iRubyProject != null) {
            arrayList.add(new EclipsePreferencesAdapter((IScopeContext)new ProjectScope(iRubyProject.getProject()), "org.rubypeople.rdt.core"));
        }
        arrayList.add(RubyPlugin.getDefault().getPreferenceStore());
        arrayList.add(new PreferencesAdapter(RubyCore.getPlugin().getPluginPreferences()));
        arrayList.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(arrayList.toArray(new IPreferenceStore[arrayList.size()]));
    }

    public void outlinePageClosed() {
        if (this.fOutlinePage != null) {
            this.fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this.fOutlinePage);
            this.fOutlinePage = null;
            this.resetHighlightRange();
        }
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport sourceViewerDecorationSupport) {
        sourceViewerDecorationSupport.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        sourceViewerDecorationSupport.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        super.configureSourceViewerDecorationSupport(sourceViewerDecorationSupport);
    }

    protected ISourceViewer createSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        ISourceViewer iSourceViewer = this.createRubySourceViewer(composite, iVerticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), n, iPreferenceStore);
        this.getSourceViewerDecorationSupport(iSourceViewer);
        return iSourceViewer;
    }

    protected ISourceViewer createRubySourceViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, boolean bl, int n, IPreferenceStore iPreferenceStore) {
        return new RubySourceViewer(composite, iVerticalRuler, iOverviewRuler, bl, n, iPreferenceStore);
    }

    protected void setOutlinerContextMenuId(String string) {
        this.fOutlinerContextMenuId = string;
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore iPreferenceStore = this.createCombinedPreferenceStore(null);
        this.setPreferenceStore(iPreferenceStore);
        RubyTextTools rubyTextTools = RubyPlugin.getDefault().getRubyTextTools();
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new RubySourceViewerConfiguration(rubyTextTools.getColorManager(), iPreferenceStore, (ITextEditor)this, "___ruby_partitioning"));
    }

    protected void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        super.setPreferenceStore(iPreferenceStore);
        if (this.getSourceViewerConfiguration() instanceof RubySourceViewerConfiguration) {
            RubyTextTools rubyTextTools = RubyPlugin.getDefault().getRubyTextTools();
            this.setSourceViewerConfiguration((SourceViewerConfiguration)new RubySourceViewerConfiguration(rubyTextTools.getColorManager(), iPreferenceStore, (ITextEditor)this, "___ruby_partitioning"));
        }
        if (this.getSourceViewer() instanceof RubySourceViewer) {
            ((RubySourceViewer)this.getSourceViewer()).setPreferenceStore(iPreferenceStore);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(clazz)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = this.createRubyOutlinePage();
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(clazz);
    }

    protected RubyOutlinePage createRubyOutlinePage() {
        RubyOutlinePage rubyOutlinePage = new RubyOutlinePage(this.fOutlinerContextMenuId, this);
        this.fOutlineSelectionChangedListener.install((ISelectionProvider)rubyOutlinePage);
        this.setOutlinePageInput(rubyOutlinePage, this.getEditorInput());
        return rubyOutlinePage;
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        super.doSetInput(iEditorInput);
        this.setOutlinePageInput(this.fOutlinePage, iEditorInput);
    }

    protected void setOutlinePageInput(RubyOutlinePage rubyOutlinePage, IEditorInput iEditorInput) {
        if (rubyOutlinePage != null) {
            IWorkingCopyManager iWorkingCopyManager = RubyPlugin.getDefault().getWorkingCopyManager();
            rubyOutlinePage.setInput((IRubyElement)iWorkingCopyManager.getWorkingCopy(iEditorInput));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        IContentAssistant iContentAssistant;
        Object object;
        String string;
        block12: {
            block11: {
                block10: {
                    string = propertyChangeEvent.getProperty();
                    if ("tabWidth".equals(string)) {
                        return;
                    }
                    try {
                        object = (AdaptedSourceViewer)this.getSourceViewer();
                        if (object == null) {
                            Object var6_4 = null;
                            break block10;
                        }
                        ((RubySourceViewerConfiguration)this.getSourceViewerConfiguration()).handlePropertyChangeEvent(propertyChangeEvent);
                        if ("org.rubypeople.rdt.core.formatter.tabulation.size".equals(string) || "org.rubypeople.rdt.core.formatter.indentation.size".equals(string) || "org.rubypeople.rdt.core.formatter.tabulation.char".equals(string)) {
                            StyledText styledText = object.getTextWidget();
                            int n = this.getSourceViewerConfiguration().getTabWidth((ISourceViewer)object);
                            if (styledText.getTabs() != n) {
                                styledText.setTabs(n);
                            }
                            break block11;
                        }
                        iContentAssistant = ((AdaptedSourceViewer)((Object)object)).getContentAssistant();
                        if (iContentAssistant instanceof ContentAssistant) {
                            ContentAssistPreference.changeConfiguration((ContentAssistant)iContentAssistant, this.getPreferenceStore(), propertyChangeEvent);
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        super.handlePreferenceStoreChanged(propertyChangeEvent);
                        throw throwable;
                    }
                }
                super.handlePreferenceStoreChanged(propertyChangeEvent);
                return;
            }
            Object var6_5 = null;
            super.handlePreferenceStoreChanged(propertyChangeEvent);
            return;
        }
        Object var6_7 = null;
        super.handlePreferenceStoreChanged(propertyChangeEvent);
        if ("show_range_indicator".equals(string)) {
            object = propertyChangeEvent.getNewValue();
            iContentAssistant = this.getSourceViewer();
            if (object != null && iContentAssistant != null && Boolean.valueOf(object.toString()).booleanValue()) {
                Point point = iContentAssistant.getSelectedRange();
                this.adjustHighlightRange(point.x, point.y);
            }
        }
    }

    protected void handleOutlinePageSelection(SelectionChangedEvent selectionChangedEvent) {
        StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
        Iterator iterator = structuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ISourceReference)) continue;
            this.reference = (ISourceReference)e;
            break;
        }
        if (!this.isActivePart() && RubyPlugin.getActivePage() != null) {
            RubyPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
        }
        this.setSelection(this.reference, true);
    }

    protected boolean isActivePart() {
        IWorkbenchPart iWorkbenchPart = this.getActivePart();
        return iWorkbenchPart != null && iWorkbenchPart.equals((Object)this);
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow iWorkbenchWindow = this.getSite().getWorkbenchWindow();
        IPartService iPartService = iWorkbenchWindow.getPartService();
        IWorkbenchPart iWorkbenchPart = iPartService.getActivePart();
        return iWorkbenchPart;
    }

    public void setSelection(IRubyElement iRubyElement) {
        if (iRubyElement == null || iRubyElement instanceof IRubyScript) {
            return;
        }
        IRubyElement iRubyElement2 = this.getCorrespondingElement(iRubyElement);
        if (iRubyElement2 instanceof ISourceReference) {
            ISourceReference iSourceReference = (ISourceReference)iRubyElement2;
            this.setSelection(iSourceReference, true);
            if (this.fOutlinePage != null) {
                this.fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this.fOutlinePage);
                this.fOutlinePage.select(iSourceReference);
                this.fOutlineSelectionChangedListener.install((ISelectionProvider)this.fOutlinePage);
            }
        }
    }

    protected IRubyElement getCorrespondingElement(IRubyElement iRubyElement) {
        return iRubyElement;
    }

    protected void synchronizeOutlinePage(ISourceReference iSourceReference, boolean bl) {
        if (!(this.fOutlinePage == null || iSourceReference == null || bl && this.isRubyOutlinePageActive())) {
            this.fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this.fOutlinePage);
            this.fOutlinePage.select(iSourceReference);
            this.fOutlineSelectionChangedListener.install((ISelectionProvider)this.fOutlinePage);
        }
    }

    private boolean isRubyOutlinePageActive() {
        IWorkbenchPart iWorkbenchPart = this.getActivePart();
        return iWorkbenchPart instanceof ContentOutline && ((ContentOutline)iWorkbenchPart).getCurrentPage() == this.fOutlinePage;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setSelection(ISourceReference iSourceReference, boolean bl) {
        TextSelection textSelection;
        if (this.getSelectionProvider() == null) {
            return;
        }
        ISelection iSelection = this.getSelectionProvider().getSelection();
        if (iSelection instanceof TextSelection) {
            textSelection = (TextSelection)iSelection;
            if (bl && (textSelection.getOffset() != 0 || textSelection.getLength() != 0)) {
                this.markInNavigationHistory();
            }
        }
        if (iSourceReference == null) {
            if (!bl) return;
            this.resetHighlightRange();
            this.markInNavigationHistory();
            return;
        }
        textSelection = null;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer != null) {
            textSelection = iSourceViewer.getTextWidget();
        }
        if (textSelection == null) {
            return;
        }
        try {
            String string;
            String string2;
            ISourceRange iSourceRange = null;
            iSourceRange = iSourceReference.getSourceRange();
            if (iSourceRange == null) {
                return;
            }
            int n = iSourceRange.getOffset();
            int n2 = iSourceRange.getLength();
            if (n < 0) return;
            if (n2 < 0) {
                return;
            }
            this.setHighlightRange(n, n2, bl);
            if (!bl) {
                return;
            }
            n = -1;
            n2 = -1;
            if (iSourceReference instanceof IMember) {
                iSourceRange = ((IMember)iSourceReference).getNameRange();
                if (iSourceRange != null) {
                    n = iSourceRange.getOffset();
                    n2 = iSourceRange.getLength();
                }
            } else if (iSourceReference instanceof IImportDeclaration && (string2 = ((IImportDeclaration)iSourceReference).getElementName()) != null && string2.length() > 0 && (string = iSourceReference.getSource()) != null) {
                n = iSourceRange.getOffset() + string.indexOf(string2);
                n2 = string2.length();
            }
            if (n <= -1) return;
            if (n2 <= 0) return;
            try {
                textSelection.setRedraw(false);
                iSourceViewer.revealRange(n, n2);
                iSourceViewer.setSelectedRange(n, n2);
            }
            catch (Throwable throwable) {
                string2 = null;
                textSelection.setRedraw(true);
                throw throwable;
            }
            {
                string2 = null;
            }
            textSelection.setRedraw(true);
            this.markInNavigationHistory();
            return;
        }
        catch (RubyModelException rubyModelException) {
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent propertyChangeEvent) {
        return ((RubySourceViewerConfiguration)this.getSourceViewerConfiguration()).affectsTextPresentation(propertyChangeEvent) || super.affectsTextPresentation(propertyChangeEvent);
    }

    protected void doSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISourceReference iSourceReference = null;
        ISelection iSelection = selectionChangedEvent.getSelection();
        Iterator iterator = ((IStructuredSelection)iSelection).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ISourceReference)) continue;
            iSourceReference = (ISourceReference)e;
            break;
        }
        if (!this.isActivePart() && RubyPlugin.getActivePage() != null) {
            RubyPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
        }
        this.setSelection(iSourceReference, !this.isActivePart());
    }

    protected ISourceReference computeHighlightRangeSourceReference() {
        ITextViewerExtension5 iTextViewerExtension5;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer == null) {
            return null;
        }
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int n = 0;
        if (iSourceViewer instanceof ITextViewerExtension5) {
            iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
            n = iTextViewerExtension5.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int n2 = iSourceViewer.getVisibleRegion().getOffset();
            n = n2 + styledText.getCaretOffset();
        }
        iTextViewerExtension5 = this.getElementAt(n, false);
        if (!(iTextViewerExtension5 instanceof ISourceReference)) {
            return null;
        }
        if (iTextViewerExtension5.getElementType() == 6) {
            IImportDeclaration iImportDeclaration = (IImportDeclaration)iTextViewerExtension5;
            IImportContainer iImportContainer = (IImportContainer)iImportDeclaration.getParent();
            ISourceRange iSourceRange = null;
            try {
                iSourceRange = iImportContainer.getSourceRange();
            }
            catch (RubyModelException rubyModelException) {}
            if (iSourceRange != null && iSourceRange.getOffset() == n) {
                return iImportContainer;
            }
        }
        return (ISourceReference)iTextViewerExtension5;
    }

    protected abstract IRubyElement getElementAt(int var1, boolean var2);

    protected abstract IRubyElement getElementAt(int var1);

    class OutlineSelectionChangedListener
    extends AbstractTextEditor.AbstractSelectionChangedListener {
        OutlineSelectionChangedListener() {
            super((AbstractTextEditor)RubyAbstractEditor.this);
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            RubyAbstractEditor.this.doSelectionChanged(selectionChangedEvent);
        }
    }

    private static class EclipsePreferencesAdapter
    implements IPreferenceStore {
        private ListenerList fListeners = new ListenerList();
        private IEclipsePreferences.IPreferenceChangeListener fListener = new PreferenceChangeListener();
        private final IScopeContext fContext;
        private final String fQualifier;

        public EclipsePreferencesAdapter(IScopeContext iScopeContext, String string) {
            this.fContext = iScopeContext;
            this.fQualifier = string;
        }

        private IEclipsePreferences getNode() {
            return this.fContext.getNode(this.fQualifier);
        }

        public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
            if (this.fListeners.size() == 0) {
                this.getNode().addPreferenceChangeListener(this.fListener);
            }
            this.fListeners.add((Object)iPropertyChangeListener);
        }

        public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
            this.fListeners.remove((Object)iPropertyChangeListener);
            if (this.fListeners.size() == 0) {
                this.getNode().removePreferenceChangeListener(this.fListener);
            }
        }

        public boolean contains(String string) {
            return this.getNode().get(string, null) != null;
        }

        public void firePropertyChangeEvent(String string, Object object, Object object2) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
            Object[] objectArray = this.fListeners.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
                ++n;
            }
        }

        public boolean getBoolean(String string) {
            return this.getNode().getBoolean(string, false);
        }

        public boolean getDefaultBoolean(String string) {
            return false;
        }

        public double getDefaultDouble(String string) {
            return 0.0;
        }

        public float getDefaultFloat(String string) {
            return 0.0f;
        }

        public int getDefaultInt(String string) {
            return 0;
        }

        public long getDefaultLong(String string) {
            return 0L;
        }

        public String getDefaultString(String string) {
            return "";
        }

        public double getDouble(String string) {
            return this.getNode().getDouble(string, 0.0);
        }

        public float getFloat(String string) {
            return this.getNode().getFloat(string, 0.0f);
        }

        public int getInt(String string) {
            return this.getNode().getInt(string, 0);
        }

        public long getLong(String string) {
            return this.getNode().getLong(string, 0L);
        }

        public String getString(String string) {
            return this.getNode().get(string, "");
        }

        public boolean isDefault(String string) {
            return false;
        }

        public boolean needsSaving() {
            try {
                return this.getNode().keys().length > 0;
            }
            catch (BackingStoreException backingStoreException) {
                return true;
            }
        }

        public void putValue(String string, String string2) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String string, double d) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String string, float f) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String string, int n) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String string, long l) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String string, String string2) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String string, boolean bl) {
            throw new UnsupportedOperationException();
        }

        public void setToDefault(String string) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String string, double d) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String string, float f) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String string, int n) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String string, long l) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String string, String string2) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String string, boolean bl) {
            throw new UnsupportedOperationException();
        }

        private class PreferenceChangeListener
        implements IEclipsePreferences.IPreferenceChangeListener {
            PreferenceChangeListener() {
            }

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
                if (Display.getCurrent() == null) {
                    Display.getDefault().asyncExec(new Runnable(this, preferenceChangeEvent){
                        final /* synthetic */ PreferenceChangeListener this$2;
                        private final /* synthetic */ IEclipsePreferences.PreferenceChangeEvent val$event;
                        {
                            this.this$2 = preferenceChangeListener;
                            this.val$event = preferenceChangeEvent;
                        }

                        public void run() {
                            PreferenceChangeListener.access$0(this.this$2).firePropertyChangeEvent(this.val$event.getKey(), this.val$event.getOldValue(), this.val$event.getNewValue());
                        }
                    });
                } else {
                    EclipsePreferencesAdapter.this.firePropertyChangeEvent(preferenceChangeEvent.getKey(), preferenceChangeEvent.getOldValue(), preferenceChangeEvent.getNewValue());
                }
            }

            static /* synthetic */ EclipsePreferencesAdapter access$0(PreferenceChangeListener preferenceChangeListener) {
                return preferenceChangeListener.EclipsePreferencesAdapter.this;
            }
        }
    }

    class AdaptedSourceViewer
    extends RubySourceViewer {
        private List fTextConverters;
        private boolean fIgnoreTextConverters;

        public AdaptedSourceViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, boolean bl, int n, IPreferenceStore iPreferenceStore) {
            super(composite, iVerticalRuler, iOverviewRuler, bl, n, iPreferenceStore);
            this.fIgnoreTextConverters = false;
        }

        public IContentAssistant getContentAssistant() {
            return this.fContentAssistant;
        }
    }
}

