/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.preferences.IPreferenceConfigurationBlock;
import org.rubypeople.rdt.internal.ui.preferences.OverlayPreferenceStore;
import org.rubypeople.rdt.internal.ui.text.folding.RubyFoldingStructureProviderDescriptor;
import org.rubypeople.rdt.internal.ui.text.folding.RubyFoldingStructureProviderRegistry;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.ui.text.folding.IRubyFoldingPreferenceBlock;

class FoldingConfigurationBlock
implements IPreferenceConfigurationBlock {
    private final OverlayPreferenceStore fStore;
    private Combo fProviderCombo;
    private Button fFoldingCheckbox;
    private ComboViewer fProviderViewer;
    private Map fProviderDescriptors;
    private Composite fGroup;
    private Map fProviderPreferences;
    private Map fProviderControls;
    private StackLayout fStackLayout;

    public FoldingConfigurationBlock(OverlayPreferenceStore overlayPreferenceStore) {
        Assert.isNotNull((Object)overlayPreferenceStore);
        this.fStore = overlayPreferenceStore;
        this.fStore.addKeys(this.createOverlayStoreKeys());
        this.fProviderDescriptors = this.createListModel();
        this.fProviderPreferences = new HashMap();
        this.fProviderControls = new HashMap();
    }

    private Map createListModel() {
        RubyFoldingStructureProviderRegistry rubyFoldingStructureProviderRegistry = RubyPlugin.getDefault().getFoldingStructureProviderRegistry();
        rubyFoldingStructureProviderRegistry.reloadExtensions();
        RubyFoldingStructureProviderDescriptor[] rubyFoldingStructureProviderDescriptorArray = rubyFoldingStructureProviderRegistry.getFoldingProviderDescriptors();
        HashMap<String, RubyFoldingStructureProviderDescriptor> hashMap = new HashMap<String, RubyFoldingStructureProviderDescriptor>();
        int n = 0;
        while (n < rubyFoldingStructureProviderDescriptorArray.length) {
            hashMap.put(rubyFoldingStructureProviderDescriptorArray[n].getId(), rubyFoldingStructureProviderDescriptorArray[n]);
            ++n;
        }
        return hashMap;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> arrayList = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_enabled"));
        arrayList.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "editor_folding_provider"));
        OverlayPreferenceStore.OverlayKey[] overlayKeyArray = new OverlayPreferenceStore.OverlayKey[arrayList.size()];
        arrayList.toArray(overlayKeyArray);
        return overlayKeyArray;
    }

    public Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(80);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        PixelConverter pixelConverter = new PixelConverter((Control)composite2);
        gridLayout.verticalSpacing = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        composite2.setLayout((Layout)gridLayout);
        this.fFoldingCheckbox = new Button(composite2, 32);
        this.fFoldingCheckbox.setText(RubyUIMessages.getString("FoldingConfigurationBlock.enable"));
        gridData = new GridData(34);
        this.fFoldingCheckbox.setLayoutData((Object)gridData);
        this.fFoldingCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = FoldingConfigurationBlock.this.fFoldingCheckbox.getSelection();
                FoldingConfigurationBlock.this.fStore.setValue("editor_folding_enabled", bl);
                FoldingConfigurationBlock.this.updateCheckboxDependencies();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        Label label = new Label(composite2, 0x1000000);
        gridData = new GridData(770);
        label.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridData = new GridData(770);
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        Label label2 = new Label(composite3, 0x1000000);
        gridData = new GridData(36);
        label2.setLayoutData((Object)gridData);
        label2.setText(RubyUIMessages.getString("FoldingConfigurationBlock.combo_caption"));
        label = new Label(composite2, 0x1000000);
        gridData = new GridData(770);
        label.setLayoutData((Object)gridData);
        this.fProviderCombo = new Combo(composite3, 12);
        gridData = new GridData(132);
        this.fProviderCombo.setLayoutData((Object)gridData);
        this.fProviderViewer = new ComboViewer(this.fProviderCombo);
        this.fProviderViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                return FoldingConfigurationBlock.this.fProviderDescriptors.values().toArray();
            }
        });
        this.fProviderViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object object) {
                return null;
            }

            public String getText(Object object) {
                return ((RubyFoldingStructureProviderDescriptor)object).getName();
            }
        });
        this.fProviderViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                if (!iStructuredSelection.isEmpty()) {
                    FoldingConfigurationBlock.this.fStore.setValue("editor_folding_provider", ((RubyFoldingStructureProviderDescriptor)iStructuredSelection.getFirstElement()).getId());
                    FoldingConfigurationBlock.this.updateListDependencies();
                }
            }
        });
        this.fProviderViewer.setInput((Object)this.fProviderDescriptors);
        this.fProviderViewer.refresh();
        Composite composite4 = new Composite(composite2, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        composite4.setLayoutData((Object)gridData);
        gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 0;
        composite4.setLayout((Layout)gridLayout2);
        this.fGroup = new Composite(composite4, 0);
        gridData = new GridData(34);
        this.fGroup.setLayoutData((Object)gridData);
        this.fStackLayout = new StackLayout();
        this.fGroup.setLayout((Layout)this.fStackLayout);
        return composite2;
    }

    private void updateCheckboxDependencies() {
    }

    void updateListDependencies() {
        IRubyFoldingPreferenceBlock iRubyFoldingPreferenceBlock;
        String string;
        String string2 = this.fStore.getString("editor_folding_provider");
        RubyFoldingStructureProviderDescriptor rubyFoldingStructureProviderDescriptor = (RubyFoldingStructureProviderDescriptor)this.fProviderDescriptors.get(string2);
        if (rubyFoldingStructureProviderDescriptor == null) {
            string = RubyUIMessages.getString("FoldingConfigurationBlock.error.not_exist");
            RubyPlugin.log((IStatus)new Status(2, RubyPlugin.getPluginId(), 0, string, null));
            iRubyFoldingPreferenceBlock = new ErrorPreferences(string);
        } else {
            iRubyFoldingPreferenceBlock = (IRubyFoldingPreferenceBlock)this.fProviderPreferences.get(string2);
            if (iRubyFoldingPreferenceBlock == null) {
                try {
                    iRubyFoldingPreferenceBlock = rubyFoldingStructureProviderDescriptor.createPreferences();
                    this.fProviderPreferences.put(string2, iRubyFoldingPreferenceBlock);
                }
                catch (CoreException coreException) {
                    RubyPlugin.log(coreException);
                    iRubyFoldingPreferenceBlock = new ErrorPreferences(coreException.getLocalizedMessage());
                }
            }
        }
        string = (Control)this.fProviderControls.get(string2);
        if (string == null) {
            string = iRubyFoldingPreferenceBlock.createControl(this.fGroup);
            if (string == null) {
                String string3 = RubyUIMessages.getString("FoldingConfigurationBlock.info.no_preferences");
                string = new ErrorPreferences(string3).createControl(this.fGroup);
            } else {
                this.fProviderControls.put(string2, string);
            }
        }
        this.fStackLayout.topControl = string;
        string.pack();
        this.fGroup.layout();
        this.fGroup.getParent().layout();
        iRubyFoldingPreferenceBlock.initialize();
    }

    public void initialize() {
        this.restoreFromPreferences();
    }

    public void performOk() {
        Iterator iterator = this.fProviderPreferences.values().iterator();
        while (iterator.hasNext()) {
            IRubyFoldingPreferenceBlock iRubyFoldingPreferenceBlock = (IRubyFoldingPreferenceBlock)iterator.next();
            iRubyFoldingPreferenceBlock.performOk();
        }
    }

    public void performDefaults() {
        this.restoreFromPreferences();
        Iterator iterator = this.fProviderPreferences.values().iterator();
        while (iterator.hasNext()) {
            IRubyFoldingPreferenceBlock iRubyFoldingPreferenceBlock = (IRubyFoldingPreferenceBlock)iterator.next();
            iRubyFoldingPreferenceBlock.performDefaults();
        }
    }

    public void dispose() {
        Iterator iterator = this.fProviderPreferences.values().iterator();
        while (iterator.hasNext()) {
            IRubyFoldingPreferenceBlock iRubyFoldingPreferenceBlock = (IRubyFoldingPreferenceBlock)iterator.next();
            iRubyFoldingPreferenceBlock.dispose();
        }
    }

    private void restoreFromPreferences() {
        boolean bl = this.fStore.getBoolean("editor_folding_enabled");
        this.fFoldingCheckbox.setSelection(bl);
        this.updateCheckboxDependencies();
        String string = this.fStore.getString("editor_folding_provider");
        Object v = this.fProviderDescriptors.get(string);
        if (v != null) {
            this.fProviderViewer.setSelection((ISelection)new StructuredSelection(v), true);
            this.updateListDependencies();
        }
    }

    private static class ErrorPreferences
    implements IRubyFoldingPreferenceBlock {
        private String fMessage;

        protected ErrorPreferences(String string) {
            this.fMessage = string;
        }

        public Control createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new FillLayout(512));
            Label label = new Label(composite2, 0x1000000);
            label.setText(this.fMessage);
            return composite2;
        }

        public void initialize() {
        }

        public void performOk() {
        }

        public void performDefaults() {
        }

        public void dispose() {
        }
    }
}

