/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.infoviews;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.rubypeople.rdt.internal.launching.RubyInterpreter;
import org.rubypeople.rdt.internal.launching.RubyRuntime;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.infoviews.InfoViewMessages;
import org.rubypeople.rdt.internal.ui.rdocexport.RDocUtility;
import org.rubypeople.rdt.internal.ui.rdocexport.RdocListener;

public class RIView
extends ViewPart
implements RdocListener {
    private boolean riFound = false;
    private PageBook pageBook;
    private SashForm form;
    private Label interpreterNeededLabel;
    private Label riNotFoundLabel;
    private Text searchStr;
    private TableViewer searchListViewer;
    private Browser searchResult;
    private List possibleMatches = new ArrayList();
    private SearchValue itemToSearch = new SearchValue();
    private DescriptionUpdater descriptionUpdater = new DescriptionUpdater();
    private RubyRuntime.Listener runtimeListener;
    private ListContentProvider contentProvider = new ListContentProvider();

    public void createPartControl(Composite composite) {
        this.contributeToActionBars();
        this.pageBook = new PageBook(composite, 0);
        this.interpreterNeededLabel = new Label((Composite)this.pageBook, 0);
        this.interpreterNeededLabel.setText(InfoViewMessages.getString("RubyInformation.interpreter_not_selected"));
        this.riNotFoundLabel = new Label((Composite)this.pageBook, 16576);
        this.riNotFoundLabel.setText(InfoViewMessages.getString("RubyInformation.ri_not_found"));
        this.form = new SashForm((Composite)this.pageBook, 256);
        Composite composite2 = new Composite((Composite)this.form, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.searchStr = new Text(composite2, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.searchStr.setLayoutData((Object)gridData);
        this.searchStr.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RIView.this.filterSearchList();
            }
        });
        this.searchStr.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                super.keyPressed(keyEvent);
                if (keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 13) {
                    RIView.this.searchListViewer.getTable().setFocus();
                } else if (keyEvent.keyCode == 27) {
                    RIView.this.searchStr.setText("");
                }
            }
        });
        this.searchListViewer = new TableViewer(composite2, 2816);
        this.searchListViewer.setContentProvider((IContentProvider)this.contentProvider);
        gridData = new GridData(1808);
        this.searchListViewer.getTable().setLayoutData((Object)gridData);
        this.searchListViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                RIView.this.showSelectedItem();
            }
        });
        this.searchStr.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                RIView.this.searchStr.selectAll();
            }
        });
        this.searchResult = new Browser((Composite)this.form, 2048);
        this.form.setWeights(new int[]{1, 3});
        this.runtimeListener = new RubyRuntime.Listener(){

            public void selectedInterpreterChanged() {
                RIView.this.updatePage();
            }
        };
        RubyRuntime.getDefault().addListener(this.runtimeListener);
        RubyPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("riDirectoryPath")) {
                    RIView.this.updatePage();
                }
            }
        });
        this.updatePage();
        this.descriptionUpdater.start();
        RDocUtility.addRdocListener(this);
    }

    private void contributeToActionBars() {
        Action action = new Action(){

            public void run() {
                RIView.this.updatePage();
            }
        };
        action.setText("Refresh");
        action.setToolTipText("Refresh list of names");
        action.setImageDescriptor(RubyPluginImages.TOOLBAR_REFRESH);
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)action);
    }

    private void updatePage() {
        RubyInterpreter rubyInterpreter = RubyRuntime.getDefault().getSelectedInterpreter();
        if (rubyInterpreter != null) {
            this.initSearchList();
            if (this.riFound) {
                this.pageBook.showPage((Control)this.form);
            }
        } else {
            this.pageBook.showPage((Control)this.interpreterNeededLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSelectedItem() {
        String string = (String)((IStructuredSelection)this.searchListViewer.getSelection()).getFirstElement();
        SearchValue searchValue = this.itemToSearch;
        synchronized (searchValue) {
            this.itemToSearch.set(string);
        }
    }

    public void dispose() {
        this.descriptionUpdater.requestStop();
        RubyRuntime.getDefault().removeListener(this.runtimeListener);
        super.dispose();
    }

    private void initSearchList() {
        RubyInvoker rubyInvoker = new RubyInvoker(){

            protected void handleOutput(Process process) {
                RIView.this.riFound = false;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String string = null;
                int n = 0;
                RIView.this.possibleMatches = new ArrayList();
                try {
                    while ((string = bufferedReader.readLine()) != null) {
                        RIView.this.possibleMatches.add(string.trim());
                        ++n;
                    }
                    if (n == 0) {
                        RIView.this.riFound = false;
                        RIView.this.pageBook.showPage((Control)RIView.this.riNotFoundLabel);
                    } else {
                        RIView.this.riFound = true;
                    }
                }
                catch (IOException iOException) {}
            }

            protected List getArgList() {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("--no-pager");
                arrayList.add("-l");
                return arrayList;
            }
        };
        rubyInvoker.invoke();
        this.filterSearchList();
    }

    private void filterSearchList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.searchStr.getText();
        Iterator iterator = this.possibleMatches.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.toLowerCase().indexOf(string.toLowerCase()) <= -1) continue;
            arrayList.add(string2);
        }
        this.searchListViewer.setInput(arrayList);
        if (arrayList.size() > 0) {
            this.searchListViewer.getTable().setSelection(0);
        }
        this.showSelectedItem();
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void rdocChanged() {
        this.updatePage();
    }

    static /* synthetic */ Browser access$0(RIView rIView) {
        return rIView.searchResult;
    }

    private class SearchValue {
        String value = null;

        SearchValue() {
        }

        void set(String string) {
            this.value = string;
            this.notifyAll();
        }

        boolean isSet() {
            return this.value != null;
        }

        String get() {
            String string = this.value;
            this.value = null;
            return string;
        }
    }

    private final class ListContentProvider
    implements IStructuredContentProvider {
        ListContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return ((Collection)object).toArray();
        }
    }

    private final class DescriptionUpdater
    extends Thread {
        private String searchValue;
        private volatile boolean stopped;
        private RubyInvoker invoker;

        public DescriptionUpdater() {
            super("RI Description Updater");
            this.stopped = false;
            this.invoker = new RubyInvoker(this, RIView.this){
                final /* synthetic */ DescriptionUpdater this$1;
                {
                    this.this$1 = descriptionUpdater;
                    super();
                }

                protected List getArgList() {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add("--no-pager");
                    arrayList.add("-f");
                    arrayList.add("html");
                    arrayList.add(DescriptionUpdater.access$0(this.this$1));
                    return arrayList;
                }

                protected void beforeInvoke() {
                    RIView.access$0(DescriptionUpdater.access$1(this.this$1)).setText(InfoViewMessages.getString("RubyInformation.please_wait"));
                }

                protected void handleOutput(Process process) {
                    StreamRedirector streamRedirector = DescriptionUpdater.access$1(this.this$1).new StreamRedirector(process.getInputStream(), "");
                    streamRedirector.start();
                    try {
                        int n = process.waitFor();
                        if (n != 0) {
                            streamRedirector.inQueue("<p>No matching results.</p>");
                        }
                        streamRedirector.done();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            };
        }

        public void requestStop() {
            this.stopped = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stopped) {
                SearchValue searchValue = RIView.this.itemToSearch;
                synchronized (searchValue) {
                    try {
                        while (!RIView.this.itemToSearch.isSet() && !this.stopped) {
                            RIView.this.itemToSearch.wait();
                        }
                        this.searchValue = RIView.this.itemToSearch.get();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.stopped) {
                    return;
                }
                this.invoker.invoke();
            }
        }

        static /* synthetic */ String access$0(DescriptionUpdater descriptionUpdater) {
            return descriptionUpdater.searchValue;
        }

        static /* synthetic */ RIView access$1(DescriptionUpdater descriptionUpdater) {
            return descriptionUpdater.RIView.this;
        }
    }

    private abstract class RubyInvoker {
        RubyInvoker() {
        }

        protected abstract List getArgList();

        protected abstract void handleOutput(Process var1);

        protected void beforeInvoke() {
        }

        public final void invoke() {
            Path path = new Path(RubyPlugin.getDefault().getPreferenceStore().getString("riDirectoryPath"));
            File file = new File(path.toOSString());
            if (!file.exists() || !file.isFile()) {
                RIView.this.riFound = false;
                RIView.this.pageBook.showPage((Control)RIView.this.riNotFoundLabel);
                return;
            }
            try {
                List list = this.getArgList();
                list.add(0, path.toString());
                Process process = RubyRuntime.getDefault().getSelectedInterpreter().exec(list, null);
                this.handleOutput(process);
            }
            catch (CoreException coreException) {
                throw new RuntimeException(coreException.getStatus().getMessage());
            }
        }
    }

    class StreamRedirector
    extends Thread {
        InputStream is;
        String linePrefix;
        String line = null;
        boolean done = false;
        final List queue = new ArrayList();
        private StringBuffer buffer = new StringBuffer();
        private final String HEADER = "<html><head></head><body>";
        private final String TAIL = "</body></html>";

        StreamRedirector(InputStream inputStream, String string) {
            this.is = inputStream;
            this.linePrefix = string;
        }

        void done() {
            this.done = true;
        }

        void inQueue(String string) {
            this.queue.add(string);
        }

        void addToBuffer(int n, String string) {
            if (n < 0) {
                n = 0;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!string.endsWith(">")) {
                stringBuffer.append("<br/>");
            }
            stringBuffer.append("\r\n");
            this.buffer.insert(n, stringBuffer.toString());
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((this.line = bufferedReader.readLine()) != null) {
                    this.addToBuffer(this.buffer.length() - 1, String.valueOf(this.linePrefix) + this.line);
                }
                this.buffer.insert(0, "<html><head></head><body>");
                this.buffer.append("</body></html>");
                this.setText();
                while (!this.done || this.queue.size() > 0) {
                    if (this.queue.size() > 0) {
                        String string = (String)this.queue.get(0);
                        if (string == null) {
                            this.queue.remove(0);
                            continue;
                        }
                        this.addToBuffer(this.buffer.length() - "</body></html>".length(), String.valueOf(this.linePrefix) + string);
                        this.queue.remove(0);
                        this.setText();
                        continue;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        private void setText() {
            Display.getDefault().syncExec(new Runnable(this){
                final /* synthetic */ StreamRedirector this$1;
                {
                    this.this$1 = streamRedirector;
                }

                public void run() {
                    RIView.access$0(StreamRedirector.access$1(this.this$1)).setText(StreamRedirector.access$0(this.this$1).toString());
                }
            });
        }

        static /* synthetic */ StringBuffer access$0(StreamRedirector streamRedirector) {
            return streamRedirector.buffer;
        }

        static /* synthetic */ RIView access$1(StreamRedirector streamRedirector) {
            return streamRedirector.RIView.this;
        }
    }
}

