/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.rubypeople.rdt.internal.core.util.Util;

public final class RubySourceFileCollectingVisitor
implements IResourceProxyVisitor {
    private static final String RUBY_SOURCE_CONTENT_TYPE_ID = "org.rubypeople.rdt.core.rubySource";
    private final List files;

    public RubySourceFileCollectingVisitor(List list) {
        this.files = list;
    }

    public boolean visit(IResourceProxy iResourceProxy) throws CoreException {
        IResource iResource = null;
        switch (iResourceProxy.getType()) {
            case 1: {
                IContentType iContentType;
                if (Util.isRubyLikeFileName(iResourceProxy.getName())) {
                    if (iResource == null) {
                        iResource = iResourceProxy.requestResource();
                    }
                    this.files.add(iResource);
                    return false;
                }
                iResource = iResourceProxy.requestResource();
                IFile iFile = (IFile)iResource;
                IContentDescription iContentDescription = iFile.getContentDescription();
                if (iContentDescription != null && (iContentType = iContentDescription.getContentType()) != null && iContentType.getId().equals(RUBY_SOURCE_CONTENT_TYPE_ID)) {
                    this.files.add(iResource);
                }
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        return object.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return 0;
    }
}

