/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.core.ElementCache;
import org.rubypeople.rdt.internal.core.RubyModelInfo;
import org.rubypeople.rdt.internal.core.buffer.OverflowingLRUCache;

public class RubyModelCache {
    public static final int CACHE_RATIO = 20;
    protected RubyModelInfo modelInfo;
    protected HashMap projectCache = new HashMap(5);
    protected OverflowingLRUCache openableCache = new ElementCache(2000);
    protected Map childrenCache = new HashMap(4000);

    public Object getInfo(IRubyElement iRubyElement) {
        switch (iRubyElement.getElementType()) {
            case 0: {
                return this.modelInfo;
            }
            case 1: {
                return this.projectCache.get(iRubyElement);
            }
            case 2: {
                return this.openableCache.get(iRubyElement);
            }
        }
        return this.childrenCache.get(iRubyElement);
    }

    protected Object peekAtInfo(IRubyElement iRubyElement) {
        switch (iRubyElement.getElementType()) {
            case 0: {
                return this.modelInfo;
            }
            case 1: {
                return this.projectCache.get(iRubyElement);
            }
            case 2: {
                return this.openableCache.peek(iRubyElement);
            }
        }
        return this.childrenCache.get(iRubyElement);
    }

    protected void putInfo(IRubyElement iRubyElement, Object object) {
        switch (iRubyElement.getElementType()) {
            case 0: {
                this.modelInfo = (RubyModelInfo)object;
                break;
            }
            case 1: {
                this.projectCache.put(iRubyElement, object);
                break;
            }
            case 2: {
                this.openableCache.put(iRubyElement, object);
                break;
            }
            default: {
                this.childrenCache.put(iRubyElement, object);
            }
        }
    }

    protected void removeInfo(IRubyElement iRubyElement) {
        switch (iRubyElement.getElementType()) {
            case 0: {
                this.modelInfo = null;
                break;
            }
            case 1: {
                this.projectCache.remove(iRubyElement);
                break;
            }
            case 2: {
                this.openableCache.remove(iRubyElement);
                break;
            }
            default: {
                this.childrenCache.remove(iRubyElement);
            }
        }
    }

    public String toStringFillingRation(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("Project cache: ");
        stringBuffer.append(this.projectCache.size());
        stringBuffer.append(" projects\n");
        stringBuffer.append(string);
        stringBuffer.append("Openable cache: ");
        stringBuffer.append(NumberFormat.getInstance().format(this.openableCache.fillingRatio()));
        stringBuffer.append("%\n");
        return stringBuffer.toString();
    }
}

