/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class PerlImageDescriptorRegistry {
    private HashMap fRegistry = new HashMap(10);
    private Display fDisplay;

    public PerlImageDescriptorRegistry() {
        this(PerlImageDescriptorRegistry.getStandardDisplay());
    }

    public PerlImageDescriptorRegistry(Display display) {
        this.fDisplay = display;
        Assert.isNotNull((Object)this.fDisplay);
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = (Image)this.fRegistry.get(descriptor)) != null) {
            return result;
        }
        Assert.isTrue((this.fDisplay == PerlImageDescriptorRegistry.getStandardDisplay() ? 1 : 0) != 0, (String)"Allocating image for wrong display.");
        result = descriptor.createImage();
        if (result != null) {
            this.fRegistry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        Iterator iter = this.fRegistry.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        this.fRegistry.clear();
    }

    private void hookDisplay() {
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

