/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ListEditor
extends FieldEditor {
    private IPropertyChangeListener mTab;
    private List list;
    private Composite buttonBox;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private SelectionListener selectionListener;

    protected ListEditor() {
    }

    public ListEditor(String name, Composite parent, IPropertyChangeListener tab) {
        this.init(name, "CGI script environment variables:");
        this.createControl(parent);
        this.mTab = tab;
    }

    private void addPressed() {
        this.setPresentsDefaultValue(false);
        String input = this.getNewInputObject();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            index = index >= 0 ? ++index : 0;
            this.list.add(input, index);
            this.list.select(index);
            this.selectionChanged();
            this.listHasChanged();
            this.firePropertyChange();
        }
    }

    private void editPressed() {
        int index = this.list.getSelectionIndex();
        this.setPresentsDefaultValue(false);
        String input = this.list.getItem(index);
        if (index < 0) {
            return;
        }
        InputDialog dialog = new InputDialog(this.getShell(), "Edit Environment Variable", "Environment Variable", input, null);
        int returnCode = dialog.open();
        if (returnCode != 0) {
            return;
        }
        input = dialog.getValue();
        if (input != null) {
            this.list.setItem(index, input);
            this.selectionChanged();
            this.firePropertyChange();
            this.listHasChanged();
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.list.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private void createButtons(Composite buttonBox) {
        this.addButton = this.createPushButton(buttonBox, "ListEditor.add");
        this.removeButton = this.createPushButton(buttonBox, "ListEditor.remove");
        this.editButton = this.createPushButton(buttonBox, "Edit");
        this.upButton = this.createPushButton(buttonBox, "ListEditor.up");
        this.downButton = this.createPushButton(buttonBox, "ListEditor.down");
    }

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        data.heightHint = this.convertVerticalDLUsToPixels((Control)button, 14);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == ListEditor.this.addButton) {
                    ListEditor.this.addPressed();
                } else if (widget == ListEditor.this.removeButton) {
                    ListEditor.this.removePressed();
                } else if (widget == ListEditor.this.upButton) {
                    ListEditor.this.upPressed();
                } else if (widget == ListEditor.this.downButton) {
                    ListEditor.this.downPressed();
                } else if (widget == ListEditor.this.editButton) {
                    ListEditor.this.editPressed();
                } else if (widget == ListEditor.this.list) {
                    ListEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.list = this.getListControl(parent);
        gd = new GridData(768);
        gd.heightHint = 100;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.list.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    public void initilizeFrom(ILaunchConfiguration fLaunch) {
        if (this.list != null) {
            this.list.removeAll();
            ArrayList envs = null;
            try {
                envs = (ArrayList)fLaunch.getAttribute("ATTR_CGI_ENV", null);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            if (envs != null) {
                int x = 0;
                while (x < envs.size()) {
                    this.list.add((String)envs.get(x));
                    ++x;
                }
            }
        }
    }

    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
        }
    }

    public void doApply(ILaunchConfigurationWorkingCopy fLaunch) {
        if (this.list != null) {
            String[] vars = this.list.getItems();
            ArrayList<String> al = new ArrayList<String>();
            int i = 0;
            while (i < vars.length) {
                al.add(vars[i]);
                ++i;
            }
            fLaunch.setAttribute("ATTR_CGI_ENV", al);
        }
    }

    private void downPressed() {
        this.swap(false);
        this.listHasChanged();
        this.firePropertyChange();
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ListEditor.this.addButton = null;
                    ListEditor.this.removeButton = null;
                    ListEditor.this.upButton = null;
                    ListEditor.this.downButton = null;
                    ListEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public List getListControl(Composite parent) {
        if (this.list == null) {
            this.list = new List(parent, 2820);
            this.list.setFont(parent.getFont());
            this.list.addSelectionListener(this.getSelectionListener());
            this.list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    ListEditor.this.list = null;
                }
            });
        } else {
            this.checkParent((Control)this.list, parent);
        }
        return this.list;
    }

    public String[] getItems() {
        return this.list.getItems();
    }

    String getNewInputObject() {
        InputDialog dialog = new InputDialog(this.getShell(), "Add Environment Variable", "Environment Variable", null, null);
        int returnCode = dialog.open();
        if (returnCode == 0) {
            return dialog.getValue();
        }
        return null;
    }

    void firePropertyChange() {
        this.mTab.propertyChange(new PropertyChangeEvent((Object)this, " ", (Object)" ", (Object)" "));
    }

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    String[] parseString(String stringList) {
        return null;
    }

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        if (index >= 0) {
            this.list.remove(index);
            int max_index = this.list.getItems().length - 1;
            if (max_index >= 0) {
                if (index > max_index) {
                    index = max_index;
                }
                this.list.setSelection(index);
            }
            this.selectionChanged();
            this.firePropertyChange();
        }
    }

    private void selectionChanged() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        this.removeButton.setEnabled(index >= 0);
        this.editButton.setEnabled(index >= 0);
        this.upButton.setEnabled(size > 1 && index > 0);
        this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
    }

    public void setFocus() {
        if (this.list != null) {
            this.list.setFocus();
        }
    }

    private void swap(boolean up) {
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0) {
            String[] selection = this.list.getSelection();
            Assert.isTrue((selection.length == 1 ? 1 : 0) != 0);
            this.list.remove(index);
            this.list.add(selection[0], target);
            this.list.setSelection(target);
        }
        this.selectionChanged();
    }

    private void upPressed() {
        this.swap(true);
        this.firePropertyChange();
        this.listHasChanged();
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getListControl(parent).setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
    }

    protected void doLoad() {
    }

    protected void doStore() {
    }

    void listHasChanged() {
    }
}

