/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.epic.debug.AnnotationType;
import org.epic.debug.PerlDebugPlugin;

public class PerlMarkerAnnotation
extends MarkerAnnotation {
    private static final int NO_IMAGE = 0;
    private static final int BREAKPOINT_IMAGE = 6;
    private IDebugModelPresentation fPresentation;
    private AnnotationType fType;
    private int fImageType;

    public PerlMarkerAnnotation(IMarker marker) {
        super(marker);
    }

    protected void initialize() {
        this.fImageType = 0;
        IMarker marker = this.getMarker();
        if (MarkerUtilities.isMarkerType((IMarker)marker, (String)IBreakpoint.BREAKPOINT_MARKER)) {
            if (this.fPresentation == null) {
                this.fPresentation = DebugUITools.newDebugModelPresentation();
            }
            this.setImage(null);
            this.setLayer(4);
            this.fImageType = 6;
            this.fType = AnnotationType.UNKNOWN;
        } else {
            this.fType = AnnotationType.UNKNOWN;
            if (marker.exists()) {
                try {
                    if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                        int severity = marker.getAttribute("severity", -1);
                        switch (severity) {
                            case 2: {
                                this.fType = AnnotationType.ERROR;
                                break;
                            }
                            case 1: {
                                this.fType = AnnotationType.WARNING;
                            }
                        }
                    } else if (marker.isSubtypeOf("org.eclipse.core.resources.taskmarker")) {
                        this.fType = AnnotationType.TASK;
                    } else if (marker.isSubtypeOf("org.eclipse.core.resources.bookmark")) {
                        this.fType = AnnotationType.BOOKMARK;
                    }
                }
                catch (CoreException e) {
                    PerlDebugPlugin.log(e);
                }
            }
            super.initialize();
        }
    }

    public String getMessage() {
        IMarker marker = this.getMarker();
        if (marker == null || !marker.exists()) {
            return "";
        }
        return marker.getAttribute("message", "");
    }

    public boolean isTemporary() {
        return false;
    }

    public Image getImage(Display display) {
        if (this.fImageType == 6) {
            IMarker marker;
            Image result = super.getImage(display);
            if (result == null && (marker = this.getMarker()) != null && marker.exists()) {
                result = this.fPresentation.getImage((Object)this.getMarker());
                this.setImage(result);
            }
            return result;
        }
        return super.getImage(display);
    }

    public AnnotationType getAnnotationType() {
        return this.fType;
    }
}

