/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.epic.core.util.ScriptExecutor;
import org.epic.perleditor.PerlEditorPlugin;

public class SourceFormatter
extends ScriptExecutor {
    protected SourceFormatter(ILog log) {
        super(log);
    }

    public static String format(String toFormat, ILog log) {
        return SourceFormatter.format(toFormat, Collections.EMPTY_LIST, log);
    }

    public static String format(String toFormat, List additionalArgs, ILog log) {
        try {
            return new SourceFormatter((ILog)log).run((String)toFormat, (List)additionalArgs).stdout;
        }
        catch (CoreException e) {
            log.log(e.getStatus());
            return toFormat;
        }
    }

    protected List getCommandLineOpts(List additionalOptions) {
        IPreferenceStore store = PerlEditorPlugin.getDefault().getPreferenceStore();
        int numSpaces = store.getInt("insertTabOnIndent");
        boolean useSpaces = store.getBoolean("spacesInsteadOfTabs");
        int tabWidth = useSpaces ? numSpaces : store.getInt("editorTabWidth");
        int pageSize = store.getInt("printMarginColumn");
        boolean cuddleElse = store.getBoolean("Formatter.cuddledElse");
        boolean bracesLeft = store.getBoolean("Formatter.bracesLeft");
        boolean lineUpParentheses = store.getBoolean("Formatter.lineUpWithParenttheses");
        boolean swallowOptionalBlankLines = store.getBoolean("Formatter.swallowOptionalBlankLines");
        ArrayList<String> args = new ArrayList<String>();
        args.add("-q");
        args.add("--indent-columns=" + tabWidth);
        args.add("--maximum-line-length=" + pageSize);
        if (!useSpaces) {
            args.add("--entab-leading-whitespace=" + tabWidth);
        }
        if (cuddleElse) {
            args.add("--cuddled-else");
        }
        if (bracesLeft) {
            args.add("--opening-brace-on-new-line");
        }
        if (lineUpParentheses) {
            args.add("--line-up-parentheses");
        }
        if (swallowOptionalBlankLines) {
            args.add("--swallow-optional-blank-lines");
        }
        StringTokenizer st = new StringTokenizer(store.getString("Formatter.perltidyOptions"));
        while (st.hasMoreTokens()) {
            args.add(st.nextToken());
        }
        if (additionalOptions != null) {
            args.addAll(additionalOptions);
        }
        return args;
    }

    protected String getExecutable() {
        return "perltidy";
    }

    protected String getScriptDir() {
        return "perlutils/perltidy";
    }
}

