/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class Dom4jAccessor
implements PropertyAccessor {
    private String nodeName;
    private Type propertyType;
    private final SessionFactoryImplementor factory;
    static /* synthetic */ Class class$java$lang$Object;

    public Dom4jAccessor(String nodeName, Type propertyType, SessionFactoryImplementor factory) {
        this.factory = factory;
        this.nodeName = nodeName;
        this.propertyType = propertyType;
    }

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        if (this.nodeName == null) {
            throw new MappingException("no node name for property: " + propertyName);
        }
        if (".".equals(this.nodeName)) {
            return new TextGetter(this.propertyType, this.factory);
        }
        if (this.nodeName.indexOf(47) > -1) {
            return new ElementAttributeGetter(this.nodeName, this.propertyType, this.factory);
        }
        if (this.nodeName.indexOf(64) > -1) {
            return new AttributeGetter(this.nodeName, this.propertyType, this.factory);
        }
        return new ElementGetter(this.nodeName, this.propertyType, this.factory);
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        if (this.nodeName == null) {
            throw new MappingException("no node name for property: " + propertyName);
        }
        if (".".equals(this.nodeName)) {
            return new TextSetter(this.propertyType);
        }
        if (this.nodeName.indexOf(47) > -1) {
            return new ElementAttributeSetter(this.nodeName, this.propertyType);
        }
        if (this.nodeName.indexOf(64) > -1) {
            return new AttributeSetter(this.nodeName, this.propertyType);
        }
        return new ElementSetter(this.nodeName, this.propertyType);
    }

    public static class ElementAttributeSetter
    extends Dom4jSetter {
        private final String elementName;
        private final String attributeName;

        ElementAttributeSetter(String name, Type propertyType) {
            super(propertyType);
            this.elementName = name.substring(0, name.indexOf(47));
            this.attributeName = name.substring(name.indexOf(47) + 2);
        }

        public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
            Element owner = (Element)target;
            Element element = owner.element(this.elementName);
            if (value == null) {
                if (element != null) {
                    element.detach();
                }
            } else {
                Attribute attribute;
                if (element == null) {
                    element = owner.addElement(this.elementName);
                    attribute = null;
                } else {
                    attribute = element.attribute(this.attributeName);
                }
                if (attribute == null) {
                    element.addAttribute(this.attributeName, "null");
                    attribute = element.attribute(this.attributeName);
                }
                this.propertyType.setToXMLNode((Node)attribute, value, factory);
            }
        }
    }

    public static class ElementSetter
    extends Dom4jSetter {
        private final String elementName;

        ElementSetter(String name, Type propertyType) {
            super(propertyType);
            this.elementName = name;
        }

        public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
            if (value != CollectionType.UNFETCHED_COLLECTION) {
                Element owner = (Element)target;
                Element existing = owner.element(this.elementName);
                if (existing != null) {
                    existing.detach();
                }
                if (value != null) {
                    Element element = owner.addElement(this.elementName);
                    this.propertyType.setToXMLNode((Node)element, value, factory);
                }
            }
        }
    }

    public static class AttributeSetter
    extends Dom4jSetter {
        private final String attributeName;

        AttributeSetter(String name, Type propertyType) {
            super(propertyType);
            this.attributeName = name.substring(1);
        }

        public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
            Element owner = (Element)target;
            Attribute attribute = owner.attribute(this.attributeName);
            if (value == null) {
                if (attribute != null) {
                    attribute.detach();
                }
            } else {
                if (attribute == null) {
                    owner.addAttribute(this.attributeName, "null");
                    attribute = owner.attribute(this.attributeName);
                }
                this.propertyType.setToXMLNode((Node)attribute, value, factory);
            }
        }
    }

    public static class TextSetter
    extends Dom4jSetter {
        TextSetter(Type propertyType) {
            super(propertyType);
        }

        public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
            Element owner = (Element)target;
            if (!this.propertyType.isXMLElement()) {
                if (value == null) {
                    owner.setText(null);
                } else {
                    this.propertyType.setToXMLNode((Node)owner, value, factory);
                }
            }
        }
    }

    public static class ElementAttributeGetter
    extends Dom4jGetter {
        private final String elementName;
        private final String attributeName;

        ElementAttributeGetter(String name, Type propertyType, SessionFactoryImplementor factory) {
            super(propertyType, factory);
            this.elementName = name.substring(0, name.indexOf(47));
            this.attributeName = name.substring(name.indexOf(47) + 2);
        }

        public Object get(Object owner) throws HibernateException {
            Element ownerElement = (Element)owner;
            Element element = ownerElement.element(this.elementName);
            if (element == null) {
                return null;
            }
            Attribute attribute = element.attribute(this.attributeName);
            if (attribute == null) {
                return null;
            }
            return this.propertyType.fromXMLNode((Node)attribute, this.factory);
        }
    }

    public static class ElementGetter
    extends Dom4jGetter {
        private final String elementName;

        ElementGetter(String name, Type propertyType, SessionFactoryImplementor factory) {
            super(propertyType, factory);
            this.elementName = name;
        }

        public Object get(Object owner) throws HibernateException {
            Element ownerElement = (Element)owner;
            Element element = ownerElement.element(this.elementName);
            return element == null ? null : this.propertyType.fromXMLNode((Node)element, this.factory);
        }
    }

    public static class AttributeGetter
    extends Dom4jGetter {
        private final String attributeName;

        AttributeGetter(String name, Type propertyType, SessionFactoryImplementor factory) {
            super(propertyType, factory);
            this.attributeName = name.substring(1);
        }

        public Object get(Object owner) throws HibernateException {
            Element ownerElement = (Element)owner;
            Attribute attribute = ownerElement.attribute(this.attributeName);
            return attribute == null ? null : this.propertyType.fromXMLNode((Node)attribute, this.factory);
        }
    }

    public static class TextGetter
    extends Dom4jGetter {
        TextGetter(Type propertyType, SessionFactoryImplementor factory) {
            super(propertyType, factory);
        }

        public Object get(Object owner) throws HibernateException {
            Element ownerElement = (Element)owner;
            return this.propertyType.fromXMLNode((Node)ownerElement, this.factory);
        }
    }

    public static abstract class Dom4jSetter
    implements Setter {
        protected final Type propertyType;

        Dom4jSetter(Type propertyType) {
            this.propertyType = propertyType;
        }

        public String getMethodName() {
            return null;
        }

        public Method getMethod() {
            return null;
        }
    }

    public static abstract class Dom4jGetter
    implements Getter {
        protected final Type propertyType;
        protected final SessionFactoryImplementor factory;

        Dom4jGetter(Type propertyType, SessionFactoryImplementor factory) {
            this.propertyType = propertyType;
            this.factory = factory;
        }

        public Object getForInsert(Object owner, Map mergeMap, SessionImplementor session) throws HibernateException {
            return this.get(owner);
        }

        public Class getReturnType() {
            return class$java$lang$Object == null ? (class$java$lang$Object = Dom4jAccessor.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public Member getMember() {
            return null;
        }

        public String getMethodName() {
            return null;
        }

        public Method getMethod() {
            return null;
        }
    }
}

