/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.utils;

import net.sourceforge.jffmpeg.codecs.utils.FFMpegException;
import net.sourceforge.jffmpeg.codecs.utils.VLCTable;

public class BitStream {
    public static final int KEEP_HISTORIC_BITS = 4096;
    private byte[] data = new byte[2048];
    private int bitIndex;
    private int sizeInBits;

    public final void setData(byte[] byArray, int n) {
        this.data = byArray;
        this.bitIndex = 0;
        this.sizeInBits = n * 8;
    }

    public void addData(byte[] byArray, int n, int n2) {
        if (this.getPos() > 4096) {
            this.binData((this.getPos() - 4096) / 8);
        }
        if (this.data.length - this.sizeInBits / 8 < n2 + 8) {
            byte[] byArray2 = new byte[(this.data.length + n2) * 2];
            System.arraycopy(this.data, 0, byArray2, 0, this.sizeInBits / 8);
            System.arraycopy(byArray, n, byArray2, this.sizeInBits / 8, n2);
            this.data = byArray2;
        } else {
            System.arraycopy(byArray, n, this.data, this.sizeInBits / 8, n2);
        }
        this.sizeInBits += n2 * 8;
    }

    public final byte[] getDataArray() {
        return this.data;
    }

    public final void binData(int n) {
        System.arraycopy(this.data, n, this.data, 0, this.data.length - n);
        this.sizeInBits -= n * 8;
        this.bitIndex -= n * 8;
    }

    public void seek(int n) {
        this.bitIndex = n;
    }

    public final int availableBits() {
        return this.sizeInBits - this.bitIndex;
    }

    public final int getPos() {
        return this.bitIndex;
    }

    public final boolean getTrueFalse() {
        return (this.data[this.bitIndex >> 3] << (this.bitIndex++ & 7) & 0x80) != 0;
    }

    public final int getBits(int n) {
        int n2 = n;
        int n3 = this.bitIndex >> 3;
        int n4 = this.data[n3++];
        n2 -= 8 - (this.bitIndex & 7);
        while (n2 > 0) {
            n4 = n4 << 8 | this.data[n3++] & 0xFF;
            n2 -= 8;
        }
        n4 = n4 >> -n2 & (1 << n) - 1;
        this.bitIndex += n;
        if (this.availableBits() < 0) {
            throw new Error("Buffer underflow");
        }
        return n4;
    }

    public final int showBits(int n) {
        int n2 = n;
        int n3 = this.bitIndex >> 3;
        int n4 = this.data[n3++];
        n2 -= 8 - (this.bitIndex & 7);
        while (n2 > 0) {
            n4 = n4 << 8 | this.data[n3++] & 0xFF;
            n2 -= 8;
        }
        n4 = n4 >> -n2 & (1 << n) - 1;
        return n4;
    }

    public final int show12Bits() {
        if (this.availableBits() < 12) {
            if (this.availableBits() < 0) {
                throw new Error("Buffer underflow");
            }
            return this.showBits(this.availableBits()) << 12 - this.availableBits();
        }
        int n = this.bitIndex >> 3;
        int n2 = this.bitIndex & 7;
        int n3 = this.data[n++] << 16 | (this.data[n++] & 0xFF) << 8 | this.data[n++] & 0xFF;
        return n3 >> 12 - n2 & 0xFFF;
    }

    public final int decode012() {
        return this.getTrueFalse() ? (this.getTrueFalse() ? 2 : 1) : 0;
    }

    public final int getVLC(VLCTable vLCTable) throws FFMpegException {
        int n = this.show12Bits();
        int n2 = vLCTable.getCodeLength(n);
        if (n2 > 0) {
            this.bitIndex += n2;
            if (this.availableBits() < 0) {
                throw new FFMpegException("Buffer underflow");
            }
            return vLCTable.getCodeValue(n);
        }
        if (n2 < 0) {
            this.bitIndex += 12;
            return this.getVLC(vLCTable.getNextLevel(n));
        }
        if (this.availableBits() < 12) {
            throw new FFMpegException("Buffer underflow");
        }
        throw new FFMpegException("Illegal VLC code " + vLCTable);
    }
}

