/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.util.FastVector;
import oracle.xml.util.QxName;

public class XMLSchema
extends XSDNode {
    private Hashtable schemaNodeTable;
    private Hashtable schemas;
    private Hashtable notationTable;
    private String schemaNS;
    private boolean isPathTableBuilt;
    String schemaTargetNS;
    XSDBuilder builder;

    public XMLSchema() throws XSDException {
        this.init(100);
    }

    XMLSchema(int n) throws XSDException {
        this.init(n);
    }

    public String[] getXMLSchemaURLS() {
        String[] stringArray = new String[this.schemas.size()];
        int n = 0;
        String[] stringArray2 = this.schemas.keys();
        while (stringArray2.hasMoreElements()) {
            String string = (String)stringArray2.nextElement();
            if (string.indexOf(" ") >= 0) continue;
            stringArray[n++] = string;
        }
        if (n < stringArray.length) {
            stringArray2 = stringArray;
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
        }
        return stringArray;
    }

    public Hashtable getXMLSchemaNodeTable() {
        return this.schemaNodeTable;
    }

    String getSchemaNS() {
        return this.schemaNS;
    }

    boolean isNewSchemaNS(String string, String string2) {
        String string3;
        if (string2 == null) {
            string2 = "";
        }
        if ((string3 = (String)this.schemas.get(string)) != null) {
            if (string3.equals(string2)) {
                return false;
            }
            String string4 = string + " " + string2;
            if (this.schemas.get(string4) != null) {
                return false;
            }
            this.schemas.put(string4, string2);
            return true;
        }
        this.schemas.put(string, string2);
        return true;
    }

    public XMLSchemaNode getSchemaByTargetNS(String string) {
        if (string == null) {
            string = "";
        }
        return (XMLSchemaNode)this.schemaNodeTable.get(string);
    }

    boolean setXMLSchemaNode(String string, XMLSchemaNode xMLSchemaNode) {
        xMLSchemaNode.setTargetNS(string);
        xMLSchemaNode.parent = this;
        return this.schemaNodeTable.put(string, xMLSchemaNode) != null;
    }

    void setSchemaNS(String string) {
        this.schemaNS = string;
    }

    XSDNode getComponent(String string, String string2, int n) {
        XMLSchemaNode xMLSchemaNode = this.getSchemaByTargetNS(string);
        if (xMLSchemaNode == null) {
            return null;
        }
        return xMLSchemaNode.getComponent(string2, n);
    }

    public XSDNode getType(String string, String string2, int n) {
        XMLSchemaNode xMLSchemaNode;
        if (string.equals(this.schemaNS)) {
            if (string2.intern() == "anyType") {
                return XSDComplexType.urType;
            }
            if (string2.intern() == "anySimpleType") {
                return XSDSimpleType.urType;
            }
        } else if (string.equals("http://www.w3.org/2005/04/xpath-datatypes") && n == 2) {
            if (string2.equals("yearMonthDuration")) {
                return XSDSimpleType.getBuiltInType(20);
            }
            if (string2.equals("dayTimeDuration")) {
                return XSDSimpleType.getBuiltInType(21);
            }
        }
        if ((xMLSchemaNode = this.getSchemaByTargetNS(string)) == null) {
            return null;
        }
        return xMLSchemaNode.getType(string2, n);
    }

    public XSDNode getType(String string, String string2) {
        XMLSchemaNode xMLSchemaNode;
        if (string.intern() == this.schemaNS) {
            if (string2.intern() == "anyType") {
                return XSDComplexType.urType;
            }
            if (string2.intern() == "anySimpleType") {
                return XSDSimpleType.urType;
            }
        }
        if ((xMLSchemaNode = this.getSchemaByTargetNS(string)) == null) {
            return null;
        }
        return xMLSchemaNode.getType(string2);
    }

    public XSDElement getElement(String string, String string2) {
        XMLSchemaNode xMLSchemaNode = this.getSchemaByTargetNS(string);
        if (xMLSchemaNode == null) {
            return null;
        }
        return xMLSchemaNode.getElement(string2);
    }

    XSDAttribute getAttribute(String string, String string2) {
        XMLSchemaNode xMLSchemaNode = this.getSchemaByTargetNS(string);
        if (xMLSchemaNode == null) {
            return null;
        }
        return xMLSchemaNode.getAttribute(string2);
    }

    void mergeXMLSchema(XMLSchema xMLSchema) {
        Enumeration enumeration = xMLSchema.getXMLSchemaNodeTable().elements();
        while (enumeration.hasMoreElements()) {
            XMLSchemaNode xMLSchemaNode = (XMLSchemaNode)enumeration.nextElement();
            this.setXMLSchemaNode(xMLSchemaNode.getTargetNS(), xMLSchemaNode);
        }
    }

    public void printSchema() {
        Enumeration enumeration = this.schemaNodeTable.elements();
        while (enumeration.hasMoreElements()) {
            XMLSchemaNode xMLSchemaNode = (XMLSchemaNode)enumeration.nextElement();
            if (xMLSchemaNode.getTargetNS() == "http://www.w3.org/2001/XMLSchema") continue;
            xMLSchemaNode.print();
        }
    }

    public void printSchema(boolean bl) {
        if (bl) {
            Enumeration enumeration = this.schemaNodeTable.elements();
            while (enumeration.hasMoreElements()) {
                XMLSchemaNode xMLSchemaNode = (XMLSchemaNode)enumeration.nextElement();
                xMLSchemaNode.print();
            }
        } else {
            this.printSchema();
        }
    }

    public String[] getAllTargetNS() {
        int n = 0;
        String[] stringArray = new String[this.schemaNodeTable.size()];
        Enumeration enumeration = this.schemaNodeTable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String getSchemaTargetNS() {
        return this.schemaTargetNS;
    }

    void postProcessSchema() throws Exception {
        FastVector fastVector = new FastVector();
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.schemaNodeTable.elements();
        while (enumeration.hasMoreElements()) {
            ((XMLSchemaNode)enumeration.nextElement()).postProcessSchema(fastVector, hashtable);
        }
        this.isPathTableBuilt = false;
    }

    public synchronized void buildSchemaPathTable() throws Exception {
        if (this.isPathTableBuilt) {
            return;
        }
        Enumeration enumeration = this.schemaNodeTable.elements();
        while (enumeration.hasMoreElements()) {
            XMLSchemaNode xMLSchemaNode = (XMLSchemaNode)enumeration.nextElement();
            xMLSchemaNode.buildSchemaPathTable();
        }
        this.isPathTableBuilt = true;
    }

    boolean isPathTableBuilt() {
        return this.isPathTableBuilt;
    }

    void setBuilder(XSDBuilder xSDBuilder) {
        this.builder = xSDBuilder;
    }

    XSDBuilder getBuilder() {
        return this.builder;
    }

    void addNotationValue(QxName qxName) {
        if (this.notationTable == null) {
            this.notationTable = new Hashtable(20);
        }
        this.notationTable.put(qxName, qxName);
    }

    QxName checkNotation() {
        if (this.notationTable == null) {
            return null;
        }
        Enumeration enumeration = this.notationTable.keys();
        while (enumeration.hasMoreElements()) {
            XMLSchemaNode xMLSchemaNode;
            QxName qxName = (QxName)enumeration.nextElement();
            String string = qxName.getNamespaceURI();
            if (string == null) {
                string = "";
            }
            if ((xMLSchemaNode = (XMLSchemaNode)this.schemaNodeTable.get(string)) != null && xMLSchemaNode.getComponent(qxName.getLocalPart(), 25) != null) continue;
            return qxName;
        }
        return null;
    }

    private void init(int n) throws XSDException {
        this.schemaNodeTable = new Hashtable(n);
        this.schemas = new Hashtable(n);
        Hashtable hashtable = XSDSimpleType.getBuiltInDatatypes();
        XMLSchemaNode xMLSchemaNode = new XMLSchemaNode(50);
        this.setXMLSchemaNode("http://www.w3.org/2001/XMLSchema", xMLSchemaNode);
        xMLSchemaNode.getTypeDefinitionTable().putAll(hashtable);
        XSDComplexType.init();
    }
}

