/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;

public class TestRights
extends TestBase {
    Statement stat;

    public void test() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("rights");
        Connection conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.testTableType(conn, "MEMORY");
        this.testTableType(conn, "CACHED");
        this.executeSuccess("CREATE USER PASSREADER PASSWORD 'abc'");
        this.executeSuccess("CREATE TABLE PASS(ID INT PRIMARY KEY, NAME VARCHAR, PASSWORD VARCHAR)");
        this.executeSuccess("CREATE VIEW PASS_NAME AS SELECT ID, NAME FROM PASS");
        this.executeSuccess("GRANT SELECT ON PASS_NAME TO PASSREADER");
        conn.close();
        conn = this.getConnection("rights", "PASSREADER", "abc");
        this.stat = conn.createStatement();
        this.executeSuccess("SELECT * FROM PASS_NAME");
        this.executeError("SELECT * FROM PASS");
        conn.close();
        conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.executeSuccess("CREATE USER TEST PASSWORD 'abc'");
        this.executeSuccess("ALTER USER TEST ADMIN TRUE");
        this.executeSuccess("CREATE TABLE TEST(ID INT)");
        this.executeSuccess("CREATE SCHEMA SCHEMA_A AUTHORIZATION SA");
        this.executeSuccess("CREATE TABLE SCHEMA_A.TABLE_B(ID INT)");
        this.executeSuccess("GRANT ALL ON SCHEMA_A.TABLE_B TO TEST");
        this.executeSuccess("CREATE TABLE HIDDEN(ID INT)");
        this.executeSuccess("CREATE TABLE PUBTABLE(ID INT)");
        this.executeSuccess("CREATE TABLE ROLETABLE(ID INT)");
        this.executeSuccess("CREATE ROLE TESTROLE");
        this.executeSuccess("GRANT SELECT ON ROLETABLE TO TESTROLE");
        this.executeSuccess("GRANT UPDATE ON ROLETABLE TO TESTROLE");
        this.executeSuccess("REVOKE UPDATE ON ROLETABLE FROM TESTROLE");
        this.executeError("REVOKE SELECT, SUB1 ON ROLETABLE FROM TESTROLE");
        this.executeSuccess("GRANT TESTROLE TO TEST");
        this.executeSuccess("GRANT SELECT ON PUBTABLE TO PUBLIC");
        this.executeSuccess("GRANT SELECT ON TEST TO TEST");
        this.executeSuccess("CREATE ROLE SUB1");
        this.executeSuccess("CREATE ROLE SUB2");
        this.executeSuccess("CREATE TABLE SUBTABLE(ID INT)");
        this.executeSuccess("GRANT ALL ON SUBTABLE TO SUB2");
        this.executeSuccess("REVOKE UPDATE, DELETE ON SUBTABLE FROM SUB2");
        this.executeSuccess("GRANT SUB2 TO SUB1");
        this.executeSuccess("GRANT SUB1 TO TEST");
        this.executeSuccess("ALTER USER TEST SET PASSWORD 'def'");
        this.executeSuccess("CREATE USER TEST2 PASSWORD 'def' ADMIN");
        this.executeSuccess("ALTER USER TEST ADMIN FALSE");
        this.executeSuccess("SCRIPT TO '" + BASE_DIR + "/rights.sql' CIPHER XTEA PASSWORD 'test'");
        conn.close();
        try {
            conn = this.getConnection("rights", "Test", "abc");
            this.error("unexpected success (mixed case user name)");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        try {
            conn = this.getConnection("rights", "TEST", "abc");
            this.error("unexpected success (wrong password)");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        try {
            conn = this.getConnection("rights", "TEST", null);
            this.error("unexpected success (wrong password)");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        conn = this.getConnection("rights", "TEST", "def");
        this.stat = conn.createStatement();
        this.executeError("SET DEFAULT_TABLE_TYPE MEMORY");
        this.executeSuccess("SELECT * FROM TEST");
        this.executeSuccess("SELECT * FROM SYSTEM_RANGE(1,2)");
        this.executeSuccess("SELECT * FROM SCHEMA_A.TABLE_B");
        this.executeSuccess("SELECT * FROM PUBTABLE");
        this.executeSuccess("SELECT * FROM ROLETABLE");
        this.executeError("UPDATE ROLETABLE SET ID=0");
        this.executeError("DELETE FROM ROLETABLE");
        this.executeError("SELECT * FROM HIDDEN");
        this.executeError("UPDATE TEST SET ID=0");
        this.executeSuccess("SELECT * FROM SUBTABLE");
        this.executeSuccess("INSERT INTO SUBTABLE VALUES(1)");
        this.executeError("DELETE FROM SUBTABLE");
        this.executeError("UPDATE FROM SUBTABLE");
        this.executeError("CREATE USER TEST3 PASSWORD 'def'");
        this.executeError("ALTER USER TEST2 ADMIN FALSE");
        this.executeError("ALTER USER TEST2 SET PASSWORD 'ghi'");
        this.executeError("ALTER USER TEST2 RENAME TO TEST_X");
        this.executeError("ALTER USER TEST RENAME TO TEST_X");
        this.executeSuccess("ALTER USER TEST SET PASSWORD 'ghi'");
        this.executeError("DROP USER TEST2");
        conn.close();
        conn = this.getConnection("rights");
        this.stat = conn.createStatement();
        this.executeSuccess("DROP ROLE SUB1");
        this.executeSuccess("DROP TABLE ROLETABLE");
        this.executeSuccess("DROP USER TEST");
        conn.close();
    }

    private void testTableType(Connection conn, String type) throws Exception {
        this.executeSuccess("SET DEFAULT_TABLE_TYPE " + type);
        this.executeSuccess("CREATE TABLE TEST(ID INT)");
        ResultSet rs = conn.createStatement().executeQuery("SELECT STORAGE_TYPE FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='TEST'");
        rs.next();
        this.check(rs.getString(1), type);
        this.executeSuccess("DROP TABLE TEST");
    }

    public void executeError(String sql) throws Exception {
        try {
            this.stat.execute(sql);
            this.error("unexpected success (not admin)");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
    }

    public void executeSuccess(String sql) throws Exception {
        if (this.stat.execute(sql)) {
            int i;
            ResultSet rs = this.stat.getResultSet();
            rs.getConcurrency();
            ResultSetMetaData meta = rs.getMetaData();
            int columnCount = meta.getColumnCount();
            for (i = 0; i < columnCount; ++i) {
                meta.getCatalogName(i + 1);
                meta.getColumnClassName(i + 1);
                meta.getColumnDisplaySize(i + 1);
                meta.getColumnLabel(i + 1);
                meta.getColumnName(i + 1);
                meta.getColumnType(i + 1);
                meta.getColumnTypeName(i + 1);
                meta.getPrecision(i + 1);
                meta.getScale(i + 1);
                meta.getSchemaName(i + 1);
                meta.getTableName(i + 1);
            }
            while (rs.next()) {
                for (i = 0; i < columnCount; ++i) {
                    rs.getObject(i + 1);
                }
            }
        }
    }
}

