/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.server.TcpServerThread;
import org.h2.util.NetUtils;

public class TcpServer
implements Service {
    private String driver = "org.h2.Driver";
    public static final int DEFAULT_PORT = 9092;
    public static final int SHUTDOWN_NORMAL = 0;
    public static final int SHUTDOWN_FORCE = 1;
    public static boolean LOG_INTERNAL_ERRORS = false;
    private int port;
    private boolean log = false;
    private boolean ssl = false;
    private boolean stop;
    private ServerSocket serverSocket;
    private HashSet running = new HashSet();
    private String baseDir;
    private String url;
    private boolean allowOthers;
    private boolean ifExists;
    private Connection managementDb;
    private String managementPassword = "";
    private static HashMap servers = new HashMap();
    static /* synthetic */ Class class$org$h2$server$TcpServer;

    public static String getManagementDbName(int port) {
        return "mem:management_db_" + port;
    }

    private void initManagementDb() throws SQLException {
        Connection conn;
        this.managementDb = conn = DriverManager.getConnection("jdbc:h2:" + TcpServer.getManagementDbName(this.port), "sa", this.managementPassword);
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS STOP_SERVER FOR \"" + (class$org$h2$server$TcpServer == null ? (class$org$h2$server$TcpServer = TcpServer.class$("org.h2.server.TcpServer")) : class$org$h2$server$TcpServer).getName() + ".stopServer\"");
        servers.put("" + this.port, this);
    }

    private void stopManagementDb() {
        if (this.managementDb != null) {
            try {
                this.managementDb.close();
            }
            catch (SQLException e) {
                TraceSystem.traceThrowable(e);
            }
            this.managementDb = null;
        }
    }

    public static void stopServer(int port, String password, int shutdownMode) {
        TcpServer server = (TcpServer)servers.get("" + port);
        if (server == null) {
            return;
        }
        if (!server.managementPassword.equals(password)) {
            return;
        }
        if (shutdownMode == 0) {
            server.stop = true;
            try {
                Socket s = new Socket("localhost", port);
                s.close();
            }
            catch (Exception e) {}
        } else if (shutdownMode == 1) {
            server.stop();
        }
    }

    public void init(String[] args) throws Exception {
        this.port = 9092;
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a.equals("-log")) {
                this.log = Boolean.valueOf(args[++i]);
                continue;
            }
            if (a.equals("-tcpSSL")) {
                this.ssl = Boolean.valueOf(args[++i]);
                continue;
            }
            if (a.equals("-tcpPort")) {
                this.port = Integer.parseInt(args[++i]);
                continue;
            }
            if (a.equals("-tcpPassword")) {
                this.managementPassword = args[++i];
                continue;
            }
            if (a.equals("-baseDir")) {
                this.baseDir = args[++i];
                continue;
            }
            if (a.equals("-tcpAllowOthers")) {
                this.allowOthers = Boolean.valueOf(args[++i]);
                continue;
            }
            if (!a.equals("-ifExists")) continue;
            this.ifExists = Boolean.valueOf(args[++i]);
        }
        Class.forName(this.driver);
        this.url = (this.ssl ? "ssl" : "tcp") + "://localhost:" + this.port;
    }

    public String getURL() {
        return this.url;
    }

    boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        return socket.getInetAddress().isLoopbackAddress();
    }

    public void start() throws SQLException {
        this.initManagementDb();
        this.serverSocket = NetUtils.createServerSocket(this.port, this.ssl);
    }

    public void listen() {
        block4: {
            String threadName = Thread.currentThread().getName();
            try {
                while (!this.stop) {
                    Socket s = this.serverSocket.accept();
                    if (!this.allow(s)) {
                        this.log("Connection not allowed");
                        s.close();
                        continue;
                    }
                    TcpServerThread c = new TcpServerThread(s, this);
                    this.running.add(c);
                    Thread thread = new Thread(c);
                    thread.setName(threadName + " thread");
                    c.setThread(thread);
                    thread.start();
                }
            }
            catch (Exception e) {
                if (this.stop) break block4;
                TraceSystem.traceThrowable(e);
            }
        }
        this.stopManagementDb();
    }

    public boolean isRunning() {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = new Socket(this.serverSocket.getInetAddress(), this.serverSocket.getLocalPort());
            s.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized void stop() {
        if (!this.stop) {
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    TraceSystem.traceThrowable(e);
                }
                this.serverSocket = null;
            }
        }
        ArrayList list = new ArrayList(this.running);
        for (int i = 0; i < list.size(); ++i) {
            TcpServerThread c = (TcpServerThread)list.get(i);
            c.close();
            try {
                c.getThread().join(100L);
                continue;
            }
            catch (Exception e) {
                TraceSystem.traceThrowable(e);
            }
        }
        servers.remove("" + this.port);
    }

    synchronized void remove(TcpServerThread t) {
        this.running.remove(t);
    }

    boolean getLog() {
        return this.log;
    }

    String getBaseDir() {
        return this.baseDir;
    }

    void log(String s) {
        if (this.log) {
            System.out.println(s);
        }
    }

    void logError(Exception e) {
        if (this.log) {
            e.printStackTrace();
        }
    }

    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    public String getType() {
        return "TCP";
    }

    public void logInternalError(String string) {
        if (LOG_INTERNAL_ERRORS) {
            System.out.println(string);
            new Error(string).printStackTrace();
        }
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

