/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.phonegap.api.PhonegapActivity;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AccelListener
extends Plugin
implements SensorEventListener {
    public static int STOPPED = 0;
    public static int STARTING = 1;
    public static int RUNNING = 2;
    public static int ERROR_FAILED_TO_START = 3;
    public float TIMEOUT = 30000.0f;
    float x = 0.0f;
    float y = 0.0f;
    float z = 0.0f;
    long timestamp = 0L;
    int status;
    long lastAccessTime;
    private SensorManager sensorManager;
    Sensor mSensor;

    public AccelListener() {
        this.setStatus(STOPPED);
    }

    public void setContext(PhonegapActivity ctx) {
        super.setContext(ctx);
        this.sensorManager = (SensorManager)ctx.getSystemService("sensor");
    }

    public PluginResult execute(String action, JSONArray args, String callbackId) {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("getStatus")) {
                int i = this.getStatus();
                return new PluginResult(status, i);
            }
            if (action.equals("start")) {
                int i = this.start();
                return new PluginResult(status, i);
            }
            if (action.equals("stop")) {
                this.stop();
                return new PluginResult(status, 0);
            }
            if (action.equals("getAcceleration")) {
                if (this.status != RUNNING) {
                    int r = this.start();
                    if (r == ERROR_FAILED_TO_START) {
                        return new PluginResult(PluginResult.Status.IO_EXCEPTION, ERROR_FAILED_TO_START);
                    }
                    long timeout = 2000L;
                    while (this.status == STARTING && timeout > 0L) {
                        timeout -= 100L;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (timeout == 0L) {
                        return new PluginResult(PluginResult.Status.IO_EXCEPTION, ERROR_FAILED_TO_START);
                    }
                }
                this.lastAccessTime = System.currentTimeMillis();
                JSONObject r = new JSONObject();
                r.put("x", (double)this.x);
                r.put("y", (double)this.y);
                r.put("z", (double)this.z);
                r.put("timestamp", this.timestamp);
                return new PluginResult(status, r);
            }
            if (action.equals("setTimeout")) {
                try {
                    float timeout = Float.parseFloat(args.getString(0));
                    this.setTimeout(timeout);
                    return new PluginResult(status, 0);
                }
                catch (NumberFormatException e) {
                    status = PluginResult.Status.INVALID_ACTION;
                    e.printStackTrace();
                }
                catch (JSONException e) {
                    status = PluginResult.Status.JSON_EXCEPTION;
                    e.printStackTrace();
                }
            } else if (action.equals("getTimeout")) {
                float f = this.getTimeout();
                return new PluginResult(status, f);
            }
            return new PluginResult(status, result);
        }
        catch (JSONException e) {
            return new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
    }

    public boolean isSynch(String action) {
        if (action.equals("getStatus")) {
            return true;
        }
        return action.equals("getAcceleration") ? this.status == RUNNING : action.equals("getTimeout");
    }

    public void onDestroy() {
        this.stop();
    }

    public int start() {
        if (this.status == RUNNING || this.status == STARTING) {
            return this.status;
        }
        List list = this.sensorManager.getSensorList(1);
        if (list != null && list.size() > 0) {
            this.mSensor = (Sensor)list.get(0);
            this.sensorManager.registerListener((SensorEventListener)this, this.mSensor, 0);
            this.setStatus(STARTING);
            this.lastAccessTime = System.currentTimeMillis();
        } else {
            this.setStatus(ERROR_FAILED_TO_START);
        }
        return this.status;
    }

    public void stop() {
        if (this.status != STOPPED) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
        this.setStatus(STOPPED);
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() != 1) {
            return;
        }
        if (this.status == STOPPED) {
            return;
        }
        this.timestamp = System.currentTimeMillis();
        this.x = event.values[0];
        this.y = event.values[1];
        this.z = event.values[2];
        this.setStatus(RUNNING);
        if ((float)(this.timestamp - this.lastAccessTime) > this.TIMEOUT) {
            this.stop();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void setTimeout(float timeout) {
        this.TIMEOUT = timeout;
    }

    public float getTimeout() {
        return this.TIMEOUT;
    }

    private void setStatus(int status) {
        this.status = status;
    }
}

