1. TM Module

Jiri Kuthan

   FhG FOKUS

Juha Heinanen

   <jh@tutpro.com>

   Copyright  2003 FhG FOKUS

   Copyright  2008 Juha Heinanen
     __________________________________________________________________

   1.1. Overview
   1.2. Serial Forking Based on Q Value
   1.3. Known Issues
   1.4. Parameters

        1.4.1. fr_timer (integer)
        1.4.2. fr_inv_timer (integer)
        1.4.3. max_inv_lifetime (integer)
        1.4.4. max_noninv_lifetime (integer)
        1.4.5. wt_timer (integer)
        1.4.6. delete_timer (integer)
        1.4.7. retr_timer1 (integer)
        1.4.8. retr_timer2 (integer)
        1.4.9. noisy_ctimer (integer)
        1.4.10. restart_fr_on_each_reply (integer)
        1.4.11. auto_inv_100 (integer)
        1.4.12. auto_inv_100_reason (string)
        1.4.13. unix_tx_timeout (integer)
        1.4.14. aggregate_challenges (integer)
        1.4.15. reparse_invite (integer)
        1.4.16. ac_extra_hdrs (string)
        1.4.17. blst_503 (integer)
        1.4.18. blst_503_def_timeout (integer)
        1.4.19. blst_503_min_timeout (integer)
        1.4.20. blst_503_max_timeout (integer)
        1.4.21. blst_methods_add (unsigned integer)
        1.4.22. blst_methods_lookup (unsigned integer)
        1.4.23. cancel_b_method (integer)
        1.4.24. reparse_on_dns_failover (integer)
        1.4.25. on_sl_reply (string)
        1.4.26. contacts_avp (string)
        1.4.27. fr_timer_avp (string)
        1.4.28. fr_inv_timer_avp (string)
        1.4.29. unmatched_cancel (string)
        1.4.30. ruri_matching (integer)
        1.4.31. via1_matching (integer)
        1.4.32. pass_provisional_replies (integer)
        1.4.33. default_code (integer)
        1.4.34. default_reason (string)
        1.4.35. disable_6xx_block (integer)
        1.4.36. local_ack_mode (integer)
        1.4.37. failure_reply_mode (integer)
        1.4.38. faked_reply_prio (integer)
        1.4.39. local_cancel_reason (boolean)
        1.4.40. e2e_cancel_reason (boolean)

   1.5. Functions

        1.5.1. t_relay([host, port])
        1.5.2. t_relay_to_udp([ip, port])
        1.5.3. t_relay_to_tcp([ip, port])
        1.5.4. t_relay_to_tls([ip, port])
        1.5.5. t_relay_to_sctp([ip, port])
        1.5.6. t_on_failure(failure_route)
        1.5.7. t_on_reply(onreply_route)
        1.5.8. t_on_branch(branch_route)
        1.5.9. append_branch()
        1.5.10. t_newtran()
        1.5.11. t_reply(code, reason_phrase)
        1.5.12. t_lookup_request()
        1.5.13. t_retransmit_reply()
        1.5.14. t_release()
        1.5.15. t_forward_nonack([ip, port])
        1.5.16. t_forward_nonack_udp(ip, port)
        1.5.17. t_forward_nonack_tcp(ip, port)
        1.5.18. t_forward_nonack_tls(ip, port)
        1.5.19. t_forward_nonack_sctp(ip, port)
        1.5.20. t_set_fr(fr_inv_timeout [, fr_timeout])
        1.5.21. t_reset_fr()
        1.5.22. t_set_max_lifetime(inv_lifetime, noninv_lifetime)
        1.5.23. t_reset_max_lifetime()
        1.5.24. t_set_retr(retr_t1_interval, retr_t2_interval)
        1.5.25. t_reset_retr()
        1.5.26. t_set_auto_inv_100(0|1)
        1.5.27. t_branch_timeout()
        1.5.28. t_branch_replied()
        1.5.29. t_any_timeout()
        1.5.30. t_any_replied()
        1.5.31. t_grep_status("code")
        1.5.32. t_is_canceled()
        1.5.33. t_is_expired()
        1.5.34. t_relay_cancel()
        1.5.35. t_lookup_cancel([1])
        1.5.36. t_drop_replies([mode])
        1.5.37. t_save_lumps()
        1.5.38. t_load_contacts()
        1.5.39. t_next_contacts()
        1.5.40. t_check_trans()
        1.5.41. t_set_disable_6xx(0|1)
        1.5.42. t_set_disable_failover(0|1)
        1.5.43. t_replicate(params)
        1.5.44. t_relay_to(proxy, flags)
        1.5.45. t_set_no_e2e_cancel_reason(0|1)

   1.6. TM Module API

        1.6.1. Defines
        1.6.2. Functions

              1.6.2.1. register_tmcb(cb_type, cb_func)
              1.6.2.2. load_tm(*import_structure)
              1.6.2.3. int t_suspend(struct sip_msg *msg, unsigned int
                      *hash_index, unsigned int *label)

              1.6.2.4. int t_continue(unsigned int hash_index, unsigned
                      int label, struct action *route)

              1.6.2.5. int t_cancel_suspend(unsigned int hash_index,
                      unsigned int label)

1.1. Overview

   TM module enables stateful processing of SIP transactions. The main use
   of stateful logic, which is costly in terms of memory and CPU, is some
   services inherently need state. For example, transaction-based
   accounting (module acc) needs to process transaction state as opposed
   to individual messages, and any kinds of forking must be implemented
   statefully. Other use of stateful processing is it trading CPU caused
   by retransmission processing for memory. That makes however only sense
   if CPU consumption per request is huge. For example, if you want to
   avoid costly DNS resolution for every retransmission of a request to an
   unresolvable destination, use stateful mode. Then, only the initial
   message burdens server by DNS queries, subsequent retransmissions will
   be dropped and will not result in more processes blocked by DNS
   resolution. The price is more memory consumption and higher processing
   latency.

   From user's perspective, there are these major functions : t_relay,
   t_relay_to_udp and t_relay_to_tcp. All of them setup transaction state,
   absorb retransmissions from upstream, generate downstream
   retransmissions and correlate replies to requests. t_relay forwards to
   current URI (be it original request's URI or a URI changed by some of
   URI-modifying functions, such as sethost). t_relay_to_udp and
   t_relay_to_tcp forward to a specific address over UDP or TCP
   respectively.

   In general, if TM is used, it copies clones of received SIP messages in
   shared memory. That costs the memory and also CPU time (memcpys,
   lookups, shmem locks, etc.) Note that non-TM functions operate over the
   received message in private memory, that means that any core operations
   will have no effect on statefully processed messages after creating the
   transactional state. For example, calling record_route after t_relay is
   pretty useless, as the RR is added to privately held message whereas
   its TM clone is being forwarded.

   TM is quite big and uneasy to program--lot of mutexes, shared memory
   access, malloc and free, timers--you really need to be careful when you
   do anything. To simplify TM programming, there is the instrument of
   callbacks. The callback mechanisms allow programmers to register their
   functions to specific event. See t_hooks.h for a list of possible
   events.

   Other things programmers may want to know is UAC--it is a very
   simplistic code which allows you to generate your own transactions.
   Particularly useful for things like NOTIFYs or IM gateways. The UAC
   takes care of all the transaction machinery: retransmissions , FR
   timeouts, forking, etc. See t_uac prototype in uac.h for more details.
   Who wants to see the transaction result may register for a callback.

Note

   Several Kamailio (OpenSER) TM module functionalities are now
   implemented in the TMX module: "modules_k/tmx". Check it to see if what
   you are looking for is there.

1.2. Serial Forking Based on Q Value

   A single SIP INVITE request may be forked to multiple destinations. We
   call the set of all such destinations a destination set. Individual
   elements within the destination sets are called branches. The script
   writer can add URIs to the destination set from the configuration file,
   or they can be loaded from the user location database, each registered
   contact then becomes one branch in the destination set.

   The default behavior of the tm module, if it encounters a SIP message
   with multiple branches in the destination set, it to forward the SIP
   message to all the branches in parallel. That means it sends the
   message to all the branch destinations before it waits for replies from
   any of them. This is the default behavior if you call t_relay() and
   similar functions without anything else.

   Another approach of handling multiple branches in a destination set it
   serial forking. When configured to do serial forking, the server takes
   the first branch out of the destination set, forwards the message to
   its destination and waits for a reply or timeout. Only after a reply
   has been received or the timeout occurred, the server takes another
   destination from the destination set and tries again, until it receives
   a positive final reply or until all branches from the destination set
   have been tried.

   Yet another, more sophisticated, way of handling multiple branches is
   combined serial/parallel forking, where individual branches within the
   destination set are assigned priorities. The order in which individual
   branches are tried is then determined by their relative priority within
   the destination set. Branches can be tried sequentially in the
   descending priority order and all branches that have the same priority
   can be tried in parallel. Such combined serial/parallel forking can be
   achieved in the tm module with the help of functions t_load_contacts()
   and t_next_contacts().

   Every branch in the destination set is assigned a priority number, also
   known as the q value. The q value is a floating point number in a range
   0 to 1.0. The higher the q value number, the more priority is the
   particular branch in the destination set is given. Branches with q
   value 1.0 have maximum priority, such branches should be always tried
   first in serial forking. Branches with q value 0 have the lowest
   priority and they should by tried after all other branches with higher
   priority in the destination set.

   As an example, consider the following simple configuration file. When
   the server receives an INVITE, it creates four branches for it with
   usernames A through D and then forwards the request using t_relay():
route {
  seturi("sip:a@example.com");
  append_branch("sip:b@example.com");
  append_branch("sip:c@example.com");
  append_branch("sip:d@example.com");

  t_relay();
  break;
}

   With this configuratin the server forwards the request to all four
   branches at once, performing parallel forking described above. We did
   not set the q value for individual branches in this example but we can
   do that by slightly modifying the arguments given to append_branch():
route {
  seturi("sip:a@example.com");
  append_branch("sip:b@example.com", "0.5");
  append_branch("sip:c@example.com", "0.5");
  append_branch("sip:d@example.com", "1.0");

  t_relay();
  break;
}

   Here we assigned q value 0.5 to branches B and C and q value 1.0 to
   branch D. We did not specify any q value for branch A and in that case
   it is assumed that its q value is the lowest from all branches within
   the destination set. If you try to run this example again, you will
   figure out that nothing changed, t_relay() still forward the message to
   all branches in parallel.

   We now want to implement the combined serial/parallel forking. Branch D
   should be tried first, because its q value is 1.0. Branches B and C
   should be tried in parallel, but only after D finishes. Branch A should
   be tried after B and C finished, because its q value (the default) is
   the lowest of all. To do that, we need to introduce two new functions
   into our example and one tm module parameter:
modparam("tm", "contacts_avp", "tm_contacts");

route {
  seturi("sip:a@example.com");
  append_branch("sip:b@example.com", "0.5");
  append_branch("sip:c@example.com", "0.5");
  append_branch("sip:d@example.com", "1.0");

  t_load_contacts();

  t_next_contacts();
  t_relay();
  break;
}

   First of all, the tm module parameter is mandatory if the two new
   functions are used. Function t_load_contacts() takes all branches from
   the destination set, sorts them according to their q values and stores
   them in the AVP configured in the modparam. The function also clears
   the destination set, which means that it removes all branches
   configured before with seturi() and append_branch().

   Function t_next_contacts() takes the AVP created by the previous
   function and extract the branches with highest q values from it. In our
   example it is branch D. That branch is then put back into the
   destination set and when the script finally reaches t_relay(), the
   destination set only contains branch D and the request will be
   forwarded there.

   We achieved the first step of serial forking, but this is not
   sufficient. Now we also need to forward to other branches with lower
   priority values when branch D finishes. To do that, we need to extend
   the configuration file again and introduce a failure_route section:
modparam("tm", "contacts_avp", "tm_contacts");

route {
  seturi("sip:a@example.com");
  append_branch("sip:b@example.com", "0.5");
  append_branch("sip:c@example.com", "0.5");
  append_branch("sip:d@example.com", "1.0");

  t_load_contacts();

  t_next_contacts();
  t_on_failure("serial");
  t_relay();
  break;
}

failure_route["serial"]
{
  if (!t_next_contacts()) {
    exit;
  }

  t_on_failure("serial");
  t_relay();
}

   The failure_route section will be executed when branch D finishes. It
   executes t_next_contacts() again and this time the function retrieves
   branches B and C from the AVP and adds them to the destination set.
   Here we need to check the return value of the function, because a
   negative value indicates that there were no more branches, in that case
   the failure_route should just terminate and forward the response from
   branch D upstream.

   If t_next_contact() returns a positive value then we have more new
   branches to try and we need to setup the failure_route again and call
   t_relay(). In our example the request will now be forwarded to branches
   B and C in paralell, because they were both added to the destination
   set by t_next_contacts() at the same time.

   When branches B and C finish, the failure_route block is executed
   again, this time t_next_contacts() puts the final branch A into the
   destination set and t_relay() forwards the request there.

   And that's the whole example, we achieved combined serial/parallel
   forking based on the q value of individual branches. In real-world
   configuration files the script writer would need to check the return
   value of all functions and restart_fr_on_each_reply. Also the
   destination set would not be configured directly in the configuration
   file, but can be retrieved from the user location database, for
   example. In that case registered contacts will be stored in the
   destination set as branches and their q values (provided by UAs) will
   be used.

1.3. Known Issues

     * Possibly, performance could be improved by not parsing non-INVITEs,
       as they do not be replied with 100, and do not result in
       ACK/CANCELs, and other things which take parsing. However, we need
       to rethink whether we don't need parsed headers later for something
       else. Remember, when we now conserver a request in sh_mem, we can't
       apply any pkg_mem operations to it any more. (that might be
       redesigned too).
     * Another performance improvement may be achieved by not parsing CSeq
       in replies until reply branch matches branch of an INVITE/CANCEL in
       transaction table.
     * t_replicate should be done more cleanly--Vias, Routes, etc. should
       be removed from a message prior to replicating it (well, does not
       matter any longer so much as there is a new replication module).

1.4. Parameters

1.4.1. fr_timer (integer)

   Timer which hits if no final reply for a request or ACK for a negative
   INVITE reply arrives (in milliseconds).

   Default value is 30000 ms (30 seconds).

   See also: t_set_fr(), max_noninv_lifetime.

   Example 1. Set fr_timer parameter
...
modparam("tm", "fr_timer", 10000)
...

1.4.2. fr_inv_timer (integer)

   Timer which hits if no final reply for an INVITE arrives after a
   provisional message was received (in milliseconds).

   Note: this timer can be restarted when a provisional response is
   received. For more details see restart_fr_on_each_reply.

   Default value is 120000 ms (120 seconds).

   See also: t_set_fr(), max_inv_lifetime.

   Example 2. Set fr_inv_timer parameter
...
modparam("tm", "fr_inv_timer", 180000)
...

1.4.3. max_inv_lifetime (integer)

   Maximum time an INVITE transaction is allowed to be active (in
   milliseconds). After this interval has passed from the transaction
   creation, the transaction will be either moved into the wait state or
   in the final response retransmission state, irrespective of the
   transaction fr_inv_timer and fr_timer values.

   An INVITE transaction will be kept in memory for maximum:
   max_inv_lifetime+fr_timer(from the ack to the final reply
   wait)+wt_timer.

   The main difference between this timer and fr_inv_timer is that the
   fr_inv_timer is per branch, while max_inv_lifetime is per the whole
   transaction. Even on a per branch basis fr_inv_timer could be
   restarted. For example, by default if restart_fr_on_each_reply is not
   cleared, the fr_inv_timer will be restarted for each received
   provisional reply. Even if restart_fr_on_each_reply is not set the
   fr_inv_timer will still be restarted for each increasing reply (e.g.
   180, 181, 182, ...). Another example when a transaction can live
   substantially more then its fr_inv_timer and where max_inv_lifetime
   will help is when dns failover is used (each failed dns destination can
   introduce a new branch).

   The default value is 180000 ms (180 seconds - the rfc3261 timer C
   value).

   See also: max_noninv_lifetime, t_set_max_lifetime() (allows changing
   max_inv_lifetime on a per transaction basis), t_reset_max_lifetime
   fr_timer, wt_timer, restart_fr_on_each_reply.

   Example 3. Set max_inv_lifetime parameter
...
modparam("tm", "max_inv_lifetime", 150000)
...

1.4.4. max_noninv_lifetime (integer)

   Maximum time a non-INVITE transaction is allowed to be active (in
   milliseconds). After this interval has passed from the transaction
   creation, the transaction will be either moved into the wait state or
   in the final response retransmission state, irrespective of the
   transaction fr_timer value. It's the same as max_inv_lifetime, but for
   non-INVITEs.

   A non-INVITE transaction will be kept in memory for maximum:
   max_noninv_lifetime+wt_timer.

   The main difference between this timer and fr_timer is that the
   fr_timer is per branch, while max_noninv_lifetime is per the whole
   transaction. An example when a transaction can live substantially more
   then its fr_timer and where max_noninv_lifetime will help is when dns
   failover is used (each failed dns destination can introduce a new
   branch).

   The default value is 32000 ms (32 seconds - the rfc3261 timer F value).

   See also: max_inv_lifetime, t_set_max_lifetime() (allows changing
   max_noninv_lifetime on a per transaction basis), t_reset_max_lifetime
   fr_timer, wt_timer.

   Example 4. Set max_noninv_lifetime parameter
...
modparam("tm", "max_inv_lifetime", 30000)
...

1.4.5. wt_timer (integer)

   Time for which a transaction stays in memory to absorb delayed messages
   after it completed (in milliseconds); also, when this timer hits,
   retransmission of local cancels is stopped (a puristic but complex
   behavior would be not to enter wait state until local branches are
   finished by a final reply or FR timer--we simplified).

   Default value is 5000 ms (5 seconds).

   Example 5. Set wt_timer parameter
...
modparam("tm", "wt_timer", 1000)
...

1.4.6. delete_timer (integer)

   Time after which a to-be-deleted transaction currently ref-ed by a
   process will be tried to be deleted again (in milliseconds).

   Note: this parameter is obsolete for ser 2.1 (in 2.1 the transaction is
   deleted the moment it's not referenced anymore).

   Default value is 200 milliseconds.

   Example 6. Set delete_timer parameter
...
modparam("tm", "delete_timer", 100)
...

1.4.7. retr_timer1 (integer)

   Initial retransmission period (in milliseconds).

   Default value is 500 milliseconds.

   Example 7. Set retr_timer1 parameter
...
modparam("tm", "retr_timer1", 1000)
...

1.4.8. retr_timer2 (integer)

   Maximum retransmission period (in milliseconds). The retransmission
   interval starts with retr_timer1 and increases until it reaches this
   value. After this it stays constant at retr_timer2.

   Default value is 4000 milliseconds.

   Example 8. Set retr_timer2 parameter
...
modparam("tm", "retr_timer2", 2000)
...

1.4.9. noisy_ctimer (integer)

   If set, INVITE transactions that time-out (FR INV timer) will be always
   replied. If it's not set, the transaction has only one branch and no
   response was ever received on this branch, it will be silently dropped
   (no 408 reply will be generated) This behavior is overridden if a
   request is forked, the transaction has a failure route or callback, or
   some functionality explicitly turned it on for a transaction (like acc
   does to avoid unaccounted transactions due to expired timer). Turn this
   off only if you know the client UACs will timeout and their timeout
   interval for INVITEs is lower or equal than tm's fr_inv_timer.

   Default value is 1 (on).

   Example 9. Set noisy_ctimer parameter
...
modparam("tm", "noisy_ctimer", 1)
...

1.4.10. restart_fr_on_each_reply (integer)

   If set (default), the fr_inv_timer for an INVITE transaction will be
   restarted for each provisional reply received (rfc3261 mandated
   behaviour). If not set, the fr_inv_timer will be restarted only for the
   first provisional replies and for increasing replies greater or equal
   180 (e.g. 180, 181, 182, 185, ...).

   Setting it to 0 is especially useful when dealing with bad UAs that
   continuously retransmit 180s, not allowing the transaction to timeout
   (and thus making impossible the implementation of certain services,
   like automatic voicemail after x seconds).

   Default value is 1 (on).

   See also: fr_inv_timer, max_inv_lifetime.

   Example 10. Set restart_fr_on_each_reply parameter
...
modparam("tm", "restart_fr_on_each_reply", 0)
...

1.4.11. auto_inv_100 (integer)

   If set (default) tm will automatically send and 100 reply to INVITEs.

   Setting it to 0 one can be used to enable doing first some tests or
   pre-processing on the INVITE and only if some conditions are met
   manually send a 100 (using t_reply()). Note however that in this case
   all the 100s have to be sent "by hand". t_set_auto_inv_100() might help
   to selectively turn off this feature only for some specific
   transactions.

   Default value is 1 (on).

   See also: t_set_auto_inv_100() auto_inv_100_reason.

   Example 11. Set auto_inv_100 parameter
...
modparam("tm", "auto_inv_100", 0)
...

1.4.12. auto_inv_100_reason (string)

   Set reason text of the automatically send 100 to an INVITE.

   Default value is "trying -- your call is important to us".

   See also: auto_inv_100.

   Example 12. Set auto_inv_100_reason parameter
...
modparam("tm", "auto_inv_100_reason", "Trying")
...

1.4.13. unix_tx_timeout (integer)

   Unix socket transmission timeout, in milliseconds.

   If unix sockets are used (e.g.: to communicate with sems) and sending a
   message on a unix socket takes longer then unix_tx_timeout, the send
   will fail.

   The default value is 500 milliseconds.

   Example 13. Set unix_tx_timeout parameter
...
modparam("tm", "unix_tx_timeout", 250)
...

1.4.14. aggregate_challenges (integer)

   If set (default), the final reply is a 401 or a 407 and more then one
   branch received a 401 or 407, then all the WWW-Authenticate and
   Proxy-Authenticate headers from all the 401 and 407 replies will be
   aggregated in a new final reply. If only one branch received the
   winning 401 or 407 then this reply will be forwarded (no new one will
   be built). If 0 only the first 401, or if no 401 was received the first
   407, will be forwarded (no header aggregation).

   Default value is 1 (required by rfc3261).

   Example 14. Set aggregate_challenges parameter
...
modparam("tm", "aggregate_challenges", 0)
...

1.4.15. reparse_invite (integer)

   If set (default), the CANCEL and negative ACK requests are constructed
   from the INVITE message which was sent out instead of building them
   from the received request. The disadvantage is that the outgoing INVITE
   has to be partially re-parsed, the advantage is that the CANCEL/ACK is
   always RFC 3261-compliant, it always contains the same route-set as the
   INVITE message. Do not disable the INVITE re-parsing for example in the
   following cases:

   - The INVITE contains a preloaded route-set, and SER forwards the
   message to the next hop according to the Route header. The Route header
   is not removed in the CANCEL without reparse_invite=1.

   - SER record-routes, thus an in-dialog INVITE contains a Route header
   which is removed during loose routing. If the in-dialog INVITE is
   rejected, the negative ACK still contains the Route header without
   reparse_invite=1.

   Default value is 1.

   Example 15. Set reparse_invite parameter
...
modparam("tm", "reparse_invite", 0)
...

1.4.16. ac_extra_hdrs (string)

   Header fields prefixed by this parameter value are included in the
   CANCEL and negative ACK messages if they were present in the outgoing
   INVITE.

   Note, that the parameter value effects only those headers which are not
   covered by RFC-3261 (which are neither mandatory nor prohibited in
   CANCEL and ACK), and the parameter can be used only together with
   reparse_invite=1.

   Default value is "".

   Example 16. Set ac_extra_hdrs parameter
...
modparam("tm", "ac_extra_hdrs", "myfavoriteheaders-")
...

1.4.17. blst_503 (integer)

   If set and the blacklist support is enabled, every 503 reply source is
   added to the blacklist. The initial blacklist timeout (or ttl) depends
   on the presence of a Retry-After header in the reply and the values of
   the following tm parameters: blst_503_def_timeout, blst_503_min_timeout
   and blst_503_max_timeout.

   WARNING:blindly allowing 503 blacklisting could be very easily
   exploited for DOS attacks in most network setups.

   The default value is 0 (disabled due to the reasons above).

   Example 17. Set blst_503 parameter
...
modparam("tm", "blst_503", 1)
...

1.4.18. blst_503_def_timeout (integer)

   Blacklist interval in seconds for a 503 reply with no Retry-After
   header. See also blst_503, blst_503_min_timeout and
   blst_503_max_timeout.

   The default value is 0, which means that if no Retry-After header is
   present, the 503 reply source will not be blacklisted (rfc conformant
   behaviour).

   Example 18. Set blst_503_def_timeout parameter
...
modparam("tm", "blst_503_def_timeout", 120)
...

1.4.19. blst_503_min_timeout (integer)

   Minimum blacklist interval in seconds for a 503 reply with a
   Retry-After header. It will be used if the Retry-After value is
   smaller. See also blst_503, blst_503_def_timeout and
   blst_503_max_timeout.

   The default value is 0

   Example 19. Set blst_503_min_timeout parameter
...
modparam("tm", "blst_503_min_timeout", 30)
...

1.4.20. blst_503_max_timeout (integer)

   Maximum blacklist interval in seconds for a 503 reply with a
   Retry-After header. It will be used if the Retry-After value is
   greater. See also blst_503, blst_503_def_timeout and
   blst_503_min_timeout.

   The default value is 3600

   Example 20. Set blst_503_max_timeout parameter
...
modparam("tm", "blst_503_max_timeout", 604800)
...

1.4.21. blst_methods_add (unsigned integer)

   Bitmap of method types that trigger blacklisting on transaction
   timeouts. (This setting has no effect on blacklisting because of send
   failures.)

   The following values are associated to the request methods: INVITE=1,
   CANCEL=2, ACK=4 (not retransmitted, thus, never times-out), BYE=8,
   INFO=16, REGISTER=32, SUBSCRIBE=64, NOTIFY=126, OTHER=256 (all the
   unknown types). Check parser/msg_parser.h for farther details.

   Change the value carefully, because requests not having provisional
   response (everything but INVITE) can easily cause the next hop to be
   inserted into the blacklist by mistake. For exmaple the next hop is a
   proxy, it is alive, but waiting for the response of the UAS, and has
   higher fr_timer value.

   The default value is 1, only INVITEs trigger blacklisting

   Example 21. Set blst_methods_add parameter
...
# INVITEs and REGISTERs trigger blacklisting
modparam("tm", "blst_methods_add", 33)
...

1.4.22. blst_methods_lookup (unsigned integer)

   Bitmap of method types that are looked-up in the blacklist before
   statefull forwarding. See also blst_methods_add

   The default value is 4294967287, every method type except BYE. (We try
   to deliver BYEs no matter what)

   Example 22. Set blst_methods_lookup parameter
...
# lookup only INVITEs
modparam("tm", "blst_methods_lookup", 1)
...

1.4.23. cancel_b_method (integer)

   Method used when attempting to CANCEL an unreplied transaction branch
   (a branch where no reply greater the 99 was received). The possible
   values are 0, 1, and 2.

   0 will immediately stop the request (INVITE) retransmission on the
   branch and it will behave as if the branch was immediately replied with
   a 487 (a fake internal 487 reply). The advantage is the unreplied
   branches will be terminated immediately. However it introduces a race
   risk with a possible slightly delayed 2xx reply. In this case we could
   have an UA receiving a 2xx after a 487. Moreover this risk is greatly
   amplified by packet loss (e.g. if an 180 is lost the branch will look
   as unreplied and a CANCEL will silently drop the branch, but a 2xx can
   still come at a later time). This is the behaviour for ser versions
   older then 2.1.

   1 will keep retransmitting the request on unreplied branches. If a
   provisional answer is later received a CANCEL will be immediately sent
   back (attempting to quickly trigger a 487). This approach is race free
   and avoids the 2xx after 487 problem, but it's more resource intensive:
   faced with a branch towards and UA that doesn't answer, a CANCEL
   attempt will keep the transaction alive for the whole timeout interval
   (fr_timer).

   2 will send and retransmit CANCEL even on unreplied branches, stopping
   the request retransmissions. This has the same advantages as 1 and also
   avoids the extra roundtrip in the case of the provisional reply, but
   it's not RFC 3261 conforming (the RFC allows sending CANCELs only on
   pending branches).

   The default value is 1.

   Example 23. Set cancel_b_method parameter
...
modparam("tm", "cancel_b_method", 1)
...

1.4.24. reparse_on_dns_failover (integer)

   If set to 1, the SIP message after a DNS failover is constructed from
   the outgoing message buffer of the failed branch instead of from the
   received request.

   It must be set if multiple branches are installed, the SIP message is
   modified differently in them, and at least one of them can result in
   DNS failover. If the parameter is not set the per-branch modifications
   are lost after the failover.

   Note: If the parameter is set, branch route block and
   TMCB_REQUEST_FWDED callback are not called in case of the failover.

   Disadvantage: only the via header is replaced in the message buffer, so
   the outgoing socket address is not corrected in any other part of the
   message. It is dangerous on multihomed hosts: when the new SIP request
   after the DNS failover is sent via different interface than the first
   request, the message can contain incorrect ip address in the
   Record-Route header for instance.

   Default value is 1.

   Example 24. Set reparse_on_dns_failover parameter
...
modparam("tm", "reparse_on_dns_failover", 0)
...

1.4.25. on_sl_reply (string)

   Sets reply route block, to which control is passed when a reply is
   received that has no associated transaction. The reply is passed to the
   core for stateless forwarding after the route block execution unless it
   returns 0.

   Example 25. Set on_sl_reply parameter
...
modparam("tm", "on_sl_reply", "stateless_replies")
...

onreply_route["stateless_replies"] {
        # do not allow stateless replies to be forwarded
        return 0;
}

1.4.26. contacts_avp (string)

   This is the name or Id of an AVP that t_load_contacts() function uses
   to store contacts of the destination set and that t_next_contacts()
   function uses to restore those contacts.

   Default value is "NULL" (t_load_contacts()/t_next_contacts() functions
   are disabled).

   Example 26. Set contacts_avp parameter
...
modparam("tm", "contacts_avp", "$avp(i:25)")
...

1.4.27. fr_timer_avp (string)

   The value of fr_timer timer can be overriden on per-transaction basis.
   The administrator can provide a value to be used for a particular
   transaction in an AVP. This parameter contains the name of the AVP that
   will be checked. If the AVP exists then its value will be used for the
   fr_timer timer, effectively overriding the value configured in fr_timer
   parameter for the current transaction.

   The value of this parameter is the the name of the AVP to be checked,
   without the $ character or "$avp" prefix.

Note

   The value of the AVP is expected to be expressed in seconds and not
   milliseconds (unlike the rest of the timers).

   This parameter is kept for backwards compatibility (hence its value
   expressed in seconds instead of milliseconds and its arcane way of
   specifying the avps). The recommended replacement is using t_set_fr()
   on a per transaction basis.

   See also: t_set_fr(), fr_timer.

   In Kamailio compatibility mode (defined by #!KAMAILIO), the value of
   the parameter must be the name of an AVP in pseudo-variable format:
   $avp(name). In SER compatibility mode it must by just AVP name.

   Example 27. Set fr_timer_avp parameter
...
modparam("tm", "fr_timer_avp", "i:708")
# K mode
modparam("tm", "fr_timer_avp", "$avp(i:708)")
...

1.4.28. fr_inv_timer_avp (string)

   The value of fr_inv_timer timer can be overriden on per-transaction
   basis. The administrator can provide a value to be used for a
   particular transaction in an AVP. This parameter contains the name of
   the AVP that will be checked. If the AVP exists, is non-empty and
   non-zero then its value will be used for the fr_inv_timer timer,
   effectively overriding the value configured in fr_inv_timer parameter
   for the current transaction.

   The value of this parameter is the the name of the AVP to be checked,
   without the $ character or "$avp" prefix.

Note

   The value of the AVP is expected to be expressed in seconds and not
   milliseconds (unlike the rest of the timers).

   This parameter is kept for backwards compatibility (hence its value
   expressed in seconds instead of milliseconds and its arcane way of
   specifying the avps). The recommended replacement is using t_set_fr()
   on a per transaction basis.

   See also: t_set_fr(), fr_inv_timer.

   In Kamailio compatibility mode (defined by #!KAMAILIO), the value of
   the parameter must be the name of an AVP in pseudo-variable format:
   $avp(name). In SER compatibility mode it must by just AVP name.

   Example 28. Set fr_inv_timer_avp parameter
...
modparam("tm", "fr_inv_timer_avp", "my_fr_inv_timer")
# K mode
modparam("tm", "fr_inv_timer_avp", "$avp(my_fr_inv_timer)")
...

1.4.29. unmatched_cancel (string)

   This parameter selects between forwarding CANCELs that do not match any
   transaction statefully (0, default value), statelessly (1) or dropping
   them (2). Note that the statefull forwarding has an additional hidden
   advantage: tm will be able to recognize INVITEs that arrive after their
   CANCEL. Note also that this feature could be used to try a memory
   exhaustion DOS attack against a proxy that authenticates all requests,
   by continuously flooding the victim with CANCELs to random destinations
   (since the CANCEL cannot be authenticated, each received bogus CANCEL
   will create a new transaction that will live by default 30s).

   Default value is 0.

   Example 29. Set unmatched_cancel parameter
...
modparam("tm", "unmatched_cancel", "2")
...

1.4.30. ruri_matching (integer)

   If set it will also try to match the request uri when doing pre-3261
   transaction matching (the via branch parameter does not contain the
   3261 cookie).

   The only reason to have it not set is for interoperability with old,
   broken implementations.

   Default value is 1 (on).

   Can be set at runtime, e.g.:
        $ sercmd cfg.set_now_int tm ruri_matching 0

   Example 30. Set ruri_matching parameter
...
modparam("tm", "ruri_matching", 1)
...

1.4.31. via1_matching (integer)

   If set it will also try to match the topmost via when doing pre-3261
   transaction matching (the via branch parameter does not contain the
   3261 cookie).

   The only reason to have it not set is for interoperability with old,
   broken implementations.

   Default value is 1 (on).

   Can be set at runtime, e.g.:
        $ sercmd cfg.set_now_int tm via1_matching 0

   Example 31. Set via1_matching parameter
...
modparam("tm", "via1_matching", 1)
...

1.4.32. pass_provisional_replies (integer)

   If set, TMCB_LOCAL_REPONSE_OUT tm registered callbacks will be called
   also for provisional replies.

   Default value is 0 (off).

   Can be set at runtime, e.g.:
        $ sercmd cfg.set_now_int tm pass_provisional_replies 1

   Example 32. Set pass_provisional_replies parameter
...
modparam("tm", "pass_provisional_replies", 1)
...

1.4.33. default_code (integer)

   Default response code sent by t_reply() if it cannot retrieve its
   parameters (e.g. inexistent avp). Valid values are between 400 and 699.

   Default value is 500.

   Can be set at runtime, e.g.:
        $ sercmd cfg.set_now_int tm default_code 505

   Example 33. Set default_code parameter
...
modparam("tm", "default_code", 501)
...

1.4.34. default_reason (string)

   Default SIP reason phrase sent by t_reply() if it cannot retrieve its
   parameters (e.g. inexistent avp).

   Default value is "Server Internal Error".

   Can be set at runtime, e.g.:
        $ sercmd cfg.set_now_string tm default_reason "Unknown error"

   Example 34. Set default_reason parameter
...
modparam("tm", "default_reason", "Unknown reason")
...

1.4.35. disable_6xx_block (integer)

   If set tm will treat all the 6xx replies like normal replies (warning:
   this would be non-rfc conformant behaviour).

   If not set (default) receiving a 6xx will cancel all the running
   parallel branches, will stop dns failover and forking. However serial
   forking using append_branch() in the failure_route will still work.

   It can be overwritten on a per transaction basis using
   t_set_disable_6xx().

   Default value is 0 (off, rfc conformant behaviour).

   Can be set at runtime, e.g.:
        $ sercmd cfg.set_now_int tm disable_6xx_block 0

   See also: t_set_disable_6xx().

   Example 35. Set disable_6xx_block parameter
...
modparam("tm", "disable_6xx_block", 1)
...

1.4.36. local_ack_mode (integer)

   It controls where locally generated ACKs for 2xx replies to local
   transactions (transactions created via t_uac*() either thorugh the tm
   api or via RPC/mi/fifo) are sent.

   It has 3 possible values:
     * 0 - the ACK destination is choosen according to the rfc: the next
       hop is found using the contact and the route set and then DNS
       resolution is used on it.
     * 1 - the ACK is sent to the same address as the corresponding INVITE
       branch.
     * 2 - the ACK is sent to the source of the 2xx reply.

Note

   Mode 1 and 2 break the rfc, but are useful to deal with some simple UAs
   behind the NAT cases (no different routing for the ACK and the contact
   contains an address behind the NAT).

   The default value is 0 (rfc conformant behaviour).

   Can be set at runtime, e.g.:
        $ sercmd cfg.set_now_int tm local_ack_mode 0

   Example 36. Set local_ack_mode parameter
...
modparam("tm", "local_ack_mode", 1)
...

1.4.37. failure_reply_mode (integer)

   It controls how branches are managed and replies are selected for
   failure_route handling: keep all, drop all, drop last branches in SIP
   serial forking handling.

   To control per transaction see t_drop_replies().

   It has 4 possible values:
     * 0 - all branches are kept, no matter a new leg of serial forking
       has been started. Beware that if the new leg fails, you may get in
       failure_route a reply code from a branch of previous serial forking
       legs (e.g., if in first leg you got a 3xx, then you handled the
       redirection in failure route, sent to a new destination and this
       one timeout, you will get again the 3xx). Use t_drop_replies() on
       per transaction fashion to control the behavior you want. It is the
       default behaviour comming from SER 2.1.x.
     * 1 - all branches are discarded by default. You can still overwrite
       the behaviour via t_drop_replies()
     * 2 - by default only the branches of previous leg of serial forking
       are discarded
     * 3 - all previous branches are discarded if there is a new serial
       forking leg. This is the default behaviour coming from Kamailio
       1.5.x. Use this mode if you don't want to handle in a per
       transaction fashion with t_drop_replies(). It ensures that you will
       get the winning reply from the branches of last serial forking step
       (e.g., if in first step you get 3xx, then you forward to a new
       destination, you will get in failure_route the reply coming from
       that destination or a local timeout).

   The default value is 0.

   Example 37. Set failure_reply_mode parameter
...
modparam("tm", "failure_reply_mode", 3)
...

1.4.38. faked_reply_prio (integer)

   It controls how branch selection is done. It allows to give a penalty
   to faked replies such as the infamous 408 on branch timeout.

   Internally, every reply is assigned a priority between 0 (high prio)
   and 32000 (low prio). With this parameter the priority of fake replies
   can be adjusted.
     * 0 - disabled (default)
     * < 0 - priority is increased by given amount.
     * > 0 - priority is decreased by given amount. Do not make it higer
       than 10000 or faked replies will even loose from 1xx clsss replies.

   The default value is 0.

   To let received replies win from a locally generated 408, set this
   value to 2000.

   Example 38. Set faked_reply_prio parameter
...
modparam("tm", "faked_reply_prio", 2000)
...

1.4.39. local_cancel_reason (boolean)

   Enables/disables adding reason headers (RFC 3326) for CANCELs generated
   due to receiving a final reply. The reason header added will look like:
   "Reason: SIP;cause=<final_reply_code>".

   Default value is 1 (enabled).

   Can be set at runtime, e.g.:
        $ sercmd cfg.set_now_int tm local_cancel_reason 0

   See also: e2e_cancel_reason.

   Example 39. Set local_cancel_reason parameter
...
modparam("tm", "local_cancel_reason", 0)
...

1.4.40. e2e_cancel_reason (boolean)

   Enables/disables adding reason headers (RFC 3326) for CANCELs generated
   due to a received CANCEL. If enabled the reason headers from received
   CANCELs will be copied into the generated hop-by-hop CANCELs.

   Default value is 1 (enabled).

   Can be changed at runtime, e.g.:
        $ sercmd cfg.set_now_int tm e2e_cancel_reason 0

   See also: t_set_no_e2e_cancel_reason() and local_cancel_reason.

   Example 40. Set e2e_cancel_reason parameter
...
modparam("tm", "e2e_cancel_reason", 0)
...

1.5. Functions

1.5.1. t_relay([host, port])

   Relay a message statefully either to the destination indicated in the
   current URI (if called without any parameters) or to the specified host
   and port. In the later case (host and port specified) the protocol used
   is the same protocol on which the message was received.

   t_relay() is the statefull version for forward() while t_relay(host,
   port) is similar to forward(host, port).

   In the forward to uri case (t_relay()), if the original URI was
   rewritten (by UsrLoc, RR, strip/prefix, etc.) the new URI will be
   taken). The destination (including the protocol) is determined from the
   uri, using SIP specific DNS resolving if needed (NAPTR, SRV a.s.o
   depending also on the dns options).

   Returns a negative value on failure -- you may still want to send a
   negative reply upstream statelessly not to leave upstream UAC in lurch.

   Example 41. t_relay usage
...
if (!t_relay())
{
    sl_reply_error();
    break;
};
...

1.5.2. t_relay_to_udp([ip, port])

   Relay a message statefully using a fixed protocol either to the
   specified fixed destination or to a destination derived from the
   message uri (if the host address and port are not specified). These
   along with t_relay are the functions most users want to use--all other
   are mostly for programming. Programmers interested in writing TM logic
   should review how t_relay is implemented in tm.c and how TM callbacks
   work.

   Meaning of the parameters is as follows:
     * ip - IP address where the message should be sent.
     * port - Port number.

   If no parameters are specified the message is sent to a destination
   derived from the message uri (using sip sepcific DNS lookups), but with
   the protocol corresponding to the function name.

   Example 42. t_relay_to_udp usage
...
if (src_ip==10.0.0.0/8)
        t_relay_to_udp("1.2.3.4", "5060"); # sent to 1.2.3.4:5060 over udp
else
        t_relay_to_tcp(); # relay to msg. uri, but over tcp
...

1.5.3. t_relay_to_tcp([ip, port])

   See function t_relay_to_udp([ip, port]).

1.5.4. t_relay_to_tls([ip, port])

   See function t_relay_to_udp([ip, port]).

1.5.5. t_relay_to_sctp([ip, port])

   See function t_relay_to_udp([ip, port]).

1.5.6. t_on_failure(failure_route)

   Sets failure routing block, to which control is passed after a
   transaction completed with a negative result but before sending a final
   reply. In the referred block, you can either start a new branch (good
   for services such as forward_on_no_reply) or send a final reply on your
   own (good for example for message silo, which received a negative reply
   from upstream and wants to tell upstream "202 I will take care of it").
   Note that the set of commands which are usable within failure_routes is
   strictly limited to rewriting URI, initiating new branches, logging,
   and sending stateful replies (t_reply). Any other commands may result
   in unpredictable behavior and possible server failure. Note that
   whenever failure_route is entered, uri is reset to value which it had
   on relaying. If it temporarily changed during a reply_route processing,
   subsequent reply_route will ignore the changed value and use again the
   original one.

   Meaning of the parameters is as follows:
     * failure_route - Failure route block to be called.

   Example 43. t_on_failure usage
...
route {
    t_on_failure("1");
    t_relay();
}

failure_route[1] {
    revert_uri();
    setuser("voicemail");
    append_branch();
}
...

   See test/onr.cfg for a more complex example of combination of serial
   with parallel forking.

1.5.7. t_on_reply(onreply_route)

   Sets the reply routing block, to which control is passed when a reply
   for the current transaction is received. Note that the set of commands
   which are usable within onreply_routes is limited.

   Meaning of the parameters is as follows:
     * onreply_route - Onreply route block to be called.

   Example 44. t_on_reply usage
...
loadmodule "/usr/local/lib/ser/modules/nathelper.so"
...
route {
        /* if natted */
        t_on_reply("1");
        t_relay();
}

onreply_route[1] {
        if (status=~ "(183)|2[0-9][0-9]"){
                force_rtp_proxy();
                search_append('^(Contact|m)[ \t]*:.*sip:[^>[:cntrl:]]*', ';nat=y
es');
        }
        if (nat_uac_test("1")){
                fix_nated_contact();
        }
}

1.5.8. t_on_branch(branch_route)

   Sets the branch routing block, to which control is passed after forking
   (when a new branch is created). For now branch routes are intended only
   for last minute changes of the SIP messages (like adding new headers).
   Note that the set of commands which are usable within branch_routes is
   very limited. It is not possible to generate a reply.

   Meaning of the parameters is as follows:
     * branch_route - branch route block to be called.

   Example 45. t_on_branch usage
...
route {
        t_on_branch("1");
        t_relay();
}

branch_route[1] {
        if (uri=~"sip:[0-9]+"){
                append_hf("P-Warn: numeric uri\r\n");
        }
}

1.5.9. append_branch()

   Similarly to t_fork_to, it extends destination set by a new entry. The
   difference is that current URI is taken as new entry.

   Example 46. append_branch usage
...
set_user("john");
t_fork();
set_user("alice");
t_fork();
t_relay();
...

1.5.10. t_newtran()

   Creates a new transaction, returns a negative value on error. This is
   the only way a script can add a new transaction in an atomic way.
   Typically, it is used to deploy a UAS.

   Example 47. t_newtran usage
...
if (t_newtran()) {
    log("UAS logic");
    t_reply("999","hello");
} else sl_reply_error();
...

   See test/uas.cfg for more examples.

1.5.11. t_reply(code, reason_phrase)

   Sends a stateful reply after a transaction has been established. See
   t_newtran for usage.

   Meaning of the parameters is as follows:
     * code - Reply code number.
     * reason_phrase - Reason string.

   Example 48. t_reply usage
...
t_reply("404", "Not found");
...

1.5.12. t_lookup_request()

   Checks if a transaction exists. Returns a positive value if so,
   negative otherwise. Most likely you will not want to use it, as a
   typical application of a look-up is to introduce a new transaction if
   none was found. However this is safely (atomically) done using
   t_newtran.

   Example 49. t_lookup_request usage
...
if (t_lookup_request()) {
    ...
};
...

1.5.13. t_retransmit_reply()

   Retransmits a reply sent previously by UAS transaction.

   Example 50. t_retransmit_reply usage
...
t_retransmit_reply();
...

1.5.14. t_release()

   Remove transaction from memory (it will be first put on a wait timer to
   absorb delayed messages).

   Example 51. t_release usage
...
t_release();
...

1.5.15. t_forward_nonack([ip, port])

   Mainly for internal usage -- forward a non-ACK request statefully.
   Variants of this functions can enforce a specific transport protocol.

   Meaning of the parameters is as follows:
     * ip - IP address where the message should be sent.
     * port - Port number.

   Example 52. t_forward_nonack usage
...
t_forward_nonack("1.2.3.4", "5060");
...

1.5.16. t_forward_nonack_udp(ip, port)

   See function t_forward_nonack([ip, port]).

1.5.17. t_forward_nonack_tcp(ip, port)

   See function t_forward_nonack([ip, port]).

1.5.18. t_forward_nonack_tls(ip, port)

   See function t_forward_nonack([ip, port]).

1.5.19. t_forward_nonack_sctp(ip, port)

   See function t_forward_nonack([ip, port]).

1.5.20. t_set_fr(fr_inv_timeout [, fr_timeout])

   Sets the fr_inv_timeout and optionally fr_timeout for the current
   transaction or for transactions created during the same script
   invocation, after calling this function. If the transaction is already
   created (e.g called after t_relay() or in an onreply_route) all the
   branches will have their final response timeout updated on-the-fly. If
   one of the parameters is 0, its value won't be changed.

   Meaning of the parameters is as follows:
     * fr_inv_timeout - new final response timeout (in milliseconds) for
       INVITEs. See also fr_inv_timer.
       fr_timeout - new final response timeout (in milliseconds) for
       non-INVITE transaction, or INVITEs which haven't received yet a
       provisional response. See also fr_timer.

   See also: fr_timer, fr_inv_timer, t_reset_fr().

   Example 53. t_set_fr usage
...
route {
        t_set_fr(10000); # set only fr invite timeout to 10s
        t_on_branch("1");
        t_relay();
}

branch_route[1] {
        # if we are calling the pstn, extend the invite timeout to 50s
        # for all the branches, and set the no-reply-received timeout to 2s
        if (uri=~"sip:[0-9]+"){
                t_set_fr(50000, 2000);
        }
}

1.5.21. t_reset_fr()

   Resets the fr_inv_timer and fr_timer for the current transaction to the
   default values (set using the tm module parameters fr_inv_timer and
   fr_timer).

   It will effectively cancel any previous calls to t_set_fr for the same
   transaction.

   See also: fr_timer, fr_inv_timer, t_set_fr.

   Example 54. t_reset_fr usage
...
route {
...
                t_reset_fr();
...
}

1.5.22. t_set_max_lifetime(inv_lifetime, noninv_lifetime)

   Sets the maximum lifetime for the current INVITE or non-INVITE
   transaction, or for transactions created during the same script
   invocation, after calling this function (that's why it takes values for
   both INVITE and non-INVITE). If one of the parameters is 0, its value
   won't be changed.

   It works as a per transaction max_inv_lifetime or max_noninv_lifetime.

   Meaning of the parameters is as follows:
     * inv_lifetime - maximum INVITE transaction lifetime (in
       milliseconds). See also max_inv_lifetime.
       noninv_lifetime - maximum non-INVITE transaction lifetime (in
       milliseconds). See also max_noninv_lifetime.

   See also: max_inv_lifetime, max_noninv_lifetime, t_reset_max_lifetime.

   Example 55. t_set_max_lifetime usage
...
route {
    if (src_ip=1.2.3.4)
        t_set_max_lifetime(120000, 0); # set only max_inv_lifetime to 120s
    else
        t_set_max_lifetime(90000, 15000); # set the maximum lifetime to 90s if
                                          # the current transaction is an
                                          # INVITE and to 15s if not
}

1.5.23. t_reset_max_lifetime()

   Resets the the maximum lifetime for the current INVITE or non-INVITE
   transaction to the default value (set using the tm module parameter
   max_inv_lifetime or max_noninv_lifetime).

   It will effectively cancel any previous calls to t_set_max_lifetime for
   the same transaction.

   See also: max_inv_lifetime, max_noninv_lifetime, t_set_max_lifetime.

   Example 56. t_reset_max_lifetime usage
...
route {
...
                t_reset_max_lifetime();
...
}

1.5.24. t_set_retr(retr_t1_interval, retr_t2_interval)

   Sets the retr_t1_interval and retr_t2_interval for the current
   transaction or for transactions created during the same script
   invocation, after calling this function. If one of the parameters is 0,
   it's value won't be changed. If the transaction is already created (e.g
   called after t_relay() or in an onreply_route) all the existing
   branches will have their retransmissions intervals updated on-the-fly:
   if the retransmission interval for the branch has not yet reached T2
   the interval will be reset to retr_t1_interval, else to
   retr_t2_interval. Note that the change will happen after the current
   interval expires (after the next retransmission, the next-next
   retransmission will take place at retr_t1_interval or
   retr_t2_interval). All new branches of the same transaction will start
   with the new values. This function will work even if it's called in the
   script before a transaction creating function (e.g.: t_set_retr(500,
   4000); t_relay()). All new transaction created after this function
   call, during the same script invocation will use the new values. Note
   that this function will work only if tm is compile with
   -DTM_DIFF_RT_TIMEOUT (which increases every transaction size with 4
   bytes).

   Meaning of the parameters is as follows:
     * retr_t1_interval - new T1 retransmission interval (in
       milliseconds). See also retr_t1_timeout.
       retr_t2_interval - new T2 (or maximum) retransmission interval (in
       milliseconds). See also retr_t2_timeout.

   See also: retr_timer1, retr_timer2, t_reset_retr().

   Example 57. t_set_retr usage
...
route {
        t_set_retr(250, 0); # set only T1 to 250 ms
        t_on_branch("1");
        t_relay();
}

branch_route[1] {
        # if we are calling the a remote pstn, extend T1 and decrease T2
        # for all the branches
        if (uri=~"sip:[0-9]+"){
                t_set_retr(500, 2000);
        }
}

1.5.25. t_reset_retr()

   Resets the retr_timer1 and retr_timer2 for the current transaction to
   the default values (set using the tm module parameters retr_timer1 and
   retr_timer2).

   It will effectively cancel any previous calls to t_set_retr for the
   same transaction.

   See also: retr_timer1, retr_timer2, t_set_retr.

   Example 58. t_reset_retr usage
...
route {
...
                t_reset_retr();
...
}

1.5.26. t_set_auto_inv_100(0|1)

   Switch automatically sending 100 replies to INVITEs on/off on a per
   transaction basis. It overrides the auto_inv_100 value for the current
   transaction.

   See also: auto_inv_100.

   Example 59. t_set_auto_inv_100 usage
...
route {
...
        if (src_ip==1.2.3.0/24)
                t_set_auto_inv_100(0); # turn off automatic 100 replies
...
}

1.5.27. t_branch_timeout()

   Returns true if the failure route is executed for a branch that did
   timeout. It can be used only from the failure_route.

   Example 60. t_branch_timeout usage
...
failure_route[0]{
        if (t_branch_timeout()){
                log("timeout\n");
                # ...
        }
}

1.5.28. t_branch_replied()

   Returns true if the failure route is executed for a branch that did
   receive at least one reply in the past (the "current" reply is not
   taken into account). It can be used only from the failure_route.

   Example 61. t_branch_replied usage
...
failure_route[0]{
        if (t_branch_timeout()){
                if (t_branch_replied())
                        log("timeout after receiving a reply (no answer?)\n");
                else
                        log("timeout, remote side seems to be down\n");
                # ...
        }
}

1.5.29. t_any_timeout()

   Returns true if at least one of the current transactions branches did
   timeout.

   Example 62. t_any_timeout usage
...
failure_route[0]{
        if (!t_branch_timeout()){
                if (t_any_timeout()){
                        log("one branch did timeout\n");
                        sl_send_reply("408", "Timeout");
                }
        }
}

1.5.30. t_any_replied()

   Returns true if at least one of the current transactions branches did
   receive some reply in the past. If called from a failure or onreply
   route, the "current" reply is not taken into account.

   Example 63. t_any_replied usage
...
onreply_route[0]{
        if (!t_any_replied()){
                log("first reply received\n");
                # ...
        }
}

1.5.31. t_grep_status("code")

   Returns true if "code" is the final reply received (or locally
   generated) in at least one of the current transactions branches.

   Example 64. t_grep_status usage
...
onreply_route[0]{
        if (t_grep_status("486")){
                /* force a 486 reply, even if this is not the winning branch */
                t_reply("486", "Busy");
        }
}

1.5.32. t_is_canceled()

   Returns true if the current transaction was canceled.

   Example 65. t_is_canceled usage
...
failure_route[0]{
        if (t_is_canceled()){
                log("transaction canceled\n");
                # ...
        }
}

1.5.33. t_is_expired()

   Returns true if the current transaction has already been expired, i.e.
   the max_inv_lifetime/max_noninv_lifetime interval has already elapsed.

   Example 66. t_is_expired usage
...
failure_route[0]{
        if (t_is_expired()){
                log("transaction expired\n");
                # There is no point in adding a new branch.
        }
}

1.5.34. t_relay_cancel()

   Forwards the CANCEL if the corresponding INVITE transaction exists. The
   function is supposed to be used at the very beginning of the script,
   because the CANCELs can be caught and the rest of the script can be
   bypassed this way. Do not disable reparse_invite module parameter, and
   call t_relay_cancel() right after the sanity tests.

   Return value is 0 (drop) if the corresponding INVITE was found and the
   CANCELs were successfully sent to the pending branches, true if the
   INVITE was not found, and false in case of any error.

   Example 67. t_relay_cancel usage
if (method == CANCEL) {
        if (!t_relay_cancel()) {  # implicit drop if relaying was successful,
                                  # nothing to do

                # corresponding INVITE transaction found but error occurred
                sl_reply("500", "Internal Server Error");
                drop;
        }
        # bad luck, corresponding INVITE transaction is missing,
        # do the same as for INVITEs
}

1.5.35. t_lookup_cancel([1])

   Returns true if the corresponding INVITE transaction exists for a
   CANCEL request. The function can be called at the beginning of the
   script to check whether or not the CANCEL can be immediately forwarded
   bypassing the rest of the script. Note however that t_relay_cancel
   includes t_lookup_cancel as well, therefore it is not needed to
   explicitly call this function unless something has to be logged for
   example.

   If the function parameter (optional) is set to 1, the message flags are
   overwritten with the flags of the INVITE. isflagset() can be used to
   check the flags of the previously forwarded INVITE in this case.

   Example 68. t_lookup_cancel usage
if (method == CANCEL) {
        if (t_lookup_cancel()) {
                log("INVITE transaction exists");
                if (!t_relay_cancel()) {  # implicit drop if
                                          # relaying was successful,
                                          # nothing to do

                        # corresponding INVITE transaction found
                        # but error occurred
                        sl_reply("500", "Internal Server Error");
                        drop;
                }
        }
        # bad luck, corresponding INVITE transaction is missing,
        # do the same as for INVITEs
}

1.5.36. t_drop_replies([mode])

   Drops all the previously received replies in failure_route block to
   make sure that none of them is picked up again.

   The parameter 'mode' controls which replies are dropped: 'a' or missing
   - all replies are dropped; 'l' - replies received for last set of
   branches are dropped; 'n' - no reply is dropped.

   Dropping replies works only if a new branch is added to the
   transaction, or it is explicitly replied in the script!

   Example 69. t_drop_replies() usage
...
failure_route[0]{
        if (t_check_status("5[0-9][0-9]")){
                # I do not like the 5xx responses,
                # so I give another chance to "foobar.com",
                # and I drop all the replies to make sure that
                # they are not forwarded to the caller.
                t_drop_replies();

                rewritehostport("foobar.com");
                append_branch();
                t_relay();
        }
}

1.5.37. t_save_lumps()

   Forces the modifications of the processed SIP message to be saved in
   shared memory before t_relay() is called. The new branches which are
   created in failure_route will contain the same modifications, and any
   other modification after t_save_lumps() will be lost.

   Note that t_relay() automatically saves the modifications when it is
   called the first time, there is no need for t_save_lumps() unless
   message changes between t_save_lumps() and t_relay() must not be
   propagated to failure_route.

   The transaction must be created by t_newtran() before calling
   t_save_lumps().

   Example 70. t_save_lumps() usage
route {
        ...
        t_newtran();
        append_hf("hf1: my first header\r\n");
        ...
        t_save_lumps();
        append_hf("hf2: my second header\r\n");
        ...
        t_on_failure("1");
        t_relay();
}

failure_route[1] {
        append_branch();
        append_hf("hf3: my third header\r\n");
        #
        # This branch contains hf1 and hf3, but does
        # not contain hf2 header.
        # hf2 would be also present here without
        # t_save_lumps().
        ...
        t_relay();
}

1.5.38. t_load_contacts()

   This is the first of the two functions that can be used to implement
   serial/parallel forking based on the q value of individual branches in
   a destination set.

   The function t_load_contacts() takes all branches from the current
   destination set and encodes them into the AVP whose name or ID is
   configured with the parameter contacts_avp. Note that you have to
   configure this parameter before you can use the function, the parameter
   is set to NULL by default, which disables the function.

   If the destination set contains only one branch (the Request-URI) or if
   all branches have the same q value then the function does nothing to
   minimize performance impact. In such case all branches should be tried
   in parallel and that is the default mode of operation of functions like
   t_relay(), so there is no need to create the AVP or sort the branches.

   If the current destination set contains more than one branch and not
   all branches have the same q value then the function sorts them
   according to the increasing value of the q parameter. The resulting
   sorted list of branches is then encoded into the AVP.

   The q parameter contains a value from a range of 0 to 1.0 and it
   expresses relative preferrence of the branch among all branches in the
   destination set. The higher the q value the more preferrence the user
   agent gave to the branch. Branches with higher q values will be tried
   first when serial forking takes place.

   After that the function clears all branches and you have to call
   t_next_contacts to retrieve them sorted according to their q value.
   Note that if you use t_load_contacts then you also have to use
   t_next_contacts before calling t_relay.

   The AVP created by the function may contain multiple values, with one
   encoded branch per value. The first value will contain the branch with
   the highest q value. Each value contains the Request-URI, the
   destination URI, the path vector, the outgoing socket description and
   branch flags. All these fields are delimited with the LF character.

   The function returns 1 if loading of contacts succeeded or there was
   nothing to do. Returns -1 on error (see syslog).

   This function can be used from REQUEST_ROUTE.

   Example 71. t_load_contacts usage
...
if (!t_load_contacts()) {
        sl_send_reply("500", "Server Internal Error - Cannot load contacts");
        exit;
};
...

1.5.39. t_next_contacts()

   The function t_next_contacts is the second of the two functions that
   can be used to implement serial/parallel forking based on the q value
   of individual branches in a destination set.

   This function takes the contact_avp created by t_load_contacts and
   extracts branches with highest q value from it into the destination set
   when called for the first time. When you call the function second time
   it extracts branches with lower q value, and so on until all branches
   have been extracted. At each call, Request URI is rewritten with first
   branch and the remaining branches (if any) are added as branches. Then
   these "used" branches are remove from the AVP.

   The function does nothing if there are no contact_avp values.

   The function returns 1 if the AVP was not empty and a destination set
   was successfully added, returns -2 if contact_avp was empty and thus
   there was nothing to do, and returns -1 in case of an error (see
   syslog). This function can be used from REQUEST_ROUTE and
   FAILURE_ROUTE.

   Note that if use use t_load_contacts and t_next_contacts functions then
   you should also set the value of restart_fr_on_each_reply parameter to
   0. If you do not do that then it can happen that a broken user agent
   that retransmits 180 periodically will keep resetting the fr_inv_timer
   value and serial forking never happens.

   Before calling t_relay(), you can check if the previous call of
   next_contacts() consumed all branches by checking if contact_avp is not
   anymore set. Based on that test, you can then use t_set_fr() function
   to set timers according to your needs.

   Example 72. t_next_contacts usage
...
# First call after t_load_contacts() when transaction does not exist yet
# and contacts should be available
if (!t_next_contacts()) {
        sl_send_reply("500", "Server Internal Error - Cannot get contacts");
} else {
        t_relay();
};
...
# Following call, when transaction exists and there may or may not be
# contacts left
if (!t_next_contacts()) {
        t_reply("408", "Request Timeout");
} else {
        t_relay();
};
...

1.5.40. t_check_trans()

   t_check_trans() can be used to quickly check if a message belongs or is
   related to a transaction. It behaves differently for different types of
   messages:
     * For a SIP Reply it returns true if the reply belongs to an existing
       transaction and false otherwise.
     * For a CANCEL it behaves exactly as t_lookup_cancel(): returns true
       if a corresponding INVITE transaction exists for the CANCEL and
       false otherwise.
     * For ACKs to negative replies or for ACKs to local transactions it
       will terminate the script if the ACK belongs to a transaction (it
       would make very little sense to process an ACK to a negative reply
       for an existing transaction in some other way then to simply pass
       it to tm) or return false if not.
     * For end-to-end ACKs (ACKs to 2xx responses for forwarded INVITE
       transactions) it will return true if the corresponding INVITE
       transaction is found and still active and false if not.

Note
       Note that the e2e ACK matching is more of a hint then a certainty.
       A delayed e2e ACK might arrive after the transaction wait time
       elapses, when the INVITE transaction no longer exists and thus
       would not match anything. There are also cases when tm would not
       keep all the information needed for e2e ACK matching (since this is
       not needed for a statefull proxy and it requires additional memory,
       tm will not keep this information unless needed by some other
       module or callbacks).
     * For other requests (non ACKs and non CANCELs), it will terminate
       the script for retransmissions and return false for new requests
       (for which no transaction exists yet).

Note

   An important difference from kamailio version is that for an ACK to
   negative reply or for a local transaction, the script execution will be
   immediately stopped and the message handled by tm, instead of returning
   true.

   t_check_trans() functionality for requests, except for the e2e ACK
   matching, can be replicated in the script using t_lookup_cancel() and
   t_lookup_request().

   See also: t_lookup_request(), t_lookup_cancel().

   Example 73. t_check_trans usage
if ( method == "CANCEL" && !t_check_trans())
        sl_reply("403", "cancel out of the blue forbidden");
# note: in this example t_check_trans() can be replaced by t_lookup_cancel()

1.5.41. t_set_disable_6xx(0|1)

   Turn off/on 6xx replies special rfc conformant handling on a per
   transaction basis. If turned off (t_set_disable_6xx("1")) 6XXs will be
   treated like normal replies.

   It overrides the disable_6xx_block value for the current transaction.

   See also: disable_6xx_block.

   Example 74. t_set_disable_6xx usage
...
route {
...
        if (src_ip==1.2.3.4) # bad user agent that sends 603
                t_set_disable_6xx(1); # turn off 6xx special handling
...
}

1.5.42. t_set_disable_failover(0|1)

   Turn off/on dns failover on a per transaction basis.

   See also: use_dns_failover.

   Example 75. t_set_disable_failover usage
...
route {
...
        if (uri=~"@foo.bar$")
                t_set_disable_failover(1); # turn off dns failover
...
}

1.5.43. t_replicate(params)

   Replicate the SIP request to a specific address.

   There are several function prototypes:
     * t_replicate(uri),
     * t_replicate(host, port),
     * t_replicat_udp(host, port)
     * t_replicate_tcp(host, port)
     * t_replicate_tls(host, port)
     * t_replicate_sctp(host, port)
     * t_replicate_to(proto, hostport)

   Meaning of the parameters is as follows:
     * uri - SIP URI where the message should be sent. It can be given via
       a script variable.
     * host - host address where the message should be sent.
     * port - port number.
     * proto - transport protocol to be used.
     * hostport - address in "host:port" format. It can be given via an
       AVP.

   Example 76. t_replicate usage
...
# sent to 1.2.3.4:5060 over tcp
t_replicate("sip:1.2.3.4:5060;transport=tcp");

# sent to 1.2.3.4:5061 over tls
$var(h) = "1.2.3.4:5061";
t_replicate("sip:$var(h);transport=tls");

# sent to 1.2.3.4:5060 over udp
t_replicate_to_udp("1.2.3.4", "5060");
...

1.5.44. t_relay_to(proxy, flags)

   Forward the SIP request to a specific address, controlling internal
   behavior via flags.

   There are several function prototypes:
     * t_relay_to(),
     * t_relay_to(proxy),
     * t_relay_to(flags)
     * t_relay_to(proxy, flags)

   Meaning of the parameters is as follows:
     * proxy - address where the request should be sent. Format is:
       "proto:host:port" - any of proto or port can be ommitted, along
       with the semicolon after or before.
     * flags - bitmask integer value to control the internal behavior.
       Bits can be:
          + 0x01 - do not generate 100 reply.
          + 0x02 - do not generate reply on internal error (NOTE: has no
            effect anymore).
          + 0x04 - disable dns failover.

   Example 77. t_replicate usage
...
# sent to 1.2.3.4:5060 over tcp
t_relay_to("tcp:1.2.3.4:5060");

# sent to 1.2.3.4 over tls
t_relay_to("tls:1.2.3.4");

# sent to dst URI or R-URI without a 100 reply
t_relay_to("0x01");
...

1.5.45. t_set_no_e2e_cancel_reason(0|1)

   Enables/disables reason header (RFC 3326) copying from the triggering
   received CANCEL to the generated hop-by-hop CANCEL. 0 enables and 1
   disables.

   It overrides the e2e_cancel_reason setting (module parameter) for the
   current transaction.

   See also: e2e_cancel_reason.

   Example 78. t_set_no_e2e_cancel_reason usage
...
route {
...
        if (src_ip!=10.0.0.0/8) #  don't trust CANCELs from the outside
                t_set_no_e2e_cancel_reason(1); # turn off CANCEL reason header c
opying
...
}

1.6. TM Module API

   There are applications which would like to generate SIP transactions
   without too big involvement in SIP stack, transaction management, etc.
   An example of such an application is sending instant messages from a
   website. To address needs of such apps, SIP-router accepts requests for
   new transactions via the management interface. If you want to enable
   this feature, start the management interface server by configuring the
   proper modules.

   An application can easily launch a new transaction by writing a
   transaction request to this interface. The request must follow very
   simple format, which for the basic FIFO interface is
 :t_uac_from:[<file_name>]\n
 <method>\n
 <sender's uri>\n
 <dst uri>\n
 <CR_separated_headers>\n
 <body>\n
 .\n
 \n

   (Filename is to where a report will be dumped. ser assumes /tmp as
   file's directory.)

   Note the request write must be atomic, otherwise it might get
   intermixed with writes from other writers. You can easily use it via
   Unix command-line tools, see the following example:
[jiri@bat jiri]$ cat > /tmp/ser_fifo
:t_uac_from:xxx
MESSAGE
sip:sender@iptel.org
sip:mrx@iptel.org
header:value
foo:bar
bznk:hjhjk
p_header: p_value

body body body
yet body
end of body
.

   or cat test/transaction.fifo > /tmp/ser_fifo

1.6.1. Defines

     * ACK_TAG enables stricter matching of acknowledgments including
       to-tags. Without it, to-tags are ignored. It is disabled by default
       for two reasons:
          + It eliminates an unlikely race condition in which
            transaction's to-tag is being rewritten by a 200 OK whereas an
            ACK is being looked up by to-tag.
          + It makes UACs happy who set wrong to-tags.
       It should not make a difference, as there may be only one negative
       reply sent upstream and 200/ACKs are not matched as they constitute
       another transaction. It will make no difference at all when the new
       magic cookie matching is enabled anyway.
     * CANCEL_TAG similarly enables strict matching of CANCELs including
       to-tags--act of mercy to UACs, who screw up the to-tags (however,
       it still depends on how forgiving the downstream UAS is). Like with
       ACK_TAG, all this complex transactions matching goes with RFC3261's
       magic cookie away anyway.

1.6.2. Functions

1.6.2.1. register_tmcb(cb_type, cb_func)

   For programmatic use only--register a function to be called back on an
   event. See t_hooks.h for more details.

   Meaning of the parameters is as follows:
     * cb_type - Callback type.
     * cb_func - Callback function.

1.6.2.2. load_tm(*import_structure)

   For programmatic use only--import exported TM functions. See the acc
   module for an example of use.

   Meaning of the parameters is as follows:
     * import_structure - Pointer to the import structure.

1.6.2.3. int t_suspend(struct sip_msg *msg, unsigned int *hash_index,
unsigned int *label)

   For programmatic use only. This function together with t_continue() can
   be used to implement asynchronous actions: t_suspend() saves the
   transaction, returns its identifiers, and t_continue() continues the
   SIP request processing. (The request processing does not continue from
   the same point in the script, a separate route block defined by the
   parameter of t_continue() is executed instead. The reply lock is held
   during the route block execution.) FR timer is ticking while the
   transaction is suspended, and the transaction's failure route is
   executed if t_continue() is not called in time.

   Missing: message lumps are saved by t_suspend() and are not updated by
   the subsequent t_relay(). This means that the modifications made
   between them are lost.

   Meaning of the parameters is as follows:
     * msg - SIP message pointer.
     * hash_index - transaction identifier.
     * label - transaction identifier.

   Return value: 0 - success, <0 - error.

   Usage: Allocate a memory block for storing the transaction identifiers
   (hash_index and label), and for storing also any variable related to
   the async query. Before calling t_suspend(), register for the following
   callbacks, and pass the pointer to the allocated shared memory as a
   parameter: TMCB_ON_FAILURE, TMCB_DESTROY, and TMCB_E2ECANCEL_IN (in
   case of INVITE transaction). The async operation can be cancelled, if
   it is still pending, when TMCB_ON_FAILURE or TMCB_E2ECANCEL_IN is
   called. TMCB_DESTROY is suitable to free the shared memory allocated
   for the async and SIP transaction identifiers. Once the async query
   result is available call t_continue(), see below. The SIP transaction
   must exist before calling t_suspend(), and the module function calling
   t_suspend() should return 0 to make sure that the script processing
   does not continue.

1.6.2.4. int t_continue(unsigned int hash_index, unsigned int label, struct
action *route)

   For programmatic use only. This function is the pair of t_suspend(),
   and is supposed to be called when the asynchronous query result is
   available. The function executes a route block with the saved SIP
   message. It is possible to add more branches to the transaction, or
   send a reply from the route block.

   Meaning of the parameters is as follows:
     * hash_index - transaction identifier.
     * label - transaction identifier.
     * route - route block to execute.

   Return value: 0 - success, <0 - error.

1.6.2.5. int t_cancel_suspend(unsigned int hash_index, unsigned int label)

   For programmatic use only. This function is for revoking t_suspend()
   from the same process as it was executed before. t_cancel_suspend() can
   be used when something fails after t_suspend() has already been
   executed and it turns out that the transcation should not have been
   suspended. The function cancels the FR timer of the transacation.

   The message lumps are saved by t_suspend() which cannot be restored.

   Meaning of the parameters is as follows:
     * hash_index - transaction identifier.
     * label - transaction identifier.

   Return value: 0 - success, <0 - error.
