# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{prawn}
  s.version = "0.5.0.1"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Gregory Brown"]
  s.date = %q{2009-06-14}
  s.description = %q{Prawn is a fast, tiny, and nimble PDF generator for Ruby}
  s.email = %q{  gregory.t.brown@gmail.com}
  s.files = ["lib/prawn.rb"]
  s.homepage = %q{http://prawn.majesticseacreature.com}
  s.post_install_message = %q{
  Welcome to Prawn, the best pure-Ruby PDF solution ever!
  This is version 0.5 RC1
   
  Please note that you have downloaded a pre-release candidate gem,
  which has some bugs, ugly spots, other bad things in it.  This gem is also
  not fully backwards compatible, and may break existing code.

  If you wish to revert until a stable release is ready, uninstall prawn 0.5.0,
  prawn-core 0.5.0, prawn-layout 0.2.0 and prawn-format 0.2.0

  For details on what has changed, see:
    http://prawn.majesticseacreature.com/notes/0.5

  If you have questions, contact us at:
    http://groups.google.com/group/prawn-ruby

  To submit a patch or report a bug: 
    http://github.com/sandal/prawn

  Prawn is meant for experienced Ruby hackers, so if you are new to Ruby, you
  might want to wait until you've had some practice with the language before
  expecting Prawn to work for you.  Things may change after 1.0, but for now
  if you're not ready to read source code and patch bugs or missing features 
  yourself (with our help), Prawn might not be the right fit.

  But if you know what you're getting yourself into, enjoy!
  }
  s.require_paths = ["lib"]
  s.rubyforge_project = %q{prawn}
  s.rubygems_version = %q{1.3.7}
  s.summary = %q{A fast and nimble PDF generator for Ruby}

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
      s.add_runtime_dependency(%q<prawn-core>, ["~> 0.5.0"])
      s.add_runtime_dependency(%q<prawn-layout>, ["~> 0.2.0"])
      s.add_runtime_dependency(%q<prawn-format>, ["~> 0.2.0"])
    else
      s.add_dependency(%q<prawn-core>, ["~> 0.5.0"])
      s.add_dependency(%q<prawn-layout>, ["~> 0.2.0"])
      s.add_dependency(%q<prawn-format>, ["~> 0.2.0"])
    end
  else
    s.add_dependency(%q<prawn-core>, ["~> 0.5.0"])
    s.add_dependency(%q<prawn-layout>, ["~> 0.2.0"])
    s.add_dependency(%q<prawn-format>, ["~> 0.2.0"])
  end
end
