/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class CanvasWidget
extends gsObject {
    static CanvasWidget currentCanvas;
    Vector drawobjects = new Vector();
    MyCanvas canvas;
    double translationX = 0.0;
    double translationY = 0.0;
    double theta = 0.0;
    double scaleX = 1.0;
    double scaleY = 1.0;
    Color background = null;
    Stroke currentStroke;
    Color currentPaint;
    AffineTransform transform = null;
    AlphaComposite currentComposite;
    Font currentFont = null;
    boolean antiAliasing = true;
    boolean visible = true;
    String mouseClickedEvent;
    String mouseEnteredEvent;
    String mouseExitedEvent;
    String mousePressedEvent;
    String mouseReleasedEvent;
    String mouseDraggedEvent;
    String mouseMovedEvent;
    String mouseWheelMovedEvent;
    boolean mousePressedTags = false;
    boolean mouseReleasedTags = false;
    boolean mouseClickedTags = false;
    boolean mouseMovedTags = false;

    public CanvasWidget(StringTokenizer stringTokenizer) {
        this.id = stringTokenizer.nextToken();
        this.canvas = new MyCanvas();
        this.component = this.canvas;
        this.container = this.canvas;
        this.jcomponent = this.canvas;
        currentCanvas = this;
        this.currentStroke = new BasicStroke();
        this.currentPaint = new Color(0, 0, 0);
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        gsObject.widgets.put(this.id, this);
    }

    public void g2Canvas(StringTokenizer stringTokenizer) {
        currentCanvas = this;
    }

    public void g2Translation(StringTokenizer stringTokenizer) {
        this.translationX = Float.parseFloat(stringTokenizer.nextToken());
        this.translationY = Float.parseFloat(stringTokenizer.nextToken());
    }

    public void g2Scale(StringTokenizer stringTokenizer) {
        this.scaleX = Float.parseFloat(stringTokenizer.nextToken());
        this.scaleY = Float.parseFloat(stringTokenizer.nextToken());
    }

    public void g2Rotation(StringTokenizer stringTokenizer) {
        double d = Float.parseFloat(stringTokenizer.nextToken());
        this.theta = Math.PI * 2 * d / 360.0;
    }

    public void g2Transform(StringTokenizer stringTokenizer) {
        double d = Float.parseFloat(stringTokenizer.nextToken());
        double d2 = Float.parseFloat(stringTokenizer.nextToken());
        double d3 = Float.parseFloat(stringTokenizer.nextToken());
        double d4 = Float.parseFloat(stringTokenizer.nextToken());
        double d5 = Float.parseFloat(stringTokenizer.nextToken());
        double d6 = Float.parseFloat(stringTokenizer.nextToken());
    }

    public void g2Stroke(StringTokenizer stringTokenizer) {
        String string;
        float f = Float.parseFloat(stringTokenizer.nextToken());
        int n = 0;
        int n2 = 0;
        float f2 = 10.0f;
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            n = string.equals("round") ? 1 : (string.equals("square") ? 2 : 0);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            n2 = string.equals("round") ? 2 : (string.equals("square") ? 1 : 0);
        }
        if (stringTokenizer.hasMoreTokens()) {
            f2 = Float.parseFloat(stringTokenizer.nextToken());
        }
        this.currentStroke = new BasicStroke(f, n, n2, f2);
    }

    public void g2Paint(StringTokenizer stringTokenizer) {
        float f = Float.parseFloat(stringTokenizer.nextToken());
        float f2 = Float.parseFloat(stringTokenizer.nextToken());
        float f3 = Float.parseFloat(stringTokenizer.nextToken());
        float f4 = stringTokenizer.hasMoreTokens() ? Float.parseFloat(stringTokenizer.nextToken()) : 1.0f;
        this.currentPaint = new Color(f, f2, f3, f4);
    }

    public void g2Update(StringTokenizer stringTokenizer) {
        this.canvas.repaint();
    }

    public void g2Export(StringTokenizer stringTokenizer) {
        String string = Base64Coder.decodeString(stringTokenizer.nextToken());
        int n = this.canvas.getWidth();
        int n2 = this.canvas.getHeight();
        if (stringTokenizer.hasMoreTokens()) {
            n = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
        }
        this.canvas.export(string, "PNG", n, n2);
    }

    public void g2Print(StringTokenizer stringTokenizer) {
    }

    public void setBackground(StringTokenizer stringTokenizer) {
        float f = Float.parseFloat(stringTokenizer.nextToken());
        float f2 = Float.parseFloat(stringTokenizer.nextToken());
        float f3 = Float.parseFloat(stringTokenizer.nextToken());
        float f4 = stringTokenizer.hasMoreTokens() ? Float.parseFloat(stringTokenizer.nextToken()) : 1.0f;
        this.background = new Color(f, f2, f3, f4);
        this.component.setBackground(this.background);
    }

    public void setFont(StringTokenizer stringTokenizer) {
        String string = Base64Coder.decodeString(stringTokenizer.nextToken());
        int n = 0;
        int n2 = 12;
        if (stringTokenizer.hasMoreTokens()) {
            n2 = Integer.parseInt(stringTokenizer.nextToken());
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("plain")) {
                n |= 0;
            }
            if (string2.equals("bold")) {
                n |= 1;
            }
            if (!string2.equals("italic")) continue;
            n |= 2;
        }
        this.currentFont = new Font(string, n, n2);
        this.component.setFont(this.currentFont);
    }

    public void setAntiAliasing(StringTokenizer stringTokenizer) {
        this.antiAliasing = stringTokenizer.nextToken().equals("true");
    }

    public void drawLine(StringTokenizer stringTokenizer) {
        new LineShape(stringTokenizer);
    }

    public void drawRectangle(StringTokenizer stringTokenizer) {
        new RectangleShape(stringTokenizer);
    }

    public void fillRectangle(StringTokenizer stringTokenizer) {
        new FilledRectangleShape(stringTokenizer);
    }

    public void drawRoundRect(StringTokenizer stringTokenizer) {
        new RoundRectangleShape(stringTokenizer);
    }

    public void fillRoundRect(StringTokenizer stringTokenizer) {
        new FilledRoundRectangleShape(stringTokenizer);
    }

    public void drawEllipse(StringTokenizer stringTokenizer) {
        new EllipseShape(stringTokenizer);
    }

    public void fillEllipse(StringTokenizer stringTokenizer) {
        new FilledEllipseShape(stringTokenizer);
    }

    public void drawCircle(StringTokenizer stringTokenizer) {
        new CircleShape(stringTokenizer);
    }

    public void fillCircle(StringTokenizer stringTokenizer) {
        new FilledCircleShape(stringTokenizer);
    }

    public void drawArc(StringTokenizer stringTokenizer) {
        new ArcShape(stringTokenizer);
    }

    public void fillArc(StringTokenizer stringTokenizer) {
        new FilledArcShape(stringTokenizer);
    }

    public void drawPolygon(StringTokenizer stringTokenizer) {
        new PolygonShape(stringTokenizer);
    }

    public void fillPolygon(StringTokenizer stringTokenizer) {
        new FilledPolygonShape(stringTokenizer);
    }

    public void drawPath(StringTokenizer stringTokenizer) {
        new PathShape(stringTokenizer);
    }

    public void drawText(StringTokenizer stringTokenizer) {
        new TextShape(stringTokenizer);
    }

    public void drawImage(StringTokenizer stringTokenizer) {
        new ImageShape(stringTokenizer);
    }

    public void registerMouseClicked(StringTokenizer stringTokenizer) {
        this.mouseClickedEvent = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            this.mouseClickedTags = stringTokenizer.nextToken().equals("true");
        }
    }

    public void registerMousePressed(StringTokenizer stringTokenizer) {
        this.mousePressedEvent = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            this.mousePressedTags = stringTokenizer.nextToken().equals("true");
        }
    }

    public void registerMouseRelease(StringTokenizer stringTokenizer) {
        this.mouseReleasedEvent = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            this.mouseReleasedTags = stringTokenizer.nextToken().equals("true");
        }
    }

    public void registerMouseExited(StringTokenizer stringTokenizer) {
        this.mouseExitedEvent = stringTokenizer.nextToken();
    }

    public void registerMouseEntered(StringTokenizer stringTokenizer) {
        this.mouseEnteredEvent = stringTokenizer.nextToken();
    }

    public void registerMouseDragged(StringTokenizer stringTokenizer) {
        this.mouseDraggedEvent = stringTokenizer.nextToken();
    }

    public void registerMouseMoved(StringTokenizer stringTokenizer) {
        this.mouseMovedEvent = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            this.mouseMovedTags = stringTokenizer.nextToken().equals("true");
        }
    }

    public void registerMouseWheel(StringTokenizer stringTokenizer) {
        this.mouseWheelMovedEvent = stringTokenizer.nextToken();
    }

    public void colorTaggedShape(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        Color color = Shape.getColorParameter(stringTokenizer);
        boolean bl = stringTokenizer.nextToken().equals("true");
        for (int i = 0; i < this.drawobjects.size(); ++i) {
            Shape shape = (Shape)this.drawobjects.elementAt(i);
            if (!shape.tag.equals(string)) continue;
            shape.paintColor = color;
        }
        if (bl) {
            this.canvas.repaint();
        }
    }

    public void deleteTaggedShape(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        boolean bl = stringTokenizer.nextToken().equals("true");
        Vector<Shape> vector = new Vector<Shape>();
        for (int i = 0; i < this.drawobjects.size(); ++i) {
            Shape shape = (Shape)this.drawobjects.elementAt(i);
            if (shape.tag.equals(string)) continue;
            vector.add(shape);
        }
        this.drawobjects = vector;
        if (bl) {
            this.canvas.repaint();
        }
    }

    public void moveTaggedShape(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        boolean bl = stringTokenizer.nextToken().equals("true");
        for (int i = 0; i < this.drawobjects.size(); ++i) {
            Shape shape = (Shape)this.drawobjects.elementAt(i);
            if (!shape.tag.equals(string)) continue;
            shape.X += n;
            shape.Y += n2;
        }
        if (bl) {
            this.canvas.repaint();
        }
    }

    public void translateTaggedShape(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        double d = Float.parseFloat(stringTokenizer.nextToken());
        double d2 = Float.parseFloat(stringTokenizer.nextToken());
        boolean bl = stringTokenizer.nextToken().equals("true");
        for (int i = 0; i < this.drawobjects.size(); ++i) {
            Shape shape = (Shape)this.drawobjects.elementAt(i);
            if (!shape.tag.equals(string)) continue;
            shape.transform.translate(d, d2);
        }
        if (bl) {
            this.canvas.repaint();
        }
    }

    public void rotateTaggedShape(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        double d = Float.parseFloat(stringTokenizer.nextToken());
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        boolean bl = stringTokenizer.nextToken().equals("true");
        d = Math.PI * 2 * d / 360.0;
        for (int i = 0; i < this.drawobjects.size(); ++i) {
            Shape shape = (Shape)this.drawobjects.elementAt(i);
            if (!shape.tag.equals(string)) continue;
            shape.transform.rotate(d, n, n2);
        }
        if (bl) {
            this.canvas.repaint();
        }
    }

    public void scaleTaggedShape(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        double d = Float.parseFloat(stringTokenizer.nextToken());
        double d2 = Float.parseFloat(stringTokenizer.nextToken());
        boolean bl = stringTokenizer.nextToken().equals("true");
        for (int i = 0; i < this.drawobjects.size(); ++i) {
            Shape shape = (Shape)this.drawobjects.elementAt(i);
            if (!shape.tag.equals(string)) continue;
            shape.transform.scale(d, d2);
        }
        if (bl) {
            this.canvas.repaint();
        }
    }

    public void shearTaggedShape(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        double d = Float.parseFloat(stringTokenizer.nextToken());
        double d2 = Float.parseFloat(stringTokenizer.nextToken());
        boolean bl = stringTokenizer.nextToken().equals("true");
        for (int i = 0; i < this.drawobjects.size(); ++i) {
            Shape shape = (Shape)this.drawobjects.elementAt(i);
            if (!shape.tag.equals(string)) continue;
            shape.transform.shear(d, d2);
        }
        if (bl) {
            this.canvas.repaint();
        }
    }

    public void hideTaggedShape(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        boolean bl = stringTokenizer.nextToken().equals("true");
        for (int i = 0; i < this.drawobjects.size(); ++i) {
            Shape shape = (Shape)this.drawobjects.elementAt(i);
            if (!shape.tag.equals(string)) continue;
            shape.visible = false;
        }
        if (bl) {
            this.canvas.repaint();
        }
    }

    public void showTaggedShape(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        boolean bl = stringTokenizer.nextToken().equals("true");
        for (int i = 0; i < this.drawobjects.size(); ++i) {
            Shape shape = (Shape)this.drawobjects.elementAt(i);
            if (!shape.tag.equals(string)) continue;
            shape.visible = true;
        }
        if (bl) {
            this.canvas.repaint();
        }
    }

    public void orderTaggedShapes(StringTokenizer stringTokenizer) {
        Vector<Shape> vector = new Vector<Shape>();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            for (int i = 0; i < this.drawobjects.size(); ++i) {
                Shape shape = (Shape)this.drawobjects.elementAt(i);
                if (!shape.tag.equals(string)) continue;
                vector.add(shape);
            }
        }
        this.drawobjects = vector;
    }

    class MyCanvas
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    Printable {
        public static final long serialVersionUID = 1L;

        public MyCanvas() {
            if (guiserver.DOUBLE_BUFFERING) {
                this.setDoubleBuffered(true);
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }

        public void update(Graphics graphics) {
            if (guiserver.MAC_OS_X) {
                super.update(graphics);
            } else {
                this.paint(graphics);
            }
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.render(graphics2D);
        }

        public void render(Graphics2D graphics2D) {
            if (CanvasWidget.this.background != null) {
                graphics2D.setColor(CanvasWidget.this.background);
            }
            if (CanvasWidget.this.background != null) {
                graphics2D.setPaint(CanvasWidget.this.background);
                graphics2D.fillRect(0, 0, CanvasWidget.this.canvas.getWidth(), CanvasWidget.this.canvas.getHeight());
            }
            graphics2D.translate(CanvasWidget.this.translationX, CanvasWidget.this.translationY);
            graphics2D.scale(CanvasWidget.this.scaleX, CanvasWidget.this.scaleY);
            graphics2D.rotate(CanvasWidget.this.theta);
            AffineTransform affineTransform = graphics2D.getTransform();
            if (CanvasWidget.this.antiAliasing) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            for (int i = 0; i < CanvasWidget.this.drawobjects.size(); ++i) {
                Shape shape = (Shape)CanvasWidget.this.drawobjects.elementAt(i);
                if (!shape.visible) continue;
                graphics2D.transform(shape.transform);
                shape.drawShape(graphics2D);
                graphics2D.setTransform(affineTransform);
            }
            this.paintComponents(graphics2D);
        }

        public Iterator getTagsFromPoint(int n, int n2) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (int i = 0; i < CanvasWidget.this.drawobjects.size(); ++i) {
                Shape shape = (Shape)CanvasWidget.this.drawobjects.elementAt(i);
                if (!shape.hasPoint(n, n2) || hashMap.containsKey(shape.tag)) continue;
                hashMap.put(shape.tag, 0);
            }
            return hashMap.keySet().iterator();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (CanvasWidget.this.mouseClickedEvent == null) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            guiserver.out.print("(" + CanvasWidget.this.mouseClickedEvent + " " + n + " " + n2 + " " + mouseEvent.getButton() + " " + mouseEvent.getClickCount() + " " + mouseEvent.getModifiers());
            if (CanvasWidget.this.mouseClickedTags) {
                guiserver.out.print(" '(");
                Iterator iterator = this.getTagsFromPoint(n, n2);
                while (iterator.hasNext()) {
                    guiserver.out.print("\"" + iterator.next() + "\" ");
                }
                guiserver.out.print(")");
            }
            guiserver.out.println(")");
            guiserver.out.flush();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (CanvasWidget.this.mouseEnteredEvent == null) {
                return;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (CanvasWidget.this.mouseExitedEvent == null) {
                return;
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (CanvasWidget.this.mousePressedEvent == null) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            guiserver.out.print("(" + CanvasWidget.this.mousePressedEvent + " " + n + " " + n2 + " " + mouseEvent.getButton() + " " + mouseEvent.getModifiers());
            if (CanvasWidget.this.mousePressedTags) {
                guiserver.out.print(" '(");
                Iterator iterator = this.getTagsFromPoint(n, n2);
                while (iterator.hasNext()) {
                    guiserver.out.print("\"" + iterator.next() + "\" ");
                }
                guiserver.out.print(")");
            }
            guiserver.out.println(")");
            guiserver.out.flush();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (CanvasWidget.this.mouseReleasedEvent == null) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            guiserver.out.print("(" + CanvasWidget.this.mouseReleasedEvent + " " + n + " " + n2 + " " + mouseEvent.getButton() + " " + mouseEvent.getModifiers());
            if (CanvasWidget.this.mouseReleasedTags) {
                guiserver.out.print(" '(");
                Iterator iterator = this.getTagsFromPoint(n, n2);
                while (iterator.hasNext()) {
                    guiserver.out.print("\"" + iterator.next() + "\" ");
                }
                guiserver.out.print(")");
            }
            guiserver.out.println(")");
            guiserver.out.flush();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (CanvasWidget.this.mouseDraggedEvent == null) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            guiserver.out.println("(" + CanvasWidget.this.mouseDraggedEvent + " " + n + " " + n2 + " " + mouseEvent.getButton() + " " + mouseEvent.getModifiers() + ")");
            guiserver.out.flush();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (CanvasWidget.this.mouseMovedEvent == null) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            guiserver.out.print("(" + CanvasWidget.this.mouseMovedEvent + " " + n + " " + n2);
            if (CanvasWidget.this.mouseMovedTags) {
                guiserver.out.print(" '(");
                Iterator iterator = this.getTagsFromPoint(n, n2);
                while (iterator.hasNext()) {
                    guiserver.out.print("\"" + iterator.next() + "\" ");
                }
                guiserver.out.print(")");
            }
            guiserver.out.println(")");
            guiserver.out.flush();
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (CanvasWidget.this.mouseWheelMovedEvent == null) {
                return;
            }
            int n = mouseWheelEvent.getWheelRotation();
            int n2 = mouseWheelEvent.getX();
            int n3 = mouseWheelEvent.getY();
            guiserver.out.println("(" + CanvasWidget.this.mouseWheelMovedEvent + " " + n2 + " " + n3 + " " + n + ")");
            guiserver.out.flush();
        }

        public void export(String string, String string2, int n, int n2) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.render(graphics2D);
            try {
                ImageIO.write((RenderedImage)bufferedImage, string2, new File(string));
            }
            catch (IOException iOException) {
                ErrorDialog.show("Exporting", "Could not write file: " + string);
            }
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            return 0;
        }
    }
}

