/*
 *      project.h - this file is part of Geany, a fast and lightweight IDE
 *
 *      Copyright 2007-2010 Enrico Tröger <enrico(dot)troeger(at)uvena(dot)de>
 *      Copyright 2007-2010 Nick Treleaven <nick(dot)treleaven(at)btinternet(dot)com>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $Id: project.h 5142 2010-08-11 14:41:15Z ntrel $
 */


#ifndef GEANY_PROJECT_H
#define GEANY_PROJECT_H 1

#define GEANY_PROJECT_EXT				"geany"


/** Structure for representing a project. */
typedef struct GeanyProject
{
	gchar *name; 			/**< The name of the project. */
	gchar *description; 	/**< Short description of the project. */
	gchar *file_name; 		/**< Where the project file is stored (in UTF-8). */
	gchar *base_path;		/**< Base path of the project directory (in UTF-8, maybe relative). */
	/** Identifier whether it is a pure Geany project or modified/extended
	 * by a plugin. */
	gint type;
	gchar **file_patterns;	/**< Array of filename extension patterns. */

	struct GeanyProjectPrivate	*priv;	/* must be last, append fields before this item */
#ifdef GEANY_PRIVATE
	/* Do not use following fields in plugins */
	GPtrArray *build_filetypes_list; /* Project has custom filetype builds for these. */
	gint long_line_behaviour; /* 0 - disabled, 1 - follow global settings, 2 - enabled (custom) */
	gint long_line_column; /* Long line marker position. */
#endif
}
GeanyProject;


typedef struct ProjectPrefs
{
	gchar *session_file;
	gboolean project_session;
	gboolean project_file_in_basedir;
} ProjectPrefs;

extern ProjectPrefs project_prefs;


void project_init(void);

void project_finalize(void);


void project_new(void);

void project_open(void);

void project_close(gboolean open_default);

void project_properties(void);

void project_build_properties(void);

gboolean project_ask_close(void);


gboolean project_load_file(const gchar *locale_file_name);

gboolean project_load_file_with_session(const gchar *locale_file_name);

gchar *project_get_base_path(void);


void project_save_prefs(GKeyFile *config);

void project_load_prefs(GKeyFile *config);

void project_setup_prefs(void);

void project_apply_prefs(void);

#endif
