/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;

public class AllCDS {
    private HoodTopLevel htl;
    private Hashtable cdsRoots = new Hashtable();
    private Hashtable nodes = new Hashtable();

    AllCDS(HoodTopLevel hoodTopLevel) {
        this.htl = hoodTopLevel;
        this.resetNodes();
    }

    public void resetNodes() {
        this.cdsRoots = new Hashtable();
        this.nodes = new Hashtable();
    }

    public void addObserveNode(int n, String string) {
        CDS cDS = (CDS)this.cdsRoots.get(string);
        if (cDS == null) {
            cDS = new CDSMany(n);
            this.cdsRoots.put(string, cDS);
            this.htl.newRootSet(string);
        }
        this.nodes.put(new Integer(n), cDS);
        this.htl.newNode();
    }

    public void addFunNode(int n, int n2, int n3) {
        CDS cDS = (CDS)this.nodes.get(new Integer(n2));
        if (cDS == null) {
            Message.abort("Can't find parent node");
        }
        CDSFun cDSFun = new CDSFun(n);
        cDS.addChild(cDSFun, n3);
        this.nodes.put(new Integer(n), cDSFun);
        this.htl.newNode();
    }

    public void addEnterNode(int n, int n2, int n3) {
        CDS cDS = (CDS)this.nodes.get(new Integer(n2));
        if (cDS == null) {
            Message.abort("Can't find parent node");
        }
        CDSEnter cDSEnter = new CDSEnter(n);
        cDS.addChild(cDSEnter, n3);
        this.nodes.put(new Integer(n), cDSEnter);
        this.htl.newNode();
    }

    public void addConsNode(int n, int n2, int n3, int n4, String string) {
        CDS cDS = (CDS)this.nodes.get(new Integer(n2));
        if (cDS == null) {
            Message.abort("Can't find parent node");
        }
        CDSCons cDSCons = new CDSCons(n, string, n4);
        cDS.addChild(cDSCons, n3);
        this.nodes.put(new Integer(n), cDSCons);
        this.htl.newNode();
    }

    public CDS getContents(String string) {
        CDS cDS = (CDS)this.cdsRoots.get(string);
        return cDS;
    }
}

