<?php
/********************************************** 
   The MyReview system for web-based conference management 
  
   Copyright (C) 2003-2006 Philippe Rigaux
   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; 
  
   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of 
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
   GNU General Public License for more details. 
  
   You should have received a copy of the GNU General Public License 
   along with this program; if not, write to the Free Software 
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
************************************************/ 
 
//require_once("Tableau.class.php");
//require_once("Formulaire.class.php");

// Classe gnrique pour accder  une table.  
// Fonctionne quelle que soit la table, quel que soit le SGBD
// Peut tre spcialise pour surcharger certaines mthodes (voir IhmCarte).

define ("SELECT_FIELD", "SELECT");
define ("HIDDEN_FIELD", "HIDDEN");
define ("CHECKBOX_FIELD", "CHECKBOX");
define ("BOOLEAN_FIELD", "BOOLEAN");


define("INS_BD", 1);
define ("MAJ_BD", 2);
define ("DEL_BD", 3);
define ("EDITER", 4);

class IhmBD
{
  // ----   Partie prive : les constantes et les variables
  var $bd, $nomScript, $nomTable, $schemaTable, $title,
    $entetes, $form_fields, $form_fields_type, $hidden_fields,
    $order_by_clause, $where_clause, $auto_increment_key;

  var $slave_table, $schema_slave, $size_slave_table, 
    $foreign_keys;

  // Le constructeur
  function IhmBD ($nomTable, $bd, $script="moi")
  {
    // Initialisation des variables prives
    $this->bd = $bd;
    $this->nomTable = $nomTable;
    if ($script == "moi")
      $this->nomScript = $_SERVER['PHP_SELF'];
    else
      $this->nomScript = $script;
    $this->title = $nomTable;

    // The id should always be auto-incremented ?!
    $this->auto_increment_key["id"]=true;
    $this->order_by_clause = $this->where_clause = "";
    $this->hidden_fields = array();
    $this->slave_table = "";

    // Lecture du schma de la table, et lanc d'exception si pb
    $this->schemaTable = $this->bd->schemaTable($nomTable);

    // Par dfaut, les textes des attributs sont leurs noms
    foreach ($this->schemaTable as $nom => $options)
      $this->entetes[$nom] = $nom;
  }

  // Fonction renvoyant la cl d'accs  un tuple, sous
  // format URL ou SQL
  function accesCle($tuple, $format="url")
  {
    $separateur = $chaine = "";
    // Parcours des attributs
    foreach ($this->schemaTable as $nom => $options) 
      {
	// C'est un attribut de la cl primaire
	if ($options['cle_primaire'])  
	  {
	    if ($format=="url")
	      {
		$chaine .= "&$nom=" .  urlEncode($tuple[$nom]);
		$separateur = "&";
	      }
	    else
	      {
		$chaine .= "$separateur$nom='" . 
		  addSlashes($tuple[$nom]) . "'";
		$separateur = " AND ";
	      }
	  }
      }
    return $chaine;
  }

  // Fonction renvoyant la cl d'accs  la table esclave
  function slaveAccess($tuple)
  {
    $separateur = $chaine = "";
    // Parcours des attributs
    foreach ($this->schema_slave as $nom => $options)
      {
	if (isSet($this->foreign_keys[$nom])) {
	  $chaine .= "$separateur$nom='" . 
	    addSlashes($tuple[$this->foreign_keys[$nom]]) . "'";
	  $separateur = " AND ";
	}
      }
    return $chaine;
  }

  // Mthode effectuant des contrles avant mise  jour 
  function controle(&$ligne, &$messages)
  {
    // On commence par traiter toutes les chanes des attributs
    foreach ($this->schemaTable as $nom => $options) 
      {
	if (!isSet($this->auto_increment_key[$nom])) {
	  // Transformation des ' en \'
	  $ligne[$nom] = $this->bd->prepareString($ligne[$nom]);
	}
      }
    // On peut, de plus, contrler le type ou la longueur des donnes
    // d'aprs le schma de la table... A faire!
    return true; // false si un pb est rencontr
  }

  /*****************   Partie publique ********************/

  // Cration d'un formulaire gnrique
  function formulaire ($action, $ligne)
  {
    // print_r ($ligne); echo "<p>";

    // Cration de l'objet formulaire
    $form = new Formulaire ("POST", $this->nomScript, false);
    $form->setTitle ($this->title);

    foreach ($this->hidden_fields as $nom => $value)
      $form->champCache ($nom, $value);
      
    $form->champCache ("ihm_action", $action);
      
    $form->debutTable (VERTICAL,array(),$nbLignes=1, $this->title);

    // Pour chaque attribut, cration d'un champ de saisie
    foreach ($this->schemaTable as $nom => $options)
      {
	// D'abord vrifier que la valeur par dfaut existe
	if (!isSet($ligne[$nom])) $ligne[$nom] = "";
	$this->addFormField ($form, $action, $nom, $ligne[$nom], $options);
      }
    
    // OK. Now add lines for the slave table, if any
    if (!empty($this->slave_table)) {
      $form->debutTable (HORIZONTAL, array(), 
			 $this->size_slave_table);

      // Pour chaque attribut, cration d'un champ de saisie
      foreach ($this->schema_slave as $nom => $options)
	{
	  // D'abord vrifier que la valeur par dfaut existe
	  if (!isSet($ligne[$this->slave_table][$nom]))
	    $valeur = "";
	  else
	    $valeur = $ligne[$this->slave_table][$nom];
 
	  // Attention  grer les cls trangres
	  if (isSet($this->foreign_keys[$nom])) {
	    $options['cle_etrangere'] = 1;
	    if ($action == MAJ_BD)
	      $valeur = $ligne[$this->foreign_keys[$nom]];
	  }

	  $html_field_name = "$this->slave_table[$nom][]";
	  $this->addFormField ($form, $action, $nom, 
			       $valeur, $options, $html_field_name);
	}
      $form->finTable ();
    }
    $form->finTable();
	
    if ($action == MAJ_BD)
      $form->champValider ("Modify", "submit");
    else
      $form->champValider ("Insert", "submit");

    return $form->formulaireHTML();
  }
  
  // Add a field to the form
  function addFormField (&$form, $action, $nom, $valeur, $options,
			 $html_field_name="")
  {
    if (empty($html_field_name))
      $html_field_name = $nom;

    // Attention: traitement des balises HTML avant affichage
    if (!is_array($valeur))
      $valeur = htmlSpecialChars($valeur);

    // On met la cl primaire en champ cach  
    if ($options['cle_primaire'] and $action == MAJ_BD) {
      $form->champCache ($html_field_name, $valeur);
    }
    if (isSet($options['cle_etrangere'])) {
      $form->champCache ($html_field_name, $valeur);
    }
    else {
      if (!isSet($this->auto_increment_key[$nom])) {
	// Affichage du champ
	if ($options['type'] == "blob")
	  $form->champfenetre ($this->entetes[$nom], 
			       $html_field_name, $valeur, 5, 60);
	else
	  {
	    if ($options['type'] == "time" and $action==MAJ_BD) {
	      // Show only hour and minutes 
	      $time = explode (":", $valeur);
	      $valeur = $time[0] . ":" . $time[1];
	    }
	    
	    if (!isSet($this->form_fields_type[$nom])) {
	      $lg_visible = min (60, $options['longueur']);
	      $form->champTexte ($this->entetes[$nom], 
				 $html_field_name, $valeur, $lg_visible,
				 $options['longueur']);
	    }
	    else if ($this->form_fields_type[$nom] == SELECT_FIELD) {
	      $form->champListe ($this->entetes[$nom], 
				 $html_field_name, $valeur, 1, 
				 $this->form_fields[$nom]);
	    }
	    else if ($this->form_fields_type[$nom] == CHECKBOX_FIELD) {
	      $form->champRadio ($this->entetes[$nom], 
				 $html_field_name, $valeur, 
				 $this->form_fields[$nom]);
	    }
	    else if ($this->form_fields_type[$nom] == BOOLEAN_FIELD) {
	      $form->champRadio ($this->entetes[$nom], 
				 $html_field_name, $valeur, 
				 array("Y" => "Yes", "N" => "No"));
	    }
	  }
      }
    }
  }

  // Fonction d'insertion d'une ligne. A faire: vrifier
  // que la ligne n'existe pas dj!
  function insertion ($ligne)
  {
    // Initisalisations
    $noms = $valeurs = $virgule = "";
    $messages = array();

    // Contrle avant toute mise  jour
    if (!$this->controle ($ligne, $messages))
      {
	$mess = "";
	foreach ($messages as $m) $mess.="<li>$m</li>";
	echo "<ol>$mess</ol>\n";
	return false;
      }

    // Parcours des attributs pour crer la requte
    foreach ($this->schemaTable as $nom => $options)
      {
	if (!isSet($this->auto_increment_key[$nom])) {
	  // Liste des noms d'attributs + liste des valeurs
	  $noms .= $virgule . $nom;
	  $valeurs .= $virgule . "'" . $ligne[$nom] . "'";
	  // A partir de la seconde fois, on spare par des virgules
	  $virgule= ",";
	}
      }
    $requete = "INSERT INTO $this->nomTable ($noms) VALUES ($valeurs) ";
    $this->bd->execRequete ($requete);
    $id_master = mysql_insert_id();

    $this->insertInSlave ($id_master, $ligne);

    return true;
  }

  function deleteFromSlave ($id_master, $ligne)
  {
    // Take account of the slave table if any
    if (!empty($this->slave_table)) {
      $slave_values = $ligne[$this->slave_table];
      // On dtruit les lignes existantes
      $clause = $this->slaveAccess ($ligne);
      $query = "DELETE FROM $this->slave_table WHERE $clause";
      $res = $this->bd->execRequete($query);
    }
  }

  function insertInSlave ($id_master, $ligne)
  {
    // Take account of the slave table if any
    if (!empty($this->slave_table)) {
      $slave_values = $ligne[$this->slave_table];
      
      // On fait une boucle sur le nombre de lignes possibles
      for ($i=0; $i < $this->size_slave_table; $i++) {
	$virgule=""; $noms=""; $valeurs=""; $insertion = true;
	// Parcours des attributs pour crer la requte
	foreach ($this->schema_slave as $nom => $options)
	  {
	    if (!isSet($this->auto_increment_key[$nom])) {
	      // Liste des noms d'attributs + liste des valeurs
	      $noms .= $virgule . $nom;

	      // Attention  grer les cls trangres
	      if (isSet($this->foreign_keys[$nom])) 
		$valeur = $id_master;
	      else
		$valeur = $slave_values[$nom][$i];

	      // Never insert if one value is missing (do better some day..)
	      if ($valeur == "") $insertion = false;
	      $valeurs .= "$virgule '$valeur'";
	      // A partir de la seconde fois, on spare par des virgules
	      $virgule= ",";
	    }
	  }
	if ($insertion) {
	  $requete = "INSERT INTO $this->slave_table($noms) VALUES ($valeurs)";
	  // echo "Excution de $requete<br>";
	  $this->bd->execRequete ($requete);
	}
      }
    }
  }

  // Fonction de mise  jour  d'une ligne
  function maj ($ligne)
  {
    // Initisalisations
    $listeAffectations = $virgule = "";

    // Contrle avant toute mise  jour
    if (!$this->controle ($ligne, $messages))
      {
	$mess = "";
	foreach ($messages as $m) $mess.="<li>$m</li>";
	echo "<ol>$mess</ol>\n";
	return false;
      }

    // Parcours des attributs pour crer la requte
    foreach ($this->schemaTable as $nom => $options)
      {
	// Cration de la clause WHERE
	$clauseWhere = $this->accesCle($ligne, "SQL");
	// Cration des affectations nom='valeur'
	if (!$options['cle_primaire'])
	  {
	    $listeAffectations .= $virgule . "$nom='" . $ligne[$nom] . "'";   
	    // A partir du second, on spare par des virgules 
	    $virgule= ",";
	  }
	else
	  $id_master = $ligne[$nom];
      }

    $requete = "UPDATE $this->nomTable SET $listeAffectations "
      . "WHERE $clauseWhere";
    $this->bd->execRequete ($requete);

    // Take account of the slave table
    $this->deleteFromSlave ($id_master, $ligne);
    $this->insertInSlave ($id_master, $ligne);
    return true;
  }

  // Fonction de destruction  d'une ligne
  function del ($ligne)
  {
    // On supprime le contenu de la table esclave
    if (!empty($this->slave_table)) {
      $clause = $this->slaveAccess ($ligne);
      $query = "DELETE FROM $this->slave_table WHERE $clause";
      $res = $this->bd->execRequete($query);
    } 

    // Cration de la clause WHERE
    $clauseWhere = $this->accesCle($ligne, "SQL");
    $requete = "DELETE FROM $this->nomTable WHERE $clauseWhere";
    $this->bd->execRequete ($requete);
  }

  // Cration d'un tableau gnrique
  function tableau($attributs=array())
  {
    // Cration de l'objet tableau
    $tableau = new Tableau(2, $attributs);
    $tableau->setCouleurImpaire("silver");
    $tableau->setAfficheEntete(1, false);
    $tableau->setLegende("Lines in $this->nomTable");

    // Texte des enttes
    foreach ($this->schemaTable as $nom => $options) 
      if (!isSet($this->auto_increment_key[$nom]))
	$tableau->ajoutEntete(2, $nom, $this->entetes[$nom]);

    //    $tableau->ajoutEntete(2, "action", "Action");

    // Parcours de la table
    $requete = "SELECT * FROM $this->nomTable $this->where_clause";
    if (!empty($this->order_by_clause))
      $requete .= "ORDER BY $this->order_by_clause";
    $resultat = $this->bd->execRequete ($requete);
    
    $i=0;
    while ($ligne = $this->bd->ligneSuivante ($resultat))
      {
	$i++; 
	// Cration des cellules
	foreach ($this->schemaTable as $nom => $options) 
	  {
	    if (!isSet($this->auto_increment_key[$nom])) {
	      if ($options['type'] == "time") {
		// Show only hour and minutes 
		$time = explode (":", $ligne[$nom]);
		$ligne[$nom] = $time[0] . ":" . $time[1];
	      }

	      if (isSet ($this->form_fields_type[$nom])) {
		// La valeur est rfrence par la cl externe $ligne[$nom]
		$libelle = $this->form_fields[$nom][$ligne[$nom]];
	      }
	      else
		// Attention: traitement des balises HTML avant affichage
		$libelle = htmlSpecialChars($ligne[$nom]);
	      $tableau->ajoutValeur($i, $nom, $libelle);
	    }

	  }
	
	// Cration de l'URL de modification
	$urlMod = $this->accesCle($ligne) . "&ihm_action=" . EDITER;
	$modLink = "<a href='$this->nomScript$urlMod'>modify</a>";
	$tableau->ajoutValeur($i, "Modify", $modLink);

	$urlDel = $this->accesCle($ligne) . "&ihm_action=" . DEL_BD;
	$jscript= "onClick=\"ConfirmAction"
	  . "('This will remove this tuple!?', '$this->nomScript$urlDel')\"";
	$delLink = "<a $jscript href='#'>delete</a>";
	$tableau->ajoutValeur($i, "Delete", $delLink);
      }

    // Retour de la chane contenant le tableau
    return $tableau->tableauHTML();
  }

  // Mthode permettant d'affecter un entte  un attribut
  function setEntete($nomAttr, $texte)
  {
    $this->entetes[$nomAttr] = $texte;
  }

  // Mthode permettant d'affecter un titre
  function setTitle($title)
  {    
    $this->title = $title;
  }

  // Mthode permettant d'indiquer le type d'un champ du formulaire
  function setFormField($nomAttr, $type, $params, $whereClause="")
  {
    if ($type == SELECT_FIELD)
      {
	$this->form_fields_type[$nomAttr] = SELECT_FIELD;
	// Recherche de la liste
	$tb_name = $params["tb_name"];
	$id_name = $params["id_name"];
	$name = $params["name"];
	$res = array();
	$result = $this->bd->execRequete 
	  ("SELECT $id_name, $name FROM $tb_name $whereClause ORDER BY $name");
	while ($cursor = $this->bd->ligneSuivante ($result))
	  $res[$cursor[$id_name]] = $cursor[$name];
	$this->form_fields[$nomAttr] = $res;
      }
    else if ($type == CHECKBOX_FIELD)
      {
	$this->form_fields_type[$nomAttr] = CHECKBOX_FIELD;
	// Recherche de la liste
	$this->form_fields[$nomAttr] = $params;
      }
    else if ($type == BOOLEAN_FIELD)
      {
	$this->form_fields_type[$nomAttr] = BOOLEAN_FIELD;
      }
  }

  // Fonction recherchant une ligne d'aprs sa cl
  function chercheLigne($params, $format="tableau")
  {
    // On constitue la clause WHERE
    $clauseWhere = $this->accesCle ($params, "SQL");

    // Cration et excution de la requte SQL
    $requete = "SELECT * FROM $this->nomTable WHERE $clauseWhere";
    $resultat = $this->bd->execRequete($requete);

    if ($format == "tableau") {
      $ligne = $this->bd->ligneSuivante($resultat);

      // On complte avec le contenu de la table esclave
      if (!empty($this->slave_table)) {
	$clause = $this->slaveAccess ($ligne);
	$query = "SELECT * FROM $this->slave_table WHERE $clause";
	$res = $this->bd->execRequete($query);
	while ($sl = $this->bd->ligneSuivante($res)) {
	  foreach ($sl as $nom_att => $val_att)
	    $ligne[$this->slave_table][$nom_att][] = $val_att;
	}
      }
      return $ligne;
    }
    else
      return $this->bd->objetSuivant($resultat);
  }

  // Fonction crant une interface avec saisie, mise  jour
  // et consultation
  function genererIHM ($paramsHTTP)
  {
    echo "<script language='JavaScript1.2' src='ShowWindow.js'></script>";
 
    // A-t-on demand une action?
    if (isSet($paramsHTTP['ihm_action']))
      $action = $paramsHTTP['ihm_action'];
    else 
      $action = "";

    $affichage = "";
    switch ($action)
      {
      case INS_BD:
	// On a demand une insertion
	if ($this->insertion($paramsHTTP))
	  {
	    $affichage .= "<I>Insertion: done</I>";
	    $affichage .= "<h2>Input form</h2>";
	    $affichage .= $this->formulaire(INS_BD, array());
	  }
	else{
	  $affichage .= $this->formulaire(INS_BD, $paramsHTTP);
	}
	break;
	
      case MAJ_BD:
	// On a demand une modification
	if ($this->maj($paramsHTTP))
	  $affichage .= "<I>Update: done.</I>";
	$ligne  = $this->chercheLigne ($paramsHTTP);
	$affichage .= $this->formulaire(MAJ_BD,$ligne);
	break;

      case DEL_BD:
	// On a demand une destruction
	$this->del($paramsHTTP);
	$affichage .= "<I>Delete: done.</I>";
	$affichage .= $this->formulaire(INS_BD, array());
	break;

      case EDITER:
	// On a demand l'accs  une ligne en mise  jour
	$ligne  = $this->chercheLigne ($paramsHTTP);
	$affichage .= $this->formulaire(MAJ_BD,$ligne);
	break;
	
      default:
	$affichage .= $this->formulaire(INS_BD,array());

      }
   
    // On met toujours le tableau du contenu de la table
    $affichage .= "<h2>Lines in table <I>$this->nomTable</I></h2>"
      . $this->tableau(array("BORDER" => 2));
    $affichage .= "<a href='$this->nomScript'>Add a new line</a>";
    // Retour de la page HTML
    return $affichage;
  }

  // Pour ajouter un champ cach dans le formulaire
  function addHiddenField ($name, $value)
  {
    $this->hidden_fields[$name] = $value;
  }

  // Pour ajouter une clause de tri
  function setOrderBy ($fields_list)
  {
    // The list must be SQL-compliant: field[, field], ...
    $this->order_by_clause = $fields_list;
  }

  // Pour ajouter une clause WHERE
  function setWhereClause ($where_clause)
  {
    $this->where_clause = $where_clause;
  }

  // Pour ajouter une table-esclave
  function setSlaveTable ($tbname, $foreign_keys, $nb_lines=10) {  
    $this->slave_table = $tbname;  
    $this->schema_slave = $this->bd->schemaTable($tbname);
    $this->size_slave_table = $nb_lines;
    $this->foreign_keys = $foreign_keys;
    foreach ($this->schema_slave as $nom => $options)
      $this->entetes[$nom] = $nom;
  }

  // Pour indiquer le champ auto-incrment
  function setAutoIncrementedKey ($ai_name)
  {
    $this->auto_increment_key[$ai_name]=true;
  }
}
?>