/*
 * Decompiled with CFR 0.152.
 */
package msfgui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import msfgui.MainFrame;
import msfgui.MsfException;
import msfgui.MsfguiApp;
import msfgui.MsfguiLog;
import org.jdesktop.application.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RpcConnection {
    private String rpcToken;
    private Map callCache = new HashMap();
    public static String defaultUser = "msf";
    public static String defaultPass = null;
    public static String defaultHost = "127.0.0.1";
    public static int defaultPort = 55553;
    private Socket connection;
    private OutputStream sout;
    private InputStream sin;
    private final Object lockObject = new Object();
    private String username;
    private String password;
    private String host;
    private int port;

    RpcConnection(String username, char[] password, String host, int port) throws MsfException {
        boolean haveRpcd = false;
        this.username = username;
        this.password = new String(password);
        this.host = host;
        this.port = port;
        String message = "";
        try {
            this.connection = new Socket(host, port);
            this.sout = this.connection.getOutputStream();
            this.sin = this.connection.getInputStream();
            Map results = this.exec("auth.login", new Object[]{username, this.password});
            this.rpcToken = results.get("token").toString();
            haveRpcd = results.get("result").equals("success");
        }
        catch (MsfException xre) {
            message = xre.getLocalizedMessage();
        }
        catch (IOException io) {
            message = io.getLocalizedMessage();
        }
        catch (NullPointerException nex) {
            // empty catch block
        }
        if (!haveRpcd) {
            throw new MsfException("Error connecting. " + message);
        }
        Map root = MsfguiApp.getPropertiesNode();
        root.put("username", this.username);
        root.put("password", this.password);
        root.put("host", this.host);
        root.put("port", Integer.toString(this.port));
    }

    public String toString() {
        return "RPC connection \nusername: " + this.username + "\npassword: " + this.password + "\nhost: " + this.host + "\nport: " + Integer.toString(this.port);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map exec(String methname, Object[] params) throws MsfException {
        try {
            Object object = this.lockObject;
            synchronized (object) {
                this.writeCall(methname, params);
                return (Map)this.readResp();
            }
        }
        catch (Exception ex) {
            if (!(ex instanceof MsfException)) {
                throw new MsfException("Error in call: " + ex.getLocalizedMessage(), ex);
            }
            throw (MsfException)ex;
        }
    }

    protected void writeCall(String methname, Object[] params) throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element methodCall = doc.createElement("methodCall");
        doc.appendChild(methodCall);
        Element methodName = doc.createElement("methodName");
        methodName.appendChild(doc.createTextNode(methname));
        methodCall.appendChild(methodName);
        Element paramsEl = doc.createElement("params");
        methodCall.appendChild(paramsEl);
        for (Object param : params) {
            Element paramEl = doc.createElement("param");
            paramEl.appendChild(RpcConnection.objectToNode(doc, param));
            paramsEl.appendChild(paramEl);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        TransformerFactory.newInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(bout));
        this.sout.write(bout.toByteArray());
        this.sout.write(0);
    }

    public static Node objectToNode(Document doc, Object param) {
        Element valEl = doc.createElement("value");
        if (param instanceof Map) {
            Element structEl = doc.createElement("struct");
            Iterator i$ = ((Map)param).entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry entryObj;
                Map.Entry ent = entryObj = i$.next();
                Element membEl = doc.createElement("member");
                Element nameEl = doc.createElement("name");
                nameEl.appendChild(doc.createTextNode(ent.getKey().toString()));
                membEl.appendChild(nameEl);
                membEl.appendChild(RpcConnection.objectToNode(doc, ent.getValue()));
                structEl.appendChild(membEl);
            }
            valEl.appendChild(structEl);
        } else if (param instanceof List || param instanceof Object[]) {
            Element arrayEl = doc.createElement("array");
            Element dataEl = doc.createElement("data");
            if (param instanceof Object[]) {
                for (Object obj : (Object[])param) {
                    dataEl.appendChild(RpcConnection.objectToNode(doc, obj));
                }
            } else {
                for (Object obj : (List)param) {
                    dataEl.appendChild(RpcConnection.objectToNode(doc, obj));
                }
            }
            arrayEl.appendChild(dataEl);
            valEl.appendChild(arrayEl);
        } else if (param instanceof Integer) {
            Element i4El = doc.createElement("i4");
            i4El.appendChild(doc.createTextNode(param.toString()));
            valEl.appendChild(i4El);
        } else if (param instanceof Boolean) {
            Element boolEl = doc.createElement("boolean");
            boolEl.appendChild(doc.createTextNode(param.toString()));
            valEl.appendChild(boolEl);
        } else {
            Element strEl = doc.createElement("string");
            strEl.appendChild(doc.createTextNode(param.toString()));
            valEl.appendChild(strEl);
        }
        return valEl;
    }

    protected Object readResp() throws Exception {
        ByteArrayOutputStream cache = new ByteArrayOutputStream();
        try {
            int val;
            while ((val = this.sin.read()) != 0) {
                if (val == -1) {
                    throw new MsfException("Stream died.");
                }
                cache.write(val);
            }
        }
        catch (IOException ex) {
            throw new MsfException("Error reading response.");
        }
        ByteArrayInputStream is = new ByteArrayInputStream(cache.toByteArray());
        StringBuilder sb = new StringBuilder();
        int a = is.read();
        while (a != -1) {
            if (!Character.isISOControl(a)) {
                sb.append((char)a);
            }
            a = is.read();
        }
        Document root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(sb.toString().getBytes()));
        if (!root.getFirstChild().getNodeName().equals("methodResponse")) {
            throw new MsfException("Error reading response: not a response.");
        }
        Node methResp = root.getFirstChild();
        if (methResp.getFirstChild().getNodeName().equals("fault")) {
            throw new MsfException(methResp.getFirstChild().getFirstChild().getFirstChild().getLastChild().getLastChild().getTextContent());
        }
        Node params = methResp.getFirstChild();
        if (!params.getNodeName().equals("params")) {
            throw new MsfException("Error reading response: no params.");
        }
        Node param = params.getFirstChild();
        if (!param.getNodeName().equals("param")) {
            throw new MsfException("Error reading response: no param.");
        }
        Node value = param.getFirstChild();
        if (!value.getNodeName().equals("value")) {
            throw new MsfException("Error reading response: no value.");
        }
        return RpcConnection.parseVal(value);
    }

    public static Object parseVal(Node submemb) throws MsfException {
        Node type = submemb.getFirstChild();
        String typeName = type.getNodeName();
        if (typeName.equals("string")) {
            return type.getTextContent();
        }
        if (typeName.equals("array")) {
            ArrayList<Object> arrgh = new ArrayList<Object>();
            Node data = type.getFirstChild();
            if (!data.getNodeName().equals("data")) {
                throw new MsfException("Error reading array: no data.");
            }
            for (Node val = data.getFirstChild(); val != null; val = val.getNextSibling()) {
                arrgh.add(RpcConnection.parseVal(val));
            }
            return arrgh;
        }
        if (typeName.equals("struct")) {
            HashMap<String, Object> structmembs = new HashMap<String, Object>();
            for (Node member = type.getFirstChild(); member != null; member = member.getNextSibling()) {
                if (!member.getNodeName().equals("member")) {
                    throw new MsfException("Error reading response: non struct member.");
                }
                String name = null;
                Object membValue = null;
                for (Node submember = member.getFirstChild(); submember != null; submember = submember.getNextSibling()) {
                    if (submember.getNodeName().equals("name")) {
                        name = submember.getTextContent();
                        continue;
                    }
                    if (!submember.getNodeName().equals("value")) continue;
                    membValue = RpcConnection.parseVal(submember);
                }
                structmembs.put(name, membValue);
            }
            return structmembs;
        }
        if (typeName.equals("i4")) {
            return new Integer(type.getTextContent());
        }
        if (typeName.equals("boolean")) {
            return type.getTextContent().equals("1");
        }
        if (typeName.equals("dateTime.iso8601")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
            try {
                return sdf.parse(type.getTextContent());
            }
            catch (ParseException pex) {
                return type.getTextContent();
            }
        }
        throw new MsfException("Error reading val: unknown type " + typeName);
    }

    public Object execute(String methodName, Object ... params) throws MsfException {
        MsfguiLog.defaultLog.logMethodCall(methodName, params);
        Object[] paramsNew = new Object[params.length + 1];
        paramsNew[0] = this.rpcToken;
        System.arraycopy(params, 0, paramsNew, 1, params.length);
        Object result = this.cacheExecute(methodName, paramsNew);
        MsfguiLog.defaultLog.logMethodReturn(methodName, params, result);
        return result;
    }

    private Object cacheExecute(String methodName, Object[] params) throws MsfException {
        if (methodName.equals("module.info") || methodName.equals("module.options") || methodName.equals("module.compatible_payloads")) {
            StringBuilder keysb = new StringBuilder(methodName);
            for (int i = 1; i < params.length; ++i) {
                keysb.append(params[i].toString());
            }
            String key = keysb.toString();
            Object result = this.callCache.get(key);
            if (result != null) {
                return result;
            }
            result = this.exec(methodName, params);
            this.callCache.put(key, result);
            return result;
        }
        return this.exec(methodName, params);
    }

    public static Task startRpcConn(final MainFrame mainFrame) {
        return new Task<RpcConnection, Void>(mainFrame.getApplication()){
            private RpcConnection myRpcConn;

            @Override
            protected RpcConnection doInBackground() throws Exception {
                this.setTitle("Starting new msfrpcd");
                this.setMessage("Setting up and saving parameters.");
                this.setProgress(0.0f);
                if (defaultPass == null) {
                    StringBuilder password = new StringBuilder();
                    SecureRandom secrand = new SecureRandom();
                    for (int i = 0; i < 10; ++i) {
                        password.append((char)(97 + secrand.nextInt(26)));
                    }
                    defaultPass = password.toString();
                }
                this.setMessage("Starting msfrpcd. \"msfrpcd -P " + defaultPass + " -t Basic -S -U metasploit -a 127.0.0.1\"");
                this.setProgress(0.2f);
                Process proc = null;
                try {
                    proc = MsfguiApp.startMsfProc(new String[]{"msfrpcd", "-P", defaultPass, "-t", "Basic", "-S", "-U", defaultUser, "-a", "127.0.0.1"});
                }
                catch (MsfException ex) {
                    this.setMessage("msfrpcd not found.");
                    this.setProgress(1.0f);
                    throw new MsfException("Could not find or start msfrpcd");
                }
                this.setMessage("Started msfrpcd. Waiting for initialization to finish.");
                proc.waitFor();
                this.setMessage("Connecting to new msfrpcd...");
                this.setProgress(0.7f);
                boolean connected = false;
                for (int tries = 0; tries < 1000; ++tries) {
                    try {
                        this.myRpcConn = new RpcConnection(defaultUser, defaultPass.toCharArray(), "127.0.0.1", defaultPort);
                        connected = true;
                        break;
                    }
                    catch (MsfException mex) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException iex) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (!connected) {
                    this.setMessage("Cannot connect to started msfrpcd.");
                    throw new MsfException("Cannot connect to started msfrpcd.");
                }
                return this.myRpcConn;
            }

            @Override
            protected void succeeded(RpcConnection myRpcConn) {
                mainFrame.rpcConn = myRpcConn;
                mainFrame.getModules();
            }
        };
    }
}

