#####################################################################
###	S U B V E R S I O N   T A S K S   A N D   H E L P E R S
#####################################################################

require 'rake/tasklib'

#
# Work around the inexplicable behaviour of the original RDoc::VerifyTask, which 
# errors if your coverage isn't *exactly* the threshold.
# 

# A task that can verify that the RCov coverage doesn't
# drop below a certain threshold. It should be run after
# running Spec::Rake::SpecTask.
class VerifyTask < Rake::TaskLib
	
	COVERAGE_PERCENTAGE_PATTERN = 
		%r{<tt class='coverage_code'>(\d+\.\d+)%</tt>}
	
	# Name of the task. Defaults to :verify_rcov
	attr_accessor :name

	# Path to the index.html file generated by RCov, which
	# is the file containing the total coverage.
	# Defaults to 'coverage/index.html'
	attr_accessor :index_html

	# Whether or not to output details. Defaults to true.
	attr_accessor :verbose

	# The threshold value (in percent) for coverage. If the 
	# actual coverage is not equal to this value, the task will raise an 
	# exception. 
	attr_accessor :threshold

	def initialize( name=:verify )
		@name = name
		@index_html = 'coverage/index.html'
		@verbose = true
		yield self if block_given?
		raise "Threshold must be set" if @threshold.nil?
		define
	end

	def define
		desc "Verify that rcov coverage is at least #{threshold}%"

		task @name do
			total_coverage = nil
			if match = File.read( index_html ).match( COVERAGE_PERCENTAGE_PATTERN )
				total_coverage = Float( match[1] )
			else
				raise "Couldn't find the coverage percentage in #{index_html}"
			end

			puts "Coverage: #{total_coverage}% (threshold: #{threshold}%)" if verbose
			if total_coverage < threshold
				raise "Coverage must be at least #{threshold}% but was #{total_coverage}%"
			end
		end
	end
end

# vim: set nosta noet ts=4 sw=4:
