/*

Copyright (C) 2000 - 2007 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_protocol_instance_h
#define __nd_protocol_instance_h

#include <gtk/gtk.h>

#include <nd.h>
#include <nd_protocol.h>

struct nd_proto_info
{
  GtkWidget    *proto_tab;
  GtkWidget    *proto_gui;
  GtkWidget    *proto_label;
};


LND_ProtoInfo    *nd_proto_info_new(LND_Protocol *proto, guint nesting);
void              nd_proto_info_free(LND_ProtoInfo *pinf);
ND_ProtoInfo     *nd_proto_info_get(const LND_ProtoInfo *pinf);

/**
 * nd_proto_info_field_set_state - sets the state of a protocol header field.
 * @pinf: protocol information.
 * @field: field to update.
 * @state: new state.
 *
 * This function updates the state of a header field button,
 * including GUI updates.
 */
void              nd_proto_info_field_set_state(LND_ProtoInfo *pinf,
						ND_ProtoField *field,
						ND_ProtoFieldState state);

#endif
