#if !defined(__MSP430_HEADERS_LCD_B_H__)
#define __MSP430_HEADERS_LCD_B_H__

/* lcd_b.h
 *
 * mspgcc project: MSP430 device headers
 * LCD_B
 *
 * Based on cc430x613x.h version 1.5 by Texas Instruments
 *
 * Peter A. Bigot <pab@peoplepowerco.com>
 *
 */

/* Switches:
__MSP430_HAS_LCD_B__ -- defined to indicate availability of module
__MSP430_LCD_B_BASE__ -- base address of LCD_B module
*/

#if defined(__MSP430_LCD_B_BASE__)

#define LCDBCTL0_ __MSP430_LCD_B_BASE__ + 0x00  /* LCD_B Control Register 0 */
sfrw(LCDBCTL0, LCDBCTL0_);
#define LCDBCTL0_L_ __MSP430_LCD_B_BASE__ + 0x00  
sfrb(LCDBCTL0_L, LCDBCTL0_L_);
#define LCDBCTL0_H_ __MSP430_LCD_B_BASE__ + 0x01  
sfrb(LCDBCTL0_H, LCDBCTL0_H_);
#define LCDBCTL1_ __MSP430_LCD_B_BASE__ + 0x02  /* LCD_B Control Register 1 */
sfrw(LCDBCTL1, LCDBCTL1_);
#define LCDBCTL1_L_ __MSP430_LCD_B_BASE__ + 0x02  
sfrb(LCDBCTL1_L, LCDBCTL1_L_);
#define LCDBCTL1_H_ __MSP430_LCD_B_BASE__ + 0x03  
sfrb(LCDBCTL1_H, LCDBCTL1_H_);
#define LCDBBLKCTL_ __MSP430_LCD_B_BASE__ + 0x04  /* LCD_B blinking control register */
sfrw(LCDBBLKCTL, LCDBBLKCTL_);
#define LCDBBLKCTL_L_ __MSP430_LCD_B_BASE__ + 0x04  
sfrb(LCDBBLKCTL_L, LCDBBLKCTL_L_);
#define LCDBBLKCTL_H_ __MSP430_LCD_B_BASE__ + 0x05  
sfrb(LCDBBLKCTL_H, LCDBBLKCTL_H_);
#define LCDBMEMCTL_ __MSP430_LCD_B_BASE__ + 0x06  /* LCD_B memory control register */
sfrw(LCDBMEMCTL, LCDBMEMCTL_);
#define LCDBMEMCTL_L_ __MSP430_LCD_B_BASE__ + 0x06  
sfrb(LCDBMEMCTL_L, LCDBMEMCTL_L_);
#define LCDBMEMCTL_H_ __MSP430_LCD_B_BASE__ + 0x07  
sfrb(LCDBMEMCTL_H, LCDBMEMCTL_H_);
#define LCDBVCTL_ __MSP430_LCD_B_BASE__ + 0x08  /* LCD_B Voltage Control Register */
sfrw(LCDBVCTL, LCDBVCTL_);
#define LCDBVCTL_L_ __MSP430_LCD_B_BASE__ + 0x08  
sfrb(LCDBVCTL_L, LCDBVCTL_L_);
#define LCDBVCTL_H_ __MSP430_LCD_B_BASE__ + 0x09  
sfrb(LCDBVCTL_H, LCDBVCTL_H_);
#define LCDBPCTL0_ __MSP430_LCD_B_BASE__ + 0x0a  /* LCD_B Port Control Register 0 */
sfrw(LCDBPCTL0, LCDBPCTL0_);
#define LCDBPCTL0_L_ __MSP430_LCD_B_BASE__ + 0x0a  
sfrb(LCDBPCTL0_L, LCDBPCTL0_L_);
#define LCDBPCTL0_H_ __MSP430_LCD_B_BASE__ + 0x0b  
sfrb(LCDBPCTL0_H, LCDBPCTL0_H_);
#define LCDBPCTL1_ __MSP430_LCD_B_BASE__ + 0x0c  /* LCD_B Port Control Register 1 */
sfrw(LCDBPCTL1, LCDBPCTL1_);
#define LCDBPCTL1_L_ __MSP430_LCD_B_BASE__ + 0x0c  
sfrb(LCDBPCTL1_L, LCDBPCTL1_L_);
#define LCDBPCTL1_H_ __MSP430_LCD_B_BASE__ + 0x0d  
sfrb(LCDBPCTL1_H, LCDBPCTL1_H_);
#define LCDBPCTL2_ __MSP430_LCD_B_BASE__ + 0x0e  /* LCD_B Port Control Register 2 */
sfrw(LCDBPCTL2, LCDBPCTL2_);
#define LCDBPCTL2_L_ __MSP430_LCD_B_BASE__ + 0x0e  
sfrb(LCDBPCTL2_L, LCDBPCTL2_L_);
#define LCDBPCTL2_H_ __MSP430_LCD_B_BASE__ + 0x0f  
sfrb(LCDBPCTL2_H, LCDBPCTL2_H_);
#define LCDBPCTL3_ __MSP430_LCD_B_BASE__ + 0x10  /* LCD_B Port Control Register 3 */
sfrw(LCDBPCTL3, LCDBPCTL3_);
#define LCDBPCTL3_L_ __MSP430_LCD_B_BASE__ + 0x10  
sfrb(LCDBPCTL3_L, LCDBPCTL3_L_);
#define LCDBPCTL3_H_ __MSP430_LCD_B_BASE__ + 0x11  
sfrb(LCDBPCTL3_H, LCDBPCTL3_H_);
#define LCDBCPCTL_ __MSP430_LCD_B_BASE__ + 0x12  /* LCD_B Charge Pump Control Register 3 */
sfrw(LCDBCPCTL, LCDBCPCTL_);
#define LCDBCPCTL_L_ __MSP430_LCD_B_BASE__ + 0x12  
sfrb(LCDBCPCTL_L, LCDBCPCTL_L_);
#define LCDBCPCTL_H_ __MSP430_LCD_B_BASE__ + 0x13  
sfrb(LCDBCPCTL_H, LCDBCPCTL_H_);
#define LCDBIV_ __MSP430_LCD_B_BASE__ + 0x1e  /* LCD_B Interrupt Vector Register */
sfrw(LCDBIV, LCDBIV_);

// LCDBCTL0
#define LCDON                  (0x0001)       /* LCD_B LCD On */
#define LCDSON                 (0x0004)       /* LCD_B LCD Segments On */
#define LCDMX0                 (0x0008)       /* LCD_B Mux Rate Bit: 0 */
#define LCDMX1                 (0x0010)       /* LCD_B Mux Rate Bit: 1 */
//#define RESERVED            (0x0020)  /* LCD_B RESERVED */
//#define RESERVED            (0x0040)  /* LCD_B RESERVED */
#define LCDSSEL                (0x0080)       /* LCD_B Clock Select */
#define LCDPRE0                (0x0100)       /* LCD_B LCD frequency pre-scaler Bit: 0 */
#define LCDPRE1                (0x0200)       /* LCD_B LCD frequency pre-scaler Bit: 1 */
#define LCDPRE2                (0x0400)       /* LCD_B LCD frequency pre-scaler Bit: 2 */
#define LCDDIV0                (0x0800)       /* LCD_B LCD frequency divider Bit: 0 */
#define LCDDIV1                (0x1000)       /* LCD_B LCD frequency divider Bit: 1 */
#define LCDDIV2                (0x2000)       /* LCD_B LCD frequency divider Bit: 2 */
#define LCDDIV3                (0x4000)       /* LCD_B LCD frequency divider Bit: 3 */
#define LCDDIV4                (0x8000)       /* LCD_B LCD frequency divider Bit: 4 */

// LCDBCTL0
#define LCDON_L                (0x0001)       /* LCD_B LCD On */
#define LCDSON_L               (0x0004)       /* LCD_B LCD Segments On */
#define LCDMX0_L               (0x0008)       /* LCD_B Mux Rate Bit: 0 */
#define LCDMX1_L               (0x0010)       /* LCD_B Mux Rate Bit: 1 */
//#define RESERVED            (0x0020)  /* LCD_B RESERVED */
//#define RESERVED            (0x0040)  /* LCD_B RESERVED */
#define LCDSSEL_L              (0x0080)       /* LCD_B Clock Select */

// LCDBCTL0
//#define RESERVED            (0x0020)  /* LCD_B RESERVED */
//#define RESERVED            (0x0040)  /* LCD_B RESERVED */
#define LCDPRE0_H              (0x0001)       /* LCD_B LCD frequency pre-scaler Bit: 0 */
#define LCDPRE1_H              (0x0002)       /* LCD_B LCD frequency pre-scaler Bit: 1 */
#define LCDPRE2_H              (0x0004)       /* LCD_B LCD frequency pre-scaler Bit: 2 */
#define LCDDIV0_H              (0x0008)       /* LCD_B LCD frequency divider Bit: 0 */
#define LCDDIV1_H              (0x0010)       /* LCD_B LCD frequency divider Bit: 1 */
#define LCDDIV2_H              (0x0020)       /* LCD_B LCD frequency divider Bit: 2 */
#define LCDDIV3_H              (0x0040)       /* LCD_B LCD frequency divider Bit: 3 */
#define LCDDIV4_H              (0x0080)       /* LCD_B LCD frequency divider Bit: 4 */

#define LCDPRE_0               (0x0000)       /* LCD_B LCD frequency pre-scaler: /1 */
#define LCDPRE_1               (0x0100)       /* LCD_B LCD frequency pre-scaler: /2 */
#define LCDPRE_2               (0x0200)       /* LCD_B LCD frequency pre-scaler: /4 */
#define LCDPRE_3               (0x0300)       /* LCD_B LCD frequency pre-scaler: /8 */
#define LCDPRE_4               (0x0400)       /* LCD_B LCD frequency pre-scaler: /16 */
#define LCDPRE_5               (0x0500)       /* LCD_B LCD frequency pre-scaler: /32 */
#define LCDPRE__1              (0x0000)       /* LCD_B LCD frequency pre-scaler: /1 */
#define LCDPRE__2              (0x0100)       /* LCD_B LCD frequency pre-scaler: /2 */
#define LCDPRE__4              (0x0200)       /* LCD_B LCD frequency pre-scaler: /4 */
#define LCDPRE__8              (0x0300)       /* LCD_B LCD frequency pre-scaler: /8 */
#define LCDPRE__16             (0x0400)       /* LCD_B LCD frequency pre-scaler: /16 */
#define LCDPRE__32             (0x0500)       /* LCD_B LCD frequency pre-scaler: /32 */

#define LCDDIV_0               (0x0000)       /* LCD_B LCD frequency divider: /1 */
#define LCDDIV_1               (0x0800)       /* LCD_B LCD frequency divider: /2 */
#define LCDDIV_2               (0x1000)       /* LCD_B LCD frequency divider: /3 */
#define LCDDIV_3               (0x1800)       /* LCD_B LCD frequency divider: /4 */
#define LCDDIV_4               (0x2000)       /* LCD_B LCD frequency divider: /5 */
#define LCDDIV_5               (0x2800)       /* LCD_B LCD frequency divider: /6 */
#define LCDDIV_6               (0x3000)       /* LCD_B LCD frequency divider: /7 */
#define LCDDIV_7               (0x3800)       /* LCD_B LCD frequency divider: /8 */
#define LCDDIV_8               (0x4000)       /* LCD_B LCD frequency divider: /9 */
#define LCDDIV_9               (0x4800)       /* LCD_B LCD frequency divider: /10 */
#define LCDDIV_10              (0x5000)       /* LCD_B LCD frequency divider: /11 */
#define LCDDIV_11              (0x5800)       /* LCD_B LCD frequency divider: /12 */
#define LCDDIV_12              (0x6000)       /* LCD_B LCD frequency divider: /13 */
#define LCDDIV_13              (0x6800)       /* LCD_B LCD frequency divider: /14 */
#define LCDDIV_14              (0x7000)       /* LCD_B LCD frequency divider: /15 */
#define LCDDIV_15              (0x7800)       /* LCD_B LCD frequency divider: /16 */
#define LCDDIV_16              (0x8000)       /* LCD_B LCD frequency divider: /17 */
#define LCDDIV_17              (0x8800)       /* LCD_B LCD frequency divider: /18 */
#define LCDDIV_18              (0x9000)       /* LCD_B LCD frequency divider: /19 */
#define LCDDIV_19              (0x9800)       /* LCD_B LCD frequency divider: /20 */
#define LCDDIV_20              (0xA000)       /* LCD_B LCD frequency divider: /21 */
#define LCDDIV_21              (0xA800)       /* LCD_B LCD frequency divider: /22 */
#define LCDDIV_22              (0xB000)       /* LCD_B LCD frequency divider: /23 */
#define LCDDIV_23              (0xB800)       /* LCD_B LCD frequency divider: /24 */
#define LCDDIV_24              (0xC000)       /* LCD_B LCD frequency divider: /25 */
#define LCDDIV_25              (0xC800)       /* LCD_B LCD frequency divider: /26 */
#define LCDDIV_26              (0xD000)       /* LCD_B LCD frequency divider: /27 */
#define LCDDIV_27              (0xD800)       /* LCD_B LCD frequency divider: /28 */
#define LCDDIV_28              (0xE000)       /* LCD_B LCD frequency divider: /29 */
#define LCDDIV_29              (0xE800)       /* LCD_B LCD frequency divider: /30 */
#define LCDDIV_30              (0xF000)       /* LCD_B LCD frequency divider: /31 */
#define LCDDIV_31              (0xF800)       /* LCD_B LCD frequency divider: /32 */
#define LCDDIV__1              (0x0000)       /* LCD_B LCD frequency divider: /1 */
#define LCDDIV__2              (0x0800)       /* LCD_B LCD frequency divider: /2 */
#define LCDDIV__3              (0x1000)       /* LCD_B LCD frequency divider: /3 */
#define LCDDIV__4              (0x1800)       /* LCD_B LCD frequency divider: /4 */
#define LCDDIV__5              (0x2000)       /* LCD_B LCD frequency divider: /5 */
#define LCDDIV__6              (0x2800)       /* LCD_B LCD frequency divider: /6 */
#define LCDDIV__7              (0x3000)       /* LCD_B LCD frequency divider: /7 */
#define LCDDIV__8              (0x3800)       /* LCD_B LCD frequency divider: /8 */
#define LCDDIV__9              (0x4000)       /* LCD_B LCD frequency divider: /9 */
#define LCDDIV__10             (0x4800)       /* LCD_B LCD frequency divider: /10 */
#define LCDDIV__11             (0x5000)       /* LCD_B LCD frequency divider: /11 */
#define LCDDIV__12             (0x5800)       /* LCD_B LCD frequency divider: /12 */
#define LCDDIV__13             (0x6000)       /* LCD_B LCD frequency divider: /13 */
#define LCDDIV__14             (0x6800)       /* LCD_B LCD frequency divider: /14 */
#define LCDDIV__15             (0x7000)       /* LCD_B LCD frequency divider: /15 */
#define LCDDIV__16             (0x7800)       /* LCD_B LCD frequency divider: /16 */
#define LCDDIV__17             (0x8000)       /* LCD_B LCD frequency divider: /17 */
#define LCDDIV__18             (0x8800)       /* LCD_B LCD frequency divider: /18 */
#define LCDDIV__19             (0x9000)       /* LCD_B LCD frequency divider: /19 */
#define LCDDIV__20             (0x9800)       /* LCD_B LCD frequency divider: /20 */
#define LCDDIV__21             (0xA000)       /* LCD_B LCD frequency divider: /21 */
#define LCDDIV__22             (0xA800)       /* LCD_B LCD frequency divider: /22 */
#define LCDDIV__23             (0xB000)       /* LCD_B LCD frequency divider: /23 */
#define LCDDIV__24             (0xB800)       /* LCD_B LCD frequency divider: /24 */
#define LCDDIV__25             (0xC000)       /* LCD_B LCD frequency divider: /25 */
#define LCDDIV__26             (0xC800)       /* LCD_B LCD frequency divider: /26 */
#define LCDDIV__27             (0xD000)       /* LCD_B LCD frequency divider: /27 */
#define LCDDIV__28             (0xD800)       /* LCD_B LCD frequency divider: /28 */
#define LCDDIV__29             (0xE000)       /* LCD_B LCD frequency divider: /29 */
#define LCDDIV__30             (0xE800)       /* LCD_B LCD frequency divider: /30 */
#define LCDDIV__31             (0xF000)       /* LCD_B LCD frequency divider: /31 */
#define LCDDIV__32             (0xF800)       /* LCD_B LCD frequency divider: /32 */

/* Display modes coded with Bits 2-4 */
#define LCDSTATIC              (LCDSON)
#define LCD2MUX                (LCDMX0+LCDSON)
#define LCD3MUX                (LCDMX1+LCDSON)
#define LCD4MUX                (LCDMX1+LCDMX0+LCDSON)

// LCDBCTL1
#define LCDFRMIFG              (0x0001)       /* LCD_B LCD frame interrupt flag */
#define LCDBLKOFFIFG           (0x0002)       /* LCD_B LCD blinking off interrupt flag, */
#define LCDBLKONIFG            (0x0004)       /* LCD_B LCD blinking on interrupt flag, */
#define LCDNOCAPIFG            (0x0008)       /* LCD_B No cpacitance connected interrupt flag */
#define LCDFRMIE               (0x0100)       /* LCD_B LCD frame interrupt enable */
#define LCDBLKOFFIE            (0x0200)       /* LCD_B LCD blinking off interrupt flag, */
#define LCDBLKONIE             (0x0400)       /* LCD_B LCD blinking on interrupt flag, */
#define LCDNOCAPIE             (0x0800)       /* LCD_B No cpacitance connected interrupt enable */

// LCDBCTL1
#define LCDFRMIFG_L            (0x0001)       /* LCD_B LCD frame interrupt flag */
#define LCDBLKOFFIFG_L         (0x0002)       /* LCD_B LCD blinking off interrupt flag, */
#define LCDBLKONIFG_L          (0x0004)       /* LCD_B LCD blinking on interrupt flag, */
#define LCDNOCAPIFG_L          (0x0008)       /* LCD_B No cpacitance connected interrupt flag */

// LCDBCTL1
#define LCDFRMIE_H             (0x0001)       /* LCD_B LCD frame interrupt enable */
#define LCDBLKOFFIE_H          (0x0002)       /* LCD_B LCD blinking off interrupt flag, */
#define LCDBLKONIE_H           (0x0004)       /* LCD_B LCD blinking on interrupt flag, */
#define LCDNOCAPIE_H           (0x0008)       /* LCD_B No cpacitance connected interrupt enable */

// LCDBBLKCTL
#define LCDBLKMOD0             (0x0001)       /* LCD_B Blinking mode Bit: 0 */
#define LCDBLKMOD1             (0x0002)       /* LCD_B Blinking mode Bit: 1 */
#define LCDBLKPRE0             (0x0004)       /* LCD_B Clock pre-scaler for blinking frequency Bit: 0 */
#define LCDBLKPRE1             (0x0008)       /* LCD_B Clock pre-scaler for blinking frequency Bit: 1 */
#define LCDBLKPRE2             (0x0010)       /* LCD_B Clock pre-scaler for blinking frequency Bit: 2 */
#define LCDBLKDIV0             (0x0020)       /* LCD_B Clock divider for blinking frequency Bit: 0 */
#define LCDBLKDIV1             (0x0040)       /* LCD_B Clock divider for blinking frequency Bit: 1 */
#define LCDBLKDIV2             (0x0080)       /* LCD_B Clock divider for blinking frequency Bit: 2 */

// LCDBBLKCTL
#define LCDBLKMOD0_L           (0x0001)       /* LCD_B Blinking mode Bit: 0 */
#define LCDBLKMOD1_L           (0x0002)       /* LCD_B Blinking mode Bit: 1 */
#define LCDBLKPRE0_L           (0x0004)       /* LCD_B Clock pre-scaler for blinking frequency Bit: 0 */
#define LCDBLKPRE1_L           (0x0008)       /* LCD_B Clock pre-scaler for blinking frequency Bit: 1 */
#define LCDBLKPRE2_L           (0x0010)       /* LCD_B Clock pre-scaler for blinking frequency Bit: 2 */
#define LCDBLKDIV0_L           (0x0020)       /* LCD_B Clock divider for blinking frequency Bit: 0 */
#define LCDBLKDIV1_L           (0x0040)       /* LCD_B Clock divider for blinking frequency Bit: 1 */
#define LCDBLKDIV2_L           (0x0080)       /* LCD_B Clock divider for blinking frequency Bit: 2 */

// LCDBBLKCTL

#define LCDBLKMOD_0            (0x0000)       /* LCD_B Blinking mode: Off */
#define LCDBLKMOD_1            (0x0001)       /* LCD_B Blinking mode: Individual */
#define LCDBLKMOD_2            (0x0002)       /* LCD_B Blinking mode: All */
#define LCDBLKMOD_3            (0x0003)       /* LCD_B Blinking mode: Switching */

// LCDBMEMCTL
#define LCDDISP                (0x0001)       /* LCD_B LCD memory registers for display */
#define LCDCLRM                (0x0002)       /* LCD_B Clear LCD memory */
#define LCDCLRBM               (0x0004)       /* LCD_B Clear LCD blinking memory */

// LCDBMEMCTL
#define LCDDISP_L              (0x0001)       /* LCD_B LCD memory registers for display */
#define LCDCLRM_L              (0x0002)       /* LCD_B Clear LCD memory */
#define LCDCLRBM_L             (0x0004)       /* LCD_B Clear LCD blinking memory */

// LCDBMEMCTL

// LCDBVCTL
#define LCD2B                  (0x0001)       /* Selects 1/2 bias. */
#define VLCDREF0               (0x0002)       /* Selects reference voltage for regulated charge pump: 0 */
#define VLCDREF1               (0x0004)       /* Selects reference voltage for regulated charge pump: 1 */
#define LCDCPEN                (0x0008)       /* LCD Voltage Charge Pump Enable. */
#define VLCDEXT                (0x0010)       /* Select external source for VLCD. */
#define LCDEXTBIAS             (0x0020)       /* V2 - V4 voltage select. */
#define R03EXT                 (0x0040)       /* Selects external connections for LCD mid voltages. */
#define LCDREXT                (0x0080)       /* Selects external connection for lowest LCD voltage. */
#define VLCD0                  (0x0200)       /* VLCD select: 0 */
#define VLCD1                  (0x0400)       /* VLCD select: 1 */
#define VLCD2                  (0x0800)       /* VLCD select: 2 */
#define VLCD3                  (0x1000)       /* VLCD select: 3 */

// LCDBVCTL
#define LCD2B_L                (0x0001)       /* Selects 1/2 bias. */
#define VLCDREF0_L             (0x0002)       /* Selects reference voltage for regulated charge pump: 0 */
#define VLCDREF1_L             (0x0004)       /* Selects reference voltage for regulated charge pump: 1 */
#define LCDCPEN_L              (0x0008)       /* LCD Voltage Charge Pump Enable. */
#define VLCDEXT_L              (0x0010)       /* Select external source for VLCD. */
#define LCDEXTBIAS_L           (0x0020)       /* V2 - V4 voltage select. */
#define R03EXT_L               (0x0040)       /* Selects external connections for LCD mid voltages. */
#define LCDREXT_L              (0x0080)       /* Selects external connection for lowest LCD voltage. */

// LCDBVCTL
#define VLCD0_H                (0x0002)       /* VLCD select: 0 */
#define VLCD1_H                (0x0004)       /* VLCD select: 1 */
#define VLCD2_H                (0x0008)       /* VLCD select: 2 */
#define VLCD3_H                (0x0010)       /* VLCD select: 3 */

/* Reference voltage source select for the regulated charge pump */
#define VLCDREF_0              (0<<1)         /* Internal */
#define VLCDREF_1              (1<<1)         /* External */
#define VLCDREF_2              (2<<1)         /* Reserved */
#define VLCDREF_3              (3<<1)         /* Reserved */

/* Charge pump voltage selections */
#define VLCD_0                 (0<<9)         /* Charge pump disabled */
#define VLCD_1                 (1<<9)         /* VLCD = 2.60V */
#define VLCD_2                 (2<<9)         /* VLCD = 2.66V */
#define VLCD_3                 (3<<9)         /* VLCD = 2.72V */
#define VLCD_4                 (4<<9)         /* VLCD = 2.78V */
#define VLCD_5                 (5<<9)         /* VLCD = 2.84V */
#define VLCD_6                 (6<<9)         /* VLCD = 2.90V */
#define VLCD_7                 (7<<9)         /* VLCD = 2.96V */
#define VLCD_8                 (8<<9)         /* VLCD = 3.02V */
#define VLCD_9                 (9<<9)         /* VLCD = 3.08V */
#define VLCD_10                (10<<9)        /* VLCD = 3.14V */
#define VLCD_11                (11<<9)        /* VLCD = 3.20V */
#define VLCD_12                (12<<9)        /* VLCD = 3.26V */
#define VLCD_13                (12<<9)        /* VLCD = 3.32V */
#define VLCD_14                (13<<9)        /* VLCD = 3.38V */
#define VLCD_15                (15<<9)        /* VLCD = 3.44V */

#define VLCD_DISABLED          (0<<9)         /* Charge pump disabled */
#define VLCD_2_60              (1<<9)         /* VLCD = 2.60V */
#define VLCD_2_66              (2<<9)         /* VLCD = 2.66V */
#define VLCD_2_72              (3<<9)         /* VLCD = 2.72V */
#define VLCD_2_78              (4<<9)         /* VLCD = 2.78V */
#define VLCD_2_84              (5<<9)         /* VLCD = 2.84V */
#define VLCD_2_90              (6<<9)         /* VLCD = 2.90V */
#define VLCD_2_96              (7<<9)         /* VLCD = 2.96V */
#define VLCD_3_02              (8<<9)         /* VLCD = 3.02V */
#define VLCD_3_08              (9<<9)         /* VLCD = 3.08V */
#define VLCD_3_14              (10<<9)        /* VLCD = 3.14V */
#define VLCD_3_20              (11<<9)        /* VLCD = 3.20V */
#define VLCD_3_26              (12<<9)        /* VLCD = 3.26V */
#define VLCD_3_32              (12<<9)        /* VLCD = 3.32V */
#define VLCD_3_38              (13<<9)        /* VLCD = 3.38V */
#define VLCD_3_44              (15<<9)        /* VLCD = 3.44V */

// LCDBPCTL0
#define LCDS0                  (0x0001)       /* LCD Segment  0 enable. */
#define LCDS1                  (0x0002)       /* LCD Segment  1 enable. */
#define LCDS2                  (0x0004)       /* LCD Segment  2 enable. */
#define LCDS3                  (0x0008)       /* LCD Segment  3 enable. */
#define LCDS4                  (0x0010)       /* LCD Segment  4 enable. */
#define LCDS5                  (0x0020)       /* LCD Segment  5 enable. */
#define LCDS6                  (0x0040)       /* LCD Segment  6 enable. */
#define LCDS7                  (0x0080)       /* LCD Segment  7 enable. */
#define LCDS8                  (0x0100)       /* LCD Segment  8 enable. */
#define LCDS9                  (0x0200)       /* LCD Segment  9 enable. */
#define LCDS10                 (0x0400)       /* LCD Segment 10 enable. */
#define LCDS11                 (0x0800)       /* LCD Segment 11 enable. */
#define LCDS12                 (0x1000)       /* LCD Segment 12 enable. */
#define LCDS13                 (0x2000)       /* LCD Segment 13 enable. */
#define LCDS14                 (0x4000)       /* LCD Segment 14 enable. */
#define LCDS15                 (0x8000)       /* LCD Segment 15 enable. */

// LCDBPCTL0
#define LCDS0_L                (0x0001)       /* LCD Segment  0 enable. */
#define LCDS1_L                (0x0002)       /* LCD Segment  1 enable. */
#define LCDS2_L                (0x0004)       /* LCD Segment  2 enable. */
#define LCDS3_L                (0x0008)       /* LCD Segment  3 enable. */
#define LCDS4_L                (0x0010)       /* LCD Segment  4 enable. */
#define LCDS5_L                (0x0020)       /* LCD Segment  5 enable. */
#define LCDS6_L                (0x0040)       /* LCD Segment  6 enable. */
#define LCDS7_L                (0x0080)       /* LCD Segment  7 enable. */

// LCDBPCTL0
#define LCDS8_H                (0x0001)       /* LCD Segment  8 enable. */
#define LCDS9_H                (0x0002)       /* LCD Segment  9 enable. */
#define LCDS10_H               (0x0004)       /* LCD Segment 10 enable. */
#define LCDS11_H               (0x0008)       /* LCD Segment 11 enable. */
#define LCDS12_H               (0x0010)       /* LCD Segment 12 enable. */
#define LCDS13_H               (0x0020)       /* LCD Segment 13 enable. */
#define LCDS14_H               (0x0040)       /* LCD Segment 14 enable. */
#define LCDS15_H               (0x0080)       /* LCD Segment 15 enable. */

// LCDBPCTL1
#define LCDS16                 (0x0001)       /* LCD Segment 16 enable. */
#define LCDS17                 (0x0002)       /* LCD Segment 17 enable. */
#define LCDS18                 (0x0004)       /* LCD Segment 18 enable. */
#define LCDS19                 (0x0008)       /* LCD Segment 19 enable. */
#define LCDS20                 (0x0010)       /* LCD Segment 20 enable. */
#define LCDS21                 (0x0020)       /* LCD Segment 21 enable. */
#define LCDS22                 (0x0040)       /* LCD Segment 22 enable. */
#define LCDS23                 (0x0080)       /* LCD Segment 23 enable. */
#define LCDS24                 (0x0100)       /* LCD Segment 24 enable. */
#define LCDS25                 (0x0200)       /* LCD Segment 25 enable. */
#define LCDS26                 (0x0400)       /* LCD Segment 26 enable. */
#define LCDS27                 (0x0800)       /* LCD Segment 27 enable. */
#define LCDS28                 (0x1000)       /* LCD Segment 28 enable. */
#define LCDS29                 (0x2000)       /* LCD Segment 29 enable. */
#define LCDS30                 (0x4000)       /* LCD Segment 30 enable. */
#define LCDS31                 (0x8000)       /* LCD Segment 31 enable. */

// LCDBPCTL1
#define LCDS16_L               (0x0001)       /* LCD Segment 16 enable. */
#define LCDS17_L               (0x0002)       /* LCD Segment 17 enable. */
#define LCDS18_L               (0x0004)       /* LCD Segment 18 enable. */
#define LCDS19_L               (0x0008)       /* LCD Segment 19 enable. */
#define LCDS20_L               (0x0010)       /* LCD Segment 20 enable. */
#define LCDS21_L               (0x0020)       /* LCD Segment 21 enable. */
#define LCDS22_L               (0x0040)       /* LCD Segment 22 enable. */
#define LCDS23_L               (0x0080)       /* LCD Segment 23 enable. */

// LCDBPCTL1
#define LCDS24_H               (0x0001)       /* LCD Segment 24 enable. */
#define LCDS25_H               (0x0002)       /* LCD Segment 25 enable. */
#define LCDS26_H               (0x0004)       /* LCD Segment 26 enable. */
#define LCDS27_H               (0x0008)       /* LCD Segment 27 enable. */
#define LCDS28_H               (0x0010)       /* LCD Segment 28 enable. */
#define LCDS29_H               (0x0020)       /* LCD Segment 29 enable. */
#define LCDS30_H               (0x0040)       /* LCD Segment 30 enable. */
#define LCDS31_H               (0x0080)       /* LCD Segment 31 enable. */

// LCDBPCTL2
#define LCDS32                 (0x0001)       /* LCD Segment 32 enable. */
#define LCDS33                 (0x0002)       /* LCD Segment 33 enable. */
#define LCDS34                 (0x0004)       /* LCD Segment 34 enable. */
#define LCDS35                 (0x0008)       /* LCD Segment 35 enable. */
#define LCDS36                 (0x0010)       /* LCD Segment 36 enable. */
#define LCDS37                 (0x0020)       /* LCD Segment 37 enable. */
#define LCDS38                 (0x0040)       /* LCD Segment 38 enable. */
#define LCDS39                 (0x0080)       /* LCD Segment 39 enable. */
#define LCDS40                 (0x0100)       /* LCD Segment 40 enable. */
#define LCDS41                 (0x0200)       /* LCD Segment 41 enable. */
#define LCDS42                 (0x0400)       /* LCD Segment 42 enable. */
#define LCDS43                 (0x0800)       /* LCD Segment 43 enable. */
#define LCDS44                 (0x1000)       /* LCD Segment 44 enable. */
#define LCDS45                 (0x2000)       /* LCD Segment 45 enable. */
#define LCDS46                 (0x4000)       /* LCD Segment 46 enable. */
#define LCDS47                 (0x8000)       /* LCD Segment 47 enable. */

// LCDBPCTL2
#define LCDS32_L               (0x0001)       /* LCD Segment 32 enable. */
#define LCDS33_L               (0x0002)       /* LCD Segment 33 enable. */
#define LCDS34_L               (0x0004)       /* LCD Segment 34 enable. */
#define LCDS35_L               (0x0008)       /* LCD Segment 35 enable. */
#define LCDS36_L               (0x0010)       /* LCD Segment 36 enable. */
#define LCDS37_L               (0x0020)       /* LCD Segment 37 enable. */
#define LCDS38_L               (0x0040)       /* LCD Segment 38 enable. */
#define LCDS39_L               (0x0080)       /* LCD Segment 39 enable. */

// LCDBPCTL2
#define LCDS40_H               (0x0001)       /* LCD Segment 40 enable. */
#define LCDS41_H               (0x0002)       /* LCD Segment 41 enable. */
#define LCDS42_H               (0x0004)       /* LCD Segment 42 enable. */
#define LCDS43_H               (0x0008)       /* LCD Segment 43 enable. */
#define LCDS44_H               (0x0010)       /* LCD Segment 44 enable. */
#define LCDS45_H               (0x0020)       /* LCD Segment 45 enable. */
#define LCDS46_H               (0x0040)       /* LCD Segment 46 enable. */
#define LCDS47_H               (0x0080)       /* LCD Segment 47 enable. */

// LCDBPCTL3
#define LCDS48                 (0x0001)       /* LCD Segment 48 enable. */
#define LCDS49                 (0x0002)       /* LCD Segment 49 enable. */
#define LCDS50                 (0x0004)       /* LCD Segment 50 enable. */

// LCDBPCTL3
#define LCDS48_L               (0x0001)       /* LCD Segment 48 enable. */
#define LCDS49_L               (0x0002)       /* LCD Segment 49 enable. */
#define LCDS50_L               (0x0004)       /* LCD Segment 50 enable. */

// LCDBPCTL3

// LCDBCPCTL
#define LCDCPDIS0              (0x0001)       /* LCD charge pump disable */
#define LCDCPDIS1              (0x0002)       /* LCD charge pump disable */
#define LCDCPDIS2              (0x0004)       /* LCD charge pump disable */
#define LCDCPDIS3              (0x0008)       /* LCD charge pump disable */
#define LCDCPDIS4              (0x0010)       /* LCD charge pump disable */
#define LCDCPDIS5              (0x0020)       /* LCD charge pump disable */
#define LCDCPDIS6              (0x0040)       /* LCD charge pump disable */
#define LCDCPDIS7              (0x0080)       /* LCD charge pump disable */
#define LCDCPCLKSYNC           (0x8000)       /* LCD charge pump clock synchronization */

// LCDBCPCTL
#define LCDCPDIS0_L            (0x0001)       /* LCD charge pump disable */
#define LCDCPDIS1_L            (0x0002)       /* LCD charge pump disable */
#define LCDCPDIS2_L            (0x0004)       /* LCD charge pump disable */
#define LCDCPDIS3_L            (0x0008)       /* LCD charge pump disable */
#define LCDCPDIS4_L            (0x0010)       /* LCD charge pump disable */
#define LCDCPDIS5_L            (0x0020)       /* LCD charge pump disable */
#define LCDCPDIS6_L            (0x0040)       /* LCD charge pump disable */
#define LCDCPDIS7_L            (0x0080)       /* LCD charge pump disable */

// LCDBCPCTL
#define LCDCPCLKSYNC_H         (0x0080)       /* LCD charge pump clock synchronization */

#define LCDM1_ __MSP430_LCD_B_BASE__ + 0x20  /* LCD Memory 1 */
sfrb(LCDM1, LCDM1_);
#define LCDMEM_                LCDM1          /* LCD Memory */
#ifdef __ASM_HEADER__
#define LCDMEM                 LCDM1          /* LCD Memory (for assembler) */
#else
#define LCDMEM                 ((volatile char*)(LCDM1_)) /* LCD Memory (for C) */
#endif
#define LCDM2_ __MSP430_LCD_B_BASE__ + 0x21  /* LCD Memory 2 */
sfrb(LCDM2, LCDM2_);
#define LCDM3_ __MSP430_LCD_B_BASE__ + 0x22  /* LCD Memory 3 */
sfrb(LCDM3, LCDM3_);
#define LCDM4_ __MSP430_LCD_B_BASE__ + 0x23  /* LCD Memory 4 */
sfrb(LCDM4, LCDM4_);
#define LCDM5_ __MSP430_LCD_B_BASE__ + 0x24  /* LCD Memory 5 */
sfrb(LCDM5, LCDM5_);
#define LCDM6_ __MSP430_LCD_B_BASE__ + 0x25  /* LCD Memory 6 */
sfrb(LCDM6, LCDM6_);
#define LCDM7_ __MSP430_LCD_B_BASE__ + 0x26  /* LCD Memory 7 */
sfrb(LCDM7, LCDM7_);
#define LCDM8_ __MSP430_LCD_B_BASE__ + 0x27  /* LCD Memory 8 */
sfrb(LCDM8, LCDM8_);
#define LCDM9_ __MSP430_LCD_B_BASE__ + 0x28  /* LCD Memory 9 */
sfrb(LCDM9, LCDM9_);
#define LCDM10_ __MSP430_LCD_B_BASE__ + 0x29  /* LCD Memory 10 */
sfrb(LCDM10, LCDM10_);
#define LCDM11_ __MSP430_LCD_B_BASE__ + 0x2a  /* LCD Memory 11 */
sfrb(LCDM11, LCDM11_);
#define LCDM12_ __MSP430_LCD_B_BASE__ + 0x2b  /* LCD Memory 12 */
sfrb(LCDM12, LCDM12_);
#define LCDM13_ __MSP430_LCD_B_BASE__ + 0x2c  /* LCD Memory 13 */
sfrb(LCDM13, LCDM13_);
#define LCDM14_ __MSP430_LCD_B_BASE__ + 0x2d  /* LCD Memory 14 */
sfrb(LCDM14, LCDM14_);
#define LCDM15_ __MSP430_LCD_B_BASE__ + 0x2e  /* LCD Memory 15 */
sfrb(LCDM15, LCDM15_);
#define LCDM16_ __MSP430_LCD_B_BASE__ + 0x2f  /* LCD Memory 16 */
sfrb(LCDM16, LCDM16_);
#define LCDM17_ __MSP430_LCD_B_BASE__ + 0x30  /* LCD Memory 17 */
sfrb(LCDM17, LCDM17_);
#define LCDM18_ __MSP430_LCD_B_BASE__ + 0x31  /* LCD Memory 18 */
sfrb(LCDM18, LCDM18_);
#define LCDM19_ __MSP430_LCD_B_BASE__ + 0x32  /* LCD Memory 19 */
sfrb(LCDM19, LCDM19_);
#define LCDM20_ __MSP430_LCD_B_BASE__ + 0x33  /* LCD Memory 20 */
sfrb(LCDM20, LCDM20_);
#define LCDM21_ __MSP430_LCD_B_BASE__ + 0x34  /* LCD Memory 20 */
sfrb(LCDM21, LCDM21_);
#define LCDM22_ __MSP430_LCD_B_BASE__ + 0x35  /* LCD Memory 20 */
sfrb(LCDM22, LCDM22_);
#define LCDM23_ __MSP430_LCD_B_BASE__ + 0x36  /* LCD Memory 20 */
sfrb(LCDM23, LCDM23_);
#define LCDM24_ __MSP430_LCD_B_BASE__ + 0x37  /* LCD Memory 20 */
sfrb(LCDM24, LCDM24_);

#define LCDBM1_ __MSP430_LCD_B_BASE__ + 0x40  /* LCD Blinking Memory 1 */
sfrb(LCDBM1, LCDBM1_);
#define LCDBMEM_               LCDBM1         /* LCD Blinking Memory */
#ifdef __ASM_HEADER__
#define LCDBMEM                (LCDBM1)       /* LCD Blinking Memory (for assembler) */
#else
#define LCDBMEM                ((volatile char*)(LCDBM1_)) /* LCD Blinking Memory (for C) */
#endif
#define LCDBM2_ __MSP430_LCD_B_BASE__ + 0x41  /* LCD Blinking Memory 2 */
sfrb(LCDBM2, LCDBM2_);
#define LCDBM3_ __MSP430_LCD_B_BASE__ + 0x42  /* LCD Blinking Memory 3 */
sfrb(LCDBM3, LCDBM3_);
#define LCDBM4_ __MSP430_LCD_B_BASE__ + 0x43  /* LCD Blinking Memory 4 */
sfrb(LCDBM4, LCDBM4_);
#define LCDBM5_ __MSP430_LCD_B_BASE__ + 0x44  /* LCD Blinking Memory 5 */
sfrb(LCDBM5, LCDBM5_);
#define LCDBM6_ __MSP430_LCD_B_BASE__ + 0x45  /* LCD Blinking Memory 6 */
sfrb(LCDBM6, LCDBM6_);
#define LCDBM7_ __MSP430_LCD_B_BASE__ + 0x46  /* LCD Blinking Memory 7 */
sfrb(LCDBM7, LCDBM7_);
#define LCDBM8_ __MSP430_LCD_B_BASE__ + 0x47  /* LCD Blinking Memory 8 */
sfrb(LCDBM8, LCDBM8_);
#define LCDBM9_ __MSP430_LCD_B_BASE__ + 0x48  /* LCD Blinking Memory 9 */
sfrb(LCDBM9, LCDBM9_);
#define LCDBM10_ __MSP430_LCD_B_BASE__ + 0x49  /* LCD Blinking Memory 10 */
sfrb(LCDBM10, LCDBM10_);
#define LCDBM11_ __MSP430_LCD_B_BASE__ + 0x4a  /* LCD Blinking Memory 11 */
sfrb(LCDBM11, LCDBM11_);
#define LCDBM12_ __MSP430_LCD_B_BASE__ + 0x4b  /* LCD Blinking Memory 12 */
sfrb(LCDBM12, LCDBM12_);
#define LCDBM13_ __MSP430_LCD_B_BASE__ + 0x4c  /* LCD Blinking Memory 13 */
sfrb(LCDBM13, LCDBM13_);
#define LCDBM14_ __MSP430_LCD_B_BASE__ + 0x4d  /* LCD Blinking Memory 14 */
sfrb(LCDBM14, LCDBM14_);
#define LCDBM15_ __MSP430_LCD_B_BASE__ + 0x4e  /* LCD Blinking Memory 15 */
sfrb(LCDBM15, LCDBM15_);
#define LCDBM16_ __MSP430_LCD_B_BASE__ + 0x4f  /* LCD Blinking Memory 16 */
sfrb(LCDBM16, LCDBM16_);
#define LCDBM17_ __MSP430_LCD_B_BASE__ + 0x50  /* LCD Blinking Memory 17 */
sfrb(LCDBM17, LCDBM17_);
#define LCDBM18_ __MSP430_LCD_B_BASE__ + 0x51  /* LCD Blinking Memory 18 */
sfrb(LCDBM18, LCDBM18_);
#define LCDBM19_ __MSP430_LCD_B_BASE__ + 0x52  /* LCD Blinking Memory 19 */
sfrb(LCDBM19, LCDBM19_);
#define LCDBM20_ __MSP430_LCD_B_BASE__ + 0x53  /* LCD Blinking Memory 20 */
sfrb(LCDBM20, LCDBM20_);
#define LCDBM21_ __MSP430_LCD_B_BASE__ + 0x54  /* LCD Blinking Memory 20 */
sfrb(LCDBM21, LCDBM21_);
#define LCDBM22_ __MSP430_LCD_B_BASE__ + 0x55  /* LCD Blinking Memory 20 */
sfrb(LCDBM22, LCDBM22_);
#define LCDBM23_ __MSP430_LCD_B_BASE__ + 0x56  /* LCD Blinking Memory 20 */
sfrb(LCDBM23, LCDBM23_);
#define LCDBM24_ __MSP430_LCD_B_BASE__ + 0x57  /* LCD Blinking Memory 20 */
sfrb(LCDBM24, LCDBM24_);

/* LCDBIV Definitions */
#define LCDBIV_NONE            (0x0000)       /* No Interrupt pending */
#define LCDBIV_LCDNOCAPIFG     (0x0002)       /* No capacitor connected */
#define LCDBIV_LCDBLKOFFIFG    (0x0004)       /* Blink, segments off */
#define LCDBIV_LCDBLKONIFG     (0x0006)       /* Blink, segments on */
#define LCDBIV_LCDFRMIFG       (0x0008)       /* Frame interrupt */

#endif /* __MSP430_LCD_B_BASE__ */

#endif /* __MSP430_HEADERS_LCD_B_H__ */

