/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import org.tritonus.lowlevel.alsa.AlsaSeq;
import org.tritonus.lowlevel.alsa.AlsaSeqEvent;
import org.tritonus.lowlevel.alsa.AlsaSeqPortSubscribe;
import org.tritonus.share.TDebug;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlsaMidiIn
extends Thread {
    private AlsaSeq m_alsaSeq;
    private int m_nDestPort;
    private int m_nSourceClient;
    private int m_nSourcePort;
    private AlsaMidiInListener m_listener;
    private AlsaSeqEvent m_event;
    private int[] m_anValues;
    private long[] m_alValues;

    private final AlsaSeq getAlsaSeq() {
        return this.m_alsaSeq;
    }

    public void run() {
        while (!AlsaMidiIn.interrupted()) {
            MidiEvent midiEvent = this.getEvent();
            if (TDebug.TraceAlsaMidiIn) {
                TDebug.out("AlsaMidiIn.run(): got event: " + midiEvent);
            }
            if (midiEvent != null) {
                MidiMessage midiMessage = midiEvent.getMessage();
                long l = midiEvent.getTick();
                if (midiMessage instanceof MetaMessage) {
                    MetaMessage metaMessage = (MetaMessage)midiMessage;
                    if (TDebug.TraceAlsaMidiIn) {
                        TDebug.out("AlsaMidiIn.run(): MetaMessage.getData().length: " + metaMessage.getData().length);
                    }
                }
                this.m_listener.dequeueEvent(midiMessage, l);
                continue;
            }
            if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllWarnings) continue;
            TDebug.out("AlsaMidiIn.run(): received null from getEvent()");
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final MidiEvent getEvent() {
        if (TDebug.TraceAlsaMidiIn) {
            TDebug.out("AlsaMidiIn.getEvent(): before eventInput()");
        }
        while ((var1_1 = this.getAlsaSeq().eventInput(this.m_event)) < 0) {
            if (TDebug.TraceAlsaMidiIn || TDebug.TraceAllWarnings) {
                TDebug.out("AlsaMidiIn.getEvent(): sleeping because got no event");
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException var2_3) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(var2_3);
            }
        }
        var1_2 /* !! */  = null;
        var2_4 = this.m_event.getType();
        switch (var2_4) {
            case 6: 
            case 7: 
            case 8: {
                if (TDebug.TraceAlsaMidiIn) {
                    TDebug.out("AlsaMidiIn.getEvent(): note/aftertouch event");
                }
                this.m_event.getNote(this.m_anValues);
                var3_5 = new ShortMessage();
                var4_11 = -1;
                switch (var2_4) {
                    case 6: {
                        var4_11 = 144;
                        break;
                    }
                    case 7: {
                        var4_11 = 128;
                        break;
                    }
                    case 8: {
                        var4_11 = 160;
                        break;
                    }
                }
                var5_16 = this.m_anValues[0] & 15;
                var6_22 = this.m_anValues[1] & 127;
                var7_25 = this.m_anValues[2] & 127;
                try {
                    var3_5.setMessage(var4_11, var5_16, var6_22, var7_25);
                }
                catch (InvalidMidiDataException var8_28) {
                    if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllExceptions) ** GOTO lbl41
                    TDebug.out(var8_28);
                }
lbl41:
                // 3 sources

                var1_2 /* !! */  = var3_5;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: {
                this.m_event.getControl(this.m_anValues);
                var3_6 = -1;
                var4_12 = this.m_anValues[0] & 15;
                var5_17 = -1;
                var6_23 = -1;
                switch (var2_4) {
                    case 10: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): controller event");
                        }
                        var3_6 = 176;
                        var5_17 = this.m_anValues[1] & 127;
                        var6_23 = this.m_anValues[2] & 127;
                        break;
                    }
                    case 11: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): program change event");
                        }
                        var3_6 = 192;
                        var5_17 = this.m_anValues[2] & 127;
                        var6_23 = 0;
                        break;
                    }
                    case 12: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): channel pressure event");
                        }
                        var3_6 = 208;
                        var5_17 = this.m_anValues[2] & 127;
                        var6_23 = 0;
                        break;
                    }
                    case 13: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): pitchbend event");
                        }
                        var3_6 = 224;
                        var5_17 = this.m_anValues[2] & 127;
                        var6_23 = this.m_anValues[2] >> 7 & 127;
                        break;
                    }
                    case 22: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): MTC event");
                        }
                        var3_6 = 241;
                        var5_17 = this.m_anValues[2] & 127;
                        var6_23 = 0;
                        break;
                    }
                    case 20: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): song position event");
                        }
                        var3_6 = 242;
                        var5_17 = this.m_anValues[2] & 127;
                        var6_23 = this.m_anValues[2] >> 7 & 127;
                        break;
                    }
                    case 21: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): song select event");
                        }
                        var3_6 = 243;
                        var5_17 = this.m_anValues[2] & 127;
                        var6_23 = 0;
                        break;
                    }
                }
                var7_26 = new ShortMessage();
                try {
                    var7_26.setMessage(var3_6, var4_12, var5_17, var6_23);
                }
                catch (InvalidMidiDataException var8_29) {
                    if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllExceptions) ** GOTO lbl106
                    TDebug.out(var8_29);
                }
lbl106:
                // 3 sources

                var1_2 /* !! */  = var7_26;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 40: 
            case 41: 
            case 42: {
                var3_7 = -1;
                switch (var2_4) {
                    case 40: {
                        var3_7 = 246;
                        break;
                    }
                    case 36: {
                        if (TDebug.TraceAlsaMidiIn) {
                            TDebug.out("AlsaMidiIn.getEvent(): clock event");
                        }
                        var3_7 = 248;
                        break;
                    }
                    case 30: {
                        var3_7 = 250;
                        break;
                    }
                    case 31: {
                        var3_7 = 251;
                        break;
                    }
                    case 32: {
                        var3_7 = 252;
                        break;
                    }
                    case 42: {
                        var3_7 = 254;
                        break;
                    }
                    case 41: {
                        var3_7 = 255;
                        break;
                    }
                }
                var4_13 = new ShortMessage();
                try {
                    var4_13.setMessage(var3_7);
                }
                catch (InvalidMidiDataException var5_18) {
                    if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllExceptions) ** GOTO lbl141
                    TDebug.out(var5_18);
                }
lbl141:
                // 3 sources

                var1_2 /* !! */  = var4_13;
                break;
            }
            case 139: {
                if (TDebug.TraceAlsaMidiIn) {
                    TDebug.out("AlsaMidiIn.getEvent(): meta event");
                }
                var3_8 = new MetaMessage();
                var4_14 = this.m_event.getVar();
                var5_19 = var4_14[0];
                var6_24 = new byte[var4_14.length - 1];
                System.arraycopy(var4_14, 1, var6_24, 0, var4_14.length - 1);
                try {
                    var3_8.setMessage(var5_19, var6_24, var6_24.length);
                }
                catch (InvalidMidiDataException var7_27) {
                    if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllExceptions) ** GOTO lbl157
                    TDebug.out(var7_27);
                }
lbl157:
                // 3 sources

                var1_2 /* !! */  = var3_8;
                break;
            }
            case 130: {
                if (TDebug.TraceAlsaMidiIn) {
                    TDebug.out("AlsaMidiIn.getEvent(): sysex event");
                }
                var3_9 = new SysexMessage();
                var4_15 = this.m_event.getVar();
                try {
                    var3_9.setMessage(var4_15, var4_15.length);
                }
                catch (InvalidMidiDataException var5_20) {
                    if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllExceptions) ** GOTO lbl170
                    TDebug.out(var5_20);
                }
lbl170:
                // 3 sources

                var1_2 /* !! */  = var3_9;
                break;
            }
            default: {
                if (!TDebug.TraceAlsaMidiIn && !TDebug.TraceAllWarnings) break;
                TDebug.out("AlsaMidiIn.getEvent(): unknown event");
            }
        }
        if (var1_2 /* !! */  != null) {
            var3_10 = this.m_event.getTimestamp();
            if ((this.m_event.getFlags() & 1) == 1) {
                var3_10 /= 1000L;
            }
            var5_21 = new MidiEvent(var1_2 /* !! */ , var3_10);
            return var5_21;
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.m_event = new AlsaSeqEvent();
        this.m_anValues = new int[5];
        this.m_alValues = new long[1];
    }

    public AlsaMidiIn(AlsaSeq alsaSeq, int n, int n2, int n3, AlsaMidiInListener alsaMidiInListener) {
        this(alsaSeq, n, n2, n3, -1, false, alsaMidiInListener);
    }

    public AlsaMidiIn(AlsaSeq alsaSeq, int n, int n2, int n3, int n4, boolean bl, AlsaMidiInListener alsaMidiInListener) {
        this.this();
        this.m_nSourceClient = n2;
        this.m_nSourcePort = n3;
        this.m_listener = alsaMidiInListener;
        this.m_alsaSeq = alsaSeq;
        this.m_nDestPort = n;
        if (n4 >= 0) {
            AlsaSeqPortSubscribe alsaSeqPortSubscribe = new AlsaSeqPortSubscribe();
            alsaSeqPortSubscribe.setSender(n2, n3);
            alsaSeqPortSubscribe.setDest(this.getAlsaSeq().getClientId(), n);
            alsaSeqPortSubscribe.setQueue(n4);
            alsaSeqPortSubscribe.setExclusive(false);
            alsaSeqPortSubscribe.setTimeUpdate(true);
            alsaSeqPortSubscribe.setTimeReal(bl);
            this.getAlsaSeq().subscribePort(alsaSeqPortSubscribe);
            alsaSeqPortSubscribe.free();
        } else {
            AlsaSeqPortSubscribe alsaSeqPortSubscribe = new AlsaSeqPortSubscribe();
            alsaSeqPortSubscribe.setSender(n2, n3);
            alsaSeqPortSubscribe.setDest(this.getAlsaSeq().getClientId(), n);
            this.getAlsaSeq().subscribePort(alsaSeqPortSubscribe);
            alsaSeqPortSubscribe.free();
        }
        this.setDaemon(true);
    }

    public static interface AlsaMidiInListener {
        public void dequeueEvent(MidiMessage var1, long var2);
    }
}

